/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class DfaPsiType {
    private final PsiType myPsiType;
    private final DfaValueFactory myFactory;
    private List<DfaPsiType> mySuperTypes;
    private final int myID;

    DfaPsiType(int id, @NotNull PsiType psiType, DfaValueFactory factory) {
        if (psiType == null) {
            DfaPsiType.$$$reportNull$$$0(0);
        }
        this.myID = id;
        this.myPsiType = psiType;
        this.myFactory = factory;
    }

    @NotNull
    public PsiType getPsiType() {
        PsiType psiType = this.myPsiType;
        if (psiType == null) {
            DfaPsiType.$$$reportNull$$$0(1);
        }
        return psiType;
    }

    public Stream<DfaPsiType> superTypes() {
        if (this.mySuperTypes == null) {
            ArrayList<DfaPsiType> superTypes = new ArrayList<DfaPsiType>();
            InheritanceUtil.processSuperTypes((PsiType)this.getPsiType(), (boolean)false, t -> superTypes.add(this.myFactory.createDfaType((PsiType)t)));
            this.mySuperTypes = superTypes;
        }
        return this.mySuperTypes.stream();
    }

    @NotNull
    public TypeConstraint asConstraint() {
        TypeConstraint constraint = TypeConstraint.empty().withInstanceofValue(this);
        assert (constraint != null);
        TypeConstraint typeConstraint = constraint;
        if (typeConstraint == null) {
            DfaPsiType.$$$reportNull$$$0(2);
        }
        return typeConstraint;
    }

    public boolean isAssignableFrom(DfaPsiType other) {
        if (other == this) {
            return true;
        }
        Pair key2 = Pair.create((Object)this, (Object)other);
        return this.myFactory.myAssignableCache.computeIfAbsent((Pair<DfaPsiType, DfaPsiType>)key2, k -> this.myPsiType.isAssignableFrom(other.myPsiType));
    }

    public boolean isConvertibleFrom(DfaPsiType other) {
        if (other == this) {
            return true;
        }
        Pair key2 = Pair.create((Object)this, (Object)other);
        return this.myFactory.myConvertibleCache.computeIfAbsent((Pair<DfaPsiType, DfaPsiType>)key2, k -> this.myPsiType.isConvertibleFrom(other.myPsiType));
    }

    public DfaValueFactory getFactory() {
        return this.myFactory;
    }

    public String toString() {
        return this.myPsiType.getPresentableText();
    }

    public int getID() {
        return this.myID;
    }

    @NotNull
    public static PsiType normalizeType(@NotNull PsiType psiType) {
        PsiType[] types;
        if (psiType == null) {
            DfaPsiType.$$$reportNull$$$0(3);
        }
        if (psiType instanceof PsiArrayType) {
            PsiType psiType2 = PsiTypesUtil.createArrayType((PsiType)DfaPsiType.normalizeType(psiType.getDeepComponentType()), (int)psiType.getArrayDimensions());
            if (psiType2 == null) {
                DfaPsiType.$$$reportNull$$$0(4);
            }
            return psiType2;
        }
        if (psiType instanceof PsiWildcardType) {
            PsiType psiType3 = DfaPsiType.normalizeType(((PsiWildcardType)psiType).getExtendsBound());
            if (psiType3 == null) {
                DfaPsiType.$$$reportNull$$$0(5);
            }
            return psiType3;
        }
        if (psiType instanceof PsiCapturedWildcardType) {
            PsiType psiType4 = DfaPsiType.normalizeType(((PsiCapturedWildcardType)psiType).getUpperBound());
            if (psiType4 == null) {
                DfaPsiType.$$$reportNull$$$0(6);
            }
            return psiType4;
        }
        if (psiType instanceof PsiIntersectionType && (types = (PsiType[])StreamEx.of((Object[])((PsiIntersectionType)psiType).getConjuncts()).map(DfaPsiType::normalizeType).toArray((Object[])PsiType.EMPTY_ARRAY)).length > 0) {
            PsiType psiType5 = PsiIntersectionType.createIntersection((boolean)true, (PsiType[])types);
            if (psiType5 == null) {
                DfaPsiType.$$$reportNull$$$0(7);
            }
            return psiType5;
        }
        if (psiType instanceof PsiClassType) {
            PsiType psiType6 = DfaPsiType.normalizeClassType((PsiClassType)psiType, new HashSet<PsiClass>());
            if (psiType6 == null) {
                DfaPsiType.$$$reportNull$$$0(8);
            }
            return psiType6;
        }
        PsiType psiType7 = psiType;
        if (psiType7 == null) {
            DfaPsiType.$$$reportNull$$$0(9);
        }
        return psiType7;
    }

    @NotNull
    private static PsiType normalizeClassType(@NotNull PsiClassType psiType, Set<PsiClass> processed) {
        PsiClass aClass;
        if (psiType == null) {
            DfaPsiType.$$$reportNull$$$0(10);
        }
        if ((aClass = psiType.resolve()) instanceof PsiTypeParameter) {
            PsiClassType[] types = aClass.getExtendsListTypes();
            ArrayList<PsiType> result = new ArrayList<PsiType>();
            for (PsiClassType type2 : types) {
                PsiClass resolved = type2.resolve();
                if (resolved == null || !processed.add(resolved)) continue;
                PsiClassType classType = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(resolved);
                result.add(DfaPsiType.normalizeClassType(classType, processed));
            }
            if (!result.isEmpty()) {
                PsiType psiType2 = PsiIntersectionType.createIntersection((boolean)true, (PsiType[])result.toArray(PsiType.EMPTY_ARRAY));
                if (psiType2 == null) {
                    DfaPsiType.$$$reportNull$$$0(11);
                }
                return psiType2;
            }
            PsiClassType psiClassType = PsiType.getJavaLangObject((PsiManager)aClass.getManager(), (GlobalSearchScope)aClass.getResolveScope());
            if (psiClassType == null) {
                DfaPsiType.$$$reportNull$$$0(12);
            }
            return psiClassType;
        }
        PsiClassType psiClassType = psiType.rawType();
        if (psiClassType == null) {
            DfaPsiType.$$$reportNull$$$0(13);
        }
        return psiClassType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaPsiType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaPsiType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "asConstraint";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeClassType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "normalizeType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "normalizeClassType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

