/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ConcurrencyAnnotationsManager;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.LongStream;
import one.util.streamex.LongStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaExpressionFactory {
    private final DfaValueFactory myFactory;
    private final Map<Integer, ArrayElementDescriptor> myArrayIndices = new HashMap<Integer, ArrayElementDescriptor>();

    DfaExpressionFactory(DfaValueFactory factory) {
        this.myFactory = factory;
    }

    @Nullable
    @Contract(value="null -> null")
    public DfaValue getExpressionDfaValue(@Nullable PsiExpression expression2) {
        PsiType type2;
        DfaVariableValue qualifier;
        if (expression2 == null) {
            return null;
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            return this.getExpressionDfaValue(((PsiParenthesizedExpression)expression2).getExpression());
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            DfaValue arrayElementValue;
            Object index;
            PsiExpression arrayExpression = ((PsiArrayAccessExpression)expression2).getArrayExpression();
            qualifier = this.getQualifierVariable(arrayExpression);
            if (qualifier != null && (index = ExpressionUtils.computeConstantExpression(((PsiArrayAccessExpression)expression2).getIndexExpression())) instanceof Integer && (arrayElementValue = this.getArrayElementValue((DfaValue)qualifier, (Integer)index)) != null) {
                return arrayElementValue;
            }
            PsiType type3 = expression2.getType();
            if (type3 != null) {
                return this.myFactory.createTypeValue(type3, DfaPsiUtil.getElementNullability(type3, null));
            }
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            return this.createReferenceValue(((PsiMethodCallExpression)expression2).getMethodExpression());
        }
        if (expression2 instanceof PsiReferenceExpression) {
            return this.createReferenceValue((PsiReferenceExpression)expression2);
        }
        if (expression2 instanceof PsiLiteralExpression) {
            return this.myFactory.createLiteralValue((PsiLiteralExpression)expression2);
        }
        if (expression2 instanceof PsiNewExpression || expression2 instanceof PsiLambdaExpression) {
            return this.myFactory.createTypeValue(expression2.getType(), Nullability.NOT_NULL);
        }
        Object value2 = JavaConstantExpressionEvaluator.computeConstantExpression(expression2, false);
        if (value2 != null && (type2 = expression2.getType()) != null) {
            return this.myFactory.getConstFactory().createFromValue(value2, type2);
        }
        if (expression2 instanceof PsiThisExpression || expression2 instanceof PsiSuperExpression) {
            qualifier = ((PsiQualifiedExpression)expression2).getQualifier();
            PsiClass target = qualifier != null ? (PsiClass)ObjectUtils.tryCast((Object)qualifier.resolve(), PsiClass.class) : ClassUtils.getContainingClass((PsiElement)expression2);
            return target == null ? this.myFactory.createTypeValue(expression2.getType(), Nullability.NOT_NULL) : this.myFactory.getVarFactory().createThisValue(target);
        }
        return null;
    }

    private DfaValue createReferenceValue(@NotNull PsiReferenceExpression refExpr) {
        DfaValue constValue;
        PsiVariable variable;
        PsiElement target;
        if (refExpr == null) {
            DfaExpressionFactory.$$$reportNull$$$0(0);
        }
        if ((target = refExpr.resolve()) instanceof PsiVariable && (variable = (PsiVariable)target).hasModifierProperty("final") && !PsiUtil.isAccessedForWriting((PsiExpression)refExpr) && (constValue = this.myFactory.getConstFactory().create(variable)) != null && !DfaExpressionFactory.maybeUninitializedConstant(constValue, refExpr, (PsiModifierListOwner)variable)) {
            return constValue;
        }
        VariableDescriptor var = DfaExpressionFactory.getAccessedVariableOrGetter(target);
        if (var == null) {
            return null;
        }
        DfaVariableValue qualifier = this.getQualifierOrThisVariable(refExpr);
        return var.createValue(this.myFactory, qualifier, true);
    }

    @Nullable
    public DfaVariableValue getQualifierOrThisVariable(PsiReferenceExpression refExpr) {
        PsiElement element;
        PsiExpression qualifierExpression2 = refExpr.getQualifierExpression();
        if (qualifierExpression2 == null && (element = refExpr.resolve()) instanceof PsiMember && !((PsiMember)element).hasModifierProperty("static")) {
            PsiClass currentClass = ClassUtils.getContainingClass((PsiElement)refExpr);
            PsiClass memberClass = ((PsiMember)element).getContainingClass();
            if (memberClass != null && currentClass != null) {
                PsiClass target = currentClass == memberClass || InheritanceUtil.isInheritorOrSelf((PsiClass)currentClass, (PsiClass)memberClass, (boolean)true) ? currentClass : memberClass;
                return this.myFactory.getVarFactory().createThisValue(target);
            }
        }
        return this.getQualifierVariable(qualifierExpression2);
    }

    @Nullable
    private DfaVariableValue getQualifierVariable(PsiExpression qualifierExpression2) {
        Object constValue;
        DfaValue qualifierValue = this.getExpressionDfaValue(qualifierExpression2);
        DfaVariableValue qualifier = null;
        if (qualifierValue instanceof DfaVariableValue) {
            qualifier = (DfaVariableValue)qualifierValue;
        } else if (qualifierValue instanceof DfaConstValue && (constValue = ((DfaConstValue)qualifierValue).getValue()) instanceof PsiVariable) {
            qualifier = this.myFactory.getVarFactory().createVariableValue((PsiVariable)constValue);
        }
        return qualifier;
    }

    private static boolean maybeUninitializedConstant(DfaValue constValue, @NotNull PsiReferenceExpression refExpr, PsiModifierListOwner var) {
        if (refExpr == null) {
            DfaExpressionFactory.$$$reportNull$$$0(1);
        }
        if (!(constValue instanceof DfaConstValue) || ((DfaConstValue)constValue).getValue() != var) {
            return false;
        }
        if (!(var instanceof PsiField) || var instanceof PsiEnumConstant) {
            return false;
        }
        return PsiTreeUtil.getTopmostParentOfType((PsiElement)refExpr, PsiClass.class) == PsiTreeUtil.getTopmostParentOfType((PsiElement)var, PsiClass.class);
    }

    @Contract(value="null -> null")
    @Nullable
    public static VariableDescriptor getAccessedVariableOrGetter(PsiElement target) {
        PsiMethod method;
        SpecialField sf = SpecialField.findSpecialField(target);
        if (sf != null) {
            return sf;
        }
        if (target instanceof PsiVariable) {
            return new PlainDescriptor((PsiVariable)target);
        }
        if (target instanceof PsiMethod && (method = (PsiMethod)target).getParameterList().isEmpty() && (PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method) || JavaMethodContractUtil.isPure(method) || DfaExpressionFactory.isClassAnnotatedImmutable(method)) && DfaExpressionFactory.isContractAllowedForGetter(method)) {
            return new GetterDescriptor(method);
        }
        return null;
    }

    private static boolean isClassAnnotatedImmutable(PsiMethod method) {
        List annotations2 = ConcurrencyAnnotationsManager.getInstance((Project)method.getProject()).getImmutableAnnotations();
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)method.getContainingClass(), (Collection)annotations2) != null;
    }

    private static boolean isContractAllowedForGetter(PsiMethod method) {
        List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts(method, null);
        if (contracts2.size() == 1) {
            MethodContract contract = contracts2.get(0);
            return contract.isTrivial() && contract.getReturnValue().equals(ContractReturnValue.returnNew());
        }
        return contracts2.isEmpty();
    }

    @NotNull
    private DfaValue getAdvancedExpressionDfaValue(@Nullable PsiExpression expression2, @Nullable PsiType targetType) {
        if (expression2 == null) {
            DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
            if (dfaUnknownValue == null) {
                DfaExpressionFactory.$$$reportNull$$$0(2);
            }
            return dfaUnknownValue;
        }
        DfaValue value2 = this.getExpressionDfaValue(expression2);
        if (value2 != null) {
            DfaValue dfaValue = DfaUtil.boxUnbox(value2, targetType);
            if (dfaValue == null) {
                DfaExpressionFactory.$$$reportNull$$$0(3);
            }
            return dfaValue;
        }
        if (expression2 instanceof PsiConditionalExpression) {
            DfaValue dfaValue = this.getAdvancedExpressionDfaValue(((PsiConditionalExpression)expression2).getThenExpression(), targetType).unite(this.getAdvancedExpressionDfaValue(((PsiConditionalExpression)expression2).getElseExpression(), targetType));
            if (dfaValue == null) {
                DfaExpressionFactory.$$$reportNull$$$0(4);
            }
            return dfaValue;
        }
        PsiType type2 = expression2.getType();
        if (type2 instanceof PsiPrimitiveType) {
            DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
            if (dfaUnknownValue == null) {
                DfaExpressionFactory.$$$reportNull$$$0(5);
            }
            return dfaUnknownValue;
        }
        DfaValue typeValue = this.myFactory.createTypeValue(type2, NullabilityUtil.getExpressionNullability(expression2));
        if (expression2 instanceof PsiArrayInitializerExpression) {
            int length = ((PsiArrayInitializerExpression)expression2).getInitializers().length;
            DfaValue dfaValue = this.myFactory.withFact(typeValue, DfaFactType.SPECIAL_FIELD_VALUE, SpecialField.ARRAY_LENGTH.withValue(this.myFactory.getInt(length)));
            if (dfaValue == null) {
                DfaExpressionFactory.$$$reportNull$$$0(6);
            }
            return dfaValue;
        }
        DfaValue dfaValue = DfaUtil.boxUnbox(typeValue, targetType);
        if (dfaValue == null) {
            DfaExpressionFactory.$$$reportNull$$$0(7);
        }
        return dfaValue;
    }

    @NotNull
    public DfaValue getArrayElementValue(DfaValue array, LongRangeSet indexSet) {
        long max;
        if (!(array instanceof DfaVariableValue)) {
            DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
            if (dfaUnknownValue == null) {
                DfaExpressionFactory.$$$reportNull$$$0(8);
            }
            return dfaUnknownValue;
        }
        if (indexSet.isEmpty()) {
            DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
            if (dfaUnknownValue == null) {
                DfaExpressionFactory.$$$reportNull$$$0(9);
            }
            return dfaUnknownValue;
        }
        long min = indexSet.min();
        if (min == (max = indexSet.max()) && min >= 0L && min < Integer.MAX_VALUE) {
            DfaValue value3 = this.getArrayElementValue(array, (int)min);
            DfaValue dfaValue = value3 == null ? DfaUnknownValue.getInstance() : value3;
            if (dfaValue == null) {
                DfaExpressionFactory.$$$reportNull$$$0(10);
            }
            return dfaValue;
        }
        DfaVariableValue arrayDfaVar = (DfaVariableValue)array;
        PsiModifierListOwner arrayPsiVar = arrayDfaVar.getPsiVariable();
        if (!(arrayPsiVar instanceof PsiVariable)) {
            DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
            if (dfaUnknownValue == null) {
                DfaExpressionFactory.$$$reportNull$$$0(11);
            }
            return dfaUnknownValue;
        }
        PsiType arrayType = ((PsiVariable)arrayPsiVar).getType();
        PsiType targetType = arrayType instanceof PsiArrayType ? ((PsiArrayType)arrayType).getComponentType() : null;
        PsiExpression[] elements = ExpressionUtils.getConstantArrayElements((PsiVariable)arrayPsiVar);
        if (elements == null || elements.length == 0) {
            DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
            if (dfaUnknownValue == null) {
                DfaExpressionFactory.$$$reportNull$$$0(12);
            }
            return dfaUnknownValue;
        }
        if ((indexSet = indexSet.intersect(LongRangeSet.range(0L, elements.length - 1))).isEmpty() || indexSet.max() - indexSet.min() > 100L) {
            DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
            if (dfaUnknownValue == null) {
                DfaExpressionFactory.$$$reportNull$$$0(13);
            }
            return dfaUnknownValue;
        }
        DfaValue dfaValue = ((StreamEx)((StreamEx)LongStreamEx.of((LongStream)indexSet.stream()).mapToObj(idx -> this.getAdvancedExpressionDfaValue(elements[(int)idx], targetType)).prefix(DfaValue::unite)).takeWhileInclusive(value2 -> value2 != DfaUnknownValue.getInstance())).reduce((a, b) -> b).orElse(DfaUnknownValue.getInstance());
        if (dfaValue == null) {
            DfaExpressionFactory.$$$reportNull$$$0(14);
        }
        return dfaValue;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public DfaValue getArrayElementValue(DfaValue array, int index) {
        PsiExpression constantArrayElement;
        if (!(array instanceof DfaVariableValue)) {
            return null;
        }
        DfaVariableValue arrayDfaVar = (DfaVariableValue)array;
        PsiType type2 = arrayDfaVar.getType();
        if (!(type2 instanceof PsiArrayType)) {
            return null;
        }
        PsiModifierListOwner arrayPsiVar = arrayDfaVar.getPsiVariable();
        if (arrayPsiVar instanceof PsiVariable && (constantArrayElement = ExpressionUtils.getConstantArrayElement((PsiVariable)arrayPsiVar, index)) != null) {
            return this.getAdvancedExpressionDfaValue(constantArrayElement, ((PsiArrayType)type2).getComponentType());
        }
        ArrayElementDescriptor indexVariable = this.getArrayIndexVariable(index);
        if (indexVariable == null) {
            return null;
        }
        return indexVariable.createValue(this.myFactory, arrayDfaVar);
    }

    @Nullable
    private ArrayElementDescriptor getArrayIndexVariable(int index) {
        if (index >= 0) {
            return this.myArrayIndices.computeIfAbsent(index, ArrayElementDescriptor::new);
        }
        return null;
    }

    @NotNull
    private static PsiSubstitutor getSubstitutor(PsiElement member, @Nullable DfaVariableValue qualifier) {
        if (member instanceof PsiMember && qualifier != null) {
            PsiClass fieldClass = ((PsiMember)member).getContainingClass();
            PsiClassType classType = (PsiClassType)ObjectUtils.tryCast((Object)qualifier.getType(), PsiClassType.class);
            if (classType != null && InheritanceUtil.isInheritorOrSelf((PsiClass)classType.resolve(), (PsiClass)fieldClass, (boolean)true)) {
                PsiSubstitutor psiSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)fieldClass, (PsiClassType)classType);
                if (psiSubstitutor == null) {
                    DfaExpressionFactory.$$$reportNull$$$0(15);
                }
                return psiSubstitutor;
            }
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        if (psiSubstitutor == null) {
            DfaExpressionFactory.$$$reportNull$$$0(16);
        }
        return psiSubstitutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaExpressionFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaExpressionFactory";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdvancedExpressionDfaValue";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayElementValue";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceValue";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "maybeUninitializedConstant";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ThisDescriptor
    implements VariableDescriptor {
        @NotNull
        private final PsiClass myQualifier;

        ThisDescriptor(@NotNull PsiClass qualifier) {
            if (qualifier == null) {
                ThisDescriptor.$$$reportNull$$$0(0);
            }
            this.myQualifier = qualifier;
        }

        @NotNull
        public String toString() {
            String string = this.myQualifier.getName() + ".this";
            if (string == null) {
                ThisDescriptor.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public PsiType getType(@Nullable DfaVariableValue qualifier) {
            PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(this.myQualifier, PsiSubstitutor.EMPTY);
            if (psiImmediateClassType == null) {
                ThisDescriptor.$$$reportNull$$$0(2);
            }
            return psiImmediateClassType;
        }

        public PsiClass getPsiElement() {
            return this.myQualifier;
        }

        @Override
        public boolean isStable() {
            return true;
        }

        public int hashCode() {
            return Objects.hashCode(this.myQualifier.getQualifiedName());
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof ThisDescriptor && ((ThisDescriptor)obj).myQualifier == this.myQualifier;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaExpressionFactory$ThisDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaExpressionFactory$ThisDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ArrayElementDescriptor
    implements VariableDescriptor {
        private final int myIndex;

        ArrayElementDescriptor(int index) {
            this.myIndex = index;
        }

        @Override
        @Nullable
        public PsiType getType(@Nullable DfaVariableValue qualifier) {
            if (qualifier == null) {
                return null;
            }
            PsiType qualifierType = qualifier.getType();
            return qualifierType instanceof PsiArrayType ? ((PsiArrayType)qualifierType).getComponentType() : null;
        }

        @NotNull
        public String toString() {
            String string = "[" + this.myIndex + "]";
            if (string == null) {
                ArrayElementDescriptor.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public boolean isStable() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaExpressionFactory$ArrayElementDescriptor", "toString"));
        }
    }

    private static final class GetterDescriptor
    implements VariableDescriptor {
        @NotNull
        private final PsiMethod myGetter;
        private final boolean myStable;

        GetterDescriptor(@NotNull PsiMethod getter) {
            if (getter == null) {
                GetterDescriptor.$$$reportNull$$$0(0);
            }
            this.myGetter = getter;
            PsiField field = PsiUtil.canBeOverridden((PsiMethod)getter) ? null : PropertyUtil.getFieldOfGetter(getter);
            this.myStable = field != null && field.hasModifierProperty("final");
        }

        @NotNull
        public String toString() {
            String string = this.myGetter.getName();
            if (string == null) {
                GetterDescriptor.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nullable
        public PsiType getType(@Nullable DfaVariableValue qualifier) {
            return DfaExpressionFactory.getSubstitutor((PsiElement)this.myGetter, qualifier).substitute(this.myGetter.getReturnType());
        }

        @NotNull
        public PsiMethod getPsiElement() {
            PsiMethod psiMethod = this.myGetter;
            if (psiMethod == null) {
                GetterDescriptor.$$$reportNull$$$0(2);
            }
            return psiMethod;
        }

        @Override
        public boolean isStable() {
            return this.myStable;
        }

        @Override
        public boolean isCall() {
            return true;
        }

        @Override
        @NotNull
        public DfaValue createValue(@NotNull DfaValueFactory factory, @Nullable DfaValue qualifier, boolean forAccessor) {
            if (factory == null) {
                GetterDescriptor.$$$reportNull$$$0(3);
            }
            if (this.myGetter.hasModifierProperty("static")) {
                DfaVariableValue dfaVariableValue = factory.getVarFactory().createVariableValue(this);
                if (dfaVariableValue == null) {
                    GetterDescriptor.$$$reportNull$$$0(4);
                }
                return dfaVariableValue;
            }
            DfaValue dfaValue = VariableDescriptor.super.createValue(factory, qualifier, forAccessor);
            if (dfaValue == null) {
                GetterDescriptor.$$$reportNull$$$0(5);
            }
            return dfaValue;
        }

        public int hashCode() {
            return Objects.hashCode(this.myGetter.getName());
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof GetterDescriptor && ((GetterDescriptor)obj).myGetter == this.myGetter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getter";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaExpressionFactory$GetterDescriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaExpressionFactory$GetterDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPsiElement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class PlainDescriptor
    implements VariableDescriptor {
        @NotNull
        private final PsiVariable myVariable;

        PlainDescriptor(@NotNull PsiVariable variable) {
            if (variable == null) {
                PlainDescriptor.$$$reportNull$$$0(0);
            }
            this.myVariable = variable;
        }

        @NotNull
        public String toString() {
            String string = String.valueOf(this.myVariable.getName());
            if (string == null) {
                PlainDescriptor.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public PsiType getType(@Nullable DfaVariableValue qualifier) {
            PsiType type2 = this.myVariable.getType();
            if (type2 instanceof PsiEllipsisType) {
                type2 = ((PsiEllipsisType)type2).toArrayType();
            }
            return DfaExpressionFactory.getSubstitutor((PsiElement)this.myVariable, qualifier).substitute(type2);
        }

        public PsiVariable getPsiElement() {
            return this.myVariable;
        }

        @Override
        public boolean isStable() {
            return this.myVariable instanceof PsiLocalVariable || this.myVariable instanceof PsiParameter || this.myVariable.hasModifierProperty("final");
        }

        @Override
        @NotNull
        public DfaValue createValue(@NotNull DfaValueFactory factory, @Nullable DfaValue qualifier, boolean forAccessor) {
            if (factory == null) {
                PlainDescriptor.$$$reportNull$$$0(2);
            }
            if (this.myVariable.getType().equalsToText("java.lang.Void")) {
                DfaConstValue dfaConstValue = factory.getConstFactory().getNull();
                if (dfaConstValue == null) {
                    PlainDescriptor.$$$reportNull$$$0(3);
                }
                return dfaConstValue;
            }
            if (this.myVariable.hasModifierProperty("volatile")) {
                PsiType type2 = this.getType((DfaVariableValue)ObjectUtils.tryCast((Object)qualifier, DfaVariableValue.class));
                DfaValue dfaValue = factory.createTypeValue(type2, DfaPsiUtil.getElementNullability(type2, (PsiModifierListOwner)this.myVariable));
                if (dfaValue == null) {
                    PlainDescriptor.$$$reportNull$$$0(4);
                }
                return dfaValue;
            }
            if (this.myVariable instanceof PsiLocalVariable || this.myVariable instanceof PsiParameter || this.myVariable instanceof PsiField && this.myVariable.hasModifierProperty("static") && (!this.myVariable.hasModifierProperty("final") || !DfaUtil.hasInitializationHacks((PsiField)this.myVariable))) {
                DfaVariableValue dfaVariableValue = factory.getVarFactory().createVariableValue(this);
                if (dfaVariableValue == null) {
                    PlainDescriptor.$$$reportNull$$$0(5);
                }
                return dfaVariableValue;
            }
            DfaValue dfaValue = VariableDescriptor.super.createValue(factory, qualifier, forAccessor);
            if (dfaValue == null) {
                PlainDescriptor.$$$reportNull$$$0(6);
            }
            return dfaValue;
        }

        public int hashCode() {
            return Objects.hashCode(this.myVariable.getName());
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof PlainDescriptor && ((PlainDescriptor)obj).myVariable == this.myVariable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaExpressionFactory$PlainDescriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaExpressionFactory$PlainDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

