/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaConstValue
extends DfaValue {
    private static final Throwable ourThrowable = new Throwable();
    private static final Object SENTINEL = ObjectUtils.sentinel((String)"SENTINEL");
    private final Object myValue;
    @NotNull
    private final PsiType myType;

    private DfaConstValue(Object value2, @NotNull PsiType type2, DfaValueFactory factory) {
        if (type2 == null) {
            DfaConstValue.$$$reportNull$$$0(0);
        }
        super(factory);
        this.myValue = value2;
        this.myType = type2;
    }

    public String toString() {
        return DfaConstValue.renderValue(this.myValue);
    }

    public static String renderValue(Object value2) {
        if (value2 == null) {
            return "null";
        }
        if (value2 instanceof String) {
            return '\"' + StringUtil.escapeStringCharacters((String)((String)value2)) + '\"';
        }
        if (value2 instanceof PsiField) {
            PsiField field = (PsiField)value2;
            PsiClass containingClass = field.getContainingClass();
            return containingClass == null ? field.getName() : containingClass.getName() + "." + field.getName();
        }
        return value2.toString();
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType = this.myType;
        if (psiType == null) {
            DfaConstValue.$$$reportNull$$$0(1);
        }
        return psiType;
    }

    @Nullable
    public Object getValue() {
        return this.myValue;
    }

    @Override
    public DfaValue createNegated() {
        if (this == this.myFactory.getConstFactory().getTrue()) {
            return this.myFactory.getConstFactory().getFalse();
        }
        if (this == this.myFactory.getConstFactory().getFalse()) {
            return this.myFactory.getConstFactory().getTrue();
        }
        return DfaUnknownValue.getInstance();
    }

    @Contract(value="null -> false")
    public static boolean isContractFail(DfaValue value2) {
        return value2 instanceof DfaConstValue && ((DfaConstValue)value2).getValue() == ourThrowable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaConstValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaConstValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory {
        private final DfaConstValue dfaNull;
        private final DfaConstValue dfaFalse;
        private final DfaConstValue dfaTrue;
        private final DfaConstValue dfaFail;
        private final DfaConstValue dfaSentinel;
        private final DfaValueFactory myFactory;
        private final Map<Object, DfaConstValue> myValues = new HashMap<Object, DfaConstValue>();

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
            this.dfaNull = new DfaConstValue(null, (PsiType)PsiType.NULL, factory);
            this.dfaFalse = new DfaConstValue(Boolean.FALSE, (PsiType)PsiType.BOOLEAN, factory);
            this.dfaTrue = new DfaConstValue(Boolean.TRUE, (PsiType)PsiType.BOOLEAN, factory);
            this.dfaFail = new DfaConstValue(ourThrowable, (PsiType)PsiType.VOID, factory);
            this.dfaSentinel = new DfaConstValue(SENTINEL, (PsiType)PsiType.VOID, factory);
        }

        @Nullable
        public DfaValue create(PsiLiteralExpression expr) {
            PsiType type2 = expr.getType();
            if (type2 == null) {
                return null;
            }
            if (PsiType.NULL.equals((Object)type2)) {
                return this.dfaNull;
            }
            Object value2 = expr.getValue();
            if (value2 == null) {
                return null;
            }
            return this.createFromValue(value2, type2);
        }

        @Nullable
        public DfaValue create(PsiVariable variable) {
            if (DfaUtil.ignoreInitializer(variable)) {
                return null;
            }
            Object value2 = variable.computeConstantValue();
            PsiType type2 = variable.getType();
            if (value2 == null) {
                Boolean boo = Factory.computeJavaLangBooleanFieldReference(variable);
                if (boo != null) {
                    DfaConstValue unboxed = this.createFromValue(boo, (PsiType)PsiType.BOOLEAN);
                    return this.myFactory.getBoxedFactory().createBoxed(unboxed, (PsiType)PsiType.BOOLEAN.getBoxedType((PsiElement)variable));
                }
                PsiExpression initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer());
                if (initializer instanceof PsiLiteralExpression && initializer.textMatches((CharSequence)"null")) {
                    return this.dfaNull;
                }
                if (variable instanceof PsiField && variable.hasModifierProperty("static") && ExpressionUtils.isNewObject(initializer)) {
                    return this.createFromValue(variable, type2);
                }
                return null;
            }
            return this.createFromValue(value2, type2);
        }

        @Nullable
        private static Boolean computeJavaLangBooleanFieldReference(PsiVariable variable) {
            if (!(variable instanceof PsiField)) {
                return null;
            }
            PsiClass psiClass = ((PsiField)variable).getContainingClass();
            if (psiClass == null || !"java.lang.Boolean".equals(psiClass.getQualifiedName())) {
                return null;
            }
            String name2 = variable.getName();
            return "TRUE".equals(name2) ? Boolean.TRUE : ("FALSE".equals(name2) ? Boolean.FALSE : null);
        }

        @NotNull
        public DfaConstValue createDefault(@NotNull PsiType type2) {
            if (type2 == null) {
                Factory.$$$reportNull$$$0(0);
            }
            DfaConstValue dfaConstValue = this.createFromValue(PsiTypesUtil.getDefaultValue((PsiType)type2), type2);
            if (dfaConstValue == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return dfaConstValue;
        }

        @NotNull
        public DfaConstValue createFromValue(Object value2, @NotNull PsiType type2) {
            DfaConstValue instance;
            Object numeric;
            if (type2 == null) {
                Factory.$$$reportNull$$$0(2);
            }
            if (Boolean.TRUE.equals(value2)) {
                DfaConstValue dfaConstValue = this.dfaTrue;
                if (dfaConstValue == null) {
                    Factory.$$$reportNull$$$0(3);
                }
                return dfaConstValue;
            }
            if (Boolean.FALSE.equals(value2)) {
                DfaConstValue dfaConstValue = this.dfaFalse;
                if (dfaConstValue == null) {
                    Factory.$$$reportNull$$$0(4);
                }
                return dfaConstValue;
            }
            if (value2 == null) {
                DfaConstValue dfaConstValue = this.dfaNull;
                if (dfaConstValue == null) {
                    Factory.$$$reportNull$$$0(5);
                }
                return dfaConstValue;
            }
            if (TypeConversionUtil.isNumericType((PsiType)type2) && !TypeConversionUtil.isFloatOrDoubleType((PsiType)type2) && (numeric = TypeConversionUtil.computeCastTo((Object)value2, (PsiType)(type2 = PsiType.LONG))) != null) {
                value2 = numeric;
            }
            if (value2 instanceof Float) {
                value2 = ((Float)value2).doubleValue();
            }
            if ((instance = this.myValues.get(value2)) == null) {
                instance = new DfaConstValue(value2, type2, this.myFactory);
                this.myValues.put(value2, instance);
            }
            DfaConstValue dfaConstValue = instance;
            if (dfaConstValue == null) {
                Factory.$$$reportNull$$$0(6);
            }
            return dfaConstValue;
        }

        public DfaConstValue getContractFail() {
            return this.dfaFail;
        }

        public DfaConstValue getFalse() {
            return this.dfaFalse;
        }

        public DfaConstValue getTrue() {
            return this.dfaTrue;
        }

        public DfaConstValue getNull() {
            return this.dfaNull;
        }

        public DfaConstValue getSentinel() {
            return this.dfaSentinel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaConstValue$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaConstValue$Factory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDefault";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFromValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createDefault";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createFromValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

