/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inliner;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.CFGBuilder;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ComparatorModel {
    private static final CallMatcher KEY_EXTRACTOR = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Comparator", "comparing", "comparingInt", "comparingLong", "comparingDouble").parameterCount(1), CallMatcher.staticCall("java.util.Comparator", "comparing").parameterCount(2));
    private static final CallMatcher NULL_HOSTILE = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Comparator", "naturalOrder", "reverseOrder").parameterCount(0), CallMatcher.staticCall("java.util.Collections", "reverseOrder").parameterCount(0));
    private static final CallMatcher NULL_FRIENDLY = CallMatcher.staticCall("java.util.Comparator", "nullsFirst", "nullsLast").parameterCount(1);
    private static final CallMatcher REVERSED = CallMatcher.instanceCall("java.util.Comparator", "reversed").parameterCount(0);
    private static final CallMatcher REVERSE_ORDER = CallMatcher.staticCall("java.util.Collections", "reverseOrder").parameterCount(1);
    private final boolean myFailsOnNull;

    protected ComparatorModel(boolean failsOnNull) {
        this.myFailsOnNull = failsOnNull;
    }

    abstract void evaluate(CFGBuilder var1);

    abstract void invoke(CFGBuilder var1);

    boolean failsOnNull() {
        return this.myFailsOnNull;
    }

    @NotNull
    static ComparatorModel from(@Nullable PsiExpression expression2) {
        PsiField field;
        PsiReferenceExpression ref;
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) == null || NULL_HOSTILE.matches(expression2)) {
            NullHostile nullHostile = new NullHostile();
            if (nullHostile == null) {
                ComparatorModel.$$$reportNull$$$0(0);
            }
            return nullHostile;
        }
        if (expression2 instanceof PsiReferenceExpression && "CASE_INSENSITIVE_ORDER".equals((ref = (PsiReferenceExpression)expression2).getReferenceName()) && (field = (PsiField)ObjectUtils.tryCast((Object)ref.resolve(), PsiField.class)) != null && field.getContainingClass() != null && "java.lang.String".equals(field.getContainingClass().getQualifiedName())) {
            NullHostile nullHostile = new NullHostile();
            if (nullHostile == null) {
                ComparatorModel.$$$reportNull$$$0(1);
            }
            return nullHostile;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expression2, PsiMethodCallExpression.class);
        if (call == null) {
            Unknown unknown = new Unknown(expression2);
            if (unknown == null) {
                ComparatorModel.$$$reportNull$$$0(2);
            }
            return unknown;
        }
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (REVERSED.test(call) && qualifier != null) {
            ComparatorModel comparatorModel = ComparatorModel.from(qualifier);
            if (comparatorModel == null) {
                ComparatorModel.$$$reportNull$$$0(3);
            }
            return comparatorModel;
        }
        if (REVERSE_ORDER.test(call)) {
            ComparatorModel comparatorModel = ComparatorModel.from(call.getArgumentList().getExpressions()[0]);
            if (comparatorModel == null) {
                ComparatorModel.$$$reportNull$$$0(4);
            }
            return comparatorModel;
        }
        if (NULL_FRIENDLY.test(call) && qualifier != null) {
            NullFriendly nullFriendly = new NullFriendly(ComparatorModel.from(qualifier));
            if (nullFriendly == null) {
                ComparatorModel.$$$reportNull$$$0(5);
            }
            return nullFriendly;
        }
        if (KEY_EXTRACTOR.test(call)) {
            PsiExpression[] args = call.getArgumentList().getExpressions();
            PsiExpression keyExtractor = args[0];
            ComparatorModel downstream = args.length == 2 ? ComparatorModel.from(args[1]) : new NullHostile();
            KeyExtractor keyExtractor2 = new KeyExtractor(keyExtractor, downstream);
            if (keyExtractor2 == null) {
                ComparatorModel.$$$reportNull$$$0(6);
            }
            return keyExtractor2;
        }
        Unknown unknown = new Unknown(expression2);
        if (unknown == null) {
            ComparatorModel.$$$reportNull$$$0(7);
        }
        return unknown;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/inliner/ComparatorModel", "from"));
    }

    private static class KeyExtractor
    extends ComparatorModel {
        private final PsiExpression myKeyExtractor;
        private final ComparatorModel myDownstream;

        private KeyExtractor(PsiExpression keyExtractor, ComparatorModel downstream) {
            super(false);
            this.myKeyExtractor = keyExtractor;
            this.myDownstream = downstream;
        }

        @Override
        void evaluate(CFGBuilder builder) {
            builder.evaluateFunction(this.myKeyExtractor);
            this.myDownstream.evaluate(builder);
        }

        @Override
        void invoke(CFGBuilder builder) {
            builder.invokeFunction(1, this.myKeyExtractor, this.myDownstream.myFailsOnNull ? Nullability.NOT_NULL : Nullability.UNKNOWN).chain(this.myDownstream::invoke);
        }
    }

    private static class NullFriendly
    extends ComparatorModel {
        private final ComparatorModel myDownstream;

        NullFriendly(ComparatorModel downstream) {
            super(false);
            this.myDownstream = downstream;
        }

        @Override
        void evaluate(CFGBuilder builder) {
            this.myDownstream.evaluate(builder);
        }

        @Override
        void invoke(CFGBuilder builder) {
            builder.dup().ifNotNull().chain(this.myDownstream::invoke).elseBranch().pop().end();
        }
    }

    private static class Unknown
    extends ComparatorModel {
        private final PsiExpression myExpression;

        Unknown(PsiExpression expression2) {
            super(false);
            this.myExpression = expression2;
        }

        @Override
        void evaluate(CFGBuilder builder) {
            builder.evaluateFunction(this.myExpression);
        }

        @Override
        void invoke(CFGBuilder builder) {
            builder.pushUnknown().invokeFunction(2, this.myExpression).pop();
        }
    }

    private static class NullHostile
    extends ComparatorModel {
        NullHostile() {
            super(true);
        }

        @Override
        void evaluate(CFGBuilder builder) {
        }

        @Override
        void invoke(CFGBuilder builder) {
            builder.pop();
        }
    }
}

