/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.inference.ExpressionRange;
import com.intellij.codeInspection.dataFlow.inference.MethodReturnInferenceResult;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.FileLocalResolver;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MethodReturnInferenceVisitor {
    private static final TokenSet SHORT_CIRCUIT = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.ANDAND, JavaTokenType.OROR});
    private final LighterAST tree;
    private final List<LighterASTNode> myParameters;
    private final LighterASTNode myBody;
    private boolean hasErrors;
    private ReturnValue myReturnValue = ReturnValue.TOP;
    private boolean hasSystemExit;

    MethodReturnInferenceVisitor(LighterAST tree, List<LighterASTNode> parameters2, LighterASTNode body2) {
        this.tree = tree;
        this.myParameters = parameters2;
        this.myBody = body2;
    }

    void visitNode(LighterASTNode element) {
        LighterASTNode qualifier;
        LighterASTNode reference;
        IElementType type2 = element.getTokenType();
        if (type2 == TokenType.ERROR_ELEMENT) {
            this.hasErrors = true;
        } else if (type2 == JavaElementType.RETURN_STATEMENT) {
            LighterASTNode value2 = JavaLightTreeUtil.findExpressionChild(this.tree, element);
            if (value2 == null) {
                this.hasErrors = true;
            } else {
                this.myReturnValue = ReturnValue.merge(this.myReturnValue, this.getExpressionValue(value2));
            }
        } else if (type2 == JavaElementType.METHOD_CALL_EXPRESSION && "exit".equals(JavaLightTreeUtil.getNameIdentifierText(this.tree, reference = JavaLightTreeUtil.findExpressionChild(this.tree, element))) && "System".equals(JavaLightTreeUtil.getNameIdentifierText(this.tree, qualifier = JavaLightTreeUtil.findExpressionChild(this.tree, reference))) && JavaLightTreeUtil.findExpressionChild(this.tree, qualifier) == null) {
            this.hasSystemExit = true;
        }
    }

    @NotNull
    private ReturnValue getExpressionValue(@Nullable LighterASTNode expr) {
        LighterASTNode target;
        if ((expr = JavaLightTreeUtil.skipParenthesesCastsDown(this.tree, expr)) == null) {
            ReturnValue returnValue = ReturnValue.UNKNOWN;
            if (returnValue == null) {
                MethodReturnInferenceVisitor.$$$reportNull$$$0(0);
            }
            return returnValue;
        }
        IElementType type2 = expr.getTokenType();
        if (this.isNullLiteral(expr)) {
            ReturnValue returnValue = ReturnValue.NULLABLE;
            if (returnValue == null) {
                MethodReturnInferenceVisitor.$$$reportNull$$$0(1);
            }
            return returnValue;
        }
        if (type2 == JavaElementType.LAMBDA_EXPRESSION || type2 == JavaElementType.NEW_EXPRESSION || type2 == JavaElementType.METHOD_REF_EXPRESSION || type2 == JavaElementType.LITERAL_EXPRESSION || type2 == JavaElementType.BINARY_EXPRESSION || type2 == JavaElementType.POLYADIC_EXPRESSION) {
            ReturnValue returnValue = ReturnValue.NOT_NULL;
            if (returnValue == null) {
                MethodReturnInferenceVisitor.$$$reportNull$$$0(2);
            }
            return returnValue;
        }
        if (type2 == JavaElementType.METHOD_CALL_EXPRESSION) {
            String calledMethod = JavaLightTreeUtil.getNameIdentifierText(this.tree, (LighterASTNode)this.tree.getChildren(expr).get(0));
            if (calledMethod != null) {
                ReturnValue returnValue = ReturnValue.delegate(calledMethod, ExpressionRange.create(expr, this.myBody.getStartOffset()));
                if (returnValue == null) {
                    MethodReturnInferenceVisitor.$$$reportNull$$$0(3);
                }
                return returnValue;
            }
        } else if (type2 == JavaElementType.CONDITIONAL_EXPRESSION) {
            List<LighterASTNode> expressionChildren = JavaLightTreeUtil.getExpressionChildren(this.tree, expr);
            if (expressionChildren.size() == 3) {
                ReturnValue returnValue = ReturnValue.merge(this.getExpressionValue(expressionChildren.get(1)), this.getExpressionValue(expressionChildren.get(2)));
                if (returnValue == null) {
                    MethodReturnInferenceVisitor.$$$reportNull$$$0(4);
                }
                return returnValue;
            }
        } else if (type2 == JavaElementType.REFERENCE_EXPRESSION && (target = new FileLocalResolver(this.tree).resolveLocally(expr).getTarget()) != null && (target.getTokenType() == JavaElementType.LOCAL_VARIABLE || target.getTokenType() == JavaElementType.PARAMETER)) {
            ReturnValue returnValue = this.findVariableValue(expr, target);
            if (returnValue == null) {
                MethodReturnInferenceVisitor.$$$reportNull$$$0(5);
            }
            return returnValue;
        }
        ReturnValue returnValue = ReturnValue.UNKNOWN;
        if (returnValue == null) {
            MethodReturnInferenceVisitor.$$$reportNull$$$0(6);
        }
        return returnValue;
    }

    @NotNull
    private ReturnValue findVariableValue(LighterASTNode expr, LighterASTNode target) {
        LighterASTNode parent;
        while (true) {
            List<LighterASTNode> operands2;
            if ((parent = this.tree.getParent(expr)) == null) {
                ReturnValue returnValue = ReturnValue.UNKNOWN;
                if (returnValue == null) {
                    MethodReturnInferenceVisitor.$$$reportNull$$$0(7);
                }
                return returnValue;
            }
            IElementType type2 = parent.getTokenType();
            if (!ElementType.EXPRESSION_BIT_SET.contains(type2)) break;
            if (type2 == JavaElementType.CONDITIONAL_EXPRESSION && (operands2 = JavaLightTreeUtil.getExpressionChildren(this.tree, parent)).size() == 3) {
                LighterASTNode condition2 = operands2.get(0);
                if (expr.equals(operands2.get(1)) && this.isNullCheck(condition2, target, false) || expr.equals(operands2.get(2)) && this.isNullCheck(condition2, target, true)) {
                    ReturnValue returnValue = ReturnValue.NOT_NULL;
                    if (returnValue == null) {
                        MethodReturnInferenceVisitor.$$$reportNull$$$0(8);
                    }
                    return returnValue;
                }
            }
            expr = parent;
        }
        if (ElementType.JAVA_STATEMENT_BIT_SET.contains(parent.getTokenType())) {
            ReturnValue value2 = this.findValueBeforeStatement(parent, target);
            if (!this.myParameters.isEmpty()) {
                value2 = value2.dropNullable();
            }
            ReturnValue returnValue = value2;
            if (returnValue == null) {
                MethodReturnInferenceVisitor.$$$reportNull$$$0(9);
            }
            return returnValue;
        }
        ReturnValue returnValue = ReturnValue.UNKNOWN;
        if (returnValue == null) {
            MethodReturnInferenceVisitor.$$$reportNull$$$0(10);
        }
        return returnValue;
    }

    @NotNull
    private ReturnValue findValueBeforeStatement(LighterASTNode statement, LighterASTNode target) {
        LighterASTNode parent = this.tree.getParent(statement);
        if (parent == null) {
            ReturnValue returnValue = ReturnValue.UNKNOWN;
            if (returnValue == null) {
                MethodReturnInferenceVisitor.$$$reportNull$$$0(11);
            }
            return returnValue;
        }
        if (parent.getTokenType() == JavaElementType.CODE_BLOCK) {
            List children = this.tree.getChildren(parent);
            for (int i = children.lastIndexOf(statement) - 1; i >= 0; --i) {
                ReturnValue value2;
                LighterASTNode child = (LighterASTNode)children.get(i);
                if (!ElementType.JAVA_STATEMENT_BIT_SET.contains(child.getTokenType()) || (value2 = this.findValueInStatement(child, target)) == null) continue;
                ReturnValue returnValue = value2;
                if (returnValue == null) {
                    MethodReturnInferenceVisitor.$$$reportNull$$$0(12);
                }
                return returnValue;
            }
            LighterASTNode grandParent = this.tree.getParent(parent);
            if (grandParent == null || grandParent.getTokenType() != JavaElementType.BLOCK_STATEMENT) {
                ReturnValue returnValue = ReturnValue.UNKNOWN;
                if (returnValue == null) {
                    MethodReturnInferenceVisitor.$$$reportNull$$$0(13);
                }
                return returnValue;
            }
            ReturnValue returnValue = this.findValueBeforeStatement(grandParent, target);
            if (returnValue == null) {
                MethodReturnInferenceVisitor.$$$reportNull$$$0(14);
            }
            return returnValue;
        }
        if (parent.getTokenType() == JavaElementType.IF_STATEMENT) {
            LighterASTNode condition2 = JavaLightTreeUtil.findExpressionChild(this.tree, parent);
            List branches = LightTreeUtil.getChildrenOfType((LighterAST)this.tree, (LighterASTNode)parent, (TokenSet)ElementType.JAVA_STATEMENT_BIT_SET);
            int index = branches.indexOf(statement);
            if (index == 0 && this.isNullCheck(condition2, target, false) || index == 1 && this.isNullCheck(condition2, target, true)) {
                ReturnValue returnValue = ReturnValue.NOT_NULL;
                if (returnValue == null) {
                    MethodReturnInferenceVisitor.$$$reportNull$$$0(15);
                }
                return returnValue;
            }
            ReturnValue value3 = this.findValueInExpression(condition2, target);
            if (value3 != null) {
                ReturnValue returnValue = value3;
                if (returnValue == null) {
                    MethodReturnInferenceVisitor.$$$reportNull$$$0(16);
                }
                return returnValue;
            }
            ReturnValue returnValue = this.findValueBeforeStatement(parent, target);
            if (returnValue == null) {
                MethodReturnInferenceVisitor.$$$reportNull$$$0(17);
            }
            return returnValue;
        }
        if (parent.getTokenType() == JavaElementType.WHILE_STATEMENT) {
            LighterASTNode condition3 = JavaLightTreeUtil.findExpressionChild(this.tree, parent);
            if (this.isNullCheck(condition3, target, false)) {
                ReturnValue returnValue = ReturnValue.NOT_NULL;
                if (returnValue == null) {
                    MethodReturnInferenceVisitor.$$$reportNull$$$0(18);
                }
                return returnValue;
            }
            ReturnValue returnValue = ReturnValue.UNKNOWN;
            if (returnValue == null) {
                MethodReturnInferenceVisitor.$$$reportNull$$$0(19);
            }
            return returnValue;
        }
        if (parent.getTokenType() == JavaElementType.SYNCHRONIZED_STATEMENT) {
            ReturnValue value4 = this.findValueInExpression(JavaLightTreeUtil.findExpressionChild(this.tree, parent), target);
            if (value4 != null) {
                ReturnValue returnValue = value4;
                if (returnValue == null) {
                    MethodReturnInferenceVisitor.$$$reportNull$$$0(20);
                }
                return returnValue;
            }
            ReturnValue returnValue = this.findValueBeforeStatement(parent, target);
            if (returnValue == null) {
                MethodReturnInferenceVisitor.$$$reportNull$$$0(21);
            }
            return returnValue;
        }
        ReturnValue returnValue = ReturnValue.UNKNOWN;
        if (returnValue == null) {
            MethodReturnInferenceVisitor.$$$reportNull$$$0(22);
        }
        return returnValue;
    }

    @Nullable
    private ReturnValue findValueInStatement(LighterASTNode statement, LighterASTNode target) {
        ReturnValue value2;
        if (statement == null) {
            return null;
        }
        IElementType tokenType = statement.getTokenType();
        if (tokenType == JavaElementType.EXPRESSION_STATEMENT) {
            LighterASTNode expression2 = JavaLightTreeUtil.findExpressionChild(this.tree, statement);
            return this.findValueInExpression(expression2, target);
        }
        if (tokenType == JavaElementType.DECLARATION_STATEMENT) {
            List declaredElements = this.tree.getChildren(statement);
            for (int i = declaredElements.size() - 1; i >= 0; --i) {
                LighterASTNode declared = (LighterASTNode)declaredElements.get(i);
                if (declared.getTokenType() != JavaElementType.LOCAL_VARIABLE) continue;
                LighterASTNode initializer = JavaLightTreeUtil.findExpressionChild(this.tree, declared);
                if (declared.equals(target)) {
                    return this.getExpressionValue(initializer);
                }
                ReturnValue value3 = this.findValueInExpression(initializer, target);
                if (value3 == null) continue;
                return value3;
            }
        }
        if (tokenType == JavaElementType.BLOCK_STATEMENT) {
            LighterASTNode block = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)statement, (IElementType)JavaElementType.CODE_BLOCK);
            if (block != null) {
                List children = LightTreeUtil.getChildrenOfType((LighterAST)this.tree, (LighterASTNode)block, (TokenSet)ElementType.JAVA_STATEMENT_BIT_SET);
                for (int i = children.size() - 1; i >= 0; --i) {
                    ReturnValue value4 = this.findValueInStatement((LighterASTNode)children.get(i), target);
                    if (value4 == null) continue;
                    return value4;
                }
            }
            return null;
        }
        if (tokenType == JavaElementType.IF_STATEMENT && (value2 = this.findValueInIfStatement(statement, target)) != null) {
            return value2;
        }
        if (this.isAssignedInside(statement, target)) {
            return ReturnValue.UNKNOWN;
        }
        return null;
    }

    @Nullable
    private ReturnValue findValueInIfStatement(LighterASTNode statement, LighterASTNode target) {
        List branches = LightTreeUtil.getChildrenOfType((LighterAST)this.tree, (LighterASTNode)statement, (TokenSet)ElementType.JAVA_STATEMENT_BIT_SET);
        LighterASTNode condition2 = JavaLightTreeUtil.findExpressionChild(this.tree, statement);
        LighterASTNode thenBranch = (LighterASTNode)ContainerUtil.getFirstItem((List)branches);
        LighterASTNode elseBranch = branches.size() == 2 ? (LighterASTNode)branches.get(1) : null;
        boolean thenBreaks = this.completesAbruptly(thenBranch);
        boolean elseBreaks = this.completesAbruptly(elseBranch);
        ReturnValue thenValue = this.findValueInStatement(thenBranch, target);
        ReturnValue elseValue = this.findValueInStatement(elseBranch, target);
        if (elseValue == null && thenBreaks && !elseBreaks && this.isNullCheck(condition2, target, true)) {
            elseValue = ReturnValue.NOT_NULL;
        }
        if (thenValue == null && elseBreaks && !thenBreaks && this.isNullCheck(condition2, target, false)) {
            thenValue = ReturnValue.NOT_NULL;
        }
        if (thenBreaks && !elseBreaks) {
            thenValue = elseValue;
        }
        if (elseBreaks && !thenBreaks) {
            elseValue = thenValue;
        }
        if (thenValue == null) {
            ReturnValue returnValue = thenValue = this.isNullCheck(condition2, target, false) ? ReturnValue.NOT_NULL : this.findValueInExpression(condition2, target);
        }
        if (elseValue == null) {
            ReturnValue returnValue = elseValue = this.isNullCheck(condition2, target, true) ? ReturnValue.NOT_NULL : this.findValueInExpression(condition2, target);
        }
        if (thenValue == null || elseValue == null) {
            return null;
        }
        return ReturnValue.merge(thenValue, elseValue);
    }

    @Nullable
    private ReturnValue findValueInExpression(LighterASTNode expression2, LighterASTNode target) {
        List<LighterASTNode> children;
        if (expression2 == null) {
            return null;
        }
        IElementType type2 = expression2.getTokenType();
        if (type2 == JavaElementType.ASSIGNMENT_EXPRESSION && (children = JavaLightTreeUtil.getExpressionChildren(this.tree, expression2)).size() == 2 && this.isReferenceToLocal(children.get(0), target)) {
            if (LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)expression2, (IElementType)JavaTokenType.EQ) == null) {
                return ReturnValue.NOT_NULL;
            }
            return this.getExpressionValue(children.get(1));
        }
        if (this.isAssignedInside(expression2, target)) {
            return ReturnValue.UNKNOWN;
        }
        if (this.isDereferencedInside(expression2, target)) {
            return ReturnValue.NOT_NULL;
        }
        return null;
    }

    private boolean completesAbruptly(LighterASTNode statement) {
        LighterASTNode block;
        if (statement == null) {
            return false;
        }
        if (statement.getTokenType() == JavaElementType.BLOCK_STATEMENT && (block = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)statement, (IElementType)JavaElementType.CODE_BLOCK)) != null) {
            LighterASTNode lastStatement = (LighterASTNode)ContainerUtil.getLastItem((List)LightTreeUtil.getChildrenOfType((LighterAST)this.tree, (LighterASTNode)block, (TokenSet)ElementType.JAVA_STATEMENT_BIT_SET));
            return lastStatement != null && this.completesAbruptly(lastStatement);
        }
        return statement.getTokenType() == JavaElementType.BREAK_STATEMENT || statement.getTokenType() == JavaElementType.CONTINUE_STATEMENT || statement.getTokenType() == JavaElementType.RETURN_STATEMENT || statement.getTokenType() == JavaElementType.THROW_STATEMENT;
    }

    private boolean isAssignedInside(LighterASTNode element, LighterASTNode target) {
        ArrayDeque<LighterASTNode> workList = new ArrayDeque<LighterASTNode>();
        workList.add(element);
        while (!workList.isEmpty()) {
            IElementType tokenType;
            LighterASTNode parent;
            LighterASTNode node = (LighterASTNode)workList.poll();
            if (this.isReferenceToLocal(node, target) && (parent = this.tree.getParent(node)) != null) {
                IElementType type2 = parent.getTokenType();
                if (type2 == JavaElementType.ASSIGNMENT_EXPRESSION && node.equals(JavaLightTreeUtil.findExpressionChild(this.tree, parent))) {
                    return true;
                }
                if (type2 == JavaElementType.POSTFIX_EXPRESSION || type2 == JavaElementType.PREFIX_EXPRESSION) {
                    return true;
                }
            }
            if ((tokenType = node.getTokenType()) == JavaElementType.LAMBDA_EXPRESSION || tokenType == JavaElementType.TYPE_PARAMETER_LIST || tokenType == JavaElementType.ANONYMOUS_CLASS) continue;
            workList.addAll(this.tree.getChildren(node));
        }
        return false;
    }

    private boolean isDereferencedInside(LighterASTNode expression2, LighterASTNode target) {
        ArrayDeque<LighterASTNode> workList = new ArrayDeque<LighterASTNode>();
        workList.add(expression2);
        while (!workList.isEmpty()) {
            IElementType type2;
            LighterASTNode parent;
            LighterASTNode node = (LighterASTNode)workList.poll();
            if (this.isReferenceToLocal(node, target) && (parent = this.tree.getParent(node)) != null && ((type2 = parent.getTokenType()) == JavaElementType.REFERENCE_EXPRESSION || type2 == JavaElementType.ARRAY_ACCESS_EXPRESSION)) {
                return true;
            }
            IElementType tokenType = node.getTokenType();
            if (tokenType == JavaElementType.CONDITIONAL_EXPRESSION || tokenType == JavaElementType.SWITCH_EXPRESSION || (tokenType == JavaElementType.POLYADIC_EXPRESSION || tokenType == JavaElementType.BINARY_EXPRESSION) && LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)node, (TokenSet)SHORT_CIRCUIT) != null) {
                ContainerUtil.addIfNotNull(workList, (Object)JavaLightTreeUtil.findExpressionChild(this.tree, node));
                continue;
            }
            if (tokenType == JavaElementType.LAMBDA_EXPRESSION || tokenType == JavaElementType.TYPE_PARAMETER_LIST || tokenType == JavaElementType.ANONYMOUS_CLASS) continue;
            workList.addAll(this.tree.getChildren(node));
        }
        return false;
    }

    private boolean isNullCheck(@Nullable LighterASTNode expr, LighterASTNode var, boolean negated) {
        if ((expr = JavaLightTreeUtil.skipParenthesesCastsDown(this.tree, expr)) == null || this.isAssignedInside(expr, var)) {
            return false;
        }
        IElementType type2 = expr.getTokenType();
        if (type2 == JavaElementType.BINARY_EXPRESSION || type2 == JavaElementType.POLYADIC_EXPRESSION) {
            List<LighterASTNode> operands2 = JavaLightTreeUtil.getExpressionChildren(this.tree, expr);
            if (LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)expr, (IElementType)(negated ? JavaTokenType.EQEQ : JavaTokenType.NE)) != null) {
                return operands2.size() == 2 && this.isNullLiteral(operands2.get(1)) && this.isReferenceToLocal(operands2.get(0), var);
            }
            if (LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)expr, (IElementType)(negated ? JavaTokenType.OROR : JavaTokenType.ANDAND)) == null) {
                return false;
            }
            for (LighterASTNode t : operands2) {
                if (!this.isNullCheck(t, var, negated)) continue;
                return true;
            }
            return false;
        }
        if (type2 == JavaElementType.PREFIX_EXPRESSION && LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)expr, (IElementType)JavaTokenType.EXCL) != null) {
            return this.isNullCheck(JavaLightTreeUtil.findExpressionChild(this.tree, expr), var, !negated);
        }
        return !negated && type2 == JavaElementType.INSTANCE_OF_EXPRESSION && this.isReferenceToLocal(JavaLightTreeUtil.findExpressionChild(this.tree, expr), var);
    }

    private boolean isReferenceToLocal(@Nullable LighterASTNode operand2, @NotNull LighterASTNode var) {
        if (var == null) {
            MethodReturnInferenceVisitor.$$$reportNull$$$0(23);
        }
        return operand2 != null && operand2.getTokenType() == JavaElementType.REFERENCE_EXPRESSION && Objects.requireNonNull(this.tree.getParent(operand2)).getTokenType() != JavaElementType.METHOD_CALL_EXPRESSION && JavaLightTreeUtil.findExpressionChild(this.tree, operand2) == null && Objects.equals(JavaLightTreeUtil.getNameIdentifierText(this.tree, operand2), JavaLightTreeUtil.getNameIdentifierText(this.tree, var));
    }

    private boolean isNullLiteral(@NotNull LighterASTNode value2) {
        if (value2 == null) {
            MethodReturnInferenceVisitor.$$$reportNull$$$0(24);
        }
        return value2.getTokenType() == JavaElementType.LITERAL_EXPRESSION && ((LighterASTNode)this.tree.getChildren(value2).get(0)).getTokenType() == JavaTokenType.NULL_KEYWORD;
    }

    @Nullable
    MethodReturnInferenceResult getResult() {
        List<ExpressionRange> delegateCalls = this.myReturnValue.myCalledMethod == null ? null : this.myReturnValue.myRanges;
        boolean hasNulls = this.myReturnValue.myNullability.contains(Nullability.NULLABLE);
        boolean hasNotNulls = this.myReturnValue.myNullability.contains(Nullability.NOT_NULL);
        boolean hasUnknowns = this.myReturnValue.myNullability.contains(Nullability.UNKNOWN);
        if (hasNulls) {
            if (this.hasSystemExit) {
                return new MethodReturnInferenceResult.Predefined(Nullability.UNKNOWN);
            }
            return delegateCalls == null || hasNotNulls || this.hasErrors || hasUnknowns ? new MethodReturnInferenceResult.Predefined(Nullability.NULLABLE) : new MethodReturnInferenceResult.FromDelegate(Nullability.NULLABLE, delegateCalls);
        }
        if (this.hasErrors || hasUnknowns) {
            return null;
        }
        if (delegateCalls != null) {
            return new MethodReturnInferenceResult.FromDelegate(hasNotNulls ? Nullability.NOT_NULL : Nullability.UNKNOWN, delegateCalls);
        }
        if (hasNotNulls) {
            return new MethodReturnInferenceResult.Predefined(Nullability.NOT_NULL);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 23: 
            case 24: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 23: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/inference/MethodReturnInferenceVisitor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionValue";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findVariableValue";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findValueBeforeStatement";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/inference/MethodReturnInferenceVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceToLocal";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isNullLiteral";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 23: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReturnValue {
        static final ReturnValue TOP = new ReturnValue(EnumSet.noneOf(Nullability.class), null, Collections.emptyList());
        static final ReturnValue UNKNOWN = new ReturnValue(EnumSet.of(Nullability.UNKNOWN), null, Collections.emptyList());
        static final ReturnValue NULLABLE = new ReturnValue(EnumSet.of(Nullability.NULLABLE), null, Collections.emptyList());
        static final ReturnValue NOT_NULL = new ReturnValue(EnumSet.of(Nullability.NOT_NULL), null, Collections.emptyList());
        @NotNull
        final EnumSet<Nullability> myNullability;
        @Nullable
        final String myCalledMethod;
        @NotNull
        final List<ExpressionRange> myRanges;

        private ReturnValue(@NotNull EnumSet<Nullability> nullability, @Nullable String method, @NotNull List<ExpressionRange> ranges) {
            if (nullability == null) {
                ReturnValue.$$$reportNull$$$0(0);
            }
            if (ranges == null) {
                ReturnValue.$$$reportNull$$$0(1);
            }
            this.myNullability = nullability;
            this.myCalledMethod = method;
            this.myRanges = ranges;
        }

        public ReturnValue dropNullable() {
            if (!this.myNullability.contains(Nullability.NULLABLE)) {
                return this;
            }
            EnumSet<Nullability> copy = EnumSet.copyOf(this.myNullability);
            copy.remove(Nullability.NULLABLE);
            copy.add(Nullability.UNKNOWN);
            return new ReturnValue(copy, this.myCalledMethod, this.myRanges);
        }

        static ReturnValue delegate(@NotNull String method, @NotNull ExpressionRange range) {
            if (method == null) {
                ReturnValue.$$$reportNull$$$0(2);
            }
            if (range == null) {
                ReturnValue.$$$reportNull$$$0(3);
            }
            return new ReturnValue(EnumSet.noneOf(Nullability.class), method, Collections.singletonList(range));
        }

        static ReturnValue merge(@NotNull ReturnValue left, @NotNull ReturnValue right) {
            List range;
            String calledMethod;
            if (left == null) {
                ReturnValue.$$$reportNull$$$0(4);
            }
            if (right == null) {
                ReturnValue.$$$reportNull$$$0(5);
            }
            EnumSet<Nullability> nullability = EnumSet.copyOf(left.myNullability);
            nullability.addAll(right.myNullability);
            if (left.myCalledMethod == null) {
                calledMethod = right.myCalledMethod;
                range = right.myRanges;
            } else if (right.myCalledMethod == null) {
                calledMethod = left.myCalledMethod;
                range = left.myRanges;
            } else if (left.myCalledMethod.equals(right.myCalledMethod)) {
                calledMethod = left.myCalledMethod;
                range = ContainerUtil.concat(left.myRanges, right.myRanges);
            } else {
                calledMethod = "";
                range = Collections.emptyList();
                nullability.add(Nullability.UNKNOWN);
            }
            return new ReturnValue(nullability, calledMethod, range);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nullability";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ranges";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/dataFlow/inference/MethodReturnInferenceVisitor$ReturnValue";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "delegate";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "merge";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

