/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.inference.ContractInferenceIndexKt;
import com.intellij.codeInspection.dataFlow.inference.MethodData;
import com.intellij.codeInspection.dataFlow.inference.MethodReturnInferenceResult;
import com.intellij.codeInspection.dataFlow.inference.PreContract;
import com.intellij.codeInspection.dataFlow.inference.PurityInferenceResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;

public class JavaSourceInference {
    public static final int MAX_CONTRACT_COUNT = 10;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.inference.JavaSourceInference");

    @NotNull
    private static MethodInferenceData infer(PsiMethodImpl method) {
        InferenceMode mode = JavaSourceInference.getInferenceMode(method);
        if (mode == InferenceMode.DISABLED || mode == InferenceMode.PARAMETERS && method.getParameterList().isEmpty()) {
            MethodInferenceData methodInferenceData = MethodInferenceData.UNKNOWN;
            if (methodInferenceData == null) {
                JavaSourceInference.$$$reportNull$$$0(0);
            }
            return methodInferenceData;
        }
        MethodData data = ContractInferenceIndexKt.getIndexedData(method);
        if (data == null) {
            MethodInferenceData methodInferenceData = MethodInferenceData.UNKNOWN;
            if (methodInferenceData == null) {
                JavaSourceInference.$$$reportNull$$$0(1);
            }
            return methodInferenceData;
        }
        BitSet notNullParameters = data.getNotNullParameters();
        if (mode == InferenceMode.PARAMETERS) {
            MethodInferenceData methodInferenceData = notNullParameters.isEmpty() ? MethodInferenceData.UNKNOWN : new MethodInferenceData(Mutability.UNKNOWN, Nullability.UNKNOWN, Collections.emptyList(), false, notNullParameters);
            if (methodInferenceData == null) {
                JavaSourceInference.$$$reportNull$$$0(2);
            }
            return methodInferenceData;
        }
        Nullability nullability = JavaSourceInference.findNullability(method, data);
        Mutability mutability = JavaSourceInference.findMutability(method, data);
        boolean pure = JavaSourceInference.findPurity(method, data);
        IntPredicate isNotNullParameter = i -> {
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)method.getProject());
            NullabilityAnnotationInfo parameterInfo = manager.findExplicitNullability((PsiModifierListOwner)parameters2[i]);
            return parameterInfo != null ? parameterInfo.getNullability() == Nullability.NOT_NULL : notNullParameters.get(i);
        };
        List<StandardMethodContract> contracts2 = JavaSourceInference.findContracts(method, data, nullability, isNotNullParameter);
        if (nullability == Nullability.NULLABLE && ContainerUtil.find(contracts2, c -> c.getReturnValue().isNull()) != null) {
            nullability = Nullability.UNKNOWN;
        }
        MethodInferenceData methodInferenceData = new MethodInferenceData(mutability, nullability, contracts2, pure, notNullParameters);
        if (methodInferenceData == null) {
            JavaSourceInference.$$$reportNull$$$0(3);
        }
        return methodInferenceData;
    }

    @NotNull
    private static Nullability findNullability(PsiMethodImpl method, MethodData data) {
        PsiType type2 = method.getReturnType();
        NullabilityAnnotationInfo info = NullableNotNullManager.getInstance((Project)method.getProject()).findExplicitNullability((PsiModifierListOwner)method);
        if (info != null) {
            Nullability nullability = info.getNullability();
            if (nullability == null) {
                JavaSourceInference.$$$reportNull$$$0(4);
            }
            return nullability;
        }
        if (type2 == null || type2 instanceof PsiPrimitiveType) {
            Nullability nullability = Nullability.UNKNOWN;
            if (nullability == null) {
                JavaSourceInference.$$$reportNull$$$0(5);
            }
            return nullability;
        }
        MethodReturnInferenceResult result = data.getMethodReturn();
        if (result == null) {
            Nullability nullability = Nullability.UNKNOWN;
            if (nullability == null) {
                JavaSourceInference.$$$reportNull$$$0(6);
            }
            return nullability;
        }
        Nullability nullability = (Nullability)RecursionManager.doPreventingRecursion((Object)((Object)method), (boolean)true, () -> result.getNullability(method, data.methodBody(method)));
        Nullability nullability2 = nullability == null ? Nullability.UNKNOWN : nullability;
        if (nullability2 == null) {
            JavaSourceInference.$$$reportNull$$$0(7);
        }
        return nullability2;
    }

    @NotNull
    private static Mutability findMutability(@NotNull PsiMethodImpl method, @NotNull MethodData data) {
        PsiType type2;
        if (method == null) {
            JavaSourceInference.$$$reportNull$$$0(8);
        }
        if (data == null) {
            JavaSourceInference.$$$reportNull$$$0(9);
        }
        if ((type2 = method.getReturnType()) == null || ClassUtils.isImmutable(type2, false)) {
            Mutability mutability = Mutability.UNKNOWN;
            if (mutability == null) {
                JavaSourceInference.$$$reportNull$$$0(10);
            }
            return mutability;
        }
        MethodReturnInferenceResult result = data.getMethodReturn();
        if (result == null) {
            Mutability mutability = Mutability.UNKNOWN;
            if (mutability == null) {
                JavaSourceInference.$$$reportNull$$$0(11);
            }
            return mutability;
        }
        Mutability mutability = (Mutability)((Object)RecursionManager.doPreventingRecursion((Object)((Object)method), (boolean)true, () -> result.getMutability(method, data.methodBody(method))));
        Mutability mutability2 = mutability == null ? Mutability.UNKNOWN : mutability;
        if (mutability2 == null) {
            JavaSourceInference.$$$reportNull$$$0(12);
        }
        return mutability2;
    }

    private static boolean findPurity(@NotNull PsiMethodImpl method, @NotNull MethodData data) {
        if (method == null) {
            JavaSourceInference.$$$reportNull$$$0(13);
        }
        if (data == null) {
            JavaSourceInference.$$$reportNull$$$0(14);
        }
        if (PsiType.VOID.equals((Object)method.getReturnType())) {
            return false;
        }
        PurityInferenceResult result = data.getPurity();
        if (result == null) {
            return false;
        }
        return Boolean.TRUE.equals(RecursionManager.doPreventingRecursion((Object)((Object)method), (boolean)true, () -> result.isPure(method, data.methodBody(method))));
    }

    @NotNull
    private static List<StandardMethodContract> findContracts(@NotNull PsiMethodImpl method, @NotNull MethodData data, @NotNull Nullability nullability, @NotNull IntPredicate notNullParameter) {
        StandardMethodContract collapsed;
        PsiAnnotation explicitContract;
        if (method == null) {
            JavaSourceInference.$$$reportNull$$$0(15);
        }
        if (data == null) {
            JavaSourceInference.$$$reportNull$$$0(16);
        }
        if (nullability == null) {
            JavaSourceInference.$$$reportNull$$$0(17);
        }
        if (notNullParameter == null) {
            JavaSourceInference.$$$reportNull$$$0(18);
        }
        if ((explicitContract = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method, Collections.singleton(JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT), (boolean)true)) != null) {
            List<StandardMethodContract> list = JavaMethodContractUtil.parseContracts(method, explicitContract);
            if (list == null) {
                JavaSourceInference.$$$reportNull$$$0(19);
            }
            return list;
        }
        List<PreContract> preContracts = data.getContracts();
        List<StandardMethodContract> contracts2 = (List<StandardMethodContract>)RecursionManager.doPreventingRecursion((Object)((Object)method), (boolean)true, () -> ContainerUtil.concat((Iterable)preContracts, c -> c.toContracts(method, data.methodBody(method))));
        if (contracts2 == null || contracts2.isEmpty()) {
            List<StandardMethodContract> list = Collections.emptyList();
            if (list == null) {
                JavaSourceInference.$$$reportNull$$$0(20);
            }
            return list;
        }
        if (contracts2.size() == 2 && (collapsed = ((StandardMethodContract)contracts2.get(0)).tryCollapse((StandardMethodContract)contracts2.get(1))) != null) {
            contracts2 = Collections.singletonList(collapsed);
        }
        List<StandardMethodContract> list = JavaSourceInference.postProcessContracts(contracts2, method, nullability, notNullParameter);
        if (list == null) {
            JavaSourceInference.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    private static List<StandardMethodContract> postProcessContracts(List<StandardMethodContract> contracts2, @NotNull PsiMethod method, @NotNull Nullability nullability, @NotNull IntPredicate notNullParameter) {
        List compatible;
        PsiType returnType;
        if (method == null) {
            JavaSourceInference.$$$reportNull$$$0(22);
        }
        if (nullability == null) {
            JavaSourceInference.$$$reportNull$$$0(23);
        }
        if (notNullParameter == null) {
            JavaSourceInference.$$$reportNull$$$0(24);
        }
        if ((returnType = method.getReturnType()) != null && !(returnType instanceof PsiPrimitiveType)) {
            contracts2 = JavaSourceInference.boxReturnValues(contracts2);
        }
        if ((compatible = ContainerUtil.filter(contracts2, contract -> {
            for (int i = 0; i < contract.getParameterCount(); ++i) {
                if (contract.getParameterConstraint(i) != StandardMethodContract.ValueConstraint.NULL_VALUE || !notNullParameter.test(i)) continue;
                return false;
            }
            ContractReturnValue retValue = contract.getReturnValue();
            if (nullability == Nullability.NOT_NULL && (retValue.equals(ContractReturnValue.returnNotNull()) || retValue.isNull())) {
                return false;
            }
            if (nullability == Nullability.NULLABLE && retValue.isNotNull() && contract.isTrivial()) {
                return false;
            }
            return retValue.isMethodCompatible(method);
        })).size() > 10) {
            LOG.debug("Too many contracts for " + PsiUtil.getMemberQualifiedName((PsiMember)method) + ", shrinking the list");
            List<StandardMethodContract> list = compatible.subList(0, 10);
            if (list == null) {
                JavaSourceInference.$$$reportNull$$$0(25);
            }
            return list;
        }
        List list = compatible;
        if (list == null) {
            JavaSourceInference.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    private static MethodInferenceData getInferenceData(PsiMethod method) {
        if (!(method instanceof PsiMethodImpl)) {
            MethodInferenceData methodInferenceData = MethodInferenceData.UNKNOWN;
            if (methodInferenceData == null) {
                JavaSourceInference.$$$reportNull$$$0(27);
            }
            return methodInferenceData;
        }
        MethodInferenceData methodInferenceData = (MethodInferenceData)CachedValuesManager.getCachedValue((PsiElement)method, () -> CachedValueProvider.Result.create((Object)JavaSourceInference.infer((PsiMethodImpl)method), (Object[])new Object[]{method, PsiModificationTracker.MODIFICATION_COUNT}));
        if (methodInferenceData == null) {
            JavaSourceInference.$$$reportNull$$$0(28);
        }
        return methodInferenceData;
    }

    @NotNull
    public static Nullability inferNullability(PsiMethodImpl method) {
        Nullability nullability = JavaSourceInference.getInferenceData((PsiMethod)method).myNullability;
        if (nullability == null) {
            JavaSourceInference.$$$reportNull$$$0(29);
        }
        return nullability;
    }

    public static Nullability inferNullability(@NotNull PsiParameter parameter2) {
        int index;
        if (parameter2 == null) {
            JavaSourceInference.$$$reportNull$$$0(30);
        }
        if (!parameter2.isPhysical() || parameter2.getType() instanceof PsiPrimitiveType) {
            return Nullability.UNKNOWN;
        }
        PsiParameterList parent = (PsiParameterList)ObjectUtils.tryCast((Object)parameter2.getParent(), PsiParameterList.class);
        if (parent == null) {
            return Nullability.UNKNOWN;
        }
        PsiMethodImpl method = (PsiMethodImpl)((Object)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodImpl.class));
        if (method == null) {
            return Nullability.UNKNOWN;
        }
        BitSet notNullParameters = JavaSourceInference.getInferenceData((PsiMethod)method).myNotNullParameters;
        if (!notNullParameters.isEmpty() && notNullParameters.get(index = parent.getParameterIndex(parameter2))) {
            return Nullability.NOT_NULL;
        }
        return Nullability.UNKNOWN;
    }

    @NotNull
    public static Mutability inferMutability(PsiMethodImpl method) {
        Mutability mutability = JavaSourceInference.getInferenceData((PsiMethod)method).myMutability;
        if (mutability == null) {
            JavaSourceInference.$$$reportNull$$$0(31);
        }
        return mutability;
    }

    @NotNull
    public static List<StandardMethodContract> inferContracts(@NotNull PsiMethodImpl method) {
        if (method == null) {
            JavaSourceInference.$$$reportNull$$$0(32);
        }
        List<StandardMethodContract> list = JavaSourceInference.getInferenceData((PsiMethod)method).myContracts;
        if (list == null) {
            JavaSourceInference.$$$reportNull$$$0(33);
        }
        return list;
    }

    public static boolean inferPurity(@NotNull PsiMethodImpl method) {
        if (method == null) {
            JavaSourceInference.$$$reportNull$$$0(34);
        }
        return JavaSourceInference.getInferenceData((PsiMethod)method).myPure;
    }

    @NotNull
    private static List<StandardMethodContract> boxReturnValues(List<StandardMethodContract> contracts2) {
        List list = ContainerUtil.mapNotNull(contracts2, contract -> {
            if (contract.getReturnValue().isBoolean()) {
                return contract.withReturnValue(ContractReturnValue.returnNotNull());
            }
            return contract;
        });
        if (list == null) {
            JavaSourceInference.$$$reportNull$$$0(35);
        }
        return list;
    }

    private static InferenceMode getInferenceMode(@NotNull PsiMethodImpl method) {
        if (method == null) {
            JavaSourceInference.$$$reportNull$$$0(36);
        }
        if (JavaSourceInference.isLibraryCode(method) || method.hasModifierProperty("abstract") || method.hasModifierProperty("native")) {
            return InferenceMode.DISABLED;
        }
        if (method.hasModifierProperty("static")) {
            return InferenceMode.ENABLED;
        }
        if (PsiUtil.canBeOverridden((PsiMethod)method)) {
            return InferenceMode.PARAMETERS;
        }
        if (JavaSourceInference.isUnusedInAnonymousClass(method)) {
            return InferenceMode.DISABLED;
        }
        return InferenceMode.ENABLED;
    }

    private static boolean isUnusedInAnonymousClass(@NotNull PsiMethod method) {
        PsiClass containingClass;
        if (method == null) {
            JavaSourceInference.$$$reportNull$$$0(37);
        }
        if (!((containingClass = method.getContainingClass()) instanceof PsiAnonymousClass)) {
            return false;
        }
        if (containingClass.getParent() instanceof PsiNewExpression && containingClass.getParent().getParent() instanceof PsiVariable && !method.getHierarchicalMethodSignature().getSuperSignatures().isEmpty()) {
            return false;
        }
        return MethodReferencesSearch.search((PsiMethod)method, (SearchScope)new LocalSearchScope((PsiElement)containingClass), (boolean)false).findFirst() == null;
    }

    private static boolean isLibraryCode(@NotNull PsiMethod method) {
        if (method == null) {
            JavaSourceInference.$$$reportNull$$$0(38);
        }
        if (method instanceof PsiCompiledElement) {
            return true;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)method);
        return virtualFile != null && FileIndexFacade.getInstance((Project)method.getProject()).isInLibrarySource(virtualFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/inference/JavaSourceInference";
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 22: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 9: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullability";
                break;
            }
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notNullParameter";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "infer";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findNullability";
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/inference/JavaSourceInference";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findMutability";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findContracts";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "postProcessContracts";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getInferenceData";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "inferNullability";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "inferMutability";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "inferContracts";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "boxReturnValues";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findMutability";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findPurity";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findContracts";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "postProcessContracts";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "inferNullability";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "inferContracts";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "inferPurity";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getInferenceMode";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isUnusedInAnonymousClass";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryCode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MethodInferenceData {
        static final MethodInferenceData UNKNOWN = new MethodInferenceData(Mutability.UNKNOWN, Nullability.UNKNOWN, Collections.emptyList(), false, new BitSet());
        @NotNull
        final Mutability myMutability;
        @NotNull
        final Nullability myNullability;
        @NotNull
        final List<StandardMethodContract> myContracts;
        final boolean myPure;
        @NotNull
        final BitSet myNotNullParameters;

        MethodInferenceData(@NotNull Mutability mutability, @NotNull Nullability nullability, @NotNull List<StandardMethodContract> contracts2, boolean pure, @NotNull BitSet parameters2) {
            if (mutability == null) {
                MethodInferenceData.$$$reportNull$$$0(0);
            }
            if (nullability == null) {
                MethodInferenceData.$$$reportNull$$$0(1);
            }
            if (contracts2 == null) {
                MethodInferenceData.$$$reportNull$$$0(2);
            }
            if (parameters2 == null) {
                MethodInferenceData.$$$reportNull$$$0(3);
            }
            this.myMutability = mutability;
            this.myNullability = nullability;
            this.myContracts = contracts2;
            this.myPure = pure;
            this.myNotNullParameters = parameters2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mutability";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "nullability";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "contracts";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/inference/JavaSourceInference$MethodInferenceData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static enum InferenceMode {
        DISABLED,
        ENABLED,
        PARAMETERS;

    }
}

