/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.fix;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.dataFlow.TrackingRunner;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FindDfaProblemCauseFix
implements LocalQuickFix,
LowPriorityAction {
    private final boolean myUnknownMembersAsNullable;
    private final boolean myIgnoreAssertStatements;
    private final SmartPsiElementPointer<PsiExpression> myAnchor;
    private final TrackingRunner.DfaProblemType myProblemType;

    public FindDfaProblemCauseFix(boolean unknownMembersAsNullable, boolean ignoreAssertStatements, PsiExpression anchor, TrackingRunner.DfaProblemType problemType) {
        this.myUnknownMembersAsNullable = unknownMembersAsNullable;
        this.myIgnoreAssertStatements = ignoreAssertStatements;
        this.myAnchor = SmartPointerManager.createPointer((PsiElement)anchor);
        this.myProblemType = problemType;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        if ("Find cause" == null) {
            FindDfaProblemCauseFix.$$$reportNull$$$0(0);
        }
        return "Find cause";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            FindDfaProblemCauseFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            FindDfaProblemCauseFix.$$$reportNull$$$0(2);
        }
        ThrowableComputable causeFinder = () -> {
            PsiExpression element = (PsiExpression)this.myAnchor.getElement();
            if (element == null) {
                return null;
            }
            return TrackingRunner.findProblemCause(this.myUnknownMembersAsNullable, this.myIgnoreAssertStatements, element, this.myProblemType);
        };
        TrackingRunner.CauseItem item = (TrackingRunner.CauseItem)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (TrackingRunner.CauseItem)ReadAction.compute((ThrowableComputable)causeFinder), "Finding Cause", true, project);
        PsiFile file = this.myAnchor.getContainingFile();
        if (item != null && file != null) {
            FindDfaProblemCauseFix.displayProblemCause(file, item);
        }
    }

    private static void displayProblemCause(PsiFile file, TrackingRunner.CauseItem root) {
        Project project = file.getProject();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        Document document = editor.getDocument();
        PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file);
        if (topLevelFile == null || document != topLevelFile.getViewProvider().getDocument()) {
            return;
        }
        class CauseWithDepth {
            final int myDepth;
            final TrackingRunner.CauseItem myCauseItem;
            final CauseWithDepth myParent;
            final /* synthetic */ Document val$document;

            CauseWithDepth(CauseWithDepth item, TrackingRunner.CauseItem causeItem) {
                this.val$document = causeItem;
                this.myParent = parent;
                this.myDepth = parent == null ? 0 : parent.myDepth + 1;
                this.myCauseItem = item;
            }

            public String toString() {
                return StringUtil.repeat((String)"  ", (int)(this.myDepth - 1)) + this.myCauseItem.render(this.val$document, this.myParent == null ? null : this.myParent.myCauseItem);
            }
        }
        List causes = root == null ? Collections.emptyList() : ((StreamEx)StreamEx.ofTree((Object)new CauseWithDepth(null, root, document), cwd -> cwd.myCauseItem.children().map(child -> new CauseWithDepth(cwd, child, document))).skip(1L)).toList();
        if (causes.isEmpty()) {
            HintManagerImpl hintManager = (HintManagerImpl)HintManager.getInstance();
            hintManager.showErrorHint(editor, "Unable to find the cause");
            return;
        }
        if (causes.size() == 1) {
            TrackingRunner.CauseItem item = ((CauseWithDepth)causes.get((int)0)).myCauseItem;
            FindDfaProblemCauseFix.navigate(editor, file, item);
            return;
        }
        final AtomicReference<ScopeHighlighter> highlighter = new AtomicReference<ScopeHighlighter>(new ScopeHighlighter(editor));
        JBPopup popup = JBPopupFactory.getInstance().createPopupChooserBuilder(causes).setSelectionMode(0).setAccessibleName(root.toString()).setTitle(StringUtil.wordsToBeginFromUpperCase((String)root.toString())).setMovable(false).setResizable(false).setRequestFocus(true).setItemSelectedCallback(cause -> {
            ScopeHighlighter h = (ScopeHighlighter)highlighter.get();
            if (h == null) {
                return;
            }
            h.dropHighlight();
            if (cause == null) {
                return;
            }
            Segment target = cause.myCauseItem.getTargetSegment();
            if (target == null) {
                return;
            }
            TextRange range = TextRange.create((Segment)target);
            h.highlight(Pair.create((Object)range, Collections.singletonList(range)));
        }).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ((ScopeHighlighter)highlighter.getAndSet(null)).dropHighlight();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/dataFlow/fix/FindDfaProblemCauseFix$1", "onClosed"));
            }
        }).setItemChosenCallback(cause -> FindDfaProblemCauseFix.navigate(editor, file, cause.myCauseItem)).createPopup();
        popup.showInBestPositionFor(editor);
    }

    private static void navigate(Editor editor, PsiFile file, TrackingRunner.CauseItem item) {
        Segment range = item.getTargetSegment();
        if (range == null) {
            return;
        }
        PsiFile targetFile = item.getFile();
        assert (targetFile == file);
        PsiNavigationSupport.getInstance().createNavigatable(file.getProject(), targetFile.getVirtualFile(), range.getStartOffset()).navigate(true);
        HintManagerImpl hintManager = (HintManagerImpl)HintManager.getInstance();
        hintManager.showInformationHint(editor, StringUtil.escapeXmlEntities((String)StringUtil.capitalize((String)item.toString())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/fix/FindDfaProblemCauseFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/fix/FindDfaProblemCauseFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

