/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.ExternalAnnotationsManagerImpl;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditRangeIntention
extends BaseIntentionAction
implements LowPriorityAction {
    private static final String JETBRAINS_RANGE = "org.jetbrains.annotations.Range";
    private static final String ourPrompt = "<html>Please specify the value range<p>Leave 'from' or 'to' empty if it's unrestricted</html>";

    @NotNull
    public String getFamilyName() {
        if ("Edit range" == null) {
            EditRangeIntention.$$$reportNull$$$0(0);
        }
        return "Edit range";
    }

    @Nullable
    private static PsiModifierListOwner getTarget(Editor editor, PsiFile file) {
        PsiModifierListOwner owner2 = AddAnnotationPsiFix.getContainer(file, editor.getCaretModel().getOffset(), true);
        LongRangeSet rangeFromType = EditRangeIntention.rangeFromType(owner2);
        if (rangeFromType == null || !ExternalAnnotationsManagerImpl.areExternalAnnotationsApplicable(owner2)) {
            return null;
        }
        PsiElement original = owner2.getOriginalElement();
        return original instanceof PsiModifierListOwner ? (PsiModifierListOwner)original : owner2;
    }

    @Contract(value="null -> null")
    private static LongRangeSet rangeFromType(PsiModifierListOwner owner2) {
        Object type2 = owner2 instanceof PsiMethod ? ((PsiMethod)owner2).getReturnType() : (owner2 instanceof PsiField || owner2 instanceof PsiParameter ? ((PsiVariable)owner2).getType() : null);
        return LongRangeSet.fromType(type2);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiModifierListOwner owner2;
        if (project == null) {
            EditRangeIntention.$$$reportNull$$$0(1);
        }
        if ((owner2 = EditRangeIntention.getTarget(editor, file)) != null) {
            boolean hasRange = !LongRangeSet.fromPsiElement(owner2).equals(LongRangeSet.all());
            String name2 = ((PsiNamedElement)owner2).getName();
            this.setText(hasRange ? "Edit range of '" + name2 + "'" : "Add range to '" + name2 + "'");
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            EditRangeIntention.$$$reportNull$$$0(2);
        }
        PsiModifierListOwner owner2 = EditRangeIntention.getTarget(editor, file);
        assert (owner2 != null);
        LongRangeSet existingRange = LongRangeSet.fromPsiElement(owner2);
        final LongRangeSet fromType = EditRangeIntention.rangeFromType(owner2);
        assert (fromType != null);
        String min = existingRange.min() > fromType.min() ? String.valueOf(existingRange.min()) : "";
        String max = existingRange.max() < fromType.max() ? String.valueOf(existingRange.max()) : "";
        final JBTextField minText = new JBTextField(min);
        final JBTextField maxText = new JBTextField(max);
        final DialogBuilder builder = EditRangeIntention.createDialog(project, minText, maxText);
        DocumentAdapter validator2 = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                Couple errors;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((errors = EditRangeIntention.getErrorMessages(minText.getText(), maxText.getText(), fromType)).getFirst() != null || errors.getSecond() != null) {
                    builder.setOkActionEnabled(false);
                    builder.setErrorText((String)errors.getFirst(), (JComponent)minText);
                    if (errors.getSecond() != null) {
                        builder.setErrorText((String)errors.getSecond(), (JComponent)maxText);
                    }
                } else {
                    builder.setOkActionEnabled(true);
                    builder.setErrorText(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/dataFlow/EditRangeIntention$1", "textChanged"));
            }
        };
        minText.getDocument().addDocumentListener((DocumentListener)validator2);
        maxText.getDocument().addDocumentListener((DocumentListener)validator2);
        if (builder.showAndGet()) {
            EditRangeIntention.updateRange(owner2, fromType, minText.getText(), maxText.getText());
        }
    }

    private static DialogBuilder createDialog(@NotNull Project project, JBTextField minText, JBTextField maxText) {
        if (project == null) {
            EditRangeIntention.$$$reportNull$$$0(3);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        GridBag c = new GridBag().setDefaultAnchor(17).setDefaultFill(2).setDefaultInsets((Insets)JBUI.insets((int)2)).setDefaultWeightX(0, 1.0).setDefaultWeightX(1, 3.0).setDefaultWeightY(1.0);
        panel.add((Component)Messages.configureMessagePaneUi((JTextPane)new JTextPane(), (String)ourPrompt), c.nextLine().next().coverLine());
        JLabel fromLabel = new JLabel("From (inclusive):");
        fromLabel.setDisplayedMnemonic('f');
        fromLabel.setLabelFor((Component)minText);
        panel.add((Component)fromLabel, c.nextLine().next());
        panel.add((Component)minText, c.next());
        JLabel toLabel = new JLabel("To (inclusive):");
        toLabel.setDisplayedMnemonic('t');
        toLabel.setLabelFor((Component)maxText);
        panel.add((Component)toLabel, c.nextLine().next());
        panel.add((Component)maxText, c.next());
        DialogBuilder builder = new DialogBuilder(project).setNorthPanel((JComponent)panel).title("Edit Range");
        builder.setPreferredFocusComponent((JComponent)minText);
        builder.setHelpId("define_range_dialog");
        return builder;
    }

    private static void updateRange(PsiModifierListOwner owner2, LongRangeSet fromType, String min, String max) {
        Project project = owner2.getProject();
        ExternalAnnotationsManager manager = ExternalAnnotationsManager.getInstance((Project)project);
        manager.deannotate(owner2, JETBRAINS_RANGE);
        min = min.trim();
        max = max.trim();
        Long minValue = EditRangeIntention.parseValue(min, fromType, true);
        Long maxValue = EditRangeIntention.parseValue(max, fromType, false);
        if (minValue == null || maxValue == null || minValue.longValue() == fromType.min() && maxValue.longValue() == fromType.max()) {
            return;
        }
        if (minValue == Long.MIN_VALUE) {
            min = "java.lang.Long.MIN_VALUE";
        }
        if (minValue == Integer.MIN_VALUE) {
            min = "java.lang.Integer.MIN_VALUE";
        }
        if (maxValue == Long.MAX_VALUE) {
            max = "java.lang.Long.MAX_VALUE";
        }
        if (maxValue == Integer.MAX_VALUE) {
            max = "java.lang.Integer.MAX_VALUE";
        }
        if (min.isEmpty()) {
            min = minValue.toString();
        }
        if (max.isEmpty()) {
            max = maxValue.toString();
        }
        PsiAnnotation mockAnno = JavaPsiFacade.getElementFactory((Project)project).createAnnotationFromText("@org.jetbrains.annotations.Range(from=" + min + ", to=" + max + ")", null);
        try {
            manager.annotateExternally(owner2, JETBRAINS_RANGE, owner2.getContainingFile(), mockAnno.getParameterList().getAttributes());
        }
        catch (ExternalAnnotationsManager.CanceledConfigurationException canceledConfigurationException) {
            // empty catch block
        }
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    @NotNull
    private static Couple<String> getErrorMessages(String minText, String maxText, LongRangeSet fromType) {
        Long minValue = EditRangeIntention.parseValue(minText, fromType, true);
        Long maxValue = EditRangeIntention.parseValue(maxText, fromType, false);
        String minError = null;
        String maxError = null;
        if (minValue == null) {
            minError = "Invalid value";
        } else if (minValue < fromType.min()) {
            minError = "Should not be less than " + fromType.min();
        }
        if (maxValue == null) {
            maxError = "Invalid value";
        } else if (maxValue > fromType.max()) {
            maxError = "Should not be bigger than " + fromType.max();
        } else if (minValue != null && maxValue < minValue) {
            maxError = "Should not be less than 'from'";
        }
        Couple couple = Couple.of((Object)minError, (Object)maxError);
        if (couple == null) {
            EditRangeIntention.$$$reportNull$$$0(4);
        }
        return couple;
    }

    @Nullable
    private static Long parseValue(String text2, LongRangeSet fromType, boolean isMin) {
        if ((text2 = text2.trim()).isEmpty()) {
            return isMin ? fromType.min() : fromType.max();
        }
        Long value2 = PsiLiteralUtil.parseLong((String)text2);
        if (value2 != null) {
            return value2;
        }
        Integer intValue = PsiLiteralUtil.parseInteger((String)text2);
        return intValue != null ? Long.valueOf(intValue.longValue()) : value2;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/EditRangeIntention";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/EditRangeIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

