/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaPsiUtil {
    public static boolean isFinalField(PsiVariable var) {
        return var.hasModifierProperty("final") && !var.hasModifierProperty("transient") && var instanceof PsiField;
    }

    static PsiElement getEnclosingCodeBlock(PsiVariable variable, PsiElement context) {
        PsiAnonymousClass anon;
        PsiElement codeBlock;
        if (variable instanceof PsiParameter) {
            codeBlock = ((PsiParameter)variable).getDeclarationScope();
            if (codeBlock instanceof PsiMethod) {
                codeBlock = ((PsiMethod)codeBlock).getBody();
            }
        } else {
            codeBlock = variable instanceof PsiLocalVariable ? PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class) : DfaPsiUtil.getTopmostBlockInSameClass(context);
        }
        while (codeBlock != null && (anon = (PsiAnonymousClass)PsiTreeUtil.getParentOfType((PsiElement)codeBlock, PsiAnonymousClass.class)) != null) {
            codeBlock = PsiTreeUtil.getParentOfType((PsiElement)anon, PsiCodeBlock.class);
        }
        return codeBlock;
    }

    @NotNull
    public static Nullability getElementNullability(@Nullable PsiType resultType, @Nullable PsiModifierListOwner owner2) {
        Nullability nullability = DfaPsiUtil.getElementNullability(resultType, owner2, false);
        if (nullability == null) {
            DfaPsiUtil.$$$reportNull$$$0(0);
        }
        return nullability;
    }

    @NotNull
    public static Nullability getElementNullabilityIgnoringParameterInference(@Nullable PsiType resultType, @Nullable PsiModifierListOwner owner2) {
        Nullability nullability = DfaPsiUtil.getElementNullability(resultType, owner2, true);
        if (nullability == null) {
            DfaPsiUtil.$$$reportNull$$$0(1);
        }
        return nullability;
    }

    @NotNull
    private static Nullability getElementNullability(@Nullable PsiType resultType, @Nullable PsiModifierListOwner owner2, boolean ignoreParameterNullabilityInference) {
        PsiField field;
        if (owner2 == null) {
            Nullability nullability = DfaPsiUtil.getTypeNullability(resultType);
            if (nullability == null) {
                DfaPsiUtil.$$$reportNull$$$0(2);
            }
            return nullability;
        }
        if (resultType instanceof PsiPrimitiveType) {
            Nullability nullability = Nullability.UNKNOWN;
            if (nullability == null) {
                DfaPsiUtil.$$$reportNull$$$0(3);
            }
            return nullability;
        }
        if (owner2 instanceof PsiEnumConstant || PsiUtil.isAnnotationMethod((PsiElement)owner2)) {
            Nullability nullability = Nullability.NOT_NULL;
            if (nullability == null) {
                DfaPsiUtil.$$$reportNull$$$0(4);
            }
            return nullability;
        }
        if (owner2 instanceof PsiMethod && DfaPsiUtil.isEnumPredefinedMethod((PsiMethod)owner2)) {
            Nullability nullability = Nullability.NOT_NULL;
            if (nullability == null) {
                DfaPsiUtil.$$$reportNull$$$0(5);
            }
            return nullability;
        }
        Nullability fromAnnotation = DfaPsiUtil.getNullabilityFromAnnotation(owner2, ignoreParameterNullabilityInference);
        if (fromAnnotation != Nullability.UNKNOWN) {
            Nullability nullability = fromAnnotation;
            if (nullability == null) {
                DfaPsiUtil.$$$reportNull$$$0(6);
            }
            return nullability;
        }
        if (owner2 instanceof PsiMethod && DfaPsiUtil.isMapMethodWithUnknownNullity((PsiMethod)owner2)) {
            Nullability nullability = Nullability.UNKNOWN;
            if (nullability == null) {
                DfaPsiUtil.$$$reportNull$$$0(7);
            }
            return nullability;
        }
        Nullability fromType = DfaPsiUtil.getTypeNullability(resultType);
        if (fromType != Nullability.UNKNOWN) {
            Nullability nullability = fromType;
            if (nullability == null) {
                DfaPsiUtil.$$$reportNull$$$0(8);
            }
            return nullability;
        }
        if (owner2 instanceof PsiParameter) {
            Nullability nullability = DfaPsiUtil.inferParameterNullability((PsiParameter)owner2);
            if (nullability == null) {
                DfaPsiUtil.$$$reportNull$$$0(9);
            }
            return nullability;
        }
        if (owner2 instanceof PsiMethod && ((PsiMethod)owner2).getParameterList().isEmpty() && (field = PropertyUtil.getFieldOfGetter((PsiMethod)owner2)) != null && DfaPsiUtil.getElementNullability(resultType, (PsiModifierListOwner)field) == Nullability.NULLABLE) {
            Nullability nullability = Nullability.NULLABLE;
            if (nullability == null) {
                DfaPsiUtil.$$$reportNull$$$0(10);
            }
            return nullability;
        }
        Nullability nullability = Nullability.UNKNOWN;
        if (nullability == null) {
            DfaPsiUtil.$$$reportNull$$$0(11);
        }
        return nullability;
    }

    @NotNull
    private static Nullability getNullabilityFromAnnotation(PsiModifierListOwner owner2, boolean ignoreParameterNullabilityInference) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)owner2.getProject());
        NullabilityAnnotationInfo info = manager.findEffectiveNullabilityInfo(owner2);
        if (info == null || ignoreParameterNullabilityInference && owner2 instanceof PsiParameter && AnnotationUtil.isInferredAnnotation((PsiAnnotation)info.getAnnotation())) {
            Nullability nullability = Nullability.UNKNOWN;
            if (nullability == null) {
                DfaPsiUtil.$$$reportNull$$$0(12);
            }
            return nullability;
        }
        Nullability nullability = info.getNullability();
        if (nullability == null) {
            DfaPsiUtil.$$$reportNull$$$0(13);
        }
        return nullability;
    }

    private static boolean isMapMethodWithUnknownNullity(@NotNull PsiMethod method) {
        String name2;
        if (method == null) {
            DfaPsiUtil.$$$reportNull$$$0(14);
        }
        if (!"get".equals(name2 = method.getName()) && !"remove".equals(name2)) {
            return false;
        }
        PsiMethod superMethod = (PsiMethod)DeepestSuperMethodsSearch.search((PsiMethod)method).findFirst();
        return ("java.util.Map." + name2).equals(PsiUtil.getMemberQualifiedName((PsiMember)(superMethod != null ? superMethod : method)));
    }

    @NotNull
    public static Nullability inferParameterNullability(@NotNull PsiParameter parameter2) {
        PsiElement parent;
        if (parameter2 == null) {
            DfaPsiUtil.$$$reportNull$$$0(15);
        }
        if ((parent = parameter2.getParent()) instanceof PsiParameterList) {
            PsiElement gParent = parent.getParent();
            if (gParent instanceof PsiLambdaExpression) {
                Nullability nullability = DfaPsiUtil.getFunctionalParameterNullability((PsiFunctionalExpression)((PsiLambdaExpression)gParent), ((PsiParameterList)parent).getParameterIndex(parameter2));
                if (nullability == null) {
                    DfaPsiUtil.$$$reportNull$$$0(16);
                }
                return nullability;
            }
            if (gParent instanceof PsiMethod && OptionalUtil.OPTIONAL_OF_NULLABLE.methodMatches((PsiMethod)gParent)) {
                Nullability nullability = Nullability.NULLABLE;
                if (nullability == null) {
                    DfaPsiUtil.$$$reportNull$$$0(17);
                }
                return nullability;
            }
        }
        if (parent instanceof PsiForeachStatement) {
            Nullability nullability = DfaPsiUtil.getTypeNullability(DfaPsiUtil.inferLoopParameterTypeWithNullability((PsiForeachStatement)parent));
            if (nullability == null) {
                DfaPsiUtil.$$$reportNull$$$0(18);
            }
            return nullability;
        }
        Nullability nullability = Nullability.UNKNOWN;
        if (nullability == null) {
            DfaPsiUtil.$$$reportNull$$$0(19);
        }
        return nullability;
    }

    @Nullable
    private static PsiType inferLoopParameterTypeWithNullability(PsiForeachStatement loop) {
        PsiForeachStatement targetLoop;
        PsiElement target;
        PsiExpression iteratedValue2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)loop.getIteratedValue());
        if (iteratedValue2 == null) {
            return null;
        }
        PsiType iteratedType = iteratedValue2.getType();
        if (iteratedValue2 instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)iteratedValue2).resolve()) instanceof PsiParameter && target.getParent() instanceof PsiForeachStatement && PsiTreeUtil.isAncestor((PsiElement)(targetLoop = (PsiForeachStatement)target.getParent()), (PsiElement)loop, (boolean)true) && !HighlightControlFlowUtil.isReassigned((PsiVariable)((PsiParameter)target), new HashMap<PsiElement, Collection<ControlFlowUtil.VariableInfo>>())) {
            iteratedType = DfaPsiUtil.inferLoopParameterTypeWithNullability(targetLoop);
        }
        return JavaGenericsUtil.getCollectionItemType((PsiType)iteratedType, (GlobalSearchScope)iteratedValue2.getResolveScope());
    }

    @NotNull
    public static Nullability getTypeNullability(@Nullable PsiType type2) {
        if (type2 == null || type2 instanceof PsiPrimitiveType) {
            Nullability nullability = Nullability.UNKNOWN;
            if (nullability == null) {
                DfaPsiUtil.$$$reportNull$$$0(20);
            }
            return nullability;
        }
        Ref result = Ref.create((Object)Nullability.UNKNOWN);
        InheritanceUtil.processSuperTypes((PsiType)type2, (boolean)true, eachType -> {
            result.set((Object)DfaPsiUtil.getTypeOwnNullability(eachType));
            return result.get() == Nullability.UNKNOWN;
        });
        Nullability nullability = (Nullability)result.get();
        if (nullability == null) {
            DfaPsiUtil.$$$reportNull$$$0(21);
        }
        return nullability;
    }

    @NotNull
    private static Nullability getTypeOwnNullability(PsiType eachType) {
        for (PsiAnnotation annotation : eachType.getAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            NullableNotNullManager nnn = NullableNotNullManager.getInstance((Project)annotation.getProject());
            if (nnn.getNullables().contains(qualifiedName)) {
                Nullability nullability = Nullability.NULLABLE;
                if (nullability == null) {
                    DfaPsiUtil.$$$reportNull$$$0(22);
                }
                return nullability;
            }
            if (!nnn.getNotNulls().contains(qualifiedName)) continue;
            Nullability nullability = Nullability.NOT_NULL;
            if (nullability == null) {
                DfaPsiUtil.$$$reportNull$$$0(23);
            }
            return nullability;
        }
        Nullability nullability = Nullability.UNKNOWN;
        if (nullability == null) {
            DfaPsiUtil.$$$reportNull$$$0(24);
        }
        return nullability;
    }

    @NotNull
    public static Nullability getFunctionalParameterNullability(PsiFunctionalExpression function, int index) {
        Nullability nullability = DfaPsiUtil.inferLambdaParameterNullability(function, index);
        if (nullability != Nullability.UNKNOWN) {
            Nullability nullability2 = nullability;
            if (nullability2 == null) {
                DfaPsiUtil.$$$reportNull$$$0(25);
            }
            return nullability2;
        }
        PsiClassType type2 = (PsiClassType)ObjectUtils.tryCast((Object)LambdaUtil.getFunctionalInterfaceType((PsiElement)function, (boolean)true), PsiClassType.class);
        PsiMethod sam2 = LambdaUtil.getFunctionalInterfaceMethod((PsiType)type2);
        if (sam2 != null && index < sam2.getParameterList().getParametersCount()) {
            PsiParameter parameter2 = sam2.getParameterList().getParameters()[index];
            nullability = DfaPsiUtil.getElementNullability(null, (PsiModifierListOwner)parameter2);
            if (nullability != Nullability.UNKNOWN) {
                Nullability nullability3 = nullability;
                if (nullability3 == null) {
                    DfaPsiUtil.$$$reportNull$$$0(26);
                }
                return nullability3;
            }
            PsiType parameterType = type2.resolveGenerics().getSubstitutor().substitute(parameter2.getType());
            Nullability nullability4 = DfaPsiUtil.getTypeNullability(GenericsUtil.eliminateWildcards((PsiType)parameterType, (boolean)false, (boolean)true));
            if (nullability4 == null) {
                DfaPsiUtil.$$$reportNull$$$0(27);
            }
            return nullability4;
        }
        Nullability nullability5 = Nullability.UNKNOWN;
        if (nullability5 == null) {
            DfaPsiUtil.$$$reportNull$$$0(28);
        }
        return nullability5;
    }

    @NotNull
    private static Nullability inferLambdaParameterNullability(PsiFunctionalExpression lambda2, int parameterIndex) {
        PsiMethod method;
        PsiExpressionList list;
        PsiElement listParent;
        PsiFunctionalExpression expression2 = lambda2;
        PsiElement expressionParent = lambda2.getParent();
        while (expressionParent instanceof PsiConditionalExpression || expressionParent instanceof PsiParenthesizedExpression) {
            expression2 = expressionParent;
            expressionParent = expressionParent.getParent();
        }
        if (expressionParent instanceof PsiExpressionList && (listParent = (list = (PsiExpressionList)expressionParent).getParent()) instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)listParent).resolveMethod()) != null) {
            int expressionIndex = ArrayUtil.find((Object[])list.getExpressions(), (Object)expression2);
            Nullability nullability = DfaPsiUtil.getLambdaParameterNullability(method, expressionIndex, parameterIndex);
            if (nullability == null) {
                DfaPsiUtil.$$$reportNull$$$0(29);
            }
            return nullability;
        }
        Nullability nullability = Nullability.UNKNOWN;
        if (nullability == null) {
            DfaPsiUtil.$$$reportNull$$$0(30);
        }
        return nullability;
    }

    @NotNull
    private static Nullability getLambdaParameterNullability(@NotNull PsiMethod method, int parameterIndex, int lambdaParameterIndex) {
        String methodName;
        PsiClass type2;
        if (method == null) {
            DfaPsiUtil.$$$reportNull$$$0(31);
        }
        if ((type2 = method.getContainingClass()) != null && "java.util.Optional".equals(type2.getQualifiedName()) && ((methodName = method.getName()).equals("map") || methodName.equals("filter") || methodName.equals("ifPresent") || methodName.equals("flatMap")) && parameterIndex == 0 && lambdaParameterIndex == 0) {
            Nullability nullability = Nullability.NOT_NULL;
            if (nullability == null) {
                DfaPsiUtil.$$$reportNull$$$0(32);
            }
            return nullability;
        }
        Nullability nullability = Nullability.UNKNOWN;
        if (nullability == null) {
            DfaPsiUtil.$$$reportNull$$$0(33);
        }
        return nullability;
    }

    private static boolean isEnumPredefinedMethod(PsiMethod method) {
        PsiClass containingClass;
        String methodName = method.getName();
        if (("valueOf".equals(methodName) || "values".equals(methodName)) && method.hasModifierProperty("static") && (containingClass = method.getContainingClass()) != null && containingClass.isEnum()) {
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            if ("values".equals(methodName)) {
                return parameters2.length == 0;
            }
            return parameters2.length == 1 && parameters2[0].getType().equalsToText("java.lang.String");
        }
        return false;
    }

    public static boolean isInitializedNotNull(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        PsiMethod[] constructors = containingClass.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        for (PsiMethod method : constructors) {
            if (DfaPsiUtil.getNotNullInitializedFields(method, containingClass).contains(field)) continue;
            return false;
        }
        return true;
    }

    private static Set<PsiField> getNotNullInitializedFields(final PsiMethod constructor, final PsiClass containingClass) {
        if (!constructor.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return Collections.emptySet();
        }
        PsiCodeBlock body2 = constructor.getBody();
        if (body2 == null) {
            return Collections.emptySet();
        }
        return (Set)CachedValuesManager.getCachedValue((PsiElement)constructor, (CachedValueProvider)new CachedValueProvider<Set<PsiField>>(){

            @NotNull
            public CachedValueProvider.Result<Set<PsiField>> compute() {
                PsiCodeBlock body2 = constructor.getBody();
                final HashMap map2 = new HashMap();
                StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner(false, null){

                    private boolean isCallExposingNonInitializedFields(Instruction instruction) {
                        PsiExpression qualifier;
                        if (!(instruction instanceof MethodCallInstruction)) {
                            return false;
                        }
                        PsiCall call = ((MethodCallInstruction)instruction).getCallExpression();
                        if (call == null) {
                            return false;
                        }
                        if (call instanceof PsiNewExpression && this.canAccessFields((PsiExpression)call)) {
                            return true;
                        }
                        if (call instanceof PsiMethodCallExpression && ((qualifier = ((PsiMethodCallExpression)call).getMethodExpression().getQualifierExpression()) == null || this.canAccessFields(qualifier))) {
                            return true;
                        }
                        PsiExpressionList argumentList = call.getArgumentList();
                        if (argumentList != null) {
                            for (PsiExpression expression2 : argumentList.getExpressions()) {
                                if (!this.canAccessFields(expression2)) continue;
                                return true;
                            }
                        }
                        return false;
                    }

                    private boolean canAccessFields(PsiExpression expression2) {
                        PsiClass type2 = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
                        JBIterable typeContainers = JBIterable.generate((Object)type2, PsiClass::getContainingClass).takeWhile(c -> !c.hasModifierProperty("static"));
                        return typeContainers.contains((Object)containingClass);
                    }

                    @Override
                    @NotNull
                    protected DfaInstructionState[] acceptInstruction(@NotNull InstructionVisitor visitor, @NotNull DfaInstructionState instructionState) {
                        Instruction instruction;
                        if (visitor == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (instructionState == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (this.isCallExposingNonInitializedFields(instruction = instructionState.getInstruction()) || instruction instanceof ReturnInstruction && !((ReturnInstruction)instruction).isViaException()) {
                            for (PsiField field : containingClass.getFields()) {
                                if (!instructionState.getMemoryState().isNotNull(this.getFactory().getVarFactory().createVariableValue((PsiVariable)field))) {
                                    map2.put(field, false);
                                    continue;
                                }
                                if (map2.containsKey(field)) continue;
                                map2.put(field, true);
                            }
                            if (DfaInstructionState.EMPTY_ARRAY == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            return DfaInstructionState.EMPTY_ARRAY;
                        }
                        DfaInstructionState[] dfaInstructionStateArray = super.acceptInstruction(visitor, instructionState);
                        if (dfaInstructionStateArray == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return dfaInstructionStateArray;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 2: 
                            case 3: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 2: 
                            case 3: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "visitor";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "instructionState";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaPsiUtil$1$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaPsiUtil$1$1";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[1] = "acceptInstruction";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "acceptInstruction";
                                break;
                            }
                            case 2: 
                            case 3: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 2: 
                            case 3: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
                RunnerResult rc = dfaRunner.analyzeMethod((PsiElement)body2, new StandardInstructionVisitor());
                HashSet notNullFields = new HashSet();
                if (rc == RunnerResult.OK) {
                    for (Map.Entry entry : map2.entrySet()) {
                        if (!((Boolean)entry.getValue()).booleanValue()) continue;
                        notNullFields.add(entry.getKey());
                    }
                }
                CachedValueProvider.Result result = CachedValueProvider.Result.create(notNullFields, (Object[])new Object[]{constructor, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil$1", "compute"));
            }
        });
    }

    public static List<PsiExpression> findAllConstructorInitializers(PsiField field) {
        List result = ContainerUtil.createLockFreeCopyOnWriteList();
        ContainerUtil.addIfNotNull((Collection)result, (Object)field.getInitializer());
        PsiClass containingClass = field.getContainingClass();
        if (containingClass != null && !(containingClass instanceof PsiCompiledElement)) {
            result.addAll(DfaPsiUtil.getAllConstructorFieldInitializers(containingClass).get((Object)field));
        }
        return result;
    }

    private static MultiMap<PsiField, PsiExpression> getAllConstructorFieldInitializers(final PsiClass psiClass) {
        if (psiClass instanceof PsiCompiledElement) {
            return MultiMap.empty();
        }
        return (MultiMap)CachedValuesManager.getCachedValue((PsiElement)psiClass, (CachedValueProvider)new CachedValueProvider<MultiMap<PsiField, PsiExpression>>(){

            @NotNull
            public CachedValueProvider.Result<MultiMap<PsiField, PsiExpression>> compute() {
                final HashSet fieldNames = new HashSet();
                for (PsiField field : psiClass.getFields()) {
                    ContainerUtil.addIfNotNull(fieldNames, (Object)field.getName());
                }
                final MultiMap result = new MultiMap();
                JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor(){

                    public void visitAssignmentExpression(PsiAssignmentExpression assignment) {
                        PsiElement target;
                        super.visitAssignmentExpression(assignment);
                        PsiExpression lExpression = assignment.getLExpression();
                        PsiExpression rExpression = assignment.getRExpression();
                        if (rExpression != null && lExpression instanceof PsiReferenceExpression && fieldNames.contains(((PsiReferenceExpression)lExpression).getReferenceName()) && (target = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiField && ((PsiField)target).getContainingClass() == psiClass) {
                            result.putValue((Object)((PsiField)target), (Object)rExpression);
                        }
                    }
                };
                for (PsiMethod constructor : psiClass.getConstructors()) {
                    if (!constructor.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) continue;
                    constructor.accept((PsiElementVisitor)visitor);
                }
                CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{psiClass});
                if (result2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil$2", "compute"));
            }
        });
    }

    @Nullable
    public static PsiElement getTopmostBlockInSameClass(@NotNull PsiElement position) {
        if (position == null) {
            DfaPsiUtil.$$$reportNull$$$0(34);
        }
        return (PsiElement)JBIterable.generate((Object)position, PsiElement::getParent).takeWhile(e -> !(e instanceof PsiMember) && !(e instanceof PsiFile) && !(e instanceof PsiLambdaExpression)).filter(e -> e instanceof PsiCodeBlock || e instanceof PsiExpression && e.getParent() instanceof PsiLambdaExpression).last();
    }

    @NotNull
    public static Collection<PsiExpression> getVariableAssignmentsInFile(@NotNull PsiVariable psiVariable, boolean literalsOnly, PsiElement place) {
        if (psiVariable == null) {
            DfaPsiUtil.$$$reportNull$$$0(35);
        }
        Ref modificationRef = Ref.create((Object)Boolean.FALSE);
        PsiElement codeBlock = place == null ? null : DfaPsiUtil.getTopmostBlockInSameClass(place);
        int placeOffset = codeBlock != null ? place.getTextRange().getStartOffset() : 0;
        PsiFile containingFile = psiVariable.getContainingFile();
        LocalSearchScope scope = new LocalSearchScope(new PsiElement[]{containingFile}, null, true);
        Collection references = ReferencesSearch.search((PsiElement)psiVariable, (SearchScope)scope).findAll();
        List list = ContainerUtil.mapNotNull((Collection)references, (Function)((NullableFunction)psiReference -> {
            if (((Boolean)modificationRef.get()).booleanValue()) {
                return null;
            }
            PsiElement parent = psiReference.getElement().getParent();
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                IElementType operation = assignmentExpression.getOperationTokenType();
                if (assignmentExpression.getLExpression() == psiReference) {
                    if (JavaTokenType.EQ.equals(operation)) {
                        PsiExpression rValue = assignmentExpression.getRExpression();
                        if (!literalsOnly || DfaPsiUtil.allOperandsAreLiterals(rValue)) {
                            if (PsiTreeUtil.isAncestor((PsiElement)codeBlock, (PsiElement)parent, (boolean)true) && placeOffset < parent.getTextRange().getStartOffset()) {
                                return null;
                            }
                            return rValue;
                        }
                        modificationRef.set((Object)Boolean.TRUE);
                    } else if (JavaTokenType.PLUSEQ.equals(operation)) {
                        modificationRef.set((Object)Boolean.TRUE);
                    }
                }
            }
            return null;
        }));
        if (((Boolean)modificationRef.get()).booleanValue()) {
            List<PsiExpression> list2 = Collections.emptyList();
            if (list2 == null) {
                DfaPsiUtil.$$$reportNull$$$0(36);
            }
            return list2;
        }
        PsiExpression initializer = psiVariable.getInitializer();
        if (initializer != null && (!literalsOnly || DfaPsiUtil.allOperandsAreLiterals(initializer))) {
            list = ContainerUtil.concat((List)list, Collections.singletonList(initializer));
        }
        List list3 = list;
        if (list3 == null) {
            DfaPsiUtil.$$$reportNull$$$0(37);
        }
        return list3;
    }

    private static boolean allOperandsAreLiterals(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return false;
        }
        if (expression2 instanceof PsiLiteralExpression) {
            return true;
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            Stack stack = new Stack();
            stack.add((Object)expression2);
            while (!stack.isEmpty()) {
                PsiExpression psiExpression = (PsiExpression)stack.pop();
                if (psiExpression instanceof PsiPolyadicExpression) {
                    PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)psiExpression;
                    for (PsiExpression op : binaryExpression.getOperands()) {
                        stack.push((Object)op);
                    }
                    continue;
                }
                if (psiExpression instanceof PsiLiteralExpression) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 14: 
            case 15: 
            case 31: 
            case 34: 
            case 35: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 14: 
            case 15: 
            case 31: 
            case 34: 
            case 35: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaPsiUtil";
                break;
            }
            case 14: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementNullability";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementNullabilityIgnoringParameterInference";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullabilityFromAnnotation";
                break;
            }
            case 14: 
            case 15: 
            case 31: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaPsiUtil";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "inferParameterNullability";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeNullability";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeOwnNullability";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionalParameterNullability";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "inferLambdaParameterNullability";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getLambdaParameterNullability";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableAssignmentsInFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isMapMethodWithUnknownNullity";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "inferParameterNullability";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getLambdaParameterNullability";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostBlockInSameClass";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getVariableAssignmentsInFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 31: 
            case 34: 
            case 35: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

