/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.DistinctPairSet;
import com.intellij.codeInspection.dataFlow.EqClass;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.SpecialFieldValue;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaBinOpValue;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaMemoryStateImpl
implements DfaMemoryState {
    private static final Logger LOG = Logger.getInstance(DfaMemoryStateImpl.class);
    private final DfaValueFactory myFactory;
    private final List<EqClass> myEqClasses;
    private final MyIdMap myIdToEqClassesIndices;
    private final Stack<DfaValue> myStack;
    private final DistinctPairSet myDistinctClasses;
    private final LinkedHashMap<DfaVariableValue, DfaVariableState> myVariableStates;
    private final Map<DfaVariableValue, DfaVariableState> myDefaultVariableStates;
    private boolean myEphemeral;
    private LinkedHashSet<EqClass> myCachedNonTrivialEqClasses;
    private Integer myCachedHash;

    protected DfaMemoryStateImpl(DfaValueFactory factory) {
        this.myFactory = factory;
        this.myDefaultVariableStates = new THashMap();
        this.myEqClasses = new ArrayList<EqClass>();
        this.myVariableStates = new LinkedHashMap();
        this.myDistinctClasses = new DistinctPairSet(this);
        this.myStack = new Stack();
        this.myIdToEqClassesIndices = new MyIdMap();
    }

    protected DfaMemoryStateImpl(DfaMemoryStateImpl toCopy) {
        this.myFactory = toCopy.myFactory;
        this.myEphemeral = toCopy.myEphemeral;
        this.myDefaultVariableStates = toCopy.myDefaultVariableStates;
        this.myStack = new Stack(toCopy.myStack);
        this.myDistinctClasses = new DistinctPairSet(this, toCopy.myDistinctClasses);
        this.myEqClasses = new ArrayList<EqClass>(toCopy.myEqClasses);
        this.myIdToEqClassesIndices = (MyIdMap)toCopy.myIdToEqClassesIndices.clone();
        this.myVariableStates = new LinkedHashMap<DfaVariableValue, DfaVariableState>(toCopy.myVariableStates);
        this.myCachedNonTrivialEqClasses = toCopy.myCachedNonTrivialEqClasses;
        this.myCachedHash = toCopy.myCachedHash;
    }

    @NotNull
    public DfaValueFactory getFactory() {
        DfaValueFactory dfaValueFactory = this.myFactory;
        if (dfaValueFactory == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(0);
        }
        return dfaValueFactory;
    }

    @Override
    @NotNull
    public DfaMemoryStateImpl createCopy() {
        DfaMemoryStateImpl dfaMemoryStateImpl = new DfaMemoryStateImpl(this);
        if (dfaMemoryStateImpl == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(1);
        }
        return dfaMemoryStateImpl;
    }

    @Override
    @NotNull
    public DfaMemoryStateImpl createClosureState() {
        DfaMemoryStateImpl copy = this.createCopy();
        for (DfaVariableValue value2 : new ArrayList<DfaVariableValue>(copy.myVariableStates.keySet())) {
            copy.dropFact(value2, DfaFactType.LOCALITY);
        }
        copy.flushFields();
        copy.emptyStack();
        DfaMemoryStateImpl dfaMemoryStateImpl = copy;
        if (dfaMemoryStateImpl == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(2);
        }
        return dfaMemoryStateImpl;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DfaMemoryStateImpl)) {
            return false;
        }
        DfaMemoryStateImpl that = (DfaMemoryStateImpl)obj;
        if (this.myCachedHash != null && that.myCachedHash != null && !this.myCachedHash.equals(that.myCachedHash)) {
            return false;
        }
        return this.myEphemeral == that.myEphemeral && this.myStack.equals(that.myStack) && this.getNonTrivialEqClasses().equals(that.getNonTrivialEqClasses()) && this.getDistinctClassPairs().equals(that.getDistinctClassPairs()) && this.myVariableStates.equals(that.myVariableStates);
    }

    Object getSuperficialKey() {
        return Pair.create((Object)this.myEphemeral, this.myStack);
    }

    DistinctPairSet getDistinctClassPairs() {
        return this.myDistinctClasses;
    }

    LinkedHashSet<EqClass> getNonTrivialEqClasses() {
        if (this.myCachedNonTrivialEqClasses != null) {
            return this.myCachedNonTrivialEqClasses;
        }
        LinkedHashSet<EqClass> result = new LinkedHashSet<EqClass>();
        for (EqClass eqClass : this.myEqClasses) {
            if (eqClass == null || eqClass.size() <= 1) continue;
            result.add(eqClass);
        }
        this.myCachedNonTrivialEqClasses = result;
        return this.myCachedNonTrivialEqClasses;
    }

    public int hashCode() {
        if (this.myCachedHash != null) {
            return this.myCachedHash;
        }
        int hash = ((this.getNonTrivialEqClasses().hashCode() * 31 + this.getDistinctClassPairs().hashCode()) * 31 + this.myStack.hashCode()) * 31 + this.myVariableStates.hashCode();
        this.myCachedHash = hash;
        return this.myCachedHash;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('<');
        if (this.myEphemeral) {
            result.append("ephemeral, ");
        }
        for (EqClass set : this.getNonTrivialEqClasses()) {
            result.append(set);
        }
        if (!this.myDistinctClasses.isEmpty()) {
            result.append("\n  distincts: ");
            String distincts = ((StreamEx)StreamEx.of((Collection)this.getDistinctClassPairs()).map(DistinctPairSet.DistinctPair::toString).sorted()).joining((CharSequence)" ");
            result.append(distincts);
        }
        if (!this.myStack.isEmpty()) {
            result.append("\n  stack: ").append(StringUtil.join(this.myStack, (String)","));
        }
        if (!this.myVariableStates.isEmpty()) {
            result.append("\n  vars: ");
            this.myVariableStates.forEach((key2, value2) -> result.append("[").append(key2).append("->").append(value2).append("] "));
        }
        result.append('>');
        return result.toString();
    }

    @Override
    @NotNull
    public DfaValue pop() {
        this.myCachedHash = null;
        DfaValue dfaValue = (DfaValue)this.myStack.pop();
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(3);
        }
        return dfaValue;
    }

    @Override
    @NotNull
    public DfaValue peek() {
        DfaValue dfaValue = (DfaValue)this.myStack.peek();
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(4);
        }
        return dfaValue;
    }

    @Override
    @Nullable
    public DfaValue getStackValue(int offset) {
        int index = this.myStack.size() - 1 - offset;
        return index < 0 ? null : (DfaValue)this.myStack.get(index);
    }

    @Override
    public void push(@NotNull DfaValue value2) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(5);
        }
        this.myCachedHash = null;
        this.myStack.push((Object)value2);
    }

    @Override
    public void emptyStack() {
        while (!this.myStack.isEmpty() && !(this.myStack.peek() instanceof DfaControlTransferValue)) {
            this.myCachedHash = null;
            this.myStack.pop();
        }
    }

    @Override
    public void setVarValue(DfaVariableValue var, DfaValue value2) {
        if (var == value2) {
            return;
        }
        value2 = this.handleStackValueOnVariableFlush(value2, var, null);
        this.flushVariable(var, var.getInherentNullability() != Nullability.UNKNOWN);
        this.flushQualifiedMethods(var);
        if (value2 instanceof DfaUnknownValue) {
            this.setVariableState(var, this.getVariableState(var).withNotNull());
            return;
        }
        DfaVariableState state = this.getVariableState(var).withValue(value2);
        if (value2 instanceof DfaFactMapValue) {
            DfaValue targetSpecialField;
            DfaFactMap facts = this.filterFactsOnAssignment(var, ((DfaFactMapValue)value2).getFacts());
            this.setVariableState(var, state.withFacts(facts));
            SpecialFieldValue specialFieldValue = facts.get(DfaFactType.SPECIAL_FIELD_VALUE);
            if (specialFieldValue != null && (targetSpecialField = specialFieldValue.getField().createValue(this.myFactory, var)) instanceof DfaVariableValue) {
                this.setVarValue((DfaVariableValue)targetSpecialField, specialFieldValue.getValue());
            }
        } else if (DfaUtil.isComparedByEquals(value2.getType()) && !DfaUtil.isComparedByEquals(var.getType())) {
            TypeConstraint typeConstraint = TypeConstraint.empty().withInstanceofValue(this.myFactory.createDfaType(value2.getType()));
            DfaFactMap facts = this.filterFactsOnAssignment(var, this.getFactMap(value2).with(DfaFactType.TYPE_CONSTRAINT, typeConstraint));
            this.setVariableState(var, this.createVariableState(var).withFacts(facts));
        } else {
            this.setVariableState(var, this.isNull(value2) ? state.withFact(DfaFactType.NULLABILITY, DfaNullability.NULL) : state);
            DfaRelationValue dfaEqual = this.myFactory.getRelationFactory().createRelation(var, DfaRelationValue.RelationType.EQ, value2);
            if (dfaEqual == null) {
                return;
            }
            this.applyCondition(dfaEqual);
            if (value2 instanceof DfaVariableValue) {
                DfaVariableState targetState = this.getVariableState((DfaVariableValue)value2);
                this.setVariableState(var, targetState.withFacts(this.filterFactsOnAssignment(var, targetState.myFactMap)));
            }
        }
        this.updateEqClassesByState(var);
    }

    protected DfaFactMap filterFactsOnAssignment(DfaVariableValue var, @NotNull DfaFactMap facts) {
        if (facts == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(6);
        }
        return facts;
    }

    private DfaValue handleStackValueOnVariableFlush(DfaValue value2, DfaVariableValue flushed, DfaVariableValue replacement) {
        if (value2.dependsOn(flushed)) {
            if (value2 instanceof DfaVariableValue) {
                DfaNullability dfaNullability;
                DfaVariableValue target;
                if (replacement != null && (target = DfaMemoryStateImpl.replaceQualifier((DfaVariableValue)value2, flushed, replacement)) != value2) {
                    return target;
                }
                DfaNullability dfaNullability2 = dfaNullability = this.isNotNull(value2) ? DfaNullability.NOT_NULL : this.getValueFact(value2, DfaFactType.NULLABILITY);
                if (dfaNullability == null) {
                    dfaNullability = DfaNullability.fromNullability(((DfaVariableValue)value2).getInherentNullability());
                }
                return this.myFactory.withFact(this.myFactory.createTypeValue(value2.getType(), Nullability.UNKNOWN), DfaFactType.NULLABILITY, dfaNullability);
            }
            return this.myFactory.getFactValue(DfaFactType.RANGE, this.getValueFact(value2, DfaFactType.RANGE));
        }
        return value2;
    }

    @Nullable(value="for non-variables and non-constants which can't be compared by ==")
    private Integer getOrCreateEqClassIndex(@NotNull DfaValue dfaValue) {
        int i;
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(7);
        }
        if ((i = this.getEqClassIndex(dfaValue)) != -1) {
            return i;
        }
        if (!DfaMemoryStateImpl.canBeInRelation(dfaValue)) {
            return null;
        }
        dfaValue = this.canonicalize(dfaValue);
        EqClass eqClass = new EqClass(this.myFactory);
        eqClass.add(dfaValue.getID());
        int resultIndex = this.storeClass(eqClass);
        this.checkInvariants();
        return resultIndex;
    }

    private int storeClass(EqClass eqClass) {
        int resultIndex;
        int freeIndex = this.myEqClasses.indexOf(null);
        int n = resultIndex = freeIndex >= 0 ? freeIndex : this.myEqClasses.size();
        if (freeIndex >= 0) {
            this.myEqClasses.set(freeIndex, eqClass);
        } else {
            this.myEqClasses.add(eqClass);
        }
        eqClass.forEach(id -> {
            this.myIdToEqClassesIndices.put(id, resultIndex);
            return true;
        });
        return resultIndex;
    }

    public boolean isSuperStateOf(DfaMemoryStateImpl that) {
        if (this.myEphemeral && !that.myEphemeral) {
            return false;
        }
        if (this.myStack.size() != that.myStack.size()) {
            return false;
        }
        for (int i = 0; i < this.myStack.size(); ++i) {
            if (DfaMemoryStateImpl.isSuperValue((DfaValue)this.myStack.get(i), (DfaValue)that.myStack.get(i))) continue;
            return false;
        }
        int[] thisToThat = this.getClassesMap(that);
        if (thisToThat == null) {
            return false;
        }
        for (DistinctPairSet.DistinctPair pair2 : this.myDistinctClasses) {
            int firstIndex = thisToThat[pair2.getFirstIndex()];
            int secondIndex = thisToThat[pair2.getSecondIndex()];
            if (firstIndex == -1 || secondIndex == -1 || firstIndex == secondIndex) {
                return false;
            }
            DfaRelationValue.RelationType relation = that.myDistinctClasses.getRelation(firstIndex, secondIndex);
            if (relation != null && (!pair2.isOrdered() || relation == DfaRelationValue.RelationType.LT)) continue;
            return false;
        }
        HashSet<DfaVariableValue> values = new HashSet<DfaVariableValue>(this.myVariableStates.keySet());
        values.addAll(that.myVariableStates.keySet());
        for (DfaVariableValue value2 : values) {
            DfaVariableState thatState;
            DfaVariableState thisState = this.getVariableState(value2);
            if (thisState.isSuperStateOf(thatState = that.getVariableState(value2))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private int[] getClassesMap(DfaMemoryStateImpl that) {
        List<EqClass> thisClasses = this.myEqClasses;
        List<EqClass> thatClasses = that.myEqClasses;
        int thisSize = thisClasses.size();
        int thatSize = thatClasses.size();
        int[] thisToThat = new int[thisSize];
        for (int thisIdx = 0; thisIdx < thisSize; ++thisIdx) {
            EqClass thisClass = thisClasses.get(thisIdx);
            thisToThat[thisIdx] = -1;
            if (thisClass == null) continue;
            boolean found = false;
            for (int thatIdx = 0; thatIdx < thatSize; ++thatIdx) {
                EqClass thatClass = thatClasses.get(thatIdx);
                if (thatClass == null || !thatClass.containsAll(thisClass)) continue;
                thisToThat[thisIdx] = thatIdx;
                found = true;
                break;
            }
            if (found || thisClass.size() <= 1) continue;
            return null;
        }
        return thisToThat;
    }

    private static boolean isSuperValue(DfaValue superValue, DfaValue subValue) {
        if (superValue == DfaUnknownValue.getInstance() || superValue == subValue) {
            return true;
        }
        if (superValue instanceof DfaFactMapValue && subValue instanceof DfaFactMapValue) {
            return ((DfaFactMapValue)superValue).getFacts().isSuperStateOf(((DfaFactMapValue)subValue).getFacts());
        }
        return false;
    }

    private static boolean canBeInRelation(@NotNull DfaValue value2) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(8);
        }
        return value2 instanceof DfaBoxedValue || value2 instanceof DfaVariableValue || value2 instanceof DfaConstValue;
    }

    @NotNull
    List<DfaValue> getEquivalentValues(@NotNull DfaValue dfaValue) {
        EqClass set;
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(9);
        }
        List<Object> list = (set = this.getEqClass(dfaValue)) == null ? Collections.emptyList() : set.getMemberValues();
        if (list == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    private boolean canBeNaN(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(11);
        }
        if (!(dfaValue instanceof DfaVariableValue) || !PsiType.FLOAT.equals((Object)dfaValue.getType()) && !PsiType.DOUBLE.equals((Object)dfaValue.getType())) {
            return false;
        }
        EqClass eqClass = this.getEqClass(dfaValue);
        DfaConstValue constant = eqClass == null ? null : eqClass.findConstant();
        return constant == null || DfaMemoryStateImpl.isNaN(constant);
    }

    private boolean isEffectivelyNaN(@NotNull DfaValue dfaValue) {
        EqClass eqClass;
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(12);
        }
        return (eqClass = this.getEqClass(dfaValue)) != null && DfaMemoryStateImpl.isNaN(eqClass.findConstant());
    }

    List<EqClass> getEqClasses() {
        return this.myEqClasses;
    }

    @Nullable
    private EqClass getEqClass(DfaValue value2) {
        int index = this.getEqClassIndex(value2);
        return index == -1 ? null : this.myEqClasses.get(index);
    }

    int getEqClassIndex(@NotNull DfaValue dfaValue) {
        Integer classIndex;
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(13);
        }
        if ((classIndex = (Integer)this.myIdToEqClassesIndices.get(dfaValue.getID())) == null) {
            dfaValue = this.canonicalize(dfaValue);
            classIndex = (Integer)this.myIdToEqClassesIndices.get(dfaValue.getID());
        }
        if (classIndex == null) {
            return -1;
        }
        EqClass aClass = this.myEqClasses.get(classIndex);
        assert (aClass.contains(dfaValue.getID()));
        return classIndex;
    }

    DfaVariableValue getCanonicalVariable(DfaValue val) {
        EqClass eqClass = this.getEqClass(val);
        return eqClass == null ? null : eqClass.getCanonicalVariable();
    }

    private boolean uniteClasses(DfaValue val1, DfaValue val2) {
        DfaVariableValue var1 = this.getCanonicalVariable(val1);
        DfaVariableValue var2 = this.getCanonicalVariable(val2);
        Integer c1Index = this.getOrCreateEqClassIndex(val1);
        Integer c2Index = this.getOrCreateEqClassIndex(val2);
        if (c1Index == null || c2Index == null || c1Index.equals(c2Index)) {
            return true;
        }
        if (!this.myDistinctClasses.unite(c1Index, c2Index)) {
            return false;
        }
        EqClass c1 = this.myEqClasses.get(c1Index);
        EqClass c2 = this.myEqClasses.get(c2Index);
        if (c1.findConstant() != null && c2.findConstant() != null) {
            return false;
        }
        EqClass newClass = new EqClass(c1);
        this.myEqClasses.set(c1Index, newClass);
        for (int i = 0; i < c2.size(); ++i) {
            int c = c2.get(i);
            newClass.add(c);
            this.myIdToEqClassesIndices.put(c, c1Index);
        }
        this.myEqClasses.set(c2Index, null);
        this.checkInvariants();
        if (var1 == null || var2 == null || var1 == var2) {
            return true;
        }
        int compare = EqClass.CANONICAL_VARIABLE_COMPARATOR.compare(var1, var2);
        return compare < 0 ? this.convertQualifiers(var2, var1) : this.convertQualifiers(var1, var2);
    }

    private static DfaVariableValue replaceQualifier(DfaVariableValue variable, DfaVariableValue from, DfaVariableValue to) {
        DfaVariableValue qualifier = variable.getQualifier();
        if (qualifier != null) {
            return variable.withQualifier(DfaMemoryStateImpl.replaceQualifier(qualifier == from ? to : qualifier, from, to));
        }
        return variable;
    }

    private boolean convertQualifiers(DfaVariableValue from, DfaVariableValue to) {
        assert (from != to);
        if (from.getDependentVariables().isEmpty()) {
            return true;
        }
        ArrayList<DfaVariableValue> vars = new ArrayList<DfaVariableValue>(this.myVariableStates.keySet());
        for (DfaVariableValue var : vars) {
            DfaVariableState fromState;
            DfaVariableValue target = DfaMemoryStateImpl.replaceQualifier(var, from, to);
            if (target == var || (fromState = (DfaVariableState)this.myVariableStates.remove(var)) == null) continue;
            DfaVariableState toState = this.myVariableStates.get(target);
            if (toState == null) {
                toState = fromState;
            } else {
                toState = fromState.intersectMap(toState.myFactMap);
                if (toState == null) {
                    return false;
                }
            }
            this.setVariableState(target, toState);
        }
        for (Object valueId : (Object)this.myIdToEqClassesIndices.keys()) {
            DfaValue value2 = this.myFactory.getValue((int)valueId);
            DfaVariableValue var = (DfaVariableValue)ObjectUtils.tryCast((Object)value2, DfaVariableValue.class);
            if (var == null || var.getQualifier() != from) continue;
            DfaVariableValue target = var.withQualifier(to);
            if (!this.uniteClasses(var, target)) {
                return false;
            }
            this.removeEquivalenceForVariableAndWrappers(var);
        }
        return true;
    }

    private void checkInvariants() {
        if (!LOG.isDebugEnabled() && !ApplicationManager.getApplication().isEAP()) {
            return;
        }
        this.myIdToEqClassesIndices.forEachEntry((id, classIndex) -> {
            EqClass eqClass = this.myEqClasses.get((int)classIndex);
            if (eqClass == null || !eqClass.contains(id)) {
                LOG.error("Invariant violated: null-class for id=" + this.myFactory.getValue(id));
            }
            return true;
        });
        this.myDistinctClasses.forEach(DistinctPairSet.DistinctPair::check);
    }

    @Override
    public boolean isNull(DfaValue dfaValue) {
        if (dfaValue instanceof DfaConstValue) {
            return ((DfaConstValue)dfaValue).getValue() == null;
        }
        if (dfaValue instanceof DfaVariableValue) {
            int c1Index = this.getEqClassIndex(dfaValue);
            return c1Index >= 0 && c1Index == this.getEqClassIndex(this.myFactory.getConstFactory().getNull());
        }
        return false;
    }

    @Override
    public boolean isNotNull(DfaValue dfaVar) {
        if (dfaVar instanceof DfaConstValue) {
            return ((DfaConstValue)dfaVar).getValue() != null;
        }
        if (dfaVar instanceof DfaBoxedValue) {
            return true;
        }
        if (dfaVar instanceof DfaFactMapValue) {
            return DfaNullability.isNotNull(((DfaFactMapValue)dfaVar).getFacts());
        }
        if (dfaVar instanceof DfaVariableValue) {
            if (this.getVariableState((DfaVariableValue)dfaVar).isNotNull()) {
                return true;
            }
            DfaConstValue constantValue = this.getConstantValue(dfaVar);
            if (constantValue != null && constantValue.getValue() != null) {
                return true;
            }
        }
        DfaConstValue dfaNull = this.myFactory.getConstFactory().getNull();
        Integer c1Index = this.getOrCreateEqClassIndex(dfaVar);
        int c2Index = this.getEqClassIndex(dfaNull);
        if (c1Index == null || c2Index < 0) {
            return false;
        }
        return this.myDistinctClasses.areDistinctUnordered(c1Index, c2Index);
    }

    public Set<Object> getNonEqualConstants(DfaVariableValue value2) {
        int index = this.getEqClassIndex(value2);
        if (index == -1 || this.myEqClasses.get(index).findConstant() != null) {
            return Collections.emptySet();
        }
        return StreamEx.of((Collection)this.getDistinctClassPairs()).map(pair2 -> pair2.getOtherClass(index)).nonNull().map(EqClass::findConstant).nonNull().map(DfaConstValue::getValue).toSet();
    }

    @Override
    @Nullable
    @Contract(value="null -> null")
    public DfaConstValue getConstantValue(@Nullable DfaValue value2) {
        return this.getConstantValue(value2, true);
    }

    private DfaConstValue getConstantValue(@Nullable DfaValue value2, boolean unbox) {
        if (value2 instanceof DfaConstValue) {
            return (DfaConstValue)value2;
        }
        if (value2 instanceof DfaVariableValue) {
            Long constantValue;
            EqClass ec;
            DfaConstValue constValue;
            if (unbox && TypeConversionUtil.isPrimitiveWrapper((PsiType)value2.getType())) {
                value2 = SpecialField.UNBOX.createValue(this.myFactory, value2);
            }
            DfaConstValue dfaConstValue = constValue = (ec = this.getEqClass(value2)) == null ? null : ec.findConstant();
            if (constValue != null) {
                return constValue;
            }
            DfaVariableState state = this.getExistingVariableState((DfaVariableValue)value2);
            LongRangeSet range = state != null ? state.getFact(DfaFactType.RANGE) : null;
            Long l = constantValue = range == null ? null : range.getConstantValue();
            if (constantValue != null) {
                return this.myFactory.getConstFactory().createFromValue(constantValue, (PsiType)PsiType.LONG);
            }
        }
        return null;
    }

    @Override
    public void markEphemeral() {
        this.myEphemeral = true;
    }

    @Override
    public boolean isEphemeral() {
        return this.myEphemeral;
    }

    @Override
    public boolean isEmptyStack() {
        return this.myStack.isEmpty();
    }

    @Override
    public boolean castTopOfStack(@NotNull DfaPsiType type2) {
        if (type2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(14);
        }
        DfaValue value2 = this.peek();
        DfaFactMap facts = null;
        if (value2 instanceof DfaVariableValue) {
            DfaVariableValue dfaVar = (DfaVariableValue)value2;
            if (this.isNull(dfaVar)) {
                return true;
            }
            DfaVariableState newState = this.getVariableState(dfaVar).withInstanceofValue(type2);
            if (newState == null) {
                return false;
            }
            this.setVariableState(dfaVar, newState);
        } else if (value2 instanceof DfaFactMapValue) {
            facts = ((DfaFactMapValue)value2).getFacts();
        }
        if (facts != null) {
            DfaFactMap newFacts = TypeConstraint.withInstanceOf(facts, type2);
            if (newFacts == null) {
                return false;
            }
            this.pop();
            this.push(this.myFactory.getFactFactory().createValue(newFacts));
        }
        return true;
    }

    private boolean applyFacts(DfaValue value2, DfaFactMap facts) {
        if (value2 instanceof DfaVariableValue) {
            DfaVariableState oldState = this.getVariableState((DfaVariableValue)value2);
            DfaVariableState newState = oldState.intersectMap(facts);
            if (newState == null) {
                newState = oldState.withoutFact(DfaFactType.TYPE_CONSTRAINT);
                if (newState.intersectMap(facts) != null && DfaNullability.isNotNull(facts)) {
                    this.setVariableState((DfaVariableValue)value2, newState);
                    return this.applyRelation(value2, this.getFactory().getConstFactory().getNull(), false);
                }
                return false;
            }
            this.setVariableState((DfaVariableValue)value2, newState);
            if (DfaUtil.isComparedByEquals(newState.getTypeConstraint().getPsiType()) && !newState.getTypeConstraint().equals(oldState.getTypeConstraint())) {
                this.convertReferenceEqualityToValueEquality(value2);
            }
            this.updateEquivalentVariables((DfaVariableValue)value2, newState);
            return this.updateEqClassesByState((DfaVariableValue)value2);
        }
        return true;
    }

    private void convertReferenceEqualityToValueEquality(DfaValue value2) {
        int id = this.canonicalize(value2).getID();
        Integer index = (Integer)this.myIdToEqClassesIndices.get(id);
        assert (index != null);
        Iterator<DistinctPairSet.DistinctPair> iterator = this.myDistinctClasses.iterator();
        while (iterator.hasNext()) {
            DistinctPairSet.DistinctPair pair2 = iterator.next();
            EqClass otherClass = pair2.getOtherClass(index);
            if (otherClass == null || otherClass.findConstant() == this.getFactory().getConstFactory().getNull()) continue;
            iterator.remove();
        }
    }

    private boolean updateEqClassesByState(DfaVariableValue value2) {
        if (DfaNullability.isNotNull(this.getVariableState((DfaVariableValue)value2).myFactMap)) {
            return this.applyRelation(value2, this.getFactory().getConstFactory().getNull(), true);
        }
        return true;
    }

    @Override
    public void dropFact(@NotNull DfaValue value2, @NotNull DfaFactType<?> factType) {
        DfaVariableValue var;
        DfaVariableState state;
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(15);
        }
        if (factType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(16);
        }
        if (value2 instanceof DfaVariableValue && (state = this.getExistingVariableState(var = (DfaVariableValue)value2)) != null) {
            state = state.withoutFact(factType);
            this.setVariableState(var, state);
        }
    }

    @Override
    public <T> boolean applyFact(@NotNull DfaValue value2, @NotNull DfaFactType<T> factType, @Nullable T factValue) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(17);
        }
        if (factType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(18);
        }
        if (value2 instanceof DfaFactMapValue) {
            return ((DfaFactMapValue)value2).getFacts().intersect(factType, factValue) != null;
        }
        if (value2 instanceof DfaBinOpValue && factType == DfaFactType.RANGE && factValue != null) {
            return this.propagateRangeBack((LongRangeSet)factValue, (DfaBinOpValue)value2);
        }
        if (value2 instanceof DfaVariableValue) {
            DfaVariableValue var = (DfaVariableValue)value2;
            if (factValue != null) {
                DfaVariableState state = this.getVariableState(var);
                DfaVariableState newState = state.intersectFact(factType, factValue);
                if (newState == null) {
                    return false;
                }
                this.setVariableState(var, newState);
                this.updateEquivalentVariables(var, newState);
                return this.updateEqClassesByState(var);
            }
        }
        return true;
    }

    private boolean propagateRangeBack(@NotNull LongRangeSet factValue, @NotNull DfaBinOpValue binOp) {
        boolean isLong;
        if (factValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(19);
        }
        if (binOp == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(20);
        }
        LongRangeSet appliedRange = (isLong = PsiType.LONG.equals((Object)binOp.getType())) ? factValue : factValue.intersect(LongRangeSet.fromType((PsiType)PsiType.INT));
        DfaVariableValue left = binOp.getLeft();
        DfaValue right = binOp.getRight();
        LongRangeSet leftRange = this.getValueFact(left, DfaFactType.RANGE);
        LongRangeSet rightRange = this.getValueFact(right, DfaFactType.RANGE);
        if (leftRange == null || rightRange == null) {
            return true;
        }
        LongRangeSet result = Objects.requireNonNull(leftRange.binOpFromToken(binOp.getTokenType(), rightRange, isLong));
        if (!result.intersects(appliedRange)) {
            return false;
        }
        LongRangeSet leftConstraint = LongRangeSet.all();
        LongRangeSet rightConstraint = LongRangeSet.all();
        switch (binOp.getOperation()) {
            case PLUS: {
                leftConstraint = appliedRange.minus(rightRange, isLong);
                rightConstraint = appliedRange.minus(leftRange, isLong);
                break;
            }
            case MINUS: {
                leftConstraint = rightRange.plus(appliedRange, isLong);
                rightConstraint = leftRange.minus(appliedRange, isLong);
                break;
            }
            case REM: {
                Long value2 = rightRange.getConstantValue();
                if (value2 == null) break;
                leftConstraint = LongRangeSet.fromRemainder(value2, appliedRange.intersect(result));
            }
        }
        return this.applyFact(left, DfaFactType.RANGE, leftConstraint) && this.applyFact(right, DfaFactType.RANGE, rightConstraint);
    }

    @Override
    public boolean applyContractCondition(DfaValue condition2) {
        DfaRelationValue relation;
        if (condition2 instanceof DfaRelationValue && (relation = (DfaRelationValue)condition2).isEquality() && relation.getRightOperand() == this.myFactory.getConstFactory().getNull() && (relation.getLeftOperand() instanceof DfaUnknownValue || relation.getLeftOperand() instanceof DfaVariableValue && this.getVariableState((DfaVariableValue)relation.getLeftOperand()).getNullability() == Nullability.UNKNOWN)) {
            this.markEphemeral();
        }
        return this.applyCondition(condition2);
    }

    @Override
    public boolean areEqual(@NotNull DfaValue value1, @NotNull DfaValue value2) {
        if (value1 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(21);
        }
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(22);
        }
        if (value1 instanceof DfaBinOpValue && value2 instanceof DfaBinOpValue) {
            DfaBinOpValue binOp1 = (DfaBinOpValue)value1;
            DfaBinOpValue binOp2 = (DfaBinOpValue)value2;
            return binOp1.getOperation() == binOp2.getOperation() && this.areEqual(binOp1.getLeft(), binOp2.getLeft()) && this.areEqual(binOp1.getRight(), binOp2.getRight());
        }
        if (!(value1 instanceof DfaConstValue) && !(value1 instanceof DfaVariableValue)) {
            return false;
        }
        if (!(value2 instanceof DfaConstValue) && !(value2 instanceof DfaVariableValue)) {
            return false;
        }
        if (value1 == value2) {
            return true;
        }
        DfaConstValue const1 = this.getConstantValue(value1, false);
        if (const1 != null && const1 == this.getConstantValue(value2, false)) {
            return true;
        }
        int index1 = this.getEqClassIndex(value1);
        int index2 = this.getEqClassIndex(value2);
        return index1 != -1 && index1 == index2;
    }

    @Override
    @Nullable
    public DfaRelationValue.RelationType getRelation(DfaValue left, DfaValue right) {
        int leftClass = this.getEqClassIndex(left);
        int rightClass = this.getEqClassIndex(right);
        if (leftClass == -1 || rightClass == -1) {
            return null;
        }
        if (leftClass == rightClass) {
            return DfaRelationValue.RelationType.EQ;
        }
        return this.myDistinctClasses.getRelation(leftClass, rightClass);
    }

    @Override
    public boolean applyCondition(DfaValue dfaCond) {
        if (dfaCond instanceof DfaUnknownValue) {
            return true;
        }
        if (dfaCond instanceof DfaVariableValue) {
            DfaConstValue dfaTrue = this.myFactory.getConstFactory().getTrue();
            return this.applyRelationCondition(this.myFactory.getRelationFactory().createRelation(dfaCond, DfaRelationValue.RelationType.EQ, dfaTrue));
        }
        if (dfaCond instanceof DfaConstValue) {
            return dfaCond == this.myFactory.getConstFactory().getTrue() || dfaCond != this.myFactory.getConstFactory().getFalse();
        }
        if (!(dfaCond instanceof DfaRelationValue)) {
            return true;
        }
        return this.applyRelationCondition((DfaRelationValue)dfaCond);
    }

    private boolean applyRelationCondition(@NotNull DfaRelationValue dfaRelation) {
        if (dfaRelation == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(23);
        }
        DfaValue dfaLeft = dfaRelation.getLeftOperand();
        DfaValue dfaRight = dfaRelation.getRightOperand();
        DfaRelationValue.RelationType relationType = dfaRelation.getRelation();
        DfaConstValue sentinel = this.getFactory().getConstFactory().getSentinel();
        if (dfaLeft == sentinel || dfaRight == sentinel) {
            assert (relationType == DfaRelationValue.RelationType.EQ || relationType == DfaRelationValue.RelationType.NE);
            return dfaLeft == dfaRight == (relationType == DfaRelationValue.RelationType.EQ);
        }
        if (dfaLeft instanceof DfaUnknownValue || dfaRight instanceof DfaUnknownValue) {
            return true;
        }
        LongRangeSet left = this.getValueFact(dfaLeft, DfaFactType.RANGE);
        LongRangeSet right = this.getValueFact(dfaRight, DfaFactType.RANGE);
        if (left != null && right != null) {
            if (!this.applyFact(dfaLeft, DfaFactType.RANGE, right.fromRelation(relationType)) || !this.applyFact(dfaRight, DfaFactType.RANGE, left.fromRelation(relationType.getFlipped()))) {
                return false;
            }
            if (!this.applyBinOpRelations(dfaLeft, relationType, dfaRight)) {
                return false;
            }
        }
        if (dfaRight instanceof DfaFactMapValue) {
            DfaFactMapValue factValue = (DfaFactMapValue)dfaRight;
            if ((relationType == DfaRelationValue.RelationType.IS || relationType == DfaRelationValue.RelationType.EQ) && DfaNullability.isNotNull(factValue.getFacts()) && !this.applyRelation(dfaLeft, this.getFactory().getConstFactory().getNull(), true)) {
                return false;
            }
            if ((relationType == DfaRelationValue.RelationType.EQ || relationType.isInequality()) && !this.applyUnboxedRelation(dfaLeft, dfaRight, relationType.isInequality())) {
                return false;
            }
            if (dfaLeft instanceof DfaVariableValue) {
                DfaVariableValue dfaVar = (DfaVariableValue)dfaLeft;
                switch (relationType) {
                    case IS: {
                        return this.applyFacts(dfaVar, factValue.getFacts());
                    }
                    case IS_NOT: {
                        boolean isNotNull = DfaNullability.isNotNull(factValue.getFacts());
                        TypeConstraint constraint = factValue.get(DfaFactType.TYPE_CONSTRAINT);
                        if (constraint != null && constraint.getNotInstanceofValues().isEmpty()) {
                            DfaVariableState state = this.getVariableState(dfaVar);
                            for (DfaPsiType type2 : constraint.getInstanceofValues()) {
                                if ((state = state.withNotInstanceofValue(type2)) == null) {
                                    return isNotNull && !this.getVariableState(dfaVar).isNotNull() && this.applyRelation(dfaVar, this.myFactory.getConstFactory().getNull(), false);
                                }
                                this.setVariableState(dfaVar, state);
                            }
                        }
                        return true;
                    }
                }
                return true;
            }
            if (relationType == DfaRelationValue.RelationType.IS || relationType == DfaRelationValue.RelationType.EQ) {
                return this.getFactMap(dfaLeft).intersect(factValue.getFacts()) != null;
            }
            return true;
        }
        if (this.isEffectivelyNaN(dfaLeft) || this.isEffectivelyNaN(dfaRight)) {
            this.applyEquivalenceRelation(relationType, dfaLeft, dfaRight);
            return relationType == DfaRelationValue.RelationType.NE;
        }
        if (this.canBeNaN(dfaLeft) && !this.isNull(dfaRight) || this.canBeNaN(dfaRight) && !this.isNull(dfaLeft)) {
            if (dfaLeft == dfaRight && dfaLeft instanceof DfaVariableValue && !(dfaLeft.getType() instanceof PsiPrimitiveType)) {
                return !dfaRelation.isNonEquality();
            }
            this.applyEquivalenceRelation(relationType, dfaLeft, dfaRight);
            return true;
        }
        return this.applyEquivalenceRelation(relationType, dfaLeft, dfaRight);
    }

    private boolean applyBinOpRelations(DfaValue left, DfaRelationValue.RelationType type2, DfaValue right) {
        if (type2 != DfaRelationValue.RelationType.LT && type2 != DfaRelationValue.RelationType.GT && type2 != DfaRelationValue.RelationType.NE && type2 != DfaRelationValue.RelationType.EQ) {
            return true;
        }
        if (left instanceof DfaBinOpValue) {
            DfaBinOpValue sum = (DfaBinOpValue)left;
            DfaBinOpValue.BinOp op = sum.getOperation();
            if (op != DfaBinOpValue.BinOp.PLUS && op != DfaBinOpValue.BinOp.MINUS) {
                return true;
            }
            LongRangeSet leftRange = this.getValueFact(sum.getLeft(), DfaFactType.RANGE);
            LongRangeSet rightRange = this.getValueFact(sum.getRight(), DfaFactType.RANGE);
            if (leftRange == null || rightRange == null) {
                return true;
            }
            boolean isLong = PsiType.LONG.equals((Object)sum.getType());
            LongRangeSet rightNegated = rightRange.negate(isLong);
            LongRangeSet rightCorrected = op == DfaBinOpValue.BinOp.MINUS ? rightNegated : rightRange;
            LongRangeSet resultRange = this.getValueFact(right, DfaFactType.RANGE);
            DfaRelationValue.RelationType correctedRelation = DfaMemoryStateImpl.correctRelation(type2, leftRange, rightCorrected, resultRange, isLong);
            if (op == DfaBinOpValue.BinOp.MINUS && resultRange != null) {
                long min = resultRange.min();
                long max = resultRange.max();
                if (min == 0L && max == 0L) {
                    if (!this.applyCondition(this.myFactory.createCondition(sum.getLeft(), correctedRelation, sum.getRight()))) {
                        return false;
                    }
                } else if (min >= 0L && DfaRelationValue.RelationType.GE.isSubRelation(type2)) {
                    DfaRelationValue.RelationType correctedGt = DfaMemoryStateImpl.correctRelation(DfaRelationValue.RelationType.GT, leftRange, rightCorrected, resultRange, isLong);
                    if (!this.applyCondition(this.myFactory.createCondition(sum.getLeft(), correctedGt, sum.getRight()))) {
                        return false;
                    }
                } else if (max <= 0L && DfaRelationValue.RelationType.LE.isSubRelation(type2)) {
                    DfaRelationValue.RelationType correctedLt = DfaMemoryStateImpl.correctRelation(DfaRelationValue.RelationType.LT, leftRange, rightCorrected, resultRange, isLong);
                    if (!this.applyCondition(this.myFactory.createCondition(sum.getLeft(), correctedLt, sum.getRight()))) {
                        return false;
                    }
                }
                if (DfaRelationValue.RelationType.EQ.equals((Object)type2) && !resultRange.contains(0L) && !this.applyRelation(sum.getLeft(), sum.getRight(), true)) {
                    return false;
                }
            }
            if (right instanceof DfaVariableValue) {
                if (this.areEqual(sum.getLeft(), right)) {
                    DfaRelationValue.RelationType finalRelation;
                    DfaRelationValue.RelationType relationType = finalRelation = op == DfaBinOpValue.BinOp.MINUS ? Objects.requireNonNull(correctedRelation.getFlipped()) : correctedRelation;
                    if (!this.applyCondition(this.myFactory.createCondition(sum.getRight(), finalRelation, this.myFactory.getInt(0)))) {
                        return false;
                    }
                }
                if (op == DfaBinOpValue.BinOp.PLUS && this.areEqual(sum.getRight(), right) && !this.applyCondition(this.myFactory.createCondition(sum.getLeft(), correctedRelation, this.myFactory.getInt(0)))) {
                    return false;
                }
                if (!leftRange.subtractionMayOverflow(op == DfaBinOpValue.BinOp.MINUS ? rightRange : rightNegated, isLong)) {
                    if (rightCorrected.max() < 0L && DfaRelationValue.RelationType.GE.isSubRelation(type2) && !this.applyLessThanRelation(right, sum.getLeft())) {
                        return false;
                    }
                    if (rightCorrected.min() > 0L && DfaRelationValue.RelationType.LE.isSubRelation(type2) && !this.applyLessThanRelation(sum.getLeft(), right)) {
                        return false;
                    }
                }
                if (DfaRelationValue.RelationType.EQ == type2 && !rightRange.contains(0L) && !this.applyRelation(sum.getLeft(), right, true)) {
                    return false;
                }
            }
        }
        return true;
    }

    private static DfaRelationValue.RelationType correctRelation(DfaRelationValue.RelationType relation, LongRangeSet summand1, LongRangeSet summand2, LongRangeSet resultRange, boolean isLong) {
        if (relation != DfaRelationValue.RelationType.LT && relation != DfaRelationValue.RelationType.GT) {
            return relation;
        }
        boolean overflowPossible = true;
        if (!isLong) {
            LongRangeSet overflowRange = DfaMemoryStateImpl.getIntegerSumOverflowValues(summand1, summand2);
            overflowPossible = !overflowRange.isEmpty() && (resultRange == null || resultRange.fromRelation(relation).intersects(overflowRange));
        }
        return overflowPossible ? DfaRelationValue.RelationType.NE : relation;
    }

    @NotNull
    private static LongRangeSet getIntegerSumOverflowValues(LongRangeSet left, LongRangeSet right) {
        if (left.isEmpty() || right.isEmpty()) {
            LongRangeSet longRangeSet = LongRangeSet.empty();
            if (longRangeSet == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(24);
            }
            return longRangeSet;
        }
        long sumMin = left.min() + right.min();
        long sumMax = left.max() + right.max();
        LongRangeSet result = LongRangeSet.empty();
        if (sumMin < Integer.MIN_VALUE) {
            result = result.unite(LongRangeSet.range((int)sumMin, Integer.MAX_VALUE));
        }
        if (sumMax > Integer.MAX_VALUE) {
            result = result.unite(LongRangeSet.range(Integer.MIN_VALUE, (int)sumMax));
        }
        LongRangeSet longRangeSet = result;
        if (longRangeSet == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(25);
        }
        return longRangeSet;
    }

    private void updateVarStateOnComparison(@NotNull DfaVariableValue dfaVar, DfaValue value2, boolean isNegated) {
        if (dfaVar == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(26);
        }
        if (isNegated) {
            if (this.isNull(value2)) {
                this.setVariableState(dfaVar, this.getVariableState(dfaVar).withFact(DfaFactType.NULLABILITY, DfaNullability.NOT_NULL));
            }
        } else {
            if (value2 instanceof DfaConstValue) {
                Object constValue = ((DfaConstValue)value2).getValue();
                if (constValue == null) {
                    this.setVariableState(dfaVar, this.getVariableState(dfaVar).withFact(DfaFactType.NULLABILITY, DfaNullability.NULL));
                    return;
                }
                DfaPsiType dfaType = this.myFactory.createDfaType(((DfaConstValue)value2).getType());
                DfaVariableState state = this.getVariableState(dfaVar).withInstanceofValue(dfaType);
                if (state != null) {
                    this.setVariableState(dfaVar, state);
                }
            }
            if (this.isNotNull(value2) && !this.isNotNull(dfaVar)) {
                this.setVariableState(dfaVar, this.getVariableState(dfaVar).withoutFact(DfaFactType.NULLABILITY));
                this.applyRelation(dfaVar, this.myFactory.getConstFactory().getNull(), true);
            }
        }
    }

    private boolean applyEquivalenceRelation(DfaRelationValue.RelationType type2, DfaValue dfaLeft, DfaValue dfaRight) {
        boolean isNegated;
        boolean bl = isNegated = type2 == DfaRelationValue.RelationType.NE || type2 == DfaRelationValue.RelationType.GT || type2 == DfaRelationValue.RelationType.LT;
        if (!isNegated && type2 != DfaRelationValue.RelationType.EQ) {
            return true;
        }
        if (dfaLeft instanceof DfaVariableValue && dfaRight instanceof DfaConstValue) {
            LongRangeSet appliedRange;
            LongRangeSet leftRange = this.getValueFact(dfaLeft, DfaFactType.RANGE);
            LongRangeSet rightRange = this.getValueFact(dfaRight, DfaFactType.RANGE);
            if (leftRange != null && rightRange != null && (appliedRange = rightRange.fromRelation(type2)) != null) {
                if (!this.applyRangeToRelatedValues(dfaLeft, appliedRange)) {
                    return false;
                }
                if (appliedRange.contains(leftRange)) {
                    return true;
                }
            }
        }
        if (dfaLeft == dfaRight) {
            return !isNegated || dfaLeft instanceof DfaVariableValue && ((DfaVariableValue)dfaLeft).containsCalls();
        }
        if (this.isNull(dfaLeft) && this.isNotNull(dfaRight) || this.isNull(dfaRight) && this.isNotNull(dfaLeft)) {
            return isNegated;
        }
        if (dfaLeft instanceof DfaVariableValue) {
            this.updateVarStateOnComparison((DfaVariableValue)dfaLeft, dfaRight, isNegated);
        }
        if (dfaRight instanceof DfaVariableValue) {
            this.updateVarStateOnComparison((DfaVariableValue)dfaRight, dfaLeft, isNegated);
        }
        if (type2 == DfaRelationValue.RelationType.LT) {
            if (!this.applyLessThanRelation(dfaLeft, dfaRight)) {
                return false;
            }
        } else if (type2 == DfaRelationValue.RelationType.GT) {
            if (!this.applyLessThanRelation(dfaRight, dfaLeft)) {
                return false;
            }
        } else {
            if (!isNegated && !this.applySpecialFieldEquivalence(dfaLeft, dfaRight)) {
                return false;
            }
            if (!this.applyRelation(dfaLeft, dfaRight, isNegated)) {
                return false;
            }
        }
        if (!this.checkCompareWithBooleanLiteral(dfaLeft, dfaRight, isNegated)) {
            return false;
        }
        return this.applyUnboxedRelation(dfaLeft, dfaRight, isNegated);
    }

    private boolean applyRangeToRelatedValues(DfaValue value2, LongRangeSet appliedRange) {
        EqClass eqClass = this.getEqClass(value2);
        if (eqClass != null) {
            if (!this.applyRelationRangeToClass(eqClass, appliedRange, DfaRelationValue.RelationType.EQ)) {
                return false;
            }
            for (DistinctPairSet.DistinctPair pair2 : this.getDistinctClassPairs().toArray(new DistinctPairSet.DistinctPair[0])) {
                EqClass other;
                if (pair2.isOrdered()) {
                    if (!(pair2.getFirst() == eqClass ? !this.applyRelationRangeToClass(pair2.getSecond(), appliedRange, DfaRelationValue.RelationType.GT) : pair2.getSecond() == eqClass && !this.applyRelationRangeToClass(pair2.getFirst(), appliedRange, DfaRelationValue.RelationType.LT))) continue;
                    return false;
                }
                if (appliedRange.getConstantValue() == null) continue;
                EqClass eqClass2 = pair2.getFirst() == eqClass ? pair2.getSecond() : (other = pair2.getSecond() == eqClass ? pair2.getFirst() : null);
                if (other == null || this.applyRelationRangeToClass(other, appliedRange, DfaRelationValue.RelationType.NE)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean applyRelationRangeToClass(EqClass eqClass, LongRangeSet range, DfaRelationValue.RelationType relationType) {
        LongRangeSet appliedRange = range.fromRelation(relationType);
        for (DfaVariableValue var : eqClass.getVariables(false)) {
            if (this.applyFact(var, DfaFactType.RANGE, appliedRange)) continue;
            return false;
        }
        return true;
    }

    private Couple<DfaValue> getSpecialEquivalencePair(DfaVariableValue left, DfaValue right) {
        if (right instanceof DfaVariableValue) {
            return null;
        }
        SpecialField field = SpecialField.fromQualifierType(left.getType());
        if (field == null) {
            return null;
        }
        DfaValue leftValue = field.createValue(this.myFactory, left);
        DfaValue rightValue = field.createValue(this.myFactory, right);
        return rightValue.equals(field.getDefaultValue(this.myFactory, false)) ? null : Couple.of((Object)leftValue, (Object)rightValue);
    }

    private boolean applySpecialFieldEquivalence(@NotNull DfaValue left, @NotNull DfaValue right) {
        if (left == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(27);
        }
        if (right == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(28);
        }
        Couple<DfaValue> pair2 = left instanceof DfaVariableValue ? this.getSpecialEquivalencePair((DfaVariableValue)left, right) : (right instanceof DfaVariableValue ? this.getSpecialEquivalencePair((DfaVariableValue)right, left) : null);
        return pair2 == null || this.applyCondition(this.myFactory.createCondition((DfaValue)pair2.getFirst(), DfaRelationValue.RelationType.EQ, (DfaValue)pair2.getSecond()));
    }

    private boolean applyUnboxedRelation(@NotNull DfaValue dfaLeft, DfaValue dfaRight, boolean negated) {
        if (dfaLeft == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(29);
        }
        if (dfaLeft instanceof DfaVariableValue && !TypeConversionUtil.isPrimitiveWrapper((PsiType)dfaLeft.getType()) || dfaRight instanceof DfaVariableValue && !TypeConversionUtil.isPrimitiveWrapper((PsiType)dfaRight.getType())) {
            return true;
        }
        PsiType leftType = DfaMemoryStateImpl.getPsiType(dfaLeft);
        PsiType rightType = DfaMemoryStateImpl.getPsiType(dfaRight);
        if (TypeConversionUtil.isPrimitiveWrapper((PsiType)leftType) && TypeConversionUtil.isPrimitiveWrapper((PsiType)rightType) && !leftType.equals(rightType)) {
            return negated;
        }
        DfaValue unboxedLeft = SpecialField.UNBOX.createValue(this.myFactory, dfaLeft);
        DfaValue unboxedRight = SpecialField.UNBOX.createValue(this.myFactory, dfaRight);
        DfaConstValue leftConst = this.getConstantValue(unboxedLeft);
        DfaConstValue rightConst = this.getConstantValue(unboxedRight);
        if (leftConst != null && rightConst != null) {
            return Objects.equals(leftConst.getValue(), rightConst.getValue()) != negated;
        }
        if (negated && (PsiType.FLOAT.equals((Object)unboxedLeft.getType()) || PsiType.DOUBLE.equals((Object)unboxedLeft.getType()))) {
            return true;
        }
        return this.applyRelation(unboxedLeft, unboxedRight, negated);
    }

    @Nullable
    private static PsiType getPsiType(@NotNull DfaValue value2) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(30);
        }
        if (value2 instanceof DfaFactMapValue) {
            TypeConstraint constraint = ((DfaFactMapValue)value2).get(DfaFactType.TYPE_CONSTRAINT);
            return constraint == null ? null : constraint.getPsiType();
        }
        return value2.getType();
    }

    private boolean checkCompareWithBooleanLiteral(DfaValue dfaLeft, DfaValue dfaRight, boolean negated) {
        Object constVal;
        if (dfaRight instanceof DfaConstValue && (constVal = ((DfaConstValue)dfaRight).getValue()) instanceof Boolean) {
            boolean boolValue = (Boolean)constVal;
            return this.applyRelation(dfaLeft, this.myFactory.getBoolean(!boolValue), !negated) && this.applyRelation(dfaLeft, this.myFactory.getBoolean(boolValue), negated);
        }
        return true;
    }

    static boolean isNaN(DfaValue dfa) {
        return dfa instanceof DfaConstValue && DfaUtil.isNaN(((DfaConstValue)dfa).getValue());
    }

    private boolean applyRelation(@NotNull DfaValue dfaLeft, @NotNull DfaValue dfaRight, boolean isNegated) {
        if (dfaLeft == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(31);
        }
        if (dfaRight == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(32);
        }
        Integer c1Index = this.getOrCreateEqClassIndex(dfaLeft);
        Integer c2Index = this.getOrCreateEqClassIndex(dfaRight);
        if (c1Index == null || c2Index == null) {
            return true;
        }
        if (c1Index.equals(c2Index)) {
            return !isNegated;
        }
        DfaRelationValue.RelationType constantRelation = this.getConstantRelation(dfaLeft, dfaRight);
        if (constantRelation != null) {
            return constantRelation == DfaRelationValue.RelationType.EQ != isNegated;
        }
        if (!isNegated) {
            if (this.isUnstableValue(dfaLeft) || this.isUnstableValue(dfaRight)) {
                return true;
            }
            if (!this.uniteClasses(dfaLeft, dfaRight)) {
                return false;
            }
            Iterator<DistinctPairSet.DistinctPair> iterator = this.myDistinctClasses.iterator();
            while (iterator.hasNext()) {
                DistinctPairSet.DistinctPair pair2 = iterator.next();
                DfaConstValue const1 = pair2.getFirst().findConstant();
                DfaConstValue const2 = pair2.getSecond().findConstant();
                if (const1 == null || const2 == null || DfaMemoryStateImpl.preserveConstantDistinction(const1.getValue(), const2.getValue())) continue;
                iterator.remove();
            }
            this.myCachedNonTrivialEqClasses = null;
        } else {
            if (this.isNull(dfaLeft) && DfaMemoryStateImpl.isPrimitive(dfaRight) || this.isNull(dfaRight) && DfaMemoryStateImpl.isPrimitive(dfaLeft)) {
                return true;
            }
            if (this.applyBooleanInequality(dfaLeft, dfaRight) || this.applyBooleanInequality(dfaRight, dfaLeft)) {
                return true;
            }
            this.myDistinctClasses.addUnordered(c1Index, c2Index);
        }
        this.myCachedHash = null;
        return true;
    }

    private boolean applyBooleanInequality(DfaValue var, DfaValue value2) {
        if (!(var instanceof DfaVariableValue) || !PsiType.BOOLEAN.equals((Object)var.getType()) || ((DfaVariableValue)var).getDescriptor() == SpecialField.UNBOX) {
            return false;
        }
        if (!(value2 instanceof DfaConstValue)) {
            return false;
        }
        Boolean constValue = (Boolean)ObjectUtils.tryCast((Object)((DfaConstValue)value2).getValue(), Boolean.class);
        return constValue != null && this.applyRelation(var, this.myFactory.getBoolean(constValue == false), false);
    }

    private boolean applyLessThanRelation(@NotNull DfaValue dfaLeft, @NotNull DfaValue dfaRight) {
        if (dfaLeft == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(33);
        }
        if (dfaRight == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(34);
        }
        Integer c1Index = this.getOrCreateEqClassIndex(dfaLeft);
        Integer c2Index = this.getOrCreateEqClassIndex(dfaRight);
        if (c1Index == null || c2Index == null) {
            return true;
        }
        if (c1Index.equals(c2Index)) {
            return false;
        }
        DfaRelationValue.RelationType constantRelation = this.getConstantRelation(dfaLeft, dfaRight);
        if (constantRelation != null) {
            return constantRelation == DfaRelationValue.RelationType.LT;
        }
        if (this.isNull(dfaLeft) && DfaMemoryStateImpl.isPrimitive(dfaRight) || this.isNull(dfaRight) && DfaMemoryStateImpl.isPrimitive(dfaLeft)) {
            return true;
        }
        this.myCachedHash = null;
        return this.myDistinctClasses.addOrdered(c1Index, c2Index);
    }

    private boolean isUnstableValue(DfaValue value2) {
        if (!(value2 instanceof DfaVariableValue)) {
            return false;
        }
        DfaVariableValue var = (DfaVariableValue)value2;
        PsiModifierListOwner owner2 = var.getPsiVariable();
        if (!(owner2 instanceof PsiMethod)) {
            return false;
        }
        if (var.getType() instanceof PsiPrimitiveType) {
            return false;
        }
        if (PropertyUtilBase.isSimplePropertyGetter((PsiMethod)((PsiMethod)owner2))) {
            return false;
        }
        return !this.isNull(var);
    }

    private static boolean isPrimitive(DfaValue value2) {
        return value2 instanceof DfaVariableValue && value2.getType() instanceof PsiPrimitiveType;
    }

    private static boolean preserveConstantDistinction(Object c1, Object c2) {
        return c1 == null && c2 instanceof PsiVariable || c2 == null && c1 instanceof PsiVariable;
    }

    @Nullable
    private DfaRelationValue.RelationType getConstantRelation(DfaValue val1, DfaValue val2) {
        int cmp;
        DfaConstValue const1 = this.getConstantValue(val1, false);
        DfaConstValue const2 = this.getConstantValue(val2, false);
        if (const1 == null || const2 == null) {
            return null;
        }
        Number value1 = (Number)ObjectUtils.tryCast((Object)const1.getValue(), Number.class);
        Number value2 = (Number)ObjectUtils.tryCast((Object)const2.getValue(), Number.class);
        if (value1 == null || value2 == null) {
            return null;
        }
        if (value1 instanceof Long && value2 instanceof Long) {
            cmp = Long.compare((Long)value1, (Long)value2);
        } else {
            double double1 = value1.doubleValue();
            double double2 = value2.doubleValue();
            if (double1 == 0.0 && double2 == 0.0) {
                return DfaRelationValue.RelationType.EQ;
            }
            cmp = Double.compare(double1, double2);
        }
        return cmp == 0 ? DfaRelationValue.RelationType.EQ : (cmp < 0 ? DfaRelationValue.RelationType.LT : DfaRelationValue.RelationType.GT);
    }

    @Override
    public boolean checkNotNullable(DfaValue value2) {
        if (value2 == this.myFactory.getConstFactory().getNull()) {
            return false;
        }
        if (value2 instanceof DfaFactMapValue && DfaNullability.isNullable(((DfaFactMapValue)value2).getFacts())) {
            return false;
        }
        if (value2 instanceof DfaVariableValue) {
            DfaVariableValue varValue = (DfaVariableValue)value2;
            if (varValue.getType() instanceof PsiPrimitiveType) {
                return true;
            }
            if (this.isNotNull(varValue)) {
                return true;
            }
            return this.getVariableState(varValue).getNullability() != Nullability.NULLABLE;
        }
        return true;
    }

    @Override
    @Nullable
    public <T> T getValueFact(@NotNull DfaValue value2, @NotNull DfaFactType<T> factType) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(35);
        }
        if (factType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(36);
        }
        if (value2 instanceof DfaBinOpValue && factType == DfaFactType.RANGE) {
            return (T)this.getBinOpRange((DfaBinOpValue)value2);
        }
        if (value2 instanceof DfaVariableValue) {
            T fact;
            DfaVariableValue var = (DfaVariableValue)value2;
            DfaVariableState state = this.getExistingVariableState(var);
            if (state != null && (fact = state.getFact(factType)) != null) {
                return fact;
            }
            value2 = this.resolveVariableValue(var);
        }
        return factType.fromDfaValue(value2);
    }

    @Nullable
    public LongRangeSet getBinOpRange(DfaBinOpValue binOp) {
        LongRangeSet left = this.getValueFact(binOp.getLeft(), DfaFactType.RANGE);
        LongRangeSet right = this.getValueFact(binOp.getRight(), DfaFactType.RANGE);
        if (left == null || right == null) {
            return null;
        }
        boolean isLong = PsiType.LONG.equals((Object)binOp.getType());
        LongRangeSet result = left.binOpFromToken(binOp.getTokenType(), right, isLong);
        if (result != null && binOp.getOperation() == DfaBinOpValue.BinOp.MINUS) {
            DfaRelationValue.RelationType rel = this.getRelation(binOp.getLeft(), binOp.getRight());
            if (rel == DfaRelationValue.RelationType.NE) {
                return result.without(0L);
            }
            if (!left.subtractionMayOverflow(right, isLong)) {
                if (rel == DfaRelationValue.RelationType.GT) {
                    return result.intersect(LongRangeSet.range(1L, isLong ? Long.MAX_VALUE : Integer.MAX_VALUE));
                }
                if (rel == DfaRelationValue.RelationType.LT) {
                    return result.intersect(LongRangeSet.range(isLong ? Long.MIN_VALUE : Integer.MIN_VALUE, -1L));
                }
            }
        }
        return result;
    }

    @Override
    public <T> void forceVariableFact(@NotNull DfaVariableValue var, @NotNull DfaFactType<T> factType, @Nullable T value2) {
        if (var == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(37);
        }
        if (factType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(38);
        }
        DfaVariableState state = this.getVariableState(var);
        if (factType.equals(DfaFactType.NULLABILITY) && value2 == DfaNullability.NOT_NULL && this.isNull(var)) {
            this.removeEquivalenceForVariableAndWrappers(var);
        }
        this.setVariableState(var, state.withFact(factType, value2));
        this.updateEqClassesByState(var);
    }

    @NotNull
    private DfaValue resolveVariableValue(DfaVariableValue var) {
        DfaConstValue constValue = this.getConstantValue(var, false);
        if (constValue != null) {
            DfaConstValue dfaConstValue = constValue;
            if (dfaConstValue == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(39);
            }
            return dfaConstValue;
        }
        DfaVariableValue dfaVariableValue = var;
        if (dfaVariableValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(40);
        }
        return dfaVariableValue;
    }

    @Override
    @NotNull
    public DfaFactMap getFacts(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(41);
        }
        DfaFactMap dfaFactMap = this.getVariableState((DfaVariableValue)variable).myFactMap;
        if (dfaFactMap == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(42);
        }
        return dfaFactMap;
    }

    DfaFactMap getFactMap(@NotNull DfaValue value2) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(43);
        }
        if (value2 instanceof DfaVariableValue) {
            DfaVariableState state = this.getExistingVariableState((DfaVariableValue)value2);
            if (state != null) {
                return state.myFactMap;
            }
            if ((value2 = this.resolveVariableValue((DfaVariableValue)value2)) instanceof DfaVariableValue) {
                return this.getDefaultState((DfaVariableValue)((DfaVariableValue)value2)).myFactMap;
            }
        }
        if (value2 instanceof DfaBinOpValue) {
            return DfaFactMap.EMPTY.with(DfaFactType.RANGE, this.getValueFact(value2, DfaFactType.RANGE));
        }
        return DfaFactMap.fromDfaValue(value2);
    }

    void setVariableState(@NotNull DfaVariableValue dfaVar, @NotNull DfaVariableState state) {
        if (dfaVar == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(44);
        }
        if (state == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(45);
        }
        if (state.equals(this.getDefaultState(dfaVar = this.canonicalize(dfaVar)))) {
            this.myVariableStates.remove(dfaVar);
        } else {
            this.myVariableStates.put(dfaVar, state);
        }
        this.myCachedHash = null;
    }

    protected void updateEquivalentVariables(DfaVariableValue dfaVar, DfaVariableState state) {
        EqClass eqClass = this.getEqClass(dfaVar);
        if (eqClass != null) {
            for (DfaValue value2 : eqClass.getMemberValues()) {
                if (value2 == dfaVar || !(value2 instanceof DfaVariableValue)) continue;
                this.setVariableState((DfaVariableValue)value2, state);
            }
        }
    }

    @NotNull
    private DfaValue canonicalize(@NotNull DfaValue value2) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(46);
        }
        if (value2 instanceof DfaVariableValue) {
            DfaVariableValue dfaVariableValue = this.canonicalize((DfaVariableValue)value2);
            if (dfaVariableValue == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(47);
            }
            return dfaVariableValue;
        }
        if (value2 instanceof DfaBoxedValue) {
            DfaBoxedValue boxedValue = (DfaBoxedValue)value2;
            DfaVariableValue canonicalized = this.canonicalize(boxedValue.getWrappedValue());
            DfaValue dfaValue = Objects.requireNonNull(this.myFactory.getBoxedFactory().createBoxed(canonicalized, boxedValue.getType()));
            if (dfaValue == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(48);
            }
            return dfaValue;
        }
        DfaValue dfaValue = value2;
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(49);
        }
        return dfaValue;
    }

    @NotNull
    private DfaVariableValue canonicalize(DfaVariableValue var) {
        DfaVariableValue qualifier = var.getQualifier();
        if (qualifier != null) {
            Integer index = (Integer)this.myIdToEqClassesIndices.get(qualifier.getID());
            if (index == null && (index = (Integer)this.myIdToEqClassesIndices.get((qualifier = this.canonicalize(qualifier)).getID())) == null) {
                DfaVariableValue dfaVariableValue = var.withQualifier(qualifier);
                if (dfaVariableValue == null) {
                    DfaMemoryStateImpl.$$$reportNull$$$0(50);
                }
                return dfaVariableValue;
            }
            DfaVariableValue dfaVariableValue = var.withQualifier(Objects.requireNonNull(this.myEqClasses.get(index).getCanonicalVariable()));
            if (dfaVariableValue == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(51);
            }
            return dfaVariableValue;
        }
        DfaVariableValue dfaVariableValue = var;
        if (dfaVariableValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(52);
        }
        return dfaVariableValue;
    }

    private DfaVariableState getExistingVariableState(DfaVariableValue var) {
        DfaVariableState state = this.myVariableStates.get(var);
        if (state != null) {
            return state;
        }
        DfaVariableValue canonicalized = this.canonicalize(var);
        return canonicalized == var ? null : this.myVariableStates.get(canonicalized);
    }

    @NotNull
    DfaVariableState getVariableState(DfaVariableValue dfaVar) {
        DfaVariableState state = this.getExistingVariableState(dfaVar);
        DfaVariableState dfaVariableState = state != null ? state : this.getDefaultState(dfaVar);
        if (dfaVariableState == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(53);
        }
        return dfaVariableState;
    }

    @NotNull
    private DfaVariableState getDefaultState(DfaVariableValue dfaVar) {
        DfaVariableState dfaVariableState = this.myDefaultVariableStates.computeIfAbsent(dfaVar, this::createVariableState);
        if (dfaVariableState == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(54);
        }
        return dfaVariableState;
    }

    void forVariableStates(BiConsumer<? super DfaVariableValue, ? super DfaVariableState> consumer) {
        this.myVariableStates.forEach(consumer);
    }

    @NotNull
    protected DfaVariableState createVariableState(@NotNull DfaVariableValue var) {
        if (var == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(55);
        }
        DfaVariableState dfaVariableState = new DfaVariableState(var);
        if (dfaVariableState == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(56);
        }
        return dfaVariableState;
    }

    @Override
    public void flushFields() {
        LinkedHashSet<DfaVariableValue> vars = new LinkedHashSet<DfaVariableValue>(this.getChangedVariables());
        for (EqClass aClass : this.myEqClasses) {
            if (aClass == null) continue;
            vars.addAll(aClass.getVariables(true));
        }
        for (DfaVariableValue value2 : vars) {
            DfaVariableValue qualifier;
            if (!value2.isFlushableByCalls() || (qualifier = value2.getQualifier()) != null && (this.getValueFact(qualifier, DfaFactType.MUTABILITY) == Mutability.UNMODIFIABLE || Boolean.TRUE.equals(this.getValueFact(qualifier, DfaFactType.LOCALITY)))) continue;
            this.doFlush(value2, this.shouldMarkFlushed(value2));
        }
        this.myStack.replaceAll(val -> {
            DfaFactMapValue factMapValue;
            SpecialFieldValue sfValue;
            if (val instanceof DfaFactMapValue && (sfValue = (factMapValue = (DfaFactMapValue)val).get(DfaFactType.SPECIAL_FIELD_VALUE)) != null && !sfValue.getField().isStable() && factMapValue.get(DfaFactType.MUTABILITY) != Mutability.UNMODIFIABLE) {
                return factMapValue.withFact(DfaFactType.SPECIAL_FIELD_VALUE, null);
            }
            return val;
        });
    }

    private boolean shouldMarkFlushed(@NotNull DfaVariableValue value2) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(57);
        }
        if (value2.getInherentNullability() != Nullability.NULLABLE) {
            return false;
        }
        return this.getVariableState(value2).getFact(DfaFactType.NULLABILITY) == DfaNullability.FLUSHED || this.isNull(value2) || this.isNotNull(value2);
    }

    @NotNull
    Set<DfaVariableValue> getChangedVariables() {
        Set<DfaVariableValue> set = this.myVariableStates.keySet();
        if (set == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(58);
        }
        return set;
    }

    @Override
    public void flushVariable(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(59);
        }
        this.flushVariable(variable, false);
    }

    protected void flushVariable(@NotNull DfaVariableValue variable, boolean shouldMarkFlushed) {
        if (variable == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(60);
        }
        EqClass eqClass = variable.getDependentVariables().isEmpty() ? null : this.getEqClass(variable);
        DfaVariableValue newCanonical = eqClass == null ? null : (DfaVariableValue)StreamEx.of(eqClass.getVariables(false)).without((Object)variable).min(EqClass.CANONICAL_VARIABLE_COMPARATOR).filter(candidate -> !candidate.dependsOn(variable)).orElse(null);
        this.myStack.replaceAll(value2 -> this.handleStackValueOnVariableFlush((DfaValue)value2, variable, newCanonical));
        this.doFlush(variable, shouldMarkFlushed);
        this.flushDependencies(variable);
        this.myCachedHash = null;
    }

    void flushDependencies(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(61);
        }
        for (DfaVariableValue dependent : variable.getDependentVariables().toArray(new DfaVariableValue[0])) {
            this.doFlush(dependent, false);
        }
    }

    private void flushQualifiedMethods(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(62);
        }
        PsiModifierListOwner psiVariable = variable.getPsiVariable();
        DfaVariableValue qualifier = variable.getQualifier();
        if (psiVariable instanceof PsiField && qualifier != null) {
            List toFlush = ContainerUtil.filter(qualifier.getDependentVariables(), DfaVariableValue::containsCalls);
            toFlush.forEach(val -> this.doFlush((DfaVariableValue)val, this.shouldMarkFlushed((DfaVariableValue)val)));
        }
    }

    void doFlush(@NotNull DfaVariableValue var, boolean markFlushed) {
        if (var == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(63);
        }
        if (this.isNull(var)) {
            this.myStack.replaceAll(val -> val == var ? this.myFactory.getConstFactory().getNull() : val);
        }
        this.removeEquivalenceForVariableAndWrappers(var);
        this.myVariableStates.remove(var);
        if (markFlushed) {
            this.setVariableState(var, this.getVariableState(var).withFact(DfaFactType.NULLABILITY, DfaNullability.FLUSHED));
        }
        this.myCachedHash = null;
    }

    private void removeEquivalence(DfaValue var) {
        int varID = var.getID();
        Integer varClassIndex = (Integer)this.myIdToEqClassesIndices.get(varID);
        if (varClassIndex == null && (varClassIndex = (Integer)this.myIdToEqClassesIndices.get(varID = (var = this.canonicalize(var)).getID())) == null) {
            return;
        }
        EqClass varClass = this.myEqClasses.get(varClassIndex);
        varClass = new EqClass(varClass);
        DfaVariableValue previousCanonical = varClass.getCanonicalVariable();
        this.myEqClasses.set(varClassIndex, varClass);
        varClass.removeValue(varID);
        this.myIdToEqClassesIndices.remove(varID);
        this.checkInvariants();
        if (varClass.isEmpty()) {
            this.myEqClasses.set(varClassIndex, null);
            Iterator<DistinctPairSet.DistinctPair> iterator = this.myDistinctClasses.iterator();
            while (iterator.hasNext()) {
                DistinctPairSet.DistinctPair pair2 = iterator.next();
                if (pair2.getOtherClass(varClassIndex) == null) continue;
                iterator.remove();
            }
        } else if (varClass.containsConstantsOnly()) {
            Iterator<DistinctPairSet.DistinctPair> iterator = this.myDistinctClasses.iterator();
            while (iterator.hasNext()) {
                DistinctPairSet.DistinctPair pair3 = iterator.next();
                EqClass other = pair3.getOtherClass(varClassIndex);
                if (other == null || !other.containsConstantsOnly()) continue;
                iterator.remove();
            }
        } else {
            DfaVariableValue newCanonical = varClass.getCanonicalVariable();
            if (newCanonical != null && previousCanonical != null && previousCanonical != newCanonical && (ControlFlowAnalyzer.isTempVariable(previousCanonical) && !newCanonical.dependsOn(previousCanonical) || newCanonical.getDepth() <= previousCanonical.getDepth())) {
                boolean successfullyConverted = this.convertQualifiers(previousCanonical, newCanonical);
                assert (successfullyConverted);
            }
        }
        this.myCachedNonTrivialEqClasses = null;
        this.myCachedHash = null;
    }

    void removeEquivalenceForVariableAndWrappers(@NotNull DfaVariableValue var) {
        if (var == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(64);
        }
        this.removeEquivalence(var);
        DfaBoxedValue wrapped = this.myFactory.getBoxedFactory().getBoxedIfExists(var);
        if (wrapped != null) {
            this.removeEquivalence(wrapped);
        }
    }

    Object getMergeabilityKey() {
        return StreamEx.of(this.myStack).mapLastOrElse(val -> (DfaControlTransferValue)ObjectUtils.tryCast((Object)val, DfaControlTransferValue.class), Function.identity()).append((Object)this.isEphemeral()).toImmutableList();
    }

    void merge(DfaMemoryStateImpl other) {
        assert (other.isEphemeral() == this.isEphemeral());
        assert (other.myStack.size() == this.myStack.size());
        ProgressManager.checkCanceled();
        this.retainEquivalences(other);
        this.mergeDistinctPairs(other);
        this.mergeVariableStates(other);
        this.mergeStacks(other);
        this.myCachedHash = null;
        this.myCachedNonTrivialEqClasses = null;
        this.afterMerge(other);
    }

    protected void afterMerge(DfaMemoryStateImpl other) {
    }

    private void mergeStacks(DfaMemoryStateImpl other) {
        List values = StreamEx.zip(this.myStack, other.myStack, DfaValue::unite).toList();
        this.myStack.clear();
        values.forEach(arg_0 -> this.myStack.push(arg_0));
    }

    private void mergeDistinctPairs(DfaMemoryStateImpl other) {
        ArrayList<DistinctPairSet.DistinctPair> pairs = new ArrayList<DistinctPairSet.DistinctPair>(this.myDistinctClasses);
        for (DistinctPairSet.DistinctPair pair2 : pairs) {
            EqClass first = pair2.getFirst();
            EqClass second = pair2.getSecond();
            DfaRelationValue.RelationType relation = other.getRelation(this.myFactory.getValue(first.get(0)), this.myFactory.getValue(second.get(0)));
            if (relation == null || relation == DfaRelationValue.RelationType.EQ) {
                this.myDistinctClasses.remove(pair2);
                continue;
            }
            if (!pair2.isOrdered() || relation == DfaRelationValue.RelationType.LT) continue;
            this.myDistinctClasses.dropOrder(pair2);
        }
    }

    private void mergeVariableStates(DfaMemoryStateImpl other) {
        Set vars = (Set)StreamEx.of((Object[])new LinkedHashMap[]{this.myVariableStates, other.myVariableStates}).toFlatCollection(Map::keySet, HashSet::new);
        for (DfaVariableValue var : vars) {
            Nullability otherNullability;
            DfaVariableState state = this.getVariableState(var);
            DfaVariableState otherState = other.getVariableState(var);
            DfaFactMap result = state.myFactMap.unite(otherState.myFactMap);
            Nullability nullability = state.getNullability();
            if (nullability != (otherNullability = otherState.getNullability()) && (nullability == Nullability.NULLABLE || otherNullability == Nullability.NULLABLE)) {
                result = result.with(DfaFactType.NULLABILITY, DfaNullability.FLUSHED);
            }
            this.setVariableState(var, state.withFacts(result));
        }
    }

    private void retainEquivalences(DfaMemoryStateImpl other) {
        boolean needRestart = true;
        block0: while (needRestart) {
            ProgressManager.checkCanceled();
            needRestart = false;
            for (EqClass eqClass : new ArrayList<EqClass>(this.myEqClasses)) {
                if (eqClass == null || !this.retainEquivalences(eqClass, other)) continue;
                needRestart = true;
                continue block0;
            }
        }
    }

    private boolean retainEquivalences(EqClass eqClass, DfaMemoryStateImpl other) {
        if (eqClass.size() <= 1) {
            return false;
        }
        List<EqClass> groups = this.splitEqClass(eqClass, other);
        if (groups.size() == 1) {
            return false;
        }
        TIntArrayList addedClasses = new TIntArrayList();
        int origIndex = (Integer)this.myIdToEqClassesIndices.get(eqClass.get(0));
        for (EqClass group : groups) {
            addedClasses.add(this.storeClass(group));
        }
        int[] addedClassesArray = addedClasses.toNativeArray();
        this.myDistinctClasses.splitClass(origIndex, addedClassesArray);
        this.myEqClasses.set(origIndex, null);
        DfaVariableValue from = eqClass.getCanonicalVariable();
        boolean otherClassChanged = false;
        if (from != null && !from.getDependentVariables().isEmpty()) {
            ArrayList<DfaVariableValue> vars = new ArrayList<DfaVariableValue>(this.myVariableStates.keySet());
            for (int classIndex : addedClassesArray) {
                DfaVariableValue to = this.myEqClasses.get(classIndex).getCanonicalVariable();
                if (to == null || to == from || to.getDepth() > from.getDepth()) continue;
                for (DfaVariableValue var : vars) {
                    DfaVariableValue target = DfaMemoryStateImpl.replaceQualifier(var, from, to);
                    if (target == var) continue;
                    this.setVariableState(target, this.getVariableState(var));
                }
                for (Object valueId : (Object)this.myIdToEqClassesIndices.keys()) {
                    DfaValue value2 = this.myFactory.getValue((int)valueId);
                    DfaVariableValue var = (DfaVariableValue)ObjectUtils.tryCast((Object)value2, DfaVariableValue.class);
                    if (var == null || var.getQualifier() != from) continue;
                    DfaVariableValue target = var.withQualifier(to);
                    boolean united = this.uniteClasses(var, target);
                    assert (united);
                    otherClassChanged = true;
                }
            }
        }
        this.checkInvariants();
        return otherClassChanged;
    }

    @NotNull
    private List<EqClass> splitEqClass(EqClass eqClass, DfaMemoryStateImpl other) {
        TIntObjectHashMap groupsInClasses = new TIntObjectHashMap();
        ArrayList<EqClass> groups = new ArrayList<EqClass>();
        for (DfaValue value2 : eqClass.getMemberValues()) {
            EqClass list;
            int otherClass = other.getEqClassIndex(value2);
            if (otherClass == -1) {
                list = new EqClass(this.myFactory);
                groups.add(list);
            } else {
                list = (EqClass)groupsInClasses.get(otherClass);
                if (list == null) {
                    list = new EqClass(this.myFactory);
                    groupsInClasses.put(otherClass, (Object)list);
                }
            }
            list.add(value2.getID());
        }
        groupsInClasses.forEachValue(groups::add);
        ArrayList<EqClass> arrayList = groups;
        if (arrayList == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(65);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl";
                break;
            }
            case 5: 
            case 8: 
            case 15: 
            case 17: 
            case 30: 
            case 35: 
            case 43: 
            case 46: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facts";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaValue";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: 
            case 18: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factValue";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binOp";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value1";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value2";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaRelation";
                break;
            }
            case 26: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaVar";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaLeft";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaRight";
                break;
            }
            case 37: 
            case 55: 
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 41: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createClosureState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "pop";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "peek";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEquivalentValues";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntegerSumOverflowValues";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveVariableValue";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacts";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalize";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableState";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultState";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariableState";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedVariables";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "splitEqClass";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "filterFactsOnAssignment";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateEqClassIndex";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canBeInRelation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEquivalentValues";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canBeNaN";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isEffectivelyNaN";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getEqClassIndex";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "castTopOfStack";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "dropFact";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "applyFact";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "propagateRangeBack";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "areEqual";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "applyRelationCondition";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "updateVarStateOnComparison";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "applySpecialFieldEquivalence";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "applyUnboxedRelation";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPsiType";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "applyRelation";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "applyLessThanRelation";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getValueFact";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "forceVariableFact";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getFacts";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getFactMap";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "setVariableState";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "canonicalize";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createVariableState";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "shouldMarkFlushed";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "flushVariable";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "flushDependencies";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "flushQualifiedMethods";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "doFlush";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "removeEquivalenceForVariableAndWrappers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyIdMap
    extends TIntObjectHashMap<Integer> {
        private MyIdMap() {
        }

        public String toString() {
            final StringBuilder s = new StringBuilder("{");
            this.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Integer>(){

                public boolean execute(int id, Integer index) {
                    DfaValue value2 = DfaMemoryStateImpl.this.myFactory.getValue(id);
                    s.append(value2).append(" -> ").append(index).append(", ");
                    return true;
                }
            });
            s.append("}");
            return s.toString();
        }
    }
}

