/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.instructions.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class ContractChecker {
    ContractChecker() {
    }

    static Map<PsiElement, String> checkContractClause(PsiMethod method, StandardMethodContract contract, boolean ownContract) {
        PsiCodeBlock body2 = method.getBody();
        if (body2 == null) {
            return Collections.emptyMap();
        }
        StandardDataFlowRunner runner = new StandardDataFlowRunner(false, null);
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        DfaMemoryState initialState = runner.createMemoryState();
        DfaValueFactory factory = runner.getFactory();
        for (int i = 0; i < contract.getParameterCount(); ++i) {
            StandardMethodContract.ValueConstraint constraint = contract.getParameterConstraint(i);
            DfaConstValue comparisonValue = constraint.getComparisonValue(factory);
            if (comparisonValue == null) continue;
            boolean negated = constraint.shouldUseNonEqComparison();
            DfaVariableValue dfaParam = factory.getVarFactory().createVariableValue((PsiVariable)parameters2[i]);
            initialState.applyCondition(factory.createCondition(dfaParam, DfaRelationValue.RelationType.equivalence(!negated), comparisonValue));
        }
        ContractCheckerVisitor visitor = new ContractCheckerVisitor(method, contract, ownContract);
        runner.analyzeMethod((PsiElement)body2, visitor, false, Collections.singletonList(initialState));
        return visitor.getErrors();
    }

    private static class ContractCheckerVisitor
    extends StandardInstructionVisitor {
        private final PsiMethod myMethod;
        private final StandardMethodContract myContract;
        private final boolean myOwnContract;
        private final Set<PsiElement> myViolations = new HashSet<PsiElement>();
        private final Set<PsiElement> myNonViolations = new HashSet<PsiElement>();
        private final Set<PsiElement> myFailures = new HashSet<PsiElement>();
        private boolean myMayReturnNormally = false;

        ContractCheckerVisitor(PsiMethod method, StandardMethodContract contract, boolean ownContract) {
            this.myMethod = method;
            this.myContract = contract;
            this.myOwnContract = ownContract;
        }

        @Override
        protected void checkReturnValue(@NotNull DfaValue value2, @NotNull PsiExpression expression2, @NotNull PsiParameterListOwner context, @NotNull DfaMemoryState state) {
            if (value2 == null) {
                ContractCheckerVisitor.$$$reportNull$$$0(0);
            }
            if (expression2 == null) {
                ContractCheckerVisitor.$$$reportNull$$$0(1);
            }
            if (context == null) {
                ContractCheckerVisitor.$$$reportNull$$$0(2);
            }
            if (state == null) {
                ContractCheckerVisitor.$$$reportNull$$$0(3);
            }
            if (context != this.myMethod || state.isEphemeral()) {
                return;
            }
            if (!this.myContract.getReturnValue().isValueCompatible(state, value2)) {
                this.myViolations.add((PsiElement)expression2);
            } else {
                this.myNonViolations.add((PsiElement)expression2);
            }
        }

        @Override
        public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            PsiCall call = instruction.getCallExpression();
            if (!memState.isEphemeral() && call != null) {
                if (this.myContract.getReturnValue().isFail()) {
                    this.myFailures.add((PsiElement)call);
                    return DfaInstructionState.EMPTY_ARRAY;
                }
                if (ContractCheckerVisitor.weCannotInferAnythingAboutMethodReturnValue(instruction)) {
                    DfaInstructionState[] states;
                    for (DfaInstructionState state : states = super.visitMethodCall(instruction, runner, memState)) {
                        state.getMemoryState().markEphemeral();
                    }
                    return states;
                }
            }
            return super.visitMethodCall(instruction, runner, memState);
        }

        @Override
        @NotNull
        public DfaInstructionState[] visitControlTransfer(@NotNull ControlTransferInstruction instruction, @NotNull DataFlowRunner runner, @NotNull DfaMemoryState state) {
            if (instruction == null) {
                ContractCheckerVisitor.$$$reportNull$$$0(4);
            }
            if (runner == null) {
                ContractCheckerVisitor.$$$reportNull$$$0(5);
            }
            if (state == null) {
                ContractCheckerVisitor.$$$reportNull$$$0(6);
            }
            if (instruction instanceof ReturnInstruction && ((ReturnInstruction)instruction).isViaException()) {
                ContainerUtil.addIfNotNull(this.myFailures, (Object)((ReturnInstruction)instruction).getAnchor());
            } else {
                this.myMayReturnNormally = true;
            }
            DfaInstructionState[] dfaInstructionStateArray = super.visitControlTransfer(instruction, runner, state);
            if (dfaInstructionStateArray == null) {
                ContractCheckerVisitor.$$$reportNull$$$0(7);
            }
            return dfaInstructionStateArray;
        }

        private Map<PsiElement, String> getErrors() {
            HashMap<PsiElement, String> errors = new HashMap<PsiElement, String>();
            for (PsiElement element : this.myViolations) {
                if (this.myNonViolations.contains(element)) continue;
                errors.put(element, "Contract clause '" + this.myContract + "' is violated");
            }
            if (!this.myContract.getReturnValue().isFail()) {
                if (!(!this.myOwnContract || this.myMayReturnNormally || PsiUtil.canBeOverridden((PsiMethod)this.myMethod) && ControlFlowUtils.methodAlwaysThrowsException(this.myMethod))) {
                    for (PsiElement element : this.myFailures) {
                        errors.put(element, "Return value of clause '" + this.myContract + "' could be replaced with 'fail' as method always fails" + (this.myContract.isTrivial() ? "" : " in this case"));
                    }
                }
            } else if (this.myFailures.isEmpty() && errors.isEmpty()) {
                PsiIdentifier nameIdentifier = this.myMethod.getNameIdentifier();
                errors.put((PsiElement)(nameIdentifier != null ? nameIdentifier : this.myMethod), "Contract clause '" + this.myContract + "' is violated: no exception is thrown");
            }
            return errors;
        }

        private static boolean weCannotInferAnythingAboutMethodReturnValue(MethodCallInstruction instruction) {
            PsiMethod target = instruction.getTargetMethod();
            return instruction.getContracts().isEmpty() && target != null && !target.isConstructor() && !NullableNotNullManager.isNotNull((PsiModifierListOwner)target);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instruction";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runner";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/ContractChecker$ContractCheckerVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/ContractChecker$ContractCheckerVisitor";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visitControlTransfer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "checkReturnValue";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitControlTransfer";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

