/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.EndOfInitializerInstruction;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonDataflow {
    @Contract(value="null -> null")
    @Nullable
    private static DataflowResult runDFA(@Nullable PsiElement block) {
        if (block == null) {
            return null;
        }
        DataFlowRunner runner = new DataFlowRunner(false, block);
        CommonDataflowVisitor visitor = new CommonDataflowVisitor();
        RunnerResult result = runner.analyzeMethodRecursively(block, visitor, false);
        if (result != RunnerResult.OK) {
            return new DataflowResult(result);
        }
        if (!(block instanceof PsiClass)) {
            return visitor.myResult;
        }
        DataflowResult dfr = visitor.myResult.copy();
        List states = visitor.myEndOfInitializerStates;
        for (PsiMethod method : ((PsiClass)block).getConstructors()) {
            PsiCodeBlock body2 = method.getBody();
            if (body2 == null) continue;
            PsiMethodCallExpression call = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)method);
            List initialStates = JavaPsiConstructorUtil.isChainedConstructorCall((PsiElement)call) || call == null && DfaUtil.hasImplicitImpureSuperCall((PsiClass)block, method) ? Collections.singletonList(runner.createMemoryState()) : StreamEx.of((Collection)states).map(DfaMemoryState::createCopy).toList();
            if (runner.analyzeBlockRecursively((PsiElement)body2, initialStates, visitor, false) == RunnerResult.OK) {
                dfr = visitor.myResult.copy();
                continue;
            }
            visitor.myResult = dfr;
        }
        return dfr;
    }

    @Nullable
    public static DataflowResult getDataflowResult(PsiExpression context) {
        PsiElement body2 = DfaUtil.getDataflowContext(context);
        if (body2 == null) {
            return null;
        }
        return (DataflowResult)CachedValuesManager.getCachedValue((PsiElement)body2, () -> {
            DataflowResult result = CommonDataflow.runDFA(body2);
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    public static <T> T getExpressionFact(PsiExpression expression2, DfaFactType<T> type2) {
        DataflowResult result = CommonDataflow.getDataflowResult(expression2);
        if (result == null) {
            return null;
        }
        return result.getExpressionFact(PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2), type2);
    }

    @Contract(value="null -> null")
    @Nullable
    public static LongRangeSet getExpressionRange(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return null;
        }
        Object value2 = ExpressionUtils.computeConstantExpression(expression2);
        LongRangeSet rangeSet = LongRangeSet.fromConstant(value2);
        if (rangeSet != null) {
            return rangeSet;
        }
        return CommonDataflow.getExpressionFact(expression2, DfaFactType.RANGE);
    }

    private static class CommonDataflowVisitor
    extends StandardInstructionVisitor {
        private DataflowResult myResult = new DataflowResult(RunnerResult.OK);
        private final List<DfaMemoryState> myEndOfInitializerStates = new ArrayList<DfaMemoryState>();

        private CommonDataflowVisitor() {
        }

        @Override
        public DfaInstructionState[] visitEndOfInitializer(EndOfInitializerInstruction instruction, DataFlowRunner runner, DfaMemoryState state) {
            if (!instruction.isStatic()) {
                this.myEndOfInitializerStates.add(state.createCopy());
            }
            return super.visitEndOfInitializer(instruction, runner, state);
        }

        @Override
        protected void beforeExpressionPush(@NotNull DfaValue value2, @NotNull PsiExpression expression2, @Nullable TextRange range, @NotNull DfaMemoryState state) {
            if (value2 == null) {
                CommonDataflowVisitor.$$$reportNull$$$0(0);
            }
            if (expression2 == null) {
                CommonDataflowVisitor.$$$reportNull$$$0(1);
            }
            if (state == null) {
                CommonDataflowVisitor.$$$reportNull$$$0(2);
            }
            if (range == null) {
                this.myResult.add(expression2, (DfaMemoryStateImpl)state, value2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "state";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/CommonDataflow$CommonDataflowVisitor";
            objectArray[2] = "beforeExpressionPush";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DataflowResult {
        private final Map<PsiExpression, DataflowPoint> myData = new HashMap<PsiExpression, DataflowPoint>();
        private final RunnerResult myResult;

        public DataflowResult(RunnerResult result) {
            this.myResult = result;
        }

        DataflowResult copy() {
            DataflowResult copy = new DataflowResult(this.myResult);
            this.myData.forEach((expression2, point) -> copy.myData.put((PsiExpression)expression2, new DataflowPoint((DataflowPoint)point)));
            return copy;
        }

        void add(PsiExpression expression2, DfaMemoryStateImpl memState, DfaValue value2) {
            PsiElement parent;
            DataflowPoint point = this.myData.computeIfAbsent(expression2, e -> new DataflowPoint());
            if (DfaConstValue.isContractFail(value2)) {
                point.myMayFailByContract = true;
                return;
            }
            if (point.myFacts != DfaFactMap.EMPTY && (parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent())) instanceof PsiConditionalExpression && !PsiTreeUtil.isAncestor((PsiElement)((PsiConditionalExpression)parent).getCondition(), (PsiElement)expression2, (boolean)false)) {
                this.add((PsiExpression)parent, memState, value2);
            }
            point.addFacts(memState, value2);
            point.addValue(memState, value2);
            point.addNotValues(memState, value2);
        }

        @NotNull
        private static DfaFactMap getFactMap(DfaMemoryStateImpl memState, DfaValue value2) {
            DfaFactMap newMap = memState.getFactMap(value2);
            DfaNullability nullability = newMap.get(DfaFactType.NULLABILITY);
            if (nullability != DfaNullability.NOT_NULL && memState.isNotNull(value2)) {
                newMap = newMap.with(DfaFactType.NULLABILITY, DfaNullability.NOT_NULL);
            }
            DfaFactMap dfaFactMap = newMap;
            if (dfaFactMap == null) {
                DataflowResult.$$$reportNull$$$0(0);
            }
            return dfaFactMap;
        }

        public boolean expressionWasAnalyzed(PsiExpression expression2) {
            if (expression2 instanceof PsiParenthesizedExpression) {
                throw new IllegalArgumentException("Should not pass parenthesized expression");
            }
            return this.myData.containsKey(expression2);
        }

        public boolean cannotFailByContract(PsiCallExpression call) {
            DataflowPoint point = this.myData.get(call);
            return point != null && !point.myMayFailByContract;
        }

        @Nullable
        public <T> T getExpressionFact(PsiExpression expression2, DfaFactType<T> type2) {
            DataflowPoint point = this.myData.get(expression2);
            return point == null || point.myFacts == null ? null : (T)point.myFacts.get(type2);
        }

        @NotNull
        public Set<Object> getExpressionValues(@Nullable PsiExpression expression2) {
            DataflowPoint point = this.myData.get(expression2);
            if (point == null) {
                Set<Object> set = Collections.emptySet();
                if (set == null) {
                    DataflowResult.$$$reportNull$$$0(1);
                }
                return set;
            }
            Set<Object> values = point.myPossibleValues;
            Set<Object> set = values == null ? Collections.emptySet() : Collections.unmodifiableSet(values);
            if (set == null) {
                DataflowResult.$$$reportNull$$$0(2);
            }
            return set;
        }

        @NotNull
        public Set<Object> getValuesNotEqualToExpression(@Nullable PsiExpression expression2) {
            DataflowPoint point = this.myData.get(expression2);
            if (point == null) {
                Set<Object> set = Collections.emptySet();
                if (set == null) {
                    DataflowResult.$$$reportNull$$$0(3);
                }
                return set;
            }
            Set<Object> values = point.myNotValues;
            Set<Object> set = values == null ? Collections.emptySet() : Collections.unmodifiableSet(values);
            if (set == null) {
                DataflowResult.$$$reportNull$$$0(4);
            }
            return set;
        }

        @Nullable
        public DfaFactMap getAllFacts(PsiExpression expression2) {
            DataflowPoint point = this.myData.get(expression2);
            return point == null ? null : point.myFacts;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/dataFlow/CommonDataflow$DataflowResult";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFactMap";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpressionValues";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValuesNotEqualToExpression";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class DataflowPoint {
        @Nullable
        DfaFactMap myFacts = null;
        @Nullable
        Set<Object> myPossibleValues = Collections.emptySet();
        @Nullable
        Set<Object> myNotValues = null;
        boolean myMayFailByContract = false;

        DataflowPoint() {
        }

        DataflowPoint(DataflowPoint other) {
            this.myFacts = other.myFacts;
            this.myPossibleValues = other.myPossibleValues;
            this.myNotValues = other.myNotValues == null || other.myNotValues.isEmpty() ? other.myNotValues : new HashSet<Object>(other.myNotValues);
            this.myMayFailByContract = other.myMayFailByContract;
        }

        void addNotValues(DfaMemoryStateImpl memState, DfaValue value2) {
            if (value2 instanceof DfaVariableValue && !TypeConversionUtil.isIntegralNumberType((PsiType)value2.getType())) {
                Set<Object> notValues = this.myNotValues;
                if (notValues == null) {
                    Set<Object> constants = memState.getNonEqualConstants((DfaVariableValue)value2);
                    this.myNotValues = constants.isEmpty() ? Collections.emptySet() : constants;
                } else if (!notValues.isEmpty()) {
                    notValues.retainAll(memState.getNonEqualConstants((DfaVariableValue)value2));
                    if (notValues.isEmpty()) {
                        this.myNotValues = Collections.emptySet();
                    }
                }
            }
        }

        void addValue(DfaMemoryStateImpl memState, DfaValue value2) {
            if (this.myPossibleValues == null) {
                return;
            }
            DfaConstValue constantValue = memState.getConstantValue(value2);
            if (constantValue == null) {
                this.myPossibleValues = null;
                return;
            }
            Object newValue = constantValue.getValue();
            if (this.myPossibleValues.contains(newValue)) {
                return;
            }
            this.myNotValues = null;
            if (this.myPossibleValues.isEmpty()) {
                this.myPossibleValues = Collections.singleton(newValue);
            } else {
                this.myPossibleValues = new HashSet<Object>(this.myPossibleValues);
                this.myPossibleValues.add(newValue);
            }
        }

        void addFacts(DfaMemoryStateImpl memState, DfaValue value2) {
            SpecialField field;
            if (this.myFacts == DfaFactMap.EMPTY) {
                return;
            }
            DfaFactMap newMap = DataflowResult.getFactMap(memState, value2);
            if (value2 instanceof DfaVariableValue && (field = SpecialField.fromQualifierType(value2.getType())) != null) {
                DfaValue specialField = field.createValue(value2.getFactory(), value2);
                if (specialField instanceof DfaVariableValue) {
                    DfaConstValue constantValue = memState.getConstantValue(specialField);
                    DfaValue dfaValue = specialField = constantValue != null ? constantValue : specialField.getFactory().getFactFactory().createValue(DataflowResult.getFactMap(memState, specialField));
                }
                if (specialField instanceof DfaConstValue || specialField instanceof DfaFactMapValue) {
                    newMap = newMap.with(DfaFactType.SPECIAL_FIELD_VALUE, field.withValue(specialField));
                }
            }
            this.myFacts = this.myFacts == null ? newMap : this.myFacts.unite(newMap);
        }
    }
}

