/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisConverter;
import com.intellij.codeInspection.bytecodeAnalysis.Member;
import com.intellij.codeInspection.bytecodeAnalysis.MemberDescriptor;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;

public final class HMember
implements MemberDescriptor {
    private static final int CLASS_HASH_SIZE = 10;
    private static final int SIGNATURE_HASH_SIZE = 4;
    static final int HASH_SIZE = 14;
    final long myClassHi;
    final short myClassLo;
    final int myMethod;

    HMember(Member method, MessageDigest md) {
        if (md == null) {
            md = BytecodeAnalysisConverter.getMessageDigest();
        }
        byte[] classDigest = md.digest(method.internalClassName.getBytes(StandardCharsets.UTF_8));
        ByteBuffer classBuffer = ByteBuffer.wrap(classDigest);
        this.myClassHi = classBuffer.getLong();
        this.myClassLo = classBuffer.getShort();
        md.update(method.methodName.getBytes(StandardCharsets.UTF_8));
        md.update(method.methodDesc.getBytes(StandardCharsets.UTF_8));
        byte[] sigDigest = md.digest();
        this.myMethod = ByteBuffer.wrap(sigDigest).getInt();
    }

    public HMember(@NotNull byte[] bytes) {
        if (bytes == null) {
            HMember.$$$reportNull$$$0(0);
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        this.myClassHi = buffer.getLong();
        this.myClassLo = buffer.getShort();
        this.myMethod = buffer.getInt();
    }

    @NotNull
    byte[] asBytes() {
        ByteBuffer bytes = ByteBuffer.allocate(14);
        bytes.putLong(this.myClassHi).putShort(this.myClassLo).putInt(this.myMethod);
        byte[] byArray = bytes.array();
        if (byArray == null) {
            HMember.$$$reportNull$$$0(1);
        }
        return byArray;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HMember that = (HMember)o;
        return that.myClassHi == this.myClassHi && that.myClassLo == this.myClassLo && that.myMethod == this.myMethod;
    }

    public int hashCode() {
        int i;
        int result = 1;
        for (i = 7; i >= 0; --i) {
            result = result * 31 + (byte)(this.myClassHi >>> i * 8 & 0xFFL);
        }
        for (i = 1; i >= 0; --i) {
            result = result * 31 + (byte)(this.myClassLo >>> i * 8 & 0xFF);
        }
        for (i = 3; i >= 0; --i) {
            result = result * 31 + (byte)(this.myMethod >>> i * 8 & 0xFF);
        }
        return result;
    }

    @Override
    @NotNull
    public HMember hashed(MessageDigest md) {
        HMember hMember = this;
        if (hMember == null) {
            HMember.$$$reportNull$$$0(2);
        }
        return hMember;
    }

    public String toString() {
        return HMember.bytesToString(this.asBytes());
    }

    static String bytesToString(byte[] key2) {
        return IntStreamEx.of((byte[])key2).mapToObj(b -> String.format("%02x", b & 0xFF)).joining((CharSequence)".");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/bytecodeAnalysis/HMember";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/bytecodeAnalysis/HMember";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "asBytes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "hashed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

