/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bulkOperation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;

public class BulkMethodInfo {
    private final String myClassName;
    private final String mySimpleName;
    private final String myBulkName;

    public BulkMethodInfo(String className2, String simpleName, String bulkName) {
        this.myClassName = className2;
        this.mySimpleName = simpleName;
        this.myBulkName = bulkName;
    }

    public boolean isMyMethod(PsiReferenceExpression ref) {
        if (!this.mySimpleName.equals(ref.getReferenceName())) {
            return false;
        }
        PsiElement element = ref.resolve();
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)element;
        PsiParameterList parameters2 = method.getParameterList();
        if (parameters2.getParametersCount() != 1) {
            return false;
        }
        PsiParameter parameter2 = parameters2.getParameters()[0];
        PsiClass parameterClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)parameter2.getType());
        if (parameterClass == null || "java.lang.Iterable".equals(parameterClass.getQualifiedName()) || "java.util.Collection".equals(parameterClass.getQualifiedName())) {
            return false;
        }
        PsiClass methodClass = method.getContainingClass();
        return methodClass != null && InheritanceUtil.isInheritor((PsiClass)methodClass, (String)this.myClassName);
    }

    public boolean isSupportedIterable(PsiExpression qualifier, PsiExpression iterable, boolean useArraysAsList) {
        PsiClass aClass;
        PsiType qualifierType = qualifier.getType();
        if (!(qualifierType instanceof PsiClassType)) {
            return false;
        }
        PsiType type2 = iterable.getType();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)iterable.getProject());
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)iterable.getProject());
        String text2 = iterable.getText();
        if (type2 instanceof PsiArrayType) {
            PsiType componentType = ((PsiArrayType)type2).getComponentType();
            if (!useArraysAsList || componentType instanceof PsiPrimitiveType) {
                return false;
            }
            PsiClass listClass = psiFacade.findClass("java.util.List", iterable.getResolveScope());
            if (listClass == null) {
                return false;
            }
            if (!listClass.hasTypeParameters()) {
                type2 = factory.createType(listClass);
            } else if (listClass.getTypeParameters().length == 1) {
                type2 = factory.createType(listClass, componentType);
            } else {
                return false;
            }
            text2 = "java.util.Arrays.asList(" + text2 + ")";
        }
        if ((aClass = PsiUtil.resolveClassInType((PsiType)type2)) == null) {
            return false;
        }
        PsiClass commonParent = psiFacade.findClass("java.lang.Iterable", aClass.getResolveScope());
        if (commonParent == null) {
            commonParent = psiFacade.findClass("java.util.Collection", aClass.getResolveScope());
        }
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)commonParent, (boolean)true)) {
            return false;
        }
        PsiExpression expression2 = factory.createExpressionFromText(qualifier.getText() + "." + this.myBulkName + "(" + text2 + ")", (PsiElement)iterable);
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
        PsiMethod bulkMethod = call.resolveMethod();
        if (bulkMethod == null) {
            return false;
        }
        PsiParameterList parameters2 = bulkMethod.getParameterList();
        if (parameters2.getParametersCount() != 1) {
            return false;
        }
        PsiType parameterType = parameters2.getParameters()[0].getType();
        parameterType = call.resolveMethodGenerics().getSubstitutor().substitute(parameterType);
        PsiClass parameterClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)parameterType);
        return parameterClass != null && ("java.lang.Iterable".equals(parameterClass.getQualifiedName()) || "java.util.Collection".equals(parameterClass.getQualifiedName())) && parameterType.isAssignableFrom(type2);
    }

    public String getClassName() {
        return this.myClassName;
    }

    public String getSimpleName() {
        return this.mySimpleName;
    }

    public String getBulkName() {
        return this.myBulkName;
    }

    public String getReplacementName() {
        return StringUtil.getShortName((String)this.myClassName) + "." + this.myBulkName;
    }

    public String toString() {
        return this.myClassName + "::" + this.mySimpleName + " => " + this.myBulkName;
    }
}

