/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.AnnotatedApiUsageProcessor;
import com.intellij.codeInspection.AnnotatedElementInspectionBase;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.deprecation.DeprecationInspectionBase;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;

public class UnstableApiUsageInspection
extends AnnotatedElementInspectionBase {
    public final List<String> unstableApiAnnotations = new ExternalizableStringSet("org.jetbrains.annotations.ApiStatus.Experimental", "org.jetbrains.annotations.ApiStatus.Internal", "com.google.common.annotations.Beta", "io.reactivex.annotations.Beta", "io.reactivex.annotations.Experimental", "rx.annotations.Experimental", "rx.annotations.Beta", "org.apache.http.annotation.Beta", "org.gradle.api.Incubating");

    @Override
    @NotNull
    protected List<String> getAnnotations() {
        List<String> list = this.unstableApiAnnotations;
        if (list == null) {
            UnstableApiUsageInspection.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    protected AnnotatedApiUsageProcessor buildAnnotatedApiUsageProcessor(final @NotNull ProblemsHolder holder) {
        if (holder == null) {
            UnstableApiUsageInspection.$$$reportNull$$$0(1);
        }
        AnnotatedApiUsageProcessor annotatedApiUsageProcessor = new AnnotatedApiUsageProcessor(){

            @Override
            public void processAnnotatedTarget(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner annotatedTarget, @NotNull List<? extends PsiAnnotation> annotations2) {
                if (sourceNode == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (annotatedTarget == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (annotations2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!AnnotatedElementInspectionBase.isLibraryElement((PsiElement)annotatedTarget)) {
                    return;
                }
                String message2 = JvmAnalysisBundle.message("jvm.inspections.unstable.api.usage.description", DeprecationInspectionBase.getPresentableName((PsiElement)annotatedTarget));
                PsiElement elementToHighlight = sourceNode.getSourcePsi();
                if (elementToHighlight != null) {
                    holder.registerProblem(elementToHighlight, message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sourceNode";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "annotatedTarget";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "annotations";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/UnstableApiUsageInspection$1";
                objectArray[2] = "processAnnotatedTarget";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (annotatedApiUsageProcessor == null) {
            UnstableApiUsageInspection.$$$reportNull$$$0(2);
        }
        return annotatedApiUsageProcessor;
    }

    @Override
    @NotNull
    public JPanel createOptionsPanel() {
        JPanel checkboxPanel = super.createOptionsPanel();
        JPanel annotationsListControl = SpecialAnnotationsUtil.createSpecialAnnotationsListControl(this.unstableApiAnnotations, JvmAnalysisBundle.message("jvm.inspections.unstable.api.usage.annotations.list", new Object[0]));
        JPanel panel = new JPanel(new BorderLayout(2, 2));
        panel.add((Component)checkboxPanel, "North");
        panel.add((Component)annotationsListControl, "Center");
        JPanel jPanel = panel;
        if (jPanel == null) {
            UnstableApiUsageInspection.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/UnstableApiUsageInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/UnstableApiUsageInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAnnotatedApiUsageProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildAnnotatedApiUsageProcessor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

