/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.SpecialFieldValue;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.codeInspection.util.OptionalRefactoringUtil;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallHandler;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifyOptionalCallChainsInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher OPTIONAL_OR_ELSE = CallMatcher.instanceCall("java.util.Optional", "orElse").parameterCount(1);
    private static final CallMatcher OPTIONAL_GET = CallMatcher.instanceCall("java.util.Optional", "get").parameterCount(0);
    private static final CallMatcher OPTIONAL_OR_ELSE_GET = CallMatcher.instanceCall("java.util.Optional", "orElseGet").parameterCount(1);
    private static final CallMatcher OPTIONAL_OR_ELSE_OR_ELSE_GET = CallMatcher.anyOf(OPTIONAL_OR_ELSE, OPTIONAL_OR_ELSE_GET);
    private static final CallMatcher OPTIONAL_MAP = CallMatcher.instanceCall("java.util.Optional", "map").parameterCount(1);
    private static final CallMatcher OPTIONAL_OF_NULLABLE = CallMatcher.staticCall("java.util.Optional", "ofNullable").parameterCount(1);
    private static final CallMatcher OPTIONAL_OF_OF_NULLABLE = CallMatcher.staticCall("java.util.Optional", "ofNullable", "of").parameterCount(1);
    private static final CallMatcher OPTIONAL_IS_PRESENT = CallMatcher.anyOf(CallMatcher.exactInstanceCall("java.util.Optional", "isPresent").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalInt", "isPresent").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalLong", "isPresent").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalDouble", "isPresent").parameterCount(0));
    private static final CallMatcher OPTIONAL_IF_PRESENT = CallMatcher.anyOf(CallMatcher.exactInstanceCall("java.util.Optional", "ifPresent").parameterCount(1), CallMatcher.exactInstanceCall("java.util.OptionalInt", "ifPresent").parameterCount(1), CallMatcher.exactInstanceCall("java.util.OptionalLong", "ifPresent").parameterCount(1), CallMatcher.exactInstanceCall("java.util.OptionalDouble", "ifPresent").parameterCount(1));
    private static final CallMatcher OPTIONAL_IS_EMPTY = CallMatcher.anyOf(CallMatcher.exactInstanceCall("java.util.Optional", "isEmpty").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalInt", "isEmpty").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalLong", "isEmpty").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalDouble", "isEmpty").parameterCount(0));
    private static final CallMapper<OptionalSimplificationFix> ourMapper;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        LanguageLevel level;
        if (holder == null) {
            SimplifyOptionalCallChainsInspection.$$$reportNull$$$0(0);
        }
        if ((level = PsiUtil.getLanguageLevel((PsiElement)holder.getFile())).isLessThan(LanguageLevel.JDK_1_8)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SimplifyOptionalCallChainsInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        OptionalChainVisitor optionalChainVisitor = new OptionalChainVisitor(level){

            @Override
            protected void handleSimplification(@NotNull PsiMethodCallExpression call, @NotNull OptionalSimplificationFix fix2) {
                PsiElement element;
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (fix2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                holder.registerProblem((PsiElement)((element = call.getMethodExpression().getReferenceNameElement()) != null ? element : call), fix2.getDescription(), new LocalQuickFix[]{fix2});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "call";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fix";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$1";
                objectArray[2] = "handleSimplification";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (optionalChainVisitor == null) {
            SimplifyOptionalCallChainsInspection.$$$reportNull$$$0(2);
        }
        return optionalChainVisitor;
    }

    @Nullable
    private static <T> OptionalSimplificationFix getFix(PsiMethodCallExpression call, ChainSimplificationCase<T> inspection) {
        T context = inspection.extractContext(call.getProject(), call);
        if (context == null) {
            return null;
        }
        String name2 = inspection.getName(context);
        String description = inspection.getDescription(context);
        return new OptionalSimplificationFix(inspection, name2, description);
    }

    private static <T> void handleSimplification(ChainSimplificationCase<T> inspection, Project project, PsiMethodCallExpression call) {
        if (!inspection.getMatcher().matches((PsiExpression)call)) {
            return;
        }
        T context = inspection.extractContext(project, call);
        if (context != null) {
            inspection.apply(project, call, context);
        }
    }

    @Nullable
    private static PsiLambdaExpression getLambda(PsiExpression initializer) {
        PsiMethodReferenceExpression methodRef;
        PsiLambdaExpression lambda2;
        PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)initializer);
        if (expression2 instanceof PsiLambdaExpression) {
            return (PsiLambdaExpression)expression2;
        }
        if (expression2 instanceof PsiMethodReferenceExpression && (lambda2 = LambdaRefactoringUtil.createLambda(methodRef = (PsiMethodReferenceExpression)expression2, true)) != null) {
            LambdaRefactoringUtil.specifyLambdaParameterTypes(methodRef.getFunctionalInterfaceType(), lambda2);
            return lambda2;
        }
        return null;
    }

    private static PsiExpression getOrElseArgument(PsiMethodCallExpression call, OrElseType type2) {
        if (type2 == OrElseType.OrElse) {
            return call.getArgumentList().getExpressions()[0];
        }
        if (type2 == OrElseType.OrElseGet) {
            PsiLambdaExpression lambda2 = SimplifyOptionalCallChainsInspection.getLambda(call.getArgumentList().getExpressions()[0]);
            if (lambda2 == null || !lambda2.getParameterList().isEmpty()) {
                return null;
            }
            return LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
        }
        return null;
    }

    private static CallMatcher getMatcherByType(OrElseType type2) {
        if (type2 == OrElseType.OrElse) {
            return OPTIONAL_OR_ELSE;
        }
        if (type2 == OrElseType.OrElseGet) {
            return OPTIONAL_OR_ELSE_GET;
        }
        throw new IllegalStateException();
    }

    @Nullable
    private static PsiExpression extractConditionalDefaultValue(@NotNull PsiStatement statement, @NotNull PsiVariable optValue) {
        if (statement == null) {
            SimplifyOptionalCallChainsInspection.$$$reportNull$$$0(3);
        }
        if (optValue == null) {
            SimplifyOptionalCallChainsInspection.$$$reportNull$$$0(4);
        }
        if (statement instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                return null;
            }
            PsiExpression thenExpr = SimplifyOptionalCallChainsInspection.getReturnExpression(ifStatement.getThenBranch());
            PsiExpression elseExpr = SimplifyOptionalCallChainsInspection.getReturnExpression(ifStatement.getElseBranch());
            if (thenExpr == null || elseExpr == null) {
                return null;
            }
            return SimplifyOptionalCallChainsInspection.extractConditionalDefaultValue(thenExpr, elseExpr, condition2, optValue);
        }
        if (statement instanceof PsiReturnStatement) {
            PsiExpression returnValue = ((PsiReturnStatement)statement).getReturnValue();
            PsiConditionalExpression ternary = (PsiConditionalExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)returnValue), PsiConditionalExpression.class);
            if (ternary == null) {
                return null;
            }
            PsiExpression thenExpression2 = ternary.getThenExpression();
            PsiExpression elseExpression2 = ternary.getElseExpression();
            if (thenExpression2 == null || elseExpression2 == null) {
                return null;
            }
            return SimplifyOptionalCallChainsInspection.extractConditionalDefaultValue(thenExpression2, elseExpression2, ternary.getCondition(), optValue);
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    private static PsiExpression getReturnExpression(@Nullable PsiStatement block) {
        if (block == null) {
            return null;
        }
        PsiStatement statement = ControlFlowUtils.stripBraces(block);
        PsiReturnStatement returnStatement = (PsiReturnStatement)ObjectUtils.tryCast((Object)statement, PsiReturnStatement.class);
        if (returnStatement == null) {
            return null;
        }
        return returnStatement.getReturnValue();
    }

    @Nullable
    private static PsiExpression extractConditionalDefaultValue(@NotNull PsiExpression thenExpr, @NotNull PsiExpression elseExpr, @NotNull PsiExpression condition2, @NotNull PsiVariable optValue) {
        PsiExpression defaultExpression;
        if (thenExpr == null) {
            SimplifyOptionalCallChainsInspection.$$$reportNull$$$0(5);
        }
        if (elseExpr == null) {
            SimplifyOptionalCallChainsInspection.$$$reportNull$$$0(6);
        }
        if (condition2 == null) {
            SimplifyOptionalCallChainsInspection.$$$reportNull$$$0(7);
        }
        if (optValue == null) {
            SimplifyOptionalCallChainsInspection.$$$reportNull$$$0(8);
        }
        PsiVariable nullChecked = ExpressionUtils.getVariableFromNullComparison(condition2, true);
        boolean inverted = false;
        if (nullChecked == null) {
            nullChecked = ExpressionUtils.getVariableFromNullComparison(condition2, false);
            if (nullChecked == null) {
                return null;
            }
            inverted = true;
        }
        if (!nullChecked.equals(optValue) || !ExpressionUtils.isReferenceTo(inverted ? thenExpr : elseExpr, optValue)) {
            return null;
        }
        PsiExpression psiExpression = defaultExpression = inverted ? elseExpr : thenExpr;
        if (VariableAccessUtils.variableIsUsed(optValue, (PsiElement)defaultExpression)) {
            return null;
        }
        return defaultExpression;
    }

    static {
        List<ChainSimplificationCase> cases = Arrays.asList(new IfPresentFoldedCase(), new MapUnwrappingCase(), new OrElseNonNullCase(OrElseType.OrElse), new OrElseNonNullCase(OrElseType.OrElseGet), new FlipPresentOrEmptyCase(true), new FlipPresentOrEmptyCase(false), new OrElseReturnCase(OrElseType.OrElse), new OrElseReturnCase(OrElseType.OrElseGet), new RewrappingCase(RewrappingCase.Type.OptionalGet), new RewrappingCase(RewrappingCase.Type.OrElseNull), new MapOrElseCase(OrElseType.OrElseGet), new MapOrElseCase(OrElseType.OrElse));
        ourMapper = new CallMapper();
        for (ChainSimplificationCase theCase : cases) {
            CallHandler<OptionalSimplificationFix> handler = CallHandler.of(theCase.getMatcher(), theCase);
            ourMapper.register(handler);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenExpr";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elseExpr";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "extractConditionalDefaultValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IfPresentFoldedCase
    implements ChainSimplificationCase<Context> {
        private IfPresentFoldedCase() {
        }

        @Override
        @NotNull
        public String getName(@NotNull Context context) {
            if (context == null) {
                IfPresentFoldedCase.$$$reportNull$$$0(0);
            }
            String string = CommonQuickFixBundle.message((String)"fix.eliminate.folded.if.present.name", (Object[])new Object[0]);
            if (string == null) {
                IfPresentFoldedCase.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDescription(@NotNull Context context) {
            if (context == null) {
                IfPresentFoldedCase.$$$reportNull$$$0(2);
            }
            String string = CommonQuickFixBundle.message((String)"fix.eliminate.folded.if.present.description", (Object[])new Object[0]);
            if (string == null) {
                IfPresentFoldedCase.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        public Context extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            if (project == null) {
                IfPresentFoldedCase.$$$reportNull$$$0(4);
            }
            if (call == null) {
                IfPresentFoldedCase.$$$reportNull$$$0(5);
            }
            PsiExpression outerIfPresentQualifier = call.getMethodExpression().getQualifierExpression();
            PsiMethodCallExpression qualifierCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)outerIfPresentQualifier, PsiMethodCallExpression.class);
            PsiLambdaExpression outerIfPresentArgument = (PsiLambdaExpression)ObjectUtils.tryCast((Object)call.getArgumentList().getExpressions()[0], PsiLambdaExpression.class);
            if (outerIfPresentArgument == null) {
                return null;
            }
            if (outerIfPresentArgument.getParameterList().getParametersCount() != 1) {
                return null;
            }
            PsiParameter parameter2 = outerIfPresentArgument.getParameterList().getParameters()[0];
            if (parameter2 == null) {
                return null;
            }
            String outerIfPresentParameterName = parameter2.getName();
            if (outerIfPresentParameterName == null) {
                return null;
            }
            PsiExpression outerIfPresentBodyExpr = LambdaUtil.extractSingleExpressionFromBody((PsiElement)outerIfPresentArgument.getBody());
            PsiMethodCallExpression outerIfPresentBody = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)outerIfPresentBodyExpr, PsiMethodCallExpression.class);
            if (!OPTIONAL_IF_PRESENT.test(outerIfPresentBody)) {
                return null;
            }
            PsiExpression innerIfPresentQualifier = outerIfPresentBody.getMethodExpression().getQualifierExpression();
            PsiExpression nonTrivialQualifier = ExpressionUtils.isReferenceTo(innerIfPresentQualifier, (PsiVariable)parameter2) ? null : innerIfPresentQualifier;
            PsiExpression innerIfPresentArgument = outerIfPresentBody.getArgumentList().getExpressions()[0];
            PsiMethodCallExpression mapBefore = null;
            if (OPTIONAL_MAP.test(qualifierCall) && IfPresentFoldedCase.isOptionalTypeParameter(qualifierCall.getType())) {
                mapBefore = qualifierCall;
            }
            return new Context(mapBefore, nonTrivialQualifier, outerIfPresentParameterName, innerIfPresentArgument);
        }

        private static boolean isOptionalTypeParameter(@Nullable PsiType type2) {
            PsiClassType classType = (PsiClassType)ObjectUtils.tryCast((Object)type2, PsiClassType.class);
            if (classType == null) {
                return false;
            }
            if (classType.getParameterCount() != 1) {
                return false;
            }
            PsiType typeParameter = classType.getParameters()[0];
            PsiClass parameterClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)typeParameter);
            if (parameterClass == null) {
                return false;
            }
            return "java.util.Optional".equals(parameterClass.getQualifiedName());
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull Context context) {
            PsiExpression lambdaBodyAfter;
            if (project == null) {
                IfPresentFoldedCase.$$$reportNull$$$0(6);
            }
            if (call == null) {
                IfPresentFoldedCase.$$$reportNull$$$0(7);
            }
            if (context == null) {
                IfPresentFoldedCase.$$$reportNull$$$0(8);
            }
            PsiMethodCallExpression mapBefore = context.myMapBefore;
            CommentTracker ct = new CommentTracker();
            StringBuilder sb = new StringBuilder();
            PsiExpression qualifer = call.getMethodExpression().getQualifierExpression();
            assert (qualifer != null);
            sb.append(ct.text((PsiElement)qualifer)).append(".");
            if (mapBefore != null) {
                PsiExpression mapArgument = mapBefore.getArgumentList().getExpressions()[0];
                sb.append("flatMap(").append(ct.text((PsiElement)mapArgument)).append(").");
            }
            if ((lambdaBodyAfter = context.myMapLambdaBodyAfter) != null) {
                sb.append("flatMap(").append(context.myOuterIfPresentVarName).append("->").append(ct.text((PsiElement)lambdaBodyAfter)).append(").");
            }
            sb.append("ifPresent(").append(ct.text((PsiElement)context.myInnerIfPresentArgument)).append(")");
            PsiElement result = ct.replaceAndRestoreComments((PsiElement)call, sb.toString());
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            CallMatcher callMatcher = OPTIONAL_IF_PRESENT;
            if (callMatcher == null) {
                IfPresentFoldedCase.$$$reportNull$$$0(9);
            }
            return callMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$IfPresentFoldedCase";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$IfPresentFoldedCase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "extractContext";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        static class Context {
            @Nullable
            PsiMethodCallExpression myMapBefore;
            @Nullable
            PsiExpression myMapLambdaBodyAfter;
            @NotNull
            String myOuterIfPresentVarName;
            @NotNull
            PsiExpression myInnerIfPresentArgument;

            Context(@Nullable PsiMethodCallExpression mapBefore, @Nullable PsiExpression mapLambdaBodyAfter, @NotNull String outerIfPresentVarName, @NotNull PsiExpression innerIfPresentArgument) {
                if (outerIfPresentVarName == null) {
                    Context.$$$reportNull$$$0(0);
                }
                if (innerIfPresentArgument == null) {
                    Context.$$$reportNull$$$0(1);
                }
                this.myMapBefore = mapBefore;
                this.myMapLambdaBodyAfter = mapLambdaBodyAfter;
                this.myOuterIfPresentVarName = outerIfPresentVarName;
                this.myInnerIfPresentArgument = innerIfPresentArgument;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outerIfPresentVarName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "innerIfPresentArgument";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$IfPresentFoldedCase$Context";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class MapUnwrappingCase
    implements ChainSimplificationCase<Context> {
        private MapUnwrappingCase() {
        }

        @Override
        @NotNull
        public String getName(@NotNull Context context) {
            if (context == null) {
                MapUnwrappingCase.$$$reportNull$$$0(0);
            }
            String string = CommonQuickFixBundle.message((String)"fix.replace.map.with.flat.map.name", (Object[])new Object[0]);
            if (string == null) {
                MapUnwrappingCase.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDescription(@NotNull Context context) {
            if (context == null) {
                MapUnwrappingCase.$$$reportNull$$$0(2);
            }
            String string = CommonQuickFixBundle.message((String)"fix.replace.map.with.flat.map.description", (Object[])new Object[0]);
            if (string == null) {
                MapUnwrappingCase.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        public Context extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            PsiLambdaExpression lambda2;
            if (project == null) {
                MapUnwrappingCase.$$$reportNull$$$0(4);
            }
            if (call == null) {
                MapUnwrappingCase.$$$reportNull$$$0(5);
            }
            if ((lambda2 = SimplifyOptionalCallChainsInspection.getLambda(call.getArgumentList().getExpressions()[0])) == null) {
                return null;
            }
            PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
            if (parameters2.length != 1) {
                return null;
            }
            PsiParameter mapLambdaParameter = parameters2[0];
            PsiExpression argument = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
            PsiMethodCallExpression insideLambdaCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)argument, PsiMethodCallExpression.class);
            if (insideLambdaCall == null) {
                return null;
            }
            PsiExpression optionalQualifier = insideLambdaCall.getMethodExpression().getQualifierExpression();
            if (optionalQualifier == null) {
                return null;
            }
            if (!OPTIONAL_OR_ELSE.test(insideLambdaCall)) {
                if (!OPTIONAL_GET.test(insideLambdaCall)) {
                    return null;
                }
                PsiExpression qualifier = insideLambdaCall.getMethodExpression().getQualifierExpression();
                if (!MapUnwrappingCase.isPresentOptional(qualifier)) {
                    return null;
                }
                return new Context(optionalQualifier, call, mapLambdaParameter);
            }
            if (!ExpressionUtils.isNullLiteral(insideLambdaCall.getArgumentList().getExpressions()[0])) {
                return null;
            }
            return new Context(optionalQualifier, call, mapLambdaParameter);
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull Context context) {
            if (project == null) {
                MapUnwrappingCase.$$$reportNull$$$0(6);
            }
            if (call == null) {
                MapUnwrappingCase.$$$reportNull$$$0(7);
            }
            if (context == null) {
                MapUnwrappingCase.$$$reportNull$$$0(8);
            }
            CommentTracker ct = new CommentTracker();
            String text2 = ct.text((PsiElement)context.myMapLambdaParameter) + " ->" + ct.text((PsiElement)context.myOptionalExpression);
            PsiExpression qualifier = context.myMapCall.getMethodExpression().getQualifierExpression();
            String callReplacement = Objects.requireNonNull(qualifier).getText() + ".flatMap(" + text2 + ")";
            PsiElement result = ct.replaceAndRestoreComments((PsiElement)context.myMapCall, callReplacement);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            CallMatcher callMatcher = OPTIONAL_MAP;
            if (callMatcher == null) {
                MapUnwrappingCase.$$$reportNull$$$0(9);
            }
            return callMatcher;
        }

        private static boolean isPresentOptional(PsiExpression optionalExpression) {
            SpecialFieldValue fact = CommonDataflow.getExpressionFact(optionalExpression, DfaFactType.SPECIAL_FIELD_VALUE);
            DfaValue value2 = SpecialField.OPTIONAL_VALUE.extract(fact);
            if (!(value2 instanceof DfaFactMapValue)) {
                return false;
            }
            return DfaNullability.toNullability(DfaFactType.NULLABILITY.fromDfaValue(value2)) == Nullability.NOT_NULL;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$MapUnwrappingCase";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$MapUnwrappingCase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "extractContext";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class Context {
            private final PsiExpression myOptionalExpression;
            private final PsiMethodCallExpression myMapCall;
            private final PsiParameter myMapLambdaParameter;

            private Context(PsiExpression expression2, PsiMethodCallExpression call, PsiParameter parameter2) {
                this.myOptionalExpression = expression2;
                this.myMapCall = call;
                this.myMapLambdaParameter = parameter2;
            }
        }
    }

    private static class OrElseNonNullCase
    implements ChainSimplificationCase<Context> {
        private final OrElseType myType;

        private OrElseNonNullCase(OrElseType type2) {
            this.myType = type2;
        }

        @Override
        @NotNull
        public String getName(@NotNull Context context) {
            if (context == null) {
                OrElseNonNullCase.$$$reportNull$$$0(0);
            }
            if ("Replace null check with ifPresent()" == null) {
                OrElseNonNullCase.$$$reportNull$$$0(1);
            }
            return "Replace null check with ifPresent()";
        }

        @Override
        @NotNull
        public String getDescription(@NotNull Context context) {
            if (context == null) {
                OrElseNonNullCase.$$$reportNull$$$0(2);
            }
            if ("Null check can be eliminated with 'ifPresent'" == null) {
                OrElseNonNullCase.$$$reportNull$$$0(3);
            }
            return "Null check can be eliminated with 'ifPresent'";
        }

        @Override
        @Nullable
        public Context extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            PsiExpression orElseArgument;
            if (project == null) {
                OrElseNonNullCase.$$$reportNull$$$0(4);
            }
            if (call == null) {
                OrElseNonNullCase.$$$reportNull$$$0(5);
            }
            if (!ExpressionUtils.isNullLiteral(orElseArgument = SimplifyOptionalCallChainsInspection.getOrElseArgument(call, this.myType))) {
                return null;
            }
            PsiLocalVariable returnVar = (PsiLocalVariable)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent()), PsiLocalVariable.class);
            if (returnVar == null) {
                return null;
            }
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)returnVar, PsiStatement.class, (boolean)true);
            if (statement == null) {
                return null;
            }
            PsiStatement nextStatement = (PsiStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesForward((PsiElement)returnVar.getParent()), PsiStatement.class);
            if (nextStatement == null) {
                return null;
            }
            PsiExpression lambdaExpr = OrElseNonNullCase.extractMappingExpression(nextStatement, (PsiVariable)returnVar);
            if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)lambdaExpr)) {
                return null;
            }
            if (!ReferencesSearch.search((PsiElement)returnVar).allMatch(reference -> PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)reference.getElement(), (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)nextStatement, (PsiElement)reference.getElement(), (boolean)false))) {
                return null;
            }
            return new Context(lambdaExpr, nextStatement, statement, (PsiVariable)returnVar, call);
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull Context context) {
            PsiExpression receiver2;
            if (project == null) {
                OrElseNonNullCase.$$$reportNull$$$0(6);
            }
            if (call == null) {
                OrElseNonNullCase.$$$reportNull$$$0(7);
            }
            if (context == null) {
                OrElseNonNullCase.$$$reportNull$$$0(8);
            }
            if ((receiver2 = context.myOrElseCall.getMethodExpression().getQualifierExpression()) == null) {
                return;
            }
            String statementText = receiver2.getText() + ".ifPresent(" + LambdaUtil.createLambda((PsiVariable)context.myVariable, (PsiExpression)context.myAction) + ");";
            PsiStatement finalStatement = JavaPsiFacade.getElementFactory((Project)project).createStatementFromText(statementText, (PsiElement)context.myStatement);
            PsiElement result = context.myStatement.replace((PsiElement)finalStatement);
            context.myConditionStatement.delete();
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            CallMatcher callMatcher = SimplifyOptionalCallChainsInspection.getMatcherByType(this.myType);
            if (callMatcher == null) {
                OrElseNonNullCase.$$$reportNull$$$0(9);
            }
            return callMatcher;
        }

        @Nullable
        private static PsiExpression extractMappingExpression(@NotNull PsiStatement statement, @NotNull PsiVariable optValue) {
            PsiIfStatement ifStatement;
            if (statement == null) {
                OrElseNonNullCase.$$$reportNull$$$0(10);
            }
            if (optValue == null) {
                OrElseNonNullCase.$$$reportNull$$$0(11);
            }
            if ((ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class)) == null) {
                return null;
            }
            if (ifStatement.getElseBranch() != null) {
                return null;
            }
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                return null;
            }
            if (ExpressionUtils.getVariableFromNullComparison(condition2, false) != optValue) {
                return null;
            }
            PsiStatement thenStatement = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)thenStatement, PsiExpressionStatement.class);
            if (expressionStatement == null) {
                return null;
            }
            return expressionStatement.getExpression();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OrElseNonNullCase";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OrElseNonNullCase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "extractContext";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "extractMappingExpression";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class Context {
            @NotNull
            private final PsiExpression myAction;
            @NotNull
            private final PsiStatement myConditionStatement;
            @NotNull
            private final PsiStatement myStatement;
            @NotNull
            private final PsiVariable myVariable;
            @NotNull
            private final PsiMethodCallExpression myOrElseCall;

            private Context(@NotNull PsiExpression action, @NotNull PsiStatement conditionStatement, @NotNull PsiStatement statement, @NotNull PsiVariable variable, @NotNull PsiMethodCallExpression call) {
                if (action == null) {
                    Context.$$$reportNull$$$0(0);
                }
                if (conditionStatement == null) {
                    Context.$$$reportNull$$$0(1);
                }
                if (statement == null) {
                    Context.$$$reportNull$$$0(2);
                }
                if (variable == null) {
                    Context.$$$reportNull$$$0(3);
                }
                if (call == null) {
                    Context.$$$reportNull$$$0(4);
                }
                this.myAction = action;
                this.myConditionStatement = conditionStatement;
                this.myStatement = statement;
                this.myVariable = variable;
                this.myOrElseCall = call;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "conditionStatement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "statement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "variable";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[0] = "call";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OrElseNonNullCase$Context";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class FlipPresentOrEmptyCase
    implements ChainSimplificationCase<Context> {
        private final boolean myIsPresent;

        private FlipPresentOrEmptyCase(boolean present) {
            this.myIsPresent = present;
        }

        @Override
        @NotNull
        public String getName(@NotNull Context context) {
            if (context == null) {
                FlipPresentOrEmptyCase.$$$reportNull$$$0(0);
            }
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{context.myReplacement + "()"});
            if (string == null) {
                FlipPresentOrEmptyCase.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDescription(@NotNull Context context) {
            if (context == null) {
                FlipPresentOrEmptyCase.$$$reportNull$$$0(2);
            }
            String string = "'" + context.myReplacement + "()' can be used instead";
            if (string == null) {
                FlipPresentOrEmptyCase.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        public Context extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            if (project == null) {
                FlipPresentOrEmptyCase.$$$reportNull$$$0(4);
            }
            if (call == null) {
                FlipPresentOrEmptyCase.$$$reportNull$$$0(5);
            }
            if (!BoolUtils.isNegated((PsiExpression)call)) {
                return null;
            }
            PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
            if (nameElement == null) {
                return null;
            }
            if (this.myIsPresent) {
                return new Context("isEmpty");
            }
            return new Context("isPresent");
        }

        @Override
        public boolean isAppropriateLanguageLevel(@NotNull LanguageLevel level) {
            if (level == null) {
                FlipPresentOrEmptyCase.$$$reportNull$$$0(6);
            }
            return level.isAtLeast(LanguageLevel.JDK_11);
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull Context context) {
            PsiPrefixExpression negation;
            if (project == null) {
                FlipPresentOrEmptyCase.$$$reportNull$$$0(7);
            }
            if (call == null) {
                FlipPresentOrEmptyCase.$$$reportNull$$$0(8);
            }
            if (context == null) {
                FlipPresentOrEmptyCase.$$$reportNull$$$0(9);
            }
            if ((negation = (PsiPrefixExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent()), PsiPrefixExpression.class)) == null || BoolUtils.getNegated((PsiExpression)negation) != call) {
                return;
            }
            ExpressionUtils.bindCallTo(call, context.myReplacement);
            new CommentTracker().replaceAndRestoreComments((PsiElement)negation, (PsiElement)call);
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            if (this.myIsPresent) {
                CallMatcher callMatcher = OPTIONAL_IS_PRESENT;
                if (callMatcher == null) {
                    FlipPresentOrEmptyCase.$$$reportNull$$$0(10);
                }
                return callMatcher;
            }
            CallMatcher callMatcher = OPTIONAL_IS_EMPTY;
            if (callMatcher == null) {
                FlipPresentOrEmptyCase.$$$reportNull$$$0(11);
            }
            return callMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$FlipPresentOrEmptyCase";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$FlipPresentOrEmptyCase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 1: 
                case 3: 
                case 10: 
                case 11: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "extractContext";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isAppropriateLanguageLevel";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class Context {
            private final String myReplacement;

            private Context(String replacement) {
                this.myReplacement = replacement;
            }
        }
    }

    private static class OrElseReturnCase
    implements ChainSimplificationCase<Context> {
        private final OrElseType myType;

        private OrElseReturnCase(OrElseType type2) {
            this.myType = type2;
        }

        @Override
        @NotNull
        public String getName(@NotNull Context context) {
            if (context == null) {
                OrElseReturnCase.$$$reportNull$$$0(0);
            }
            String method = context.myIsSimple ? "orElse" : "orElseGet";
            String string = "Replace null check with " + method + "(" + PsiExpressionTrimRenderer.render((PsiExpression)context.myDefaultExpression) + ")";
            if (string == null) {
                OrElseReturnCase.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDescription(@NotNull Context context) {
            if (context == null) {
                OrElseReturnCase.$$$reportNull$$$0(2);
            }
            if ("Null check can be eliminated" == null) {
                OrElseReturnCase.$$$reportNull$$$0(3);
            }
            return "Null check can be eliminated";
        }

        @Override
        @Nullable
        public Context extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            PsiExpression falseArg;
            if (project == null) {
                OrElseReturnCase.$$$reportNull$$$0(4);
            }
            if (call == null) {
                OrElseReturnCase.$$$reportNull$$$0(5);
            }
            if (!ExpressionUtils.isNullLiteral(falseArg = SimplifyOptionalCallChainsInspection.getOrElseArgument(call, this.myType))) {
                return null;
            }
            PsiLocalVariable returnVar = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)call, PsiLocalVariable.class, (boolean)true);
            if (returnVar == null) {
                return null;
            }
            PsiStatement nextStatement = (PsiStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesForward((PsiElement)returnVar.getParent()), PsiStatement.class);
            if (nextStatement == null) {
                return null;
            }
            PsiExpression defaultValue = SimplifyOptionalCallChainsInspection.extractConditionalDefaultValue(nextStatement, (PsiVariable)returnVar);
            boolean isSimple = ExpressionUtils.isSafelyRecomputableExpression(defaultValue);
            if (defaultValue == null || !isSimple && !LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)defaultValue)) {
                return null;
            }
            PsiType type2 = defaultValue.getType();
            PsiType methodCallReturnValue = call.getMethodExpression().getType();
            if (type2 == null || methodCallReturnValue == null || !methodCallReturnValue.isAssignableFrom(type2)) {
                return null;
            }
            return new Context(call, defaultValue, nextStatement, isSimple);
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull Context context) {
            PsiExpression receiver2;
            if (project == null) {
                OrElseReturnCase.$$$reportNull$$$0(6);
            }
            if (call == null) {
                OrElseReturnCase.$$$reportNull$$$0(7);
            }
            if (context == null) {
                OrElseReturnCase.$$$reportNull$$$0(8);
            }
            if ((receiver2 = context.myOrElseCall.getMethodExpression().getQualifierExpression()) == null) {
                return;
            }
            String methodWithArg = context.myIsSimple ? ".orElse(" + context.myDefaultExpression.getText() + ")" : ".orElseGet(()->" + context.myDefaultExpression.getText() + ")";
            String expressionText = receiver2.getText() + methodWithArg;
            PsiStatement finalStatement = JavaPsiFacade.getElementFactory((Project)project).createStatementFromText("return " + expressionText + ";", (PsiElement)receiver2);
            PsiStatement current = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)context.myOrElseCall, PsiStatement.class, (boolean)false);
            if (current == null) {
                return;
            }
            PsiElement result = new CommentTracker().replaceAndRestoreComments((PsiElement)current, (PsiElement)finalStatement);
            new CommentTracker().deleteAndRestoreComments((PsiElement)context.myNextStatement);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            if (this.myType == OrElseType.OrElse) {
                CallMatcher callMatcher = OPTIONAL_OR_ELSE;
                if (callMatcher == null) {
                    OrElseReturnCase.$$$reportNull$$$0(9);
                }
                return callMatcher;
            }
            CallMatcher callMatcher = OPTIONAL_OR_ELSE_GET;
            if (callMatcher == null) {
                OrElseReturnCase.$$$reportNull$$$0(10);
            }
            return callMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OrElseReturnCase";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OrElseReturnCase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 1: 
                case 3: 
                case 9: 
                case 10: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "extractContext";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class Context {
            @NotNull
            private final PsiMethodCallExpression myOrElseCall;
            @NotNull
            private final PsiExpression myDefaultExpression;
            @NotNull
            private final PsiStatement myNextStatement;
            private final boolean myIsSimple;

            private Context(@NotNull PsiMethodCallExpression call, @NotNull PsiExpression defaultExpression, @NotNull PsiStatement nextStatement, boolean simple) {
                if (call == null) {
                    Context.$$$reportNull$$$0(0);
                }
                if (defaultExpression == null) {
                    Context.$$$reportNull$$$0(1);
                }
                if (nextStatement == null) {
                    Context.$$$reportNull$$$0(2);
                }
                this.myOrElseCall = call;
                this.myDefaultExpression = defaultExpression;
                this.myNextStatement = nextStatement;
                this.myIsSimple = simple;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "call";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "defaultExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "nextStatement";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OrElseReturnCase$Context";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class RewrappingCase
    implements ChainSimplificationCase<Context> {
        private final CallMatcher myWrapper;
        private final Type myType;

        private RewrappingCase(Type type2) {
            this.myType = type2;
            this.myWrapper = this.myType == Type.OrElseNull ? OPTIONAL_OF_NULLABLE : OPTIONAL_OF_OF_NULLABLE;
        }

        @Override
        @NotNull
        public String getName(@NotNull Context context) {
            if (context == null) {
                RewrappingCase.$$$reportNull$$$0(0);
            }
            if ("Unwrap" == null) {
                RewrappingCase.$$$reportNull$$$0(1);
            }
            return "Unwrap";
        }

        @Override
        @NotNull
        public String getDescription(@NotNull Context context) {
            if (context == null) {
                RewrappingCase.$$$reportNull$$$0(2);
            }
            if ("Unnecessary Optional rewrapping" == null) {
                RewrappingCase.$$$reportNull$$$0(3);
            }
            return "Unnecessary Optional rewrapping";
        }

        @Override
        @Nullable
        public Context extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            SpecialFieldValue fact;
            PsiElement parent;
            if (project == null) {
                RewrappingCase.$$$reportNull$$$0(4);
            }
            if (call == null) {
                RewrappingCase.$$$reportNull$$$0(5);
            }
            if (!((parent = PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent())) instanceof PsiExpressionList)) {
                return null;
            }
            PsiMethodCallExpression parentCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodCallExpression.class);
            if (!this.myWrapper.test(parentCall)) {
                return null;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null || !EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(qualifier.getType(), parentCall.getType())) {
                return null;
            }
            if ("get".equals(call.getMethodExpression().getReferenceName()) && DfaFactType.NULLABILITY.fromDfaValue(SpecialField.OPTIONAL_VALUE.extract(fact = CommonDataflow.getExpressionFact(qualifier, DfaFactType.SPECIAL_FIELD_VALUE))) != DfaNullability.NOT_NULL) {
                return null;
            }
            return new Context(qualifier, (PsiExpression)parentCall);
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull Context context) {
            if (project == null) {
                RewrappingCase.$$$reportNull$$$0(6);
            }
            if (call == null) {
                RewrappingCase.$$$reportNull$$$0(7);
            }
            if (context == null) {
                RewrappingCase.$$$reportNull$$$0(8);
            }
            PsiElement result = context.myCallToReplace.replace((PsiElement)context.myQualifier);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
            RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments(result);
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            if (this.myType == Type.OptionalGet) {
                CallMatcher callMatcher = OPTIONAL_GET;
                if (callMatcher == null) {
                    RewrappingCase.$$$reportNull$$$0(9);
                }
                return callMatcher;
            }
            CallMatcher callMatcher = OPTIONAL_OR_ELSE_OR_ELSE_GET;
            if (callMatcher == null) {
                RewrappingCase.$$$reportNull$$$0(10);
            }
            return callMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$RewrappingCase";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$RewrappingCase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 1: 
                case 3: 
                case 9: 
                case 10: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "extractContext";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        static enum Type {
            OrElseNull,
            OptionalGet;

        }

        private static class Context {
            private final PsiExpression myQualifier;
            private final PsiExpression myCallToReplace;

            private Context(PsiExpression qualifier, PsiExpression callToReplace) {
                this.myQualifier = qualifier;
                this.myCallToReplace = callToReplace;
            }
        }
    }

    private static abstract class BasicSimplificationInspection
    implements ChainSimplificationCase<StringReplacement> {
        private BasicSimplificationInspection() {
        }

        @Override
        @NotNull
        public String getName(@NotNull StringReplacement context) {
            if (context == null) {
                BasicSimplificationInspection.$$$reportNull$$$0(0);
            }
            String string = context.myMessage;
            if (string == null) {
                BasicSimplificationInspection.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDescription(@NotNull StringReplacement context) {
            if (context == null) {
                BasicSimplificationInspection.$$$reportNull$$$0(2);
            }
            String string = context.myDescription;
            if (string == null) {
                BasicSimplificationInspection.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull StringReplacement context) {
            if (project == null) {
                BasicSimplificationInspection.$$$reportNull$$$0(4);
            }
            if (call == null) {
                BasicSimplificationInspection.$$$reportNull$$$0(5);
            }
            if (context == null) {
                BasicSimplificationInspection.$$$reportNull$$$0(6);
            }
            PsiExpression replacementExpression = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(context.myReplacement, (PsiElement)call);
            PsiElement result = call.replace((PsiElement)replacementExpression);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
            RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$BasicSimplificationInspection";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$BasicSimplificationInspection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        protected static class StringReplacement {
            private final String myReplacement;
            private final String myMessage;
            private final String myDescription;

            StringReplacement(String replacement, String message2, String description) {
                this.myReplacement = replacement;
                this.myMessage = message2;
                this.myDescription = description;
            }
        }
    }

    static class OptionalSimplificationFix
    implements LocalQuickFix {
        private final ChainSimplificationCase<?> myInspection;
        private final String myName;
        private final String myDescription;

        OptionalSimplificationFix(ChainSimplificationCase<?> inspection, String name2, String description) {
            this.myInspection = inspection;
            this.myName = name2;
            this.myDescription = description;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = this.myName;
            if (string == null) {
                OptionalSimplificationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                OptionalSimplificationFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                OptionalSimplificationFix.$$$reportNull$$$0(2);
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethodCallExpression.class, (boolean)false);
            SimplifyOptionalCallChainsInspection.handleSimplification(this.myInspection, project, call);
        }

        String getDescription() {
            return this.myDescription;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OptionalSimplificationFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OptionalSimplificationFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MapOrElseCase
    extends BasicSimplificationInspection {
        private final OrElseType myType;

        private MapOrElseCase(OrElseType type2) {
            this.myType = type2;
        }

        @Override
        @Nullable
        public BasicSimplificationInspection.StringReplacement extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            PsiExpression falseArg;
            if (project == null) {
                MapOrElseCase.$$$reportNull$$$0(0);
            }
            if (call == null) {
                MapOrElseCase.$$$reportNull$$$0(1);
            }
            if ((falseArg = SimplifyOptionalCallChainsInspection.getOrElseArgument(call, this.myType)) == null) {
                return null;
            }
            PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(call);
            if (!OPTIONAL_MAP.test(qualifierCall)) {
                return null;
            }
            PsiLambdaExpression lambda2 = SimplifyOptionalCallChainsInspection.getLambda(qualifierCall.getArgumentList().getExpressions()[0]);
            if (lambda2 == null) {
                return null;
            }
            PsiExpression trueArg = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
            if (trueArg == null) {
                return null;
            }
            PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
            if (parameters2.length != 1) {
                return null;
            }
            PsiExpression qualifier = qualifierCall.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return null;
            }
            String opt = qualifier.getText();
            PsiParameter parameter2 = parameters2[0];
            boolean useOrElseGet = this.myType == OrElseType.OrElseGet;
            String proposed = OptionalRefactoringUtil.generateOptionalUnwrap(opt, (PsiVariable)parameter2, trueArg, falseArg, call.getType(), useOrElseGet);
            String canonicalOrElse = useOrElseGet && !ExpressionUtils.isSafelyRecomputableExpression(falseArg) ? ".orElseGet(() -> " + falseArg.getText() + ")" : ".orElse(" + falseArg.getText() + ")";
            String canonical = opt + ".map(" + LambdaUtil.createLambda((PsiVariable)parameter2, (PsiExpression)trueArg) + ")" + canonicalOrElse;
            if (proposed.length() < canonical.length()) {
                String displayCode;
                if (proposed.equals(opt)) {
                    displayCode = "";
                } else if (opt.length() > 10) {
                    opt = "(($))";
                    String template = OptionalRefactoringUtil.generateOptionalUnwrap(opt, (PsiVariable)parameter2, trueArg, falseArg, call.getType(), useOrElseGet);
                    displayCode = PsiExpressionTrimRenderer.render((PsiExpression)JavaPsiFacade.getElementFactory((Project)parameter2.getProject()).createExpressionFromText(template, (PsiElement)call));
                    displayCode = displayCode.replaceFirst(Pattern.quote(opt), "..");
                } else {
                    displayCode = PsiExpressionTrimRenderer.render((PsiExpression)JavaPsiFacade.getElementFactory((Project)parameter2.getProject()).createExpressionFromText(proposed, (PsiElement)call));
                }
                String message2 = displayCode.isEmpty() ? "Remove redundant steps from optional chain" : "Simplify optional chain to '" + displayCode + "'";
                String description = "Optional chain can be simplified";
                return new BasicSimplificationInspection.StringReplacement(proposed, message2, description);
            }
            return null;
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            CallMatcher callMatcher = SimplifyOptionalCallChainsInspection.getMatcherByType(this.myType);
            if (callMatcher == null) {
                MapOrElseCase.$$$reportNull$$$0(2);
            }
            return callMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$MapOrElseCase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$MapOrElseCase";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "extractContext";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class OptionalChainVisitor
    extends JavaElementVisitor {
        private final LanguageLevel myLevel;

        private OptionalChainVisitor(LanguageLevel level) {
            this.myLevel = level;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            Optional<OptionalSimplificationFix> fix2 = ourMapper.mapAll(expression2).filter(f -> ((OptionalSimplificationFix)f).myInspection.isAppropriateLanguageLevel(this.myLevel)).findAny();
            if (!fix2.isPresent()) {
                return;
            }
            this.handleSimplification(expression2, fix2.get());
        }

        protected abstract void handleSimplification(@NotNull PsiMethodCallExpression var1, @NotNull OptionalSimplificationFix var2);
    }

    private static interface ChainSimplificationCase<C>
    extends Function<PsiMethodCallExpression, OptionalSimplificationFix> {
        @Override
        default public OptionalSimplificationFix apply(PsiMethodCallExpression expression2) {
            return SimplifyOptionalCallChainsInspection.getFix(expression2, this);
        }

        @NotNull
        public String getName(@NotNull C var1);

        @NotNull
        public String getDescription(@NotNull C var1);

        @Nullable
        public C extractContext(@NotNull Project var1, @NotNull PsiMethodCallExpression var2);

        public void apply(@NotNull Project var1, @NotNull PsiMethodCallExpression var2, @NotNull C var3);

        default public boolean isAvailable(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            if (project == null) {
                ChainSimplificationCase.$$$reportNull$$$0(0);
            }
            if (call == null) {
                ChainSimplificationCase.$$$reportNull$$$0(1);
            }
            return this.extractContext(project, call) != null;
        }

        @NotNull
        public CallMatcher getMatcher();

        default public boolean isAppropriateLanguageLevel(@NotNull LanguageLevel level) {
            if (level == null) {
                ChainSimplificationCase.$$$reportNull$$$0(2);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$ChainSimplificationCase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAvailable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAppropriateLanguageLevel";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum OrElseType {
        OrElse,
        OrElseGet;

    }
}

