/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageProcessor;
import com.intellij.codeInspection.apiUsage.ApiUsageUastVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/codeInspection/NonExtendableApiUsageInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Companion", "NonExtendableApiUsageProcessor", "intellij.jvm.analysis.impl"})
public final class NonExtendableApiUsageInspection
extends LocalInspectionTool {
    @NotNull
    private static final String ANNOTATION_NAME;
    @Deprecated
    public static final Companion Companion;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return ApiUsageUastVisitor.Companion.createPsiElementVisitor(new NonExtendableApiUsageProcessor(holder));
    }

    static {
        Companion = new Companion(null);
        String string = ApiStatus.NonExtendable.class.getCanonicalName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        ANNOTATION_NAME = string;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/codeInspection/NonExtendableApiUsageInspection$NonExtendableApiUsageProcessor;", "Lcom/intellij/codeInspection/apiUsage/ApiUsageProcessor;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "isLibraryElement", "", "element", "Lcom/intellij/psi/PsiElement;", "isSuperClassReferenceInSubclassDeclaration", "sourceNode", "Lorg/jetbrains/uast/UElement;", "subclassDeclaration", "Lorg/jetbrains/uast/UClass;", "processMethodOverriding", "", "method", "Lorg/jetbrains/uast/UMethod;", "overriddenMethod", "Lcom/intellij/psi/PsiMethod;", "processReference", "target", "Lcom/intellij/psi/PsiModifierListOwner;", "qualifier", "Lorg/jetbrains/uast/UExpression;", "intellij.jvm.analysis.impl"})
    private static final class NonExtendableApiUsageProcessor
    implements ApiUsageProcessor {
        private final ProblemsHolder problemsHolder;

        private final boolean isLibraryElement(PsiElement element) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
            return virtualFile != null && ProjectFileIndex.getInstance((Project)element.getProject()).isInLibraryClasses(virtualFile);
        }

        private final boolean isSuperClassReferenceInSubclassDeclaration(UElement sourceNode, UClass subclassDeclaration) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = subclassDeclaration.getUastSuperTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        UTypeReferenceExpression it = (UTypeReferenceExpression)element$iv;
                        boolean bl2 = false;
                        if (!UastUtils.isPsiAncestor((UElement)((UElement)it), (UElement)sourceNode)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public void processReference(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target, @Nullable UExpression qualifier) {
            Intrinsics.checkParameterIsNotNull((Object)sourceNode, (String)"sourceNode");
            Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
            if (!(target instanceof PsiClass) || !target.hasAnnotation(Companion.getANNOTATION_NAME())) {
                return;
            }
            UClass classDeclaration = (UClass)UastUtils.findContaining((PsiElement)sourceNode.getSourcePsi(), UClass.class);
            if (classDeclaration == null || !this.isSuperClassReferenceInSubclassDeclaration(sourceNode, classDeclaration)) {
                return;
            }
            PsiElement psiElement = sourceNode.getSourcePsi();
            if (psiElement == null) {
                return;
            }
            PsiElement elementToHighlight = psiElement;
            if (this.isLibraryElement((PsiElement)target)) {
                String string = HighlightMessageUtil.getSymbolName((PsiElement)target);
                if (string == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"HighlightMessageUtil.get\u2026bolName(target) ?: return");
                String className2 = string;
                String description = ((PsiClass)target).isInterface() ? (classDeclaration.isInterface() ? JvmAnalysisBundle.message("jvm.inspections.api.no.extension.interface.extend.description", className2) : JvmAnalysisBundle.message("jvm.inspections.api.no.extension.interface.implement.description", className2)) : JvmAnalysisBundle.message("jvm.inspections.api.no.extension.class.description", className2);
                this.problemsHolder.registerProblem(elementToHighlight, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }

        @Override
        public void processMethodOverriding(@NotNull UMethod method, @NotNull PsiMethod overriddenMethod) {
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            Intrinsics.checkParameterIsNotNull((Object)overriddenMethod, (String)"overriddenMethod");
            PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)method.getUastAnchor());
            if (psiElement == null) {
                return;
            }
            PsiElement elementToHighlight = psiElement;
            String string = HighlightMessageUtil.getSymbolName((PsiElement)overriddenMethod);
            if (string == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"HighlightMessageUtil.get\u2026erriddenMethod) ?: return");
            String methodName = string;
            if (overriddenMethod.hasAnnotation(Companion.getANNOTATION_NAME()) && this.isLibraryElement((PsiElement)overriddenMethod)) {
                String description = JvmAnalysisBundle.message("jvm.inspections.api.no.extension.method.overriding.description", methodName);
                this.problemsHolder.registerProblem(elementToHighlight, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }

        public NonExtendableApiUsageProcessor(@NotNull ProblemsHolder problemsHolder) {
            Intrinsics.checkParameterIsNotNull((Object)problemsHolder, (String)"problemsHolder");
            this.problemsHolder = problemsHolder;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInspection/NonExtendableApiUsageInspection$Companion;", "", "()V", "ANNOTATION_NAME", "", "getANNOTATION_NAME", "()Ljava/lang/String;", "intellij.jvm.analysis.impl"})
    private static final class Companion {
        @NotNull
        public final String getANNOTATION_NAME() {
            return ANNOTATION_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

