/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.editorActions.DeclarationJoinLinesHandler;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveInitializerFix;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JoinDeclarationAndAssignmentJavaInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            JoinDeclarationAndAssignmentJavaInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitAssignmentExpression(PsiAssignmentExpression assignmentExpression) {
                super.visitAssignmentExpression(assignmentExpression);
                this.visitLocation((PsiElement)assignmentExpression);
            }

            public void visitLocalVariable(PsiLocalVariable variable) {
                super.visitLocalVariable(variable);
                if (isOnTheFly && this.isInformationLevel((PsiElement)variable)) {
                    this.visitLocation((PsiElement)variable);
                }
            }

            public void visitLocation(@Nullable PsiElement location) {
                Context context = JoinDeclarationAndAssignmentJavaInspection.getContext(location);
                if (context != null) {
                    PsiLocalVariable variable = context.myVariable;
                    PsiAssignmentExpression assignment = context.myAssignment;
                    assert (location == variable || location == assignment) : "context location";
                    String message2 = InspectionsBundle.message((String)"inspection.join.declaration.and.assignment.message", (Object[])new Object[]{context.myName});
                    JoinDeclarationAndAssignmentFix fix2 = new JoinDeclarationAndAssignmentFix();
                    if (isOnTheFly && (context.myIsUpdate || this.isInformationLevel(location))) {
                        ProblemHighlightType highlightType = context.myIsUpdate ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                        holder.registerProblem(location, message2, highlightType, new LocalQuickFix[]{fix2});
                    } else if (location == assignment && !context.myIsUpdate) {
                        holder.registerProblem((PsiElement)assignment.getLExpression(), message2, new LocalQuickFix[]{fix2});
                    }
                }
            }

            private boolean isInformationLevel(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return InspectionProjectProfileManager.isInformationLevel((String)JoinDeclarationAndAssignmentJavaInspection.this.getShortName(), (PsiElement)element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/JoinDeclarationAndAssignmentJavaInspection$1", "isInformationLevel"));
            }
        };
        if (javaElementVisitor == null) {
            JoinDeclarationAndAssignmentJavaInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    @Contract(value="null -> null")
    @Nullable
    private static Context getContext(@Nullable PsiElement element) {
        if (element != null) {
            if (!(element instanceof PsiAssignmentExpression) && !(element instanceof PsiLocalVariable)) {
                element = element.getParent();
            }
            if (element instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)element;
                return JoinDeclarationAndAssignmentJavaInspection.getContext(JoinDeclarationAndAssignmentJavaInspection.findVariable(assignment), assignment);
            }
            if (element instanceof PsiLocalVariable) {
                PsiLocalVariable variable = (PsiLocalVariable)element;
                return JoinDeclarationAndAssignmentJavaInspection.getContext(variable, JoinDeclarationAndAssignmentJavaInspection.findAssignment(variable));
            }
        }
        return null;
    }

    @Contract(value="null,_ -> null; _,null -> null")
    @Nullable
    private static Context getContext(@Nullable PsiLocalVariable variable, @Nullable PsiAssignmentExpression assignment) {
        if (variable != null && assignment != null) {
            String variableName = variable.getName();
            PsiExpression rExpression = assignment.getRExpression();
            if (variableName != null && rExpression != null) {
                PsiLocalVariable aVar = variable;
                while (aVar != null) {
                    if (VariableAccessUtils.variableIsUsed((PsiVariable)aVar, (PsiElement)rExpression)) {
                        return null;
                    }
                    aVar = (PsiLocalVariable)PsiTreeUtil.getNextSiblingOfType((PsiElement)aVar, PsiLocalVariable.class);
                }
                return new Context(variable, assignment, variableName);
            }
        }
        return null;
    }

    @Nullable
    private static PsiLocalVariable findVariable(@NotNull PsiAssignmentExpression assignmentExpression) {
        PsiElement resolved;
        PsiReferenceExpression reference;
        PsiExpression lExpression;
        if (assignmentExpression == null) {
            JoinDeclarationAndAssignmentJavaInspection.$$$reportNull$$$0(2);
        }
        if ((lExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignmentExpression.getLExpression())) instanceof PsiReferenceExpression && !(reference = (PsiReferenceExpression)lExpression).isQualified() && (resolved = reference.resolve()) instanceof PsiLocalVariable) {
            PsiLocalVariable variable = (PsiLocalVariable)resolved;
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)variable.getParent(), PsiDeclarationStatement.class);
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)assignmentExpression.getParent(), PsiExpressionStatement.class);
            if (declarationStatement != null && declarationStatement.getParent() instanceof PsiCodeBlock && expressionStatement != null && expressionStatement.getParent() == declarationStatement.getParent()) {
                return JoinDeclarationAndAssignmentJavaInspection.findOccurrence((PsiElement)expressionStatement, variable, PsiTreeUtil::skipWhitespacesAndCommentsBackward, (candidate, unused) -> candidate == declarationStatement ? variable : null);
            }
        }
        return null;
    }

    @Nullable
    private static PsiAssignmentExpression findAssignment(@NotNull PsiLocalVariable variable) {
        if (variable == null) {
            JoinDeclarationAndAssignmentJavaInspection.$$$reportNull$$$0(3);
        }
        return JoinDeclarationAndAssignmentJavaInspection.findOccurrence(variable.getParent(), variable, PsiTreeUtil::skipWhitespacesAndCommentsForward, JoinDeclarationAndAssignmentJavaInspection::findAssignment);
    }

    @Nullable
    private static <T> T findOccurrence(@Nullable PsiElement start, @NotNull PsiLocalVariable variable, @NotNull Function<? super PsiElement, ? extends PsiElement> advance, @NotNull BiFunction<? super PsiElement, ? super PsiLocalVariable, ? extends T> search) {
        PsiElement candidate;
        T result;
        if (variable == null) {
            JoinDeclarationAndAssignmentJavaInspection.$$$reportNull$$$0(4);
        }
        if (advance == null) {
            JoinDeclarationAndAssignmentJavaInspection.$$$reportNull$$$0(5);
        }
        if (search == null) {
            JoinDeclarationAndAssignmentJavaInspection.$$$reportNull$$$0(6);
        }
        if ((result = search.apply((PsiElement)(candidate = advance.apply((PsiElement)start)), (PsiLocalVariable)variable)) != null) {
            return result;
        }
        if (JoinDeclarationAndAssignmentJavaInspection.canRemoveDeclaration((PsiVariable)variable)) {
            while (candidate != null) {
                result = search.apply((PsiElement)candidate, (PsiLocalVariable)variable);
                if (result != null) {
                    return result;
                }
                if (VariableAccessUtils.variableIsUsed((PsiVariable)variable, candidate)) break;
                candidate = advance.apply((PsiElement)candidate);
            }
        }
        return null;
    }

    @Contract(value="null,_ -> null")
    @Nullable
    private static PsiAssignmentExpression findAssignment(@Nullable PsiElement candidate, @NotNull PsiVariable variable) {
        PsiAssignmentExpression assignmentExpression;
        PsiExpression expression2;
        if (variable == null) {
            JoinDeclarationAndAssignmentJavaInspection.$$$reportNull$$$0(7);
        }
        if (candidate instanceof PsiExpressionStatement && (expression2 = ((PsiExpressionStatement)candidate).getExpression()) instanceof PsiAssignmentExpression && ExpressionUtils.isReferenceTo((assignmentExpression = (PsiAssignmentExpression)expression2).getLExpression(), variable)) {
            return assignmentExpression;
        }
        return null;
    }

    @Nullable
    private static PsiAssignmentExpression findNextAssignment(@Nullable PsiElement element, @NotNull PsiVariable variable) {
        if (variable == null) {
            JoinDeclarationAndAssignmentJavaInspection.$$$reportNull$$$0(8);
        }
        PsiElement candidate = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element);
        return JoinDeclarationAndAssignmentJavaInspection.findAssignment(candidate, variable);
    }

    private static boolean canRemoveDeclaration(@NotNull PsiVariable variable) {
        PsiExpression initializer;
        if (variable == null) {
            JoinDeclarationAndAssignmentJavaInspection.$$$reportNull$$$0(9);
        }
        return (initializer = variable.getInitializer()) == null || !SideEffectChecker.checkSideEffects(initializer, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/JoinDeclarationAndAssignmentJavaInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "advance";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "search";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/JoinDeclarationAndAssignmentJavaInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findVariable";
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findAssignment";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findOccurrence";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findNextAssignment";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canRemoveDeclaration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Context {
        @NotNull
        final PsiLocalVariable myVariable;
        @NotNull
        final PsiAssignmentExpression myAssignment;
        @NotNull
        final String myName;
        final boolean myIsUpdate;

        Context(@NotNull PsiLocalVariable variable, @NotNull PsiAssignmentExpression assignment, @NotNull String name2) {
            if (variable == null) {
                Context.$$$reportNull$$$0(0);
            }
            if (assignment == null) {
                Context.$$$reportNull$$$0(1);
            }
            if (name2 == null) {
                Context.$$$reportNull$$$0(2);
            }
            this.myAssignment = assignment;
            this.myVariable = variable;
            this.myName = name2;
            this.myIsUpdate = !JavaTokenType.EQ.equals(this.myAssignment.getOperationTokenType()) || JoinDeclarationAndAssignmentJavaInspection.findNextAssignment(this.myAssignment.getParent(), (PsiVariable)this.myVariable) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "assignment";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/JoinDeclarationAndAssignmentJavaInspection$Context";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class JoinDeclarationAndAssignmentFix
    implements LocalQuickFix {
        private JoinDeclarationAndAssignmentFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.join.declaration.and.assignment.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                JoinDeclarationAndAssignmentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Context context;
            if (project == null) {
                JoinDeclarationAndAssignmentFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                JoinDeclarationAndAssignmentFix.$$$reportNull$$$0(2);
            }
            if ((context = JoinDeclarationAndAssignmentJavaInspection.getContext(descriptor.getPsiElement())) != null) {
                String textAfter;
                PsiLocalVariable variable = context.myVariable;
                PsiAssignmentExpression assignmentExpression = context.myAssignment;
                PsiExpression initializer = variable.getInitializer();
                if (initializer != null && assignmentExpression.getOperationTokenType() == JavaTokenType.EQ && !RemoveInitializerFix.sideEffectAwareRemove(project, initializer, (PsiElement)initializer, (PsiVariable)variable, textAfter = PsiExpressionTrimRenderer.render((PsiExpression)initializer) + ";<br>" + variable.getTypeElement().getText() + ' ' + variable.getName())) {
                    return;
                }
                if (!FileModificationService.getInstance().prepareFileForWrite(assignmentExpression.getContainingFile())) {
                    return;
                }
                WriteAction.run(() -> this.applyFixImpl(context));
            }
        }

        public void applyFixImpl(@NotNull Context context) {
            PsiLocalVariable varCopy;
            if (context == null) {
                JoinDeclarationAndAssignmentFix.$$$reportNull$$$0(3);
            }
            PsiExpression initializer = DeclarationJoinLinesHandler.getInitializerExpression(context.myVariable, context.myAssignment);
            PsiElement elementToReplace = context.myAssignment.getParent();
            if (elementToReplace != null && (varCopy = DeclarationJoinLinesHandler.copyVarWithInitializer(context.myVariable, initializer)) != null) {
                String text2 = varCopy.getText();
                CommentTracker tracker = new CommentTracker();
                tracker.markUnchanged(initializer);
                tracker.markUnchanged(context.myVariable);
                tracker.delete((PsiElement)context.myVariable);
                tracker.replaceAndRestoreComments(elementToReplace, text2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/JoinDeclarationAndAssignmentJavaInspection$JoinDeclarationAndAssignmentFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/JoinDeclarationAndAssignmentJavaInspection$JoinDeclarationAndAssignmentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFixImpl";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

