/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SetInspectionOptionFix;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.JavaFeature;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.CountingLoop;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.IndexedContainer;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StreamApiUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.function.Predicate;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExplicitArrayFillingInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(ExplicitArrayFillingInspection.class);
    public boolean mySuggestSetAll = false;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionsBundle.message((String)"inspection.explicit.array.filling.suggest.set.all", (Object[])new Object[0]), (InspectionProfileEntry)this, "mySuggestSetAll");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            ExplicitArrayFillingInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitForStatement(PsiForStatement statement) {
                super.visitForStatement(statement);
                CountingLoop loop = CountingLoop.from(statement);
                if (loop == null || loop.isIncluding() || loop.isDescending()) {
                    return;
                }
                if (!ExpressionUtils.isZero(loop.getInitializer())) {
                    return;
                }
                IndexedContainer container = IndexedContainer.fromLengthExpression(loop.getBound());
                if (container == null || !(container.getQualifier().getType() instanceof PsiArrayType)) {
                    return;
                }
                PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)ControlFlowUtils.stripBraces(statement.getBody()));
                if (assignment == null) {
                    return;
                }
                PsiExpression index = container.extractIndexFromGetExpression(assignment.getLExpression());
                if (!ExpressionUtils.isReferenceTo(index, (PsiVariable)loop.getCounter())) {
                    return;
                }
                PsiExpression rValue = assignment.getRExpression();
                if (rValue == null) {
                    return;
                }
                if (!VariableAccessUtils.collectUsedVariables((PsiElement)rValue).contains(loop.getCounter()) && !SideEffectChecker.mayHaveSideEffects(rValue)) {
                    Object constValue = ExpressionUtils.computeConstantExpression(rValue);
                    if (constValue != null && constValue.equals(PsiTypesUtil.getDefaultValue((PsiType)assignment.getType()))) {
                        holder.registerProblem((PsiElement)statement, this.getRange(statement, ProblemHighlightType.WARNING), QuickFixBundle.message("delete.element.fix.text", new Object[0]), new LocalQuickFix[]{QuickFixFactory.getInstance().createDeleteFix((PsiElement)statement)});
                        return;
                    }
                    this.registerProblem(statement, false);
                    return;
                }
                if (!JavaFeature.ADVANCED_COLLECTIONS_API.isFeatureSupported(holder.getFile())) {
                    return;
                }
                if (!StreamApiUtil.isSupportedStreamElement(container.getElementType())) {
                    return;
                }
                if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)rValue, Predicate.isEqual(loop.getCounter()))) {
                    return;
                }
                this.registerProblem(statement, true);
            }

            private void registerProblem(@NotNull PsiForStatement statement, boolean isSetAll) {
                if (statement == null) {
                    1.$$$reportNull$$$0(0);
                }
                String message2 = InspectionsBundle.message((String)"inspection.explicit.array.filling.description", (Object[])new Object[]{isSetAll ? "setAll" : "fill"});
                ReplaceWithArraysCallFix fix2 = new ReplaceWithArraysCallFix(!isSetAll);
                ProblemHighlightType type2 = ProblemHighlightType.WARNING;
                if (isSetAll && !ExplicitArrayFillingInspection.this.mySuggestSetAll) {
                    if (!isOnTheFly) {
                        return;
                    }
                    type2 = ProblemHighlightType.INFORMATION;
                }
                TextRange range = this.getRange(statement, type2);
                if (isSetAll && ExplicitArrayFillingInspection.this.mySuggestSetAll && isOnTheFly) {
                    SetInspectionOptionFix disableForSetAllFix = new SetInspectionOptionFix((LocalInspectionTool)ExplicitArrayFillingInspection.this, "mySuggestSetAll", InspectionsBundle.message((String)"inspection.explicit.array.filling.no.suggestion.for.set.all", (Object[])new Object[0]), false);
                    holder.registerProblem((PsiElement)statement, message2, type2, range, new LocalQuickFix[]{fix2, disableForSetAllFix});
                    return;
                }
                holder.registerProblem((PsiElement)statement, message2, type2, range, new LocalQuickFix[]{fix2});
            }

            @NotNull
            private TextRange getRange(@NotNull PsiForStatement statement, @NotNull ProblemHighlightType type2) {
                if (statement == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (type2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                PsiStatement initialization = statement.getInitialization();
                LOG.assertTrue(initialization != null);
                TextRange range = TextRange.from((int)initialization.getStartOffsetInParent(), (int)initialization.getTextLength());
                boolean wholeStatement = isOnTheFly && (InspectionProjectProfileManager.isInformationLevel((String)ExplicitArrayFillingInspection.this.getShortName(), (PsiElement)statement) || type2 == ProblemHighlightType.INFORMATION);
                PsiJavaToken rParenth = statement.getRParenth();
                if (wholeStatement && rParenth != null) {
                    range = new TextRange(0, rParenth.getStartOffsetInParent() + 1);
                }
                TextRange textRange = range;
                if (textRange == null) {
                    1.$$$reportNull$$$0(3);
                }
                return textRange;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/ExplicitArrayFillingInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/ExplicitArrayFillingInspection$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRange";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "registerProblem";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getRange";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (javaElementVisitor == null) {
            ExplicitArrayFillingInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ExplicitArrayFillingInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ExplicitArrayFillingInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceWithArraysCallFix
    implements LocalQuickFix {
        private final boolean myIsRhsConstant;

        private ReplaceWithArraysCallFix(boolean isRhsConstant) {
            this.myIsRhsConstant = isRhsConstant;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.explicit.array.filling.fix.family.name", (Object[])new Object[]{this.myIsRhsConstant ? "fill" : "setAll"});
            if (string == null) {
                ReplaceWithArraysCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement result;
            PsiForStatement statement;
            if (project == null) {
                ReplaceWithArraysCallFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplaceWithArraysCallFix.$$$reportNull$$$0(2);
            }
            if ((statement = (PsiForStatement)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiForStatement.class)) == null) {
                return;
            }
            CountingLoop loop = CountingLoop.from(statement);
            if (loop == null) {
                return;
            }
            IndexedContainer container = IndexedContainer.fromLengthExpression(loop.getBound());
            if (container == null) {
                return;
            }
            PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)ControlFlowUtils.stripBraces(statement.getBody()));
            if (assignment == null) {
                return;
            }
            PsiExpression rValue = assignment.getRExpression();
            if (rValue == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            if (this.myIsRhsConstant) {
                String replacement = "java.util.Arrays.fill(" + ct.text((PsiElement)container.getQualifier()) + ", " + ct.text((PsiElement)rValue) + ");";
                result = ct.replaceAndRestoreComments((PsiElement)statement, replacement);
            } else {
                String replacement = "java.util.Arrays.setAll(" + ct.text((PsiElement)container.getQualifier()) + ", " + loop.getCounter().getName() + "->" + ct.text((PsiElement)rValue) + ");";
                result = ct.replaceAndRestoreComments((PsiElement)statement, replacement);
                LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
            }
            result = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
            CodeStyleManager.getInstance((Project)project).reformat(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ExplicitArrayFillingInspection$ReplaceWithArraysCallFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ExplicitArrayFillingInspection$ReplaceWithArraysCallFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

