/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SetInspectionOptionFix;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnhancedSwitchMigrationInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean myWarnOnlyOnExpressionConversion = false;
    private static final SwitchConversion[] ourInspections = new SwitchConversion[]{EnhancedSwitchMigrationInspection::inspectReturningSwitch, EnhancedSwitchMigrationInspection::inspectVariableAssigningSwitch, EnhancedSwitchMigrationInspection::inspectReplacementWithStatement};

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionsBundle.message((String)"inspection.switch.expression.migration.warn.only.on.expression", (Object[])new Object[0]), (InspectionProfileEntry)this, "myWarnOnlyOnExpressionConversion");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            EnhancedSwitchMigrationInspection.$$$reportNull$$$0(0);
        }
        if (!HighlightUtil.Feature.ENHANCED_SWITCH.isAvailable((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                EnhancedSwitchMigrationInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitSwitchStatement(PsiSwitchStatement statement) {
                SwitchReplacer replacer = EnhancedSwitchMigrationInspection.findSwitchReplacer(statement);
                if (replacer == null) {
                    return;
                }
                PsiElement switchKeyword = statement.getFirstChild();
                ProblemHighlightType type2 = EnhancedSwitchMigrationInspection.this.myWarnOnlyOnExpressionConversion && replacer.getType() == ReplacementType.Statement ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                ArrayList<Object> fixes = new ArrayList<Object>();
                fixes.add(new ReplaceWithSwitchExpressionFix(replacer.getType()));
                if (!EnhancedSwitchMigrationInspection.this.myWarnOnlyOnExpressionConversion && replacer.getType() == ReplacementType.Statement) {
                    fixes.add(new SetInspectionOptionFix((LocalInspectionTool)EnhancedSwitchMigrationInspection.this, "myWarnOnlyOnExpressionConversion", InspectionsBundle.message((String)"inspection.switch.expression.migration.warn.only.on.expression", (Object[])new Object[0]), true));
                }
                holder.registerProblem(switchKeyword, InspectionsBundle.message((String)"inspection.switch.expression.migration.inspection.switch.description", (Object[])new Object[0]), type2, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        };
        if (javaElementVisitor == null) {
            EnhancedSwitchMigrationInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    @Nullable
    private static SwitchReplacer runInspections(PsiStatement statement, PsiExpression condition2, boolean isExhaustive, List<? extends OldSwitchStatementBranch> branches) {
        for (SwitchConversion inspection : ourInspections) {
            SwitchReplacer replacer = inspection.suggestReplacer(statement, condition2, branches, isExhaustive);
            if (replacer == null) continue;
            return replacer;
        }
        return null;
    }

    private static OldSwitchStatementBranch addBranch(List<? super OldSwitchStatementBranch> branches, PsiStatement[] statements, int unmatchedCaseIndex, int endIndexExcl, boolean isFallthrough, PsiBreakStatement current) {
        PsiSwitchLabelStatement labelStatement = (PsiSwitchLabelStatement)statements[unmatchedCaseIndex];
        PsiStatement[] branchStatements = Arrays.copyOfRange(statements, unmatchedCaseIndex + 1, endIndexExcl);
        OldSwitchStatementBranch branch = new OldSwitchStatementBranch(isFallthrough, branchStatements, labelStatement, current);
        branches.add(branch);
        return branch;
    }

    @Nullable
    private static List<OldSwitchStatementBranch> extractBranches(@NotNull PsiCodeBlock body2) {
        if (body2 == null) {
            EnhancedSwitchMigrationInspection.$$$reportNull$$$0(3);
        }
        ArrayList<OldSwitchStatementBranch> branches = new ArrayList<OldSwitchStatementBranch>();
        PsiStatement[] statements = body2.getStatements();
        int unmatchedCaseIndex = -1;
        OldSwitchStatementBranch previousBranch = null;
        int length = statements.length;
        for (int i = 0; i < length; ++i) {
            PsiStatement current = statements[i];
            if (current instanceof PsiSwitchLabelStatement) {
                if (unmatchedCaseIndex != -1) {
                    boolean isFallthrough = i != 0 && ControlFlowUtils.statementMayCompleteNormally(statements[i - 1]);
                    OldSwitchStatementBranch newBranch = EnhancedSwitchMigrationInspection.addBranch(branches, statements, unmatchedCaseIndex, i, isFallthrough, null);
                    newBranch.myPreviousSwitchBranch = previousBranch;
                    previousBranch = newBranch;
                }
                unmatchedCaseIndex = i;
                continue;
            }
            if (current instanceof PsiBreakStatement) {
                if (unmatchedCaseIndex == -1) {
                    return null;
                }
                OldSwitchStatementBranch newBranch = EnhancedSwitchMigrationInspection.addBranch(branches, statements, unmatchedCaseIndex, i, false, (PsiBreakStatement)current);
                newBranch.myPreviousSwitchBranch = previousBranch;
                previousBranch = newBranch;
                unmatchedCaseIndex = -1;
                continue;
            }
            if (!(current instanceof PsiSwitchLabeledRuleStatement)) continue;
            return null;
        }
        if (unmatchedCaseIndex != -1) {
            OldSwitchStatementBranch branch = EnhancedSwitchMigrationInspection.addBranch(branches, statements, unmatchedCaseIndex, statements.length, false, null);
            branch.myPreviousSwitchBranch = previousBranch;
        }
        return branches;
    }

    @Nullable
    public static SwitchReplacer findSwitchReplacer(PsiSwitchStatement switchStatement) {
        PsiExpression expression2 = switchStatement.getExpression();
        if (expression2 == null) {
            return null;
        }
        PsiCodeBlock body2 = switchStatement.getBody();
        if (body2 == null) {
            return null;
        }
        List<OldSwitchStatementBranch> branches = EnhancedSwitchMigrationInspection.extractBranches(body2);
        if (branches == null || branches.isEmpty()) {
            return null;
        }
        boolean isExhaustive = EnhancedSwitchMigrationInspection.isExhaustiveSwitch(branches, expression2);
        return EnhancedSwitchMigrationInspection.runInspections((PsiStatement)switchStatement, expression2, isExhaustive, branches);
    }

    @Nullable
    private static PsiSwitchBlock generateEnhancedSwitch(@NotNull PsiStatement statementToReplace, PsiExpression expressionBeingSwitched, List<? extends SwitchExpressionBranch> newBranches, CommentTracker mainCommentTracker, boolean isExpr) {
        if (statementToReplace == null) {
            EnhancedSwitchMigrationInspection.$$$reportNull$$$0(4);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)statementToReplace.getProject());
        mainCommentTracker.markUnchanged(expressionBeingSwitched);
        if (!(statementToReplace instanceof PsiSwitchStatement)) {
            return null;
        }
        PsiCodeBlock body2 = ((PsiSwitchStatement)statementToReplace).getBody();
        if (body2 == null) {
            return null;
        }
        for (PsiStatement statement : body2.getStatements()) {
            mainCommentTracker.markUnchanged(statement);
        }
        StringBuilder sb = new StringBuilder().append("switch(").append(expressionBeingSwitched.getText()).append("){\n");
        int size = newBranches.size();
        ArrayList<CommentTracker> branchTrackers = new ArrayList<CommentTracker>(newBranches.size());
        for (int i = 0; i < size; ++i) {
            SwitchExpressionBranch newBranch = newBranches.get(i);
            CommentTracker ct = new CommentTracker();
            branchTrackers.add(ct);
            sb.append(newBranch.generate(ct));
            if (i == size - 1) continue;
            sb.append("\n");
        }
        sb.append("\n}");
        PsiSwitchBlock switchBlock = isExpr ? (PsiSwitchBlock)factory.createExpressionFromText(sb.toString(), (PsiElement)statementToReplace) : (PsiSwitchBlock)factory.createStatementFromText(sb.toString(), (PsiElement)statementToReplace);
        PsiCodeBlock resultBody = switchBlock.getBody();
        PsiSwitchLabeledRuleStatement[] labeledStatements = (PsiSwitchLabeledRuleStatement[])PsiTreeUtil.getChildrenOfType((PsiElement)resultBody, PsiSwitchLabeledRuleStatement.class);
        if (labeledStatements == null || labeledStatements.length != size) {
            return switchBlock;
        }
        for (int i = 0; i < labeledStatements.length; ++i) {
            PsiSwitchLabeledRuleStatement labeledStatement = labeledStatements[i];
            ((CommentTracker)branchTrackers.get(i)).insertCommentsBefore((PsiElement)labeledStatement);
        }
        return switchBlock;
    }

    private static boolean isExhaustiveSwitch(List<? extends OldSwitchStatementBranch> branches, PsiExpression expressionBeingSwitched) {
        for (OldSwitchStatementBranch oldSwitchStatementBranch : branches) {
            if (!oldSwitchStatementBranch.isDefault()) continue;
            return true;
        }
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expressionBeingSwitched.getType());
        if (aClass == null || !aClass.isEnum()) {
            return false;
        }
        Set set = StreamEx.of((Object[])aClass.getAllFields()).select(PsiEnumConstant.class).map(PsiNamedElement::getName).toSet();
        for (OldSwitchStatementBranch oldSwitchStatementBranch : branches) {
            for (PsiExpression caseValue : oldSwitchStatementBranch.getCurrentBranchCaseExpressions()) {
                PsiEnumConstant enumConstant;
                PsiReferenceExpression reference = (PsiReferenceExpression)ObjectUtils.tryCast((Object)caseValue, PsiReferenceExpression.class);
                if (reference == null || (enumConstant = (PsiEnumConstant)ObjectUtils.tryCast((Object)reference.resolve(), PsiEnumConstant.class)) == null) continue;
                set.remove(enumConstant.getName());
            }
        }
        return set.isEmpty();
    }

    private static boolean isConvertibleBranch(OldSwitchStatementBranch branch, boolean allowMultipleStatements) {
        int length = branch.getStatements().length;
        if (length == 0) {
            return branch.isFallthrough();
        }
        if (branch.isFallthrough()) {
            return false;
        }
        if (allowMultipleStatements) {
            return true;
        }
        return length == 1;
    }

    @Nullable
    private static SwitchReplacer inspectReturningSwitch(@NotNull PsiStatement statement, @NotNull PsiExpression expressionBeingSwitched, @NotNull List<? extends OldSwitchStatementBranch> branches, boolean isExhaustive) {
        PsiReturnStatement returnAfterSwitch;
        if (statement == null) {
            EnhancedSwitchMigrationInspection.$$$reportNull$$$0(5);
        }
        if (expressionBeingSwitched == null) {
            EnhancedSwitchMigrationInspection.$$$reportNull$$$0(6);
        }
        if (branches == null) {
            EnhancedSwitchMigrationInspection.$$$reportNull$$$0(7);
        }
        if ((returnAfterSwitch = (PsiReturnStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class), PsiReturnStatement.class)) == null && !isExhaustive) {
            return null;
        }
        ArrayList<SwitchExpressionBranch> newBranches = new ArrayList<SwitchExpressionBranch>();
        boolean hasReturningBranch = false;
        for (OldSwitchStatementBranch oldSwitchStatementBranch : branches) {
            SwitchRuleResult result;
            if (!EnhancedSwitchMigrationInspection.isConvertibleBranch(oldSwitchStatementBranch, false)) {
                return null;
            }
            if (oldSwitchStatementBranch.isFallthrough()) continue;
            PsiStatement[] statements = oldSwitchStatementBranch.getStatements();
            if (statements.length != 1) {
                return null;
            }
            PsiReturnStatement returnStmt = (PsiReturnStatement)ObjectUtils.tryCast((Object)statements[0], PsiReturnStatement.class);
            if (returnStmt == null) {
                PsiThrowStatement throwStatement = (PsiThrowStatement)ObjectUtils.tryCast((Object)statements[0], PsiThrowStatement.class);
                if (throwStatement == null) {
                    return null;
                }
                result = new SwitchStatementBranch(new PsiStatement[]{throwStatement});
            } else {
                PsiExpression returnExpr = returnStmt.getReturnValue();
                if (returnExpr == null) {
                    return null;
                }
                result = new SwitchRuleExpressionResult(returnExpr);
                hasReturningBranch = true;
            }
            newBranches.add(new SwitchExpressionBranch(oldSwitchStatementBranch.isDefault(), oldSwitchStatementBranch.getCaseExpressions(), result, oldSwitchStatementBranch.getUsedElements()));
        }
        if (!hasReturningBranch) {
            return null;
        }
        if (!isExhaustive) {
            PsiExpression returnExpr = returnAfterSwitch.getReturnValue();
            if (returnExpr == null) {
                return null;
            }
            newBranches.add(new SwitchExpressionBranch(true, Collections.emptyList(), new SwitchRuleExpressionResult(returnExpr), Collections.emptyList()));
        }
        return new ReturningSwitchReplacer(statement, expressionBeingSwitched, newBranches, returnAfterSwitch);
    }

    @Nullable
    private static SwitchReplacer inspectVariableAssigningSwitch(@NotNull PsiStatement statement, @NotNull PsiExpression expressionBeingSwitched, @NotNull List<? extends OldSwitchStatementBranch> branches, boolean isExhaustive) {
        PsiElement parent;
        if (statement == null) {
            EnhancedSwitchMigrationInspection.$$$reportNull$$$0(8);
        }
        if (expressionBeingSwitched == null) {
            EnhancedSwitchMigrationInspection.$$$reportNull$$$0(9);
        }
        if (branches == null) {
            EnhancedSwitchMigrationInspection.$$$reportNull$$$0(10);
        }
        PsiElement anchor = (parent = statement.getParent()) instanceof PsiLabeledStatement ? parent : statement;
        PsiLocalVariable assignedVariable = null;
        ArrayList<SwitchExpressionBranch> newBranches = new ArrayList<SwitchExpressionBranch>();
        boolean hasAssignedBranch = false;
        boolean wasDefault = false;
        for (OldSwitchStatementBranch oldSwitchStatementBranch : branches) {
            SwitchRuleResult result;
            if (!EnhancedSwitchMigrationInspection.isConvertibleBranch(oldSwitchStatementBranch, false)) {
                return null;
            }
            if (oldSwitchStatementBranch.isFallthrough() && oldSwitchStatementBranch.getStatements().length == 0) continue;
            PsiStatement first = oldSwitchStatementBranch.getStatements()[0];
            PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)first);
            PsiExpression rExpression = null;
            if (assignment != null) {
                rExpression = assignment.getRExpression();
                PsiLocalVariable var = ExpressionUtils.resolveLocalVariable(assignment.getLExpression());
                if (var == null) {
                    return null;
                }
                if (assignedVariable == null) {
                    assignedVariable = var;
                } else if (assignedVariable != var) {
                    return null;
                }
            }
            if (rExpression == null) {
                PsiThrowStatement throwStatement = (PsiThrowStatement)ObjectUtils.tryCast((Object)first, PsiThrowStatement.class);
                if (throwStatement == null) {
                    return null;
                }
                result = new SwitchStatementBranch(new PsiStatement[]{throwStatement});
            } else {
                hasAssignedBranch = true;
                result = new SwitchRuleExpressionResult(rExpression);
            }
            boolean isDefault = oldSwitchStatementBranch.isDefault();
            if (isDefault) {
                wasDefault = true;
            }
            newBranches.add(new SwitchExpressionBranch(isDefault, oldSwitchStatementBranch.getCaseExpressions(), result, oldSwitchStatementBranch.getRelatedStatements()));
        }
        if (assignedVariable == null || !hasAssignedBranch) {
            return null;
        }
        PsiExpression initializer = assignedVariable.getInitializer();
        if (initializer != null && !wasDefault) {
            newBranches.add(new SwitchExpressionBranch(true, Collections.emptyList(), new SwitchRuleExpressionResult(initializer), Collections.emptyList()));
        } else if (!isExhaustive) {
            return null;
        }
        boolean bl = EnhancedSwitchMigrationInspection.isRightAfterDeclaration(anchor, assignedVariable);
        return new SwitchExistingVariableReplacer((PsiVariable)assignedVariable, statement, expressionBeingSwitched, newBranches, bl);
    }

    private static boolean isRightAfterDeclaration(PsiElement anchor, PsiVariable assignedVariable) {
        PsiLocalVariable localVariable;
        PsiElement[] elements;
        PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.getPrevSiblingOfType((PsiElement)anchor, PsiStatement.class), PsiDeclarationStatement.class);
        return declaration2 != null && (elements = declaration2.getDeclaredElements()).length == 1 && (localVariable = (PsiLocalVariable)ObjectUtils.tryCast((Object)elements[0], PsiLocalVariable.class)) != null && localVariable == assignedVariable;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static SwitchReplacer inspectReplacementWithStatement(@NotNull PsiStatement statement, @NotNull PsiExpression expressionBeingSwitched, @NotNull List<? extends OldSwitchStatementBranch> branches, boolean isExhaustive) {
        void var5_7;
        if (statement == null) {
            EnhancedSwitchMigrationInspection.$$$reportNull$$$0(11);
        }
        if (expressionBeingSwitched == null) {
            EnhancedSwitchMigrationInspection.$$$reportNull$$$0(12);
        }
        if (branches == null) {
            EnhancedSwitchMigrationInspection.$$$reportNull$$$0(13);
        }
        for (OldSwitchStatementBranch oldSwitchStatementBranch : branches) {
            if (EnhancedSwitchMigrationInspection.isConvertibleBranch(oldSwitchStatementBranch, true)) continue;
            return null;
        }
        ArrayList<SwitchExpressionBranch> switchRules = new ArrayList<SwitchExpressionBranch>();
        boolean bl = false;
        int branchesSize = branches.size();
        while (var5_7 < branchesSize) {
            OldSwitchStatementBranch branch = branches.get((int)var5_7);
            if (!branch.isFallthrough() || branch.getStatements().length != 0) {
                boolean allBranchRefsWillBeValid = ((StreamEx)StreamEx.of((Object[])branch.getStatements()).limit((long)var5_7)).flatMap(stmt -> StreamEx.ofTree((Object)stmt, el -> StreamEx.of((Object[])el.getChildren()))).select(PsiReferenceExpression.class).map(PsiReference::resolve).select(PsiLocalVariable.class).allMatch(variable -> EnhancedSwitchMigrationInspection.isInBranchOrOutside(statement, branch, variable));
                if (!allBranchRefsWillBeValid) {
                    return null;
                }
                if (!branch.isFallthrough() || branch.getStatements().length != 0) {
                    PsiStatement first;
                    PsiStatement[] statements = branch.getStatements();
                    if (!(statements.length != 1 || (first = statements[0]) instanceof PsiExpressionStatement || first instanceof PsiBlockStatement || first instanceof PsiThrowStatement)) {
                        return null;
                    }
                    switchRules.add(new SwitchExpressionBranch(branch.isDefault(), branch.getCaseExpressions(), new SwitchStatementBranch(statements), branch.getRelatedStatements()));
                }
            }
            ++var5_7;
        }
        return new SwitchStatementReplacer(statement, expressionBeingSwitched, switchRules);
    }

    private static boolean isInBranchOrOutside(@NotNull PsiStatement switchStmt, OldSwitchStatementBranch branch, PsiLocalVariable variable) {
        if (switchStmt == null) {
            EnhancedSwitchMigrationInspection.$$$reportNull$$$0(14);
        }
        return !PsiTreeUtil.isAncestor((PsiElement)switchStmt, (PsiElement)variable, (boolean)false) || StreamEx.of((Object[])branch.getStatements()).anyMatch(stmt -> PsiTreeUtil.isAncestor((PsiElement)stmt, (PsiElement)variable, (boolean)false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/EnhancedSwitchMigrationInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementToReplace";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionBeingSwitched";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branches";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStmt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/EnhancedSwitchMigrationInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extractBranches";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateEnhancedSwitch";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "inspectReturningSwitch";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "inspectVariableAssigningSwitch";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "inspectReplacementWithStatement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInBranchOrOutside";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OldSwitchStatementBranch {
        final boolean myIsFallthrough;
        @NotNull
        final PsiStatement[] myStatements;
        @NotNull
        final PsiSwitchLabelStatement myLabelStatement;
        @Nullable
        final PsiBreakStatement myBreakStatement;
        @Nullable
        OldSwitchStatementBranch myPreviousSwitchBranch;

        private OldSwitchStatementBranch(boolean isFallthrough, @NotNull PsiStatement[] statements, @NotNull PsiSwitchLabelStatement switchLabelStatement, @Nullable PsiBreakStatement breakStatement) {
            if (statements == null) {
                OldSwitchStatementBranch.$$$reportNull$$$0(0);
            }
            if (switchLabelStatement == null) {
                OldSwitchStatementBranch.$$$reportNull$$$0(1);
            }
            this.myPreviousSwitchBranch = null;
            this.myIsFallthrough = isFallthrough;
            this.myStatements = statements;
            this.myLabelStatement = switchLabelStatement;
            this.myBreakStatement = breakStatement;
        }

        public boolean isDefault() {
            return this.myLabelStatement.isDefaultCase();
        }

        public boolean isFallthrough() {
            return this.myIsFallthrough;
        }

        public List<PsiExpression> getCaseExpressions() {
            List<OldSwitchStatementBranch> branches = this.getWithFallthroughBranches();
            Collections.reverse(branches);
            return StreamEx.of(branches).flatMap(branch -> {
                PsiExpressionList caseValues2 = branch.myLabelStatement.getCaseValues();
                if (caseValues2 == null) {
                    return StreamEx.empty();
                }
                return StreamEx.of((Object[])caseValues2.getExpressions());
            }).toList();
        }

        public List<PsiExpression> getCurrentBranchCaseExpressions() {
            PsiExpressionList caseValues2 = this.myLabelStatement.getCaseValues();
            if (caseValues2 == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(caseValues2.getExpressions());
        }

        public PsiStatement[] getStatements() {
            return this.myStatements;
        }

        public List<PsiStatement> getRelatedStatements() {
            StreamEx withoutBreak = StreamEx.of((Object[])this.myStatements).prepend((Object)this.myLabelStatement);
            return withoutBreak.prepend((Object)this.myBreakStatement).toList();
        }

        private List<OldSwitchStatementBranch> getWithFallthroughBranches() {
            ArrayList<OldSwitchStatementBranch> withPrevious = new ArrayList<OldSwitchStatementBranch>();
            OldSwitchStatementBranch current = this;
            do {
                withPrevious.add(current);
            } while ((current = current.myPreviousSwitchBranch) != null && current.myStatements.length == 0);
            return withPrevious;
        }

        public List<? extends PsiElement> getUsedElements() {
            return StreamEx.of(this.getWithFallthroughBranches()).flatMap(branch -> StreamEx.of(branch.getRelatedStatements())).toList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "statements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "switchLabelStatement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/EnhancedSwitchMigrationInspection$OldSwitchStatementBranch";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SwitchExpressionBranch {
        final boolean myIsDefault;
        final List<? extends PsiExpression> myCaseExpressions;
        @NotNull
        final List<? extends PsiElement> myUsedElements;
        private final SwitchRuleResult myRuleResult;

        private SwitchExpressionBranch(boolean isDefault, List<? extends PsiExpression> caseExpressions, SwitchRuleResult ruleResult, @NotNull List<? extends PsiElement> usedElements) {
            if (usedElements == null) {
                SwitchExpressionBranch.$$$reportNull$$$0(0);
            }
            this.myIsDefault = isDefault;
            this.myCaseExpressions = caseExpressions;
            this.myRuleResult = ruleResult;
            this.myUsedElements = usedElements;
        }

        String generate(CommentTracker ct) {
            StringBuilder sb = new StringBuilder();
            if (this.myIsDefault) {
                sb.append("default");
            } else {
                sb.append("case ");
                sb.append(StreamEx.of(this.myCaseExpressions).map(ct::text).joining((CharSequence)","));
            }
            sb.append("->");
            sb.append(this.myRuleResult.generate(ct));
            for (PsiElement psiElement : this.myUsedElements) {
                ct.grabComments(psiElement);
            }
            return sb.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usedElements", "com/intellij/codeInspection/EnhancedSwitchMigrationInspection$SwitchExpressionBranch", "<init>"));
        }
    }

    private static class SwitchRuleExpressionResult
    implements SwitchRuleResult {
        private final PsiExpression myExpression;

        private SwitchRuleExpressionResult(PsiExpression expression2) {
            this.myExpression = expression2;
        }

        @Override
        public String generate(CommentTracker ct) {
            return ct.text((PsiElement)this.myExpression) + ";";
        }
    }

    private static class SwitchStatementBranch
    implements SwitchRuleResult {
        final PsiStatement[] myResultStatements;

        private SwitchStatementBranch(PsiStatement[] resultStatements) {
            this.myResultStatements = resultStatements;
        }

        @Override
        public String generate(CommentTracker ct) {
            if (this.myResultStatements.length == 1) {
                return ct.text((PsiElement)this.myResultStatements[0]);
            }
            return StreamEx.of((Object[])this.myResultStatements).map(ct::text).joining((CharSequence)"\n", (CharSequence)"{\n", (CharSequence)"}");
        }
    }

    private static class SwitchStatementReplacer
    implements SwitchReplacer {
        @NotNull
        final PsiStatement myStatement;
        @NotNull
        final PsiExpression myExpressionBeingSwitched;
        @NotNull
        final List<? extends SwitchExpressionBranch> myExpressionBranches;

        private SwitchStatementReplacer(@NotNull PsiStatement statement, @NotNull PsiExpression expressionBeingSwitched, @NotNull List<? extends SwitchExpressionBranch> ruleResults) {
            if (statement == null) {
                SwitchStatementReplacer.$$$reportNull$$$0(0);
            }
            if (expressionBeingSwitched == null) {
                SwitchStatementReplacer.$$$reportNull$$$0(1);
            }
            if (ruleResults == null) {
                SwitchStatementReplacer.$$$reportNull$$$0(2);
            }
            this.myStatement = statement;
            this.myExpressionBeingSwitched = expressionBeingSwitched;
            this.myExpressionBranches = ruleResults;
        }

        @Override
        public void replace(@NotNull PsiStatement switchStatement) {
            CommentTracker commentTracker;
            PsiSwitchBlock switchBlock;
            if (switchStatement == null) {
                SwitchStatementReplacer.$$$reportNull$$$0(3);
            }
            if ((switchBlock = EnhancedSwitchMigrationInspection.generateEnhancedSwitch(switchStatement, this.myExpressionBeingSwitched, this.myExpressionBranches, commentTracker = new CommentTracker(), false)) == null) {
                return;
            }
            commentTracker.replaceAndRestoreComments((PsiElement)switchStatement, (PsiElement)switchBlock);
        }

        @Override
        public ReplacementType getType() {
            return ReplacementType.Statement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressionBeingSwitched";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ruleResults";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switchStatement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/EnhancedSwitchMigrationInspection$SwitchStatementReplacer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replace";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SwitchExistingVariableReplacer
    implements SwitchReplacer {
        @NotNull
        final PsiVariable myVariableToAssign;
        @NotNull
        final PsiStatement myStatement;
        @NotNull
        final PsiExpression myExpressionBeingSwitched;
        final List<? extends SwitchExpressionBranch> myNewBranches;
        final boolean myIsRightAfterDeclaration;

        private SwitchExistingVariableReplacer(@NotNull PsiVariable variableToAssign, @NotNull PsiStatement statement, @NotNull PsiExpression expressionBeingSwitched, List<? extends SwitchExpressionBranch> newBranches, boolean isRightAfterDeclaration) {
            if (variableToAssign == null) {
                SwitchExistingVariableReplacer.$$$reportNull$$$0(0);
            }
            if (statement == null) {
                SwitchExistingVariableReplacer.$$$reportNull$$$0(1);
            }
            if (expressionBeingSwitched == null) {
                SwitchExistingVariableReplacer.$$$reportNull$$$0(2);
            }
            this.myVariableToAssign = variableToAssign;
            this.myStatement = statement;
            this.myExpressionBeingSwitched = expressionBeingSwitched;
            this.myNewBranches = newBranches;
            this.myIsRightAfterDeclaration = isRightAfterDeclaration;
        }

        @Override
        public void replace(@NotNull PsiStatement switchStatement) {
            if (switchStatement == null) {
                SwitchExistingVariableReplacer.$$$reportNull$$$0(3);
            }
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)ObjectUtils.tryCast((Object)switchStatement.getParent(), PsiLabeledStatement.class);
            CommentTracker commentTracker = new CommentTracker();
            PsiSwitchBlock replacement = EnhancedSwitchMigrationInspection.generateEnhancedSwitch(switchStatement, this.myExpressionBeingSwitched, this.myNewBranches, commentTracker, true);
            if (replacement == null) {
                return;
            }
            PsiExpression initializer = this.myVariableToAssign.getInitializer();
            if (this.myIsRightAfterDeclaration) {
                List<PsiExpression> sideEffectExpressions;
                PsiStatement[] sideEffectStatements;
                if (initializer != null && (sideEffectStatements = StatementExtractor.generateStatements(sideEffectExpressions = SideEffectChecker.extractSideEffectExpressions(initializer), initializer)).length > 0) {
                    PsiStatement statement = (PsiStatement)ObjectUtils.tryCast((Object)this.myVariableToAssign.getParent(), PsiStatement.class);
                    if (statement == null) {
                        return;
                    }
                    BlockUtils.addBefore(statement, sideEffectStatements);
                }
                this.myVariableToAssign.setInitializer((PsiExpression)((PsiSwitchExpression)replacement));
                commentTracker.delete((PsiElement)switchStatement);
                commentTracker.insertCommentsBefore((PsiElement)this.myVariableToAssign);
                if (labeledStatement != null) {
                    new CommentTracker().deleteAndRestoreComments((PsiElement)labeledStatement);
                }
            } else {
                String text2 = this.myVariableToAssign.getName() + "=" + replacement.getText() + ";";
                PsiLabeledStatement statementToReplace = labeledStatement != null ? labeledStatement : switchStatement;
                commentTracker.replaceAndRestoreComments((PsiElement)statementToReplace, text2);
            }
        }

        @Override
        public ReplacementType getType() {
            return ReplacementType.Expression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variableToAssign";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressionBeingSwitched";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switchStatement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/EnhancedSwitchMigrationInspection$SwitchExistingVariableReplacer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replace";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ReturningSwitchReplacer
    implements SwitchReplacer {
        @NotNull
        final PsiStatement myStatement;
        @NotNull
        final PsiExpression myExpressionBeingSwitched;
        final List<? extends SwitchExpressionBranch> myNewBranches;
        @Nullable
        final PsiReturnStatement myReturnToDelete;

        private ReturningSwitchReplacer(@NotNull PsiStatement statement, @NotNull PsiExpression expressionBeingSwitched, List<? extends SwitchExpressionBranch> newBranches, @Nullable PsiReturnStatement returnToDelete) {
            if (statement == null) {
                ReturningSwitchReplacer.$$$reportNull$$$0(0);
            }
            if (expressionBeingSwitched == null) {
                ReturningSwitchReplacer.$$$reportNull$$$0(1);
            }
            this.myStatement = statement;
            this.myExpressionBeingSwitched = expressionBeingSwitched;
            this.myNewBranches = newBranches;
            this.myReturnToDelete = returnToDelete;
        }

        @Override
        public void replace(@NotNull PsiStatement statement) {
            CommentTracker commentTracker;
            PsiSwitchBlock switchBlock;
            if (statement == null) {
                ReturningSwitchReplacer.$$$reportNull$$$0(2);
            }
            if ((switchBlock = EnhancedSwitchMigrationInspection.generateEnhancedSwitch(statement, this.myExpressionBeingSwitched, this.myNewBranches, commentTracker = new CommentTracker(), true)) == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)statement.getProject());
            PsiStatement returnStatement = factory.createStatementFromText("return " + switchBlock.getText() + ";", (PsiElement)switchBlock);
            commentTracker.replaceAndRestoreComments((PsiElement)statement, (PsiElement)returnStatement);
            if (this.myReturnToDelete != null) {
                CommentTracker ct = new CommentTracker();
                ct.markUnchanged(this.myReturnToDelete.getReturnValue());
                ct.deleteAndRestoreComments((PsiElement)this.myReturnToDelete);
            }
        }

        @Override
        public ReplacementType getType() {
            return ReplacementType.Expression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressionBeingSwitched";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/EnhancedSwitchMigrationInspection$ReturningSwitchReplacer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replace";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ReplaceWithSwitchExpressionFix
    implements LocalQuickFix {
        private final ReplacementType myReplacementType;

        ReplaceWithSwitchExpressionFix(ReplacementType replacementType) {
            this.myReplacementType = replacementType;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = this.myReplacementType.getFixName();
            if (string == null) {
                ReplaceWithSwitchExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiSwitchStatement statement;
            if (project == null) {
                ReplaceWithSwitchExpressionFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplaceWithSwitchExpressionFix.$$$reportNull$$$0(2);
            }
            if ((statement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiSwitchStatement.class)) == null) {
                return;
            }
            SwitchReplacer replacer = EnhancedSwitchMigrationInspection.findSwitchReplacer(statement);
            if (replacer == null) {
                return;
            }
            replacer.replace((PsiStatement)statement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/EnhancedSwitchMigrationInspection$ReplaceWithSwitchExpressionFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/EnhancedSwitchMigrationInspection$ReplaceWithSwitchExpressionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface SwitchRuleResult {
        public String generate(CommentTracker var1);
    }

    private static interface SwitchConversion {
        @Nullable
        public SwitchReplacer suggestReplacer(@NotNull PsiStatement var1, @NotNull PsiExpression var2, @NotNull List<? extends OldSwitchStatementBranch> var3, boolean var4);
    }

    public static interface SwitchReplacer {
        public void replace(@NotNull PsiStatement var1);

        public ReplacementType getType();
    }

    private static enum ReplacementType {
        Expression("inspection.replace.with.switch.expression.fix.name"),
        Statement("inspection.replace.with.enhanced.switch.statement.fix.name");

        private final String key;

        private ReplacementType(String key2) {
            this.key = key2;
        }

        String getFixName() {
            return InspectionsBundle.message((String)this.key, (Object[])new Object[0]);
        }
    }
}

