/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.migration.TryWithIdenticalCatchesInspection;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.SwitchUtils;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateBranchesInSwitchInspection
extends LocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(DuplicateBranchesInSwitchInspection.class);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(0);
        }
        DuplicateBranchesVisitor duplicateBranchesVisitor = new DuplicateBranchesVisitor(holder);
        if (duplicateBranchesVisitor == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(1);
        }
        return duplicateBranchesVisitor;
    }

    @NotNull
    private static Collection<List<Rule>> collectProbablySimilarRules(@NotNull PsiSwitchBlock switchBlock) {
        PsiCodeBlock switchBody;
        if (switchBlock == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(2);
        }
        if ((switchBody = switchBlock.getBody()) == null) {
            List<List<Rule>> list = Collections.emptyList();
            if (list == null) {
                DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(3);
            }
            return list;
        }
        TIntObjectHashMap rulesByHash = new TIntObjectHashMap();
        ArrayList commentTexts = new ArrayList();
        for (PsiElement element = switchBody.getFirstChild(); element != null; element = element.getNextSibling()) {
            if (!(element instanceof PsiSwitchLabeledRuleStatement)) {
                TryWithIdenticalCatchesInspection.collectCommentTexts(element, commentTexts);
                continue;
            }
            PsiSwitchLabeledRuleStatement ruleStatement = (PsiSwitchLabeledRuleStatement)element;
            PsiStatement body2 = ruleStatement.getBody();
            if (body2 == null) continue;
            TryWithIdenticalCatchesInspection.collectCommentTexts((PsiElement)ruleStatement, commentTexts);
            Rule rule = new Rule(ruleStatement, body2, ArrayUtilRt.toStringArray(commentTexts));
            commentTexts.clear();
            int hash = rule.hash();
            ArrayList<Rule> list = (ArrayList<Rule>)rulesByHash.get(hash);
            if (list == null) {
                list = new ArrayList<Rule>();
                rulesByHash.put(hash, list);
            }
            list.add(rule);
        }
        ArrayList<List<Rule>> result = new ArrayList<List<Rule>>();
        rulesByHash.forEachValue(result::add);
        ArrayList<List<Rule>> arrayList = result;
        if (arrayList == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    static Collection<List<Branch>> collectProbablySimilarBranches(@NotNull PsiSwitchBlock switchBlock) {
        PsiCodeBlock body2;
        if (switchBlock == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(5);
        }
        if ((body2 = switchBlock.getBody()) == null) {
            List<List<Branch>> list = Collections.emptyList();
            if (list == null) {
                DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(6);
            }
            return list;
        }
        ArrayList<PsiStatement> statementList = null;
        Comments comments = new Comments();
        Branch previousBranch = null;
        TIntObjectHashMap branchesByHash = new TIntObjectHashMap();
        for (PsiElement child = body2.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiSwitchLabelStatement) {
                PsiSwitchLabelStatement switchLabel = (PsiSwitchLabelStatement)child;
                previousBranch = DuplicateBranchesInSwitchInspection.addBranchToMap((TIntObjectHashMap<List<Branch>>)branchesByHash, statementList, DuplicateBranchesInSwitchInspection.hasImplicitBreak((PsiStatement)switchLabel), comments, previousBranch);
                statementList = null;
                comments.addFrom((PsiStatement)switchLabel);
                continue;
            }
            if (child instanceof PsiStatement) {
                PsiStatement statement = (PsiStatement)child;
                if (statementList == null) {
                    statementList = new ArrayList<PsiStatement>();
                }
                statementList.add(statement);
                comments.addFrom(statement);
                continue;
            }
            comments.addPending(child);
        }
        DuplicateBranchesInSwitchInspection.addBranchToMap((TIntObjectHashMap<List<Branch>>)branchesByHash, statementList, true, comments, previousBranch);
        ArrayList<List<Branch>> result = new ArrayList<List<Branch>>();
        branchesByHash.forEachValue(result::add);
        ArrayList<List<Branch>> arrayList = result;
        if (arrayList == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    private static Branch addBranchToMap(@NotNull TIntObjectHashMap<List<Branch>> branchesByHash, @Nullable List<PsiStatement> statementList, boolean hasImplicitBreak, @NotNull Comments comments, @Nullable Branch previousBranch) {
        if (branchesByHash == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(8);
        }
        if (comments == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(9);
        }
        if (statementList == null || statementList.isEmpty()) {
            return previousBranch;
        }
        PsiSwitchLabelStatement[] labels2 = Branch.collectLabels(statementList.get(0));
        if (labels2.length == 0) {
            return previousBranch;
        }
        Branch branch = new Branch(labels2, statementList, hasImplicitBreak, comments.fetchTexts());
        if (previousBranch == null || !previousBranch.canFallThrough()) {
            int hash = branch.hash();
            ArrayList<Branch> branches = (ArrayList<Branch>)branchesByHash.get(hash);
            if (branches == null) {
                branches = new ArrayList<Branch>();
                branchesByHash.put(hash, branches);
            }
            branches.add(branch);
        }
        return branch;
    }

    static boolean areDuplicates(@NotNull BranchBase branch, @NotNull BranchBase otherBranch) {
        Match otherMatch;
        if (branch == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(10);
        }
        if (otherBranch == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(11);
        }
        if (branch.isSimpleExit() != otherBranch.isSimpleExit() || branch.canFallThrough() != otherBranch.canFallThrough() || branch.effectiveLength() != otherBranch.effectiveLength()) {
            return false;
        }
        Match match = branch.match(otherBranch);
        if (match != null && (otherMatch = otherBranch.match(branch)) != null) {
            if (branch.isSimpleExit() && otherBranch.isSimpleExit() && !Arrays.equals(branch.myCommentTexts, otherBranch.myCommentTexts)) {
                return false;
            }
            return ReturnValue.areEquivalent(match.getReturnValue(), otherMatch.getReturnValue());
        }
        return false;
    }

    private static boolean hasImplicitBreak(@NotNull PsiStatement statement) {
        if (statement == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(12);
        }
        while (statement instanceof PsiSwitchLabelStatement) {
            statement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
        }
        return statement == null || DuplicateBranchesInSwitchInspection.isBreakWithoutLabel(statement);
    }

    @Contract(value="null -> false")
    private static boolean isBreakWithoutLabel(@Nullable PsiStatement statement) {
        return statement instanceof PsiBreakStatement && ((PsiBreakStatement)statement).getLabelExpression() == null;
    }

    @Contract(value="_,null -> false")
    private static boolean isRedundantComment(@NotNull Set<String> existingComments, @Nullable PsiElement element) {
        if (existingComments == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(13);
        }
        if (element instanceof PsiComment) {
            String text2 = TryWithIdenticalCatchesInspection.getCommentText((PsiComment)element);
            return text2.isEmpty() || existingComments.contains(text2);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchBlock";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchesByHash";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherBranch";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingComments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProbablySimilarRules";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProbablySimilarBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectProbablySimilarRules";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectProbablySimilarBranches";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addBranchToMap";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "areDuplicates";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasImplicitBreak";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isRedundantComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RuleFixContext {
        private Rule myRuleToDelete;
        private Rule myRuleToMergeWith;
        private Set<String> myCommentsToMergeWith;

        private RuleFixContext() {
        }

        boolean prepare(PsiElement startElement, Predicate<? super Rule> shouldMergeWith) {
            PsiSwitchBlock switchBlock;
            PsiSwitchLabeledRuleStatement ruleStatement;
            if (startElement != null && (ruleStatement = (PsiSwitchLabeledRuleStatement)ObjectUtils.tryCast((Object)startElement.getParent(), PsiSwitchLabeledRuleStatement.class)) != null && (switchBlock = ruleStatement.getEnclosingSwitchBlock()) != null) {
                List candidateRules = null;
                for (List rules : DuplicateBranchesInSwitchInspection.collectProbablySimilarRules(switchBlock)) {
                    this.myRuleToDelete = (Rule)ContainerUtil.find((Iterable)rules, r -> r.myLabel == ruleStatement);
                    if (this.myRuleToDelete == null) continue;
                    candidateRules = rules;
                    break;
                }
                if (candidateRules == null) {
                    return false;
                }
                for (Rule rule : candidateRules) {
                    if (!shouldMergeWith.test(rule)) continue;
                    this.myRuleToMergeWith = rule;
                    break;
                }
                if (this.myRuleToMergeWith == null) {
                    return false;
                }
            }
            this.myCommentsToMergeWith = ContainerUtil.set((Object[])this.myRuleToMergeWith.myCommentTexts);
            return true;
        }

        void copyCaseValues() {
            PsiExpressionList caseValuesToMergeWith = ((PsiSwitchLabeledRuleStatement)this.myRuleToMergeWith.myLabel).getCaseValues();
            PsiExpressionList caseValuesToDelete = ((PsiSwitchLabeledRuleStatement)this.myRuleToDelete.myLabel).getCaseValues();
            if (caseValuesToDelete != null && caseValuesToMergeWith != null) {
                for (PsiExpression caseValue : caseValuesToDelete.getExpressions()) {
                    caseValuesToMergeWith.addAfter((PsiElement)caseValue, caseValuesToMergeWith.getLastChild());
                }
            }
        }

        void deleteRule() {
            CommentTracker tracker = new CommentTracker();
            PsiTreeUtil.processElements((PsiElement)this.myRuleToDelete.myLabel, child -> {
                if (DuplicateBranchesInSwitchInspection.isRedundantComment(this.myCommentsToMergeWith, child)) {
                    tracker.markUnchanged(child);
                }
                return true;
            });
            tracker.deleteAndRestoreComments((PsiElement)this.myRuleToDelete.myLabel);
        }
    }

    private static class DeleteRedundantRuleFix
    implements LocalQuickFix {
        private DeleteRedundantRuleFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.duplicate.branches.in.switch.delete.fix.name", (Object[])new Object[0]);
            if (string == null) {
                DeleteRedundantRuleFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.duplicate.branches.in.switch.delete.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                DeleteRedundantRuleFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            RuleFixContext context;
            if (project == null) {
                DeleteRedundantRuleFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                DeleteRedundantRuleFix.$$$reportNull$$$0(3);
            }
            if ((context = new RuleFixContext()).prepare(descriptor.getStartElement(), BranchBase::isDefault)) {
                context.deleteRule();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$DeleteRedundantRuleFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$DeleteRedundantRuleFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MergeRulesFix
    implements LocalQuickFix {
        @NotNull
        private final String mySwitchLabelText;

        MergeRulesFix(@NotNull String switchLabelText) {
            if (switchLabelText == null) {
                MergeRulesFix.$$$reportNull$$$0(0);
            }
            this.mySwitchLabelText = switchLabelText;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.duplicate.branches.in.switch.merge.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MergeRulesFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.duplicate.branches.in.switch.merge.fix.name", (Object[])new Object[]{this.mySwitchLabelText});
            if (string == null) {
                MergeRulesFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            RuleFixContext context;
            if (project == null) {
                MergeRulesFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                MergeRulesFix.$$$reportNull$$$0(4);
            }
            if ((context = new RuleFixContext()).prepare(descriptor.getStartElement(), rule -> this.mySwitchLabelText.equals(rule.getSwitchLabelText()))) {
                context.copyCaseValues();
                context.deleteRule();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switchLabelText";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$MergeRulesFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$MergeRulesFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Rule
    extends BranchBase<PsiSwitchLabeledRuleStatement> {
        private final boolean myIsSimpleExit;

        Rule(@NotNull PsiSwitchLabeledRuleStatement rule, @NotNull PsiStatement body2, @NotNull String[] commentTexts) {
            if (rule == null) {
                Rule.$$$reportNull$$$0(0);
            }
            if (body2 == null) {
                Rule.$$$reportNull$$$0(1);
            }
            if (commentTexts == null) {
                Rule.$$$reportNull$$$0(2);
            }
            super((PsiSwitchLabelStatementBase[])new PsiSwitchLabeledRuleStatement[]{rule}, new PsiStatement[]{body2}, commentTexts);
            this.myIsSimpleExit = body2 instanceof PsiExpressionStatement || body2 instanceof PsiThrowStatement;
        }

        @Override
        boolean isSimpleExit() {
            return this.myIsSimpleExit;
        }

        @Override
        boolean canFallThrough() {
            return false;
        }

        @Override
        @Nullable
        LocalQuickFix newMergeCasesFix() {
            String switchLabelText = this.getSwitchLabelText();
            return switchLabelText != null ? new MergeRulesFix(switchLabelText) : null;
        }

        @Override
        LocalQuickFix newMergeWithDefaultFix() {
            return null;
        }

        @Override
        LocalQuickFix newDeleteCaseFix() {
            return new DeleteRedundantRuleFix();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rule";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "body";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "commentTexts";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$Rule";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Comments {
        private final List<String> myTexts = new ArrayList<String>();
        private final List<PsiElement> myPending = new ArrayList<PsiElement>();

        private Comments() {
        }

        String[] fetchTexts() {
            String[] result = ArrayUtilRt.toStringArray(this.myTexts);
            this.myTexts.clear();
            return result;
        }

        void addFrom(PsiStatement statement) {
            for (PsiElement pending : this.myPending) {
                TryWithIdenticalCatchesInspection.collectCommentTexts(pending, this.myTexts);
            }
            this.myPending.clear();
            TryWithIdenticalCatchesInspection.collectCommentTexts((PsiElement)statement, this.myTexts);
        }

        public void addPending(PsiElement element) {
            this.myPending.add(element);
        }
    }

    private static class Branch
    extends BranchBase<PsiSwitchLabelStatement> {
        private static final PsiSwitchLabelStatement[] EMPTY_LABELS_ARRAY = new PsiSwitchLabelStatement[0];
        private final boolean myIsSimpleExit;
        private final boolean myCanFallThrough;

        Branch(@NotNull PsiSwitchLabelStatement[] labels2, @NotNull List<PsiStatement> statementList, boolean hasImplicitBreak, @NotNull String[] commentTexts) {
            if (labels2 == null) {
                Branch.$$$reportNull$$$0(0);
            }
            if (statementList == null) {
                Branch.$$$reportNull$$$0(1);
            }
            if (commentTexts == null) {
                Branch.$$$reportNull$$$0(2);
            }
            super((PsiSwitchLabelStatementBase[])labels2, Branch.statementsWithoutTrailingBreak(statementList), commentTexts);
            int lastIndex = statementList.size() - 1;
            PsiStatement lastStatement = statementList.get(lastIndex);
            this.myCanFallThrough = !hasImplicitBreak && ControlFlowUtils.statementMayCompleteNormally(lastStatement);
            this.myIsSimpleExit = lastIndex == 0 && Branch.isSimpleExit(lastStatement);
        }

        @Override
        boolean canFallThrough() {
            return this.myCanFallThrough;
        }

        @Override
        boolean isSimpleExit() {
            return this.myIsSimpleExit;
        }

        @Override
        @Nullable
        LocalQuickFix newMergeCasesFix() {
            String switchLabelText = this.getSwitchLabelText();
            return switchLabelText != null ? new MergeBranchesFix(switchLabelText) : null;
        }

        @Override
        LocalQuickFix newMergeWithDefaultFix() {
            return new MergeWithDefaultBranchFix();
        }

        @Override
        LocalQuickFix newDeleteCaseFix() {
            return new DeleteRedundantBranchFix();
        }

        @NotNull
        List<PsiElement> getBranchPrefix() {
            ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            for (PsiElement element = this.myStatements[0].getPrevSibling(); !(element == null || Branch.isLeftBrace(element) || !(element instanceof PsiSwitchLabelStatement) && element instanceof PsiStatement); element = element.getPrevSibling()) {
                result.add(element);
            }
            Collections.reverse(result);
            ArrayList<PsiElement> arrayList = result;
            if (arrayList == null) {
                Branch.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        private static boolean isLeftBrace(PsiElement element) {
            return element instanceof PsiJavaToken && JavaTokenType.LBRACE.equals(((PsiJavaToken)element).getTokenType());
        }

        PsiStatement[] getStatementsToDelete() {
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)this.myStatements[this.myStatements.length - 1], PsiStatement.class);
            if (DuplicateBranchesInSwitchInspection.isBreakWithoutLabel(nextStatement)) {
                PsiStatement[] statements = Arrays.copyOf(this.myStatements, this.myStatements.length + 1);
                statements[this.myStatements.length] = nextStatement;
                return statements;
            }
            return this.myStatements;
        }

        private static boolean isSimpleExit(@Nullable PsiStatement statement) {
            if (statement instanceof PsiBreakStatement || statement instanceof PsiContinueStatement || statement instanceof PsiThrowStatement) {
                return true;
            }
            if (statement instanceof PsiReturnStatement) {
                return Branch.isSimpleExpression(((PsiReturnStatement)statement).getReturnValue());
            }
            return false;
        }

        private static boolean isSimpleExpression(@Nullable PsiExpression expression2) {
            if ((expression2 = PsiUtil.deparenthesizeExpression((PsiExpression)expression2)) == null || expression2 instanceof PsiLiteralExpression) {
                return true;
            }
            if (expression2 instanceof PsiReferenceExpression) {
                PsiExpression qualifier = ((PsiReferenceExpression)expression2).getQualifierExpression();
                return qualifier == null || qualifier instanceof PsiQualifiedExpression;
            }
            if (expression2 instanceof PsiUnaryExpression) {
                return Branch.isSimpleExpression(((PsiUnaryExpression)expression2).getOperand());
            }
            return false;
        }

        private static PsiSwitchLabelStatement[] collectLabels(PsiStatement statement) {
            ArrayList<PsiSwitchLabelStatement> labels2 = new ArrayList<PsiSwitchLabelStatement>();
            PsiElement element = PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
            while (element instanceof PsiSwitchLabelStatement) {
                labels2.add((PsiSwitchLabelStatement)element);
                element = PsiTreeUtil.getPrevSiblingOfType((PsiElement)element, PsiStatement.class);
            }
            Collections.reverse(labels2);
            return labels2.toArray(EMPTY_LABELS_ARRAY);
        }

        private static PsiStatement[] statementsWithoutTrailingBreak(List<? extends PsiStatement> statementList) {
            int lastIndex = statementList.size() - 1;
            PsiStatement lastStatement = statementList.get(lastIndex);
            if (lastIndex > 0 && DuplicateBranchesInSwitchInspection.isBreakWithoutLabel(lastStatement)) {
                statementList = statementList.subList(0, lastIndex);
            }
            return statementList.toArray(PsiStatement.EMPTY_ARRAY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "labels";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statementList";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commentTexts";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$Branch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$Branch";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBranchPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class BranchBase<T extends PsiSwitchLabelStatementBase> {
        @NotNull
        protected final T myLabel;
        @NotNull
        protected final PsiStatement[] myStatements;
        @NotNull
        protected final String[] myCommentTexts;
        private final boolean myIsDefault;
        private DuplicatesFinder myFinder;

        BranchBase(@NotNull T[] labels2, @NotNull PsiStatement[] statements, @NotNull String[] commentTexts) {
            if (labels2 == null) {
                BranchBase.$$$reportNull$$$0(0);
            }
            if (statements == null) {
                BranchBase.$$$reportNull$$$0(1);
            }
            if (commentTexts == null) {
                BranchBase.$$$reportNull$$$0(2);
            }
            LOG.assertTrue(labels2.length != 0, (Object)"labels.length");
            LOG.assertTrue(statements.length != 0, (Object)"statements.length");
            this.myLabel = labels2[0];
            this.myStatements = statements;
            this.myCommentTexts = commentTexts;
            this.myIsDefault = ContainerUtil.find((Object[])labels2, PsiSwitchLabelStatementBase::isDefaultCase) != null;
        }

        boolean isDefault() {
            return this.myIsDefault;
        }

        @Nullable
        String getSwitchLabelText() {
            return BranchBase.getSwitchLabelText(this.myLabel);
        }

        abstract boolean isSimpleExit();

        abstract boolean canFallThrough();

        int effectiveLength() {
            if (this.myStatements.length == 1 && this.myStatements[0] instanceof PsiBlockStatement) {
                return ((PsiBlockStatement)this.myStatements[0]).getCodeBlock().getStatementCount();
            }
            return this.myStatements.length;
        }

        int hash() {
            return BranchBase.hashStatements(this.myStatements);
        }

        @Nullable
        abstract LocalQuickFix newMergeCasesFix();

        abstract LocalQuickFix newDeleteCaseFix();

        abstract LocalQuickFix newMergeWithDefaultFix();

        @Nullable
        Match match(BranchBase other) {
            return this.getFinder().isDuplicate((PsiElement)other.myStatements[0], true);
        }

        @NotNull
        private DuplicatesFinder getFinder() {
            if (this.myFinder == null) {
                this.myFinder = BranchBase.createFinder(this.myStatements);
            }
            DuplicatesFinder duplicatesFinder = this.myFinder;
            if (duplicatesFinder == null) {
                BranchBase.$$$reportNull$$$0(3);
            }
            return duplicatesFinder;
        }

        String getCaseBranchMessage() {
            return InspectionsBundle.message((String)"inspection.duplicate.branches.in.switch.message", (Object[])new Object[0]);
        }

        String getDefaultBranchMessage() {
            return InspectionsBundle.message((String)"inspection.duplicate.branches.in.switch.default.message", (Object[])new Object[0]);
        }

        public String toString() {
            return StringUtil.notNullize((String)this.getSwitchLabelText());
        }

        @NotNull
        private static DuplicatesFinder createFinder(@NotNull PsiStatement[] statements) {
            if (statements == null) {
                BranchBase.$$$reportNull$$$0(4);
            }
            Project project = statements[0].getProject();
            InputVariables noVariables = new InputVariables(Collections.emptyList(), project, new LocalSearchScope((PsiElement[])statements), false);
            DuplicatesFinder duplicatesFinder = new DuplicatesFinder((PsiElement[])statements, noVariables, null, Collections.emptyList());
            if (duplicatesFinder == null) {
                BranchBase.$$$reportNull$$$0(5);
            }
            return duplicatesFinder;
        }

        @Nullable
        static String getSwitchLabelText(@Nullable PsiSwitchLabelStatementBase switchLabel) {
            if (switchLabel != null) {
                PsiExpression[] expressions2;
                if (switchLabel.isDefaultCase()) {
                    return "default";
                }
                PsiExpressionList caseValues2 = switchLabel.getCaseValues();
                if (caseValues2 != null && (expressions2 = caseValues2.getExpressions()).length != 0) {
                    return "case " + expressions2[0].getText();
                }
            }
            return null;
        }

        static int hashElement(@NotNull PsiElement element, int depth) {
            IElementType type2;
            if (element == null) {
                BranchBase.$$$reportNull$$$0(6);
            }
            if (element instanceof PsiExpression) {
                return BranchBase.hashExpression((PsiExpression)element);
            }
            if (element instanceof PsiBlockStatement) {
                return BranchBase.hashStatements(((PsiBlockStatement)element).getCodeBlock().getStatements()) * 31 + JavaElementType.BLOCK_STATEMENT.getIndex();
            }
            int hash = 0;
            if (depth > 0) {
                int count = 0;
                for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child instanceof PsiWhiteSpace || child instanceof PsiComment || child instanceof PsiJavaToken) continue;
                    hash = hash * 31 + BranchBase.hashElement(child, depth - 1);
                    ++count;
                }
                if (count != 0) {
                    hash = hash * 31 + count;
                }
            }
            if ((type2 = PsiUtilCore.getElementType((PsiElement)element)) != null) {
                hash = hash * 31 + type2.getIndex();
            }
            return hash;
        }

        static int hashExpression(@Nullable PsiExpression expression2) {
            PsiJavaCodeReferenceElement reference;
            if (expression2 == null) {
                return 0;
            }
            if (expression2 instanceof PsiParenthesizedExpression) {
                return BranchBase.hashExpression(((PsiParenthesizedExpression)expression2).getExpression());
            }
            short index = expression2.getNode().getElementType().getIndex();
            if (expression2 instanceof PsiReferenceExpression) {
                return BranchBase.hashReference((PsiJavaCodeReferenceElement)((PsiReferenceExpression)expression2), index);
            }
            if (expression2 instanceof PsiMethodCallExpression) {
                return BranchBase.hashReference((PsiJavaCodeReferenceElement)((PsiMethodCallExpression)expression2).getMethodExpression(), index);
            }
            if (expression2 instanceof PsiNewExpression && (reference = ((PsiNewExpression)expression2).getClassOrAnonymousClassReference()) != null) {
                return BranchBase.hashReference(reference, index);
            }
            if (expression2 instanceof PsiAssignmentExpression) {
                PsiExpression lExpression = ((PsiAssignmentExpression)expression2).getLExpression();
                PsiExpression rExpression = ((PsiAssignmentExpression)expression2).getRExpression();
                return (BranchBase.hashExpression(lExpression) * 31 + BranchBase.hashExpression(rExpression)) * 31 + index;
            }
            return index;
        }

        static int hashReference(@NotNull PsiJavaCodeReferenceElement reference, short index) {
            if (reference == null) {
                BranchBase.$$$reportNull$$$0(7);
            }
            return Objects.hashCode(reference.getReferenceName()) * 31 + index;
        }

        static int hashStatements(@NotNull PsiStatement[] statements) {
            if (statements == null) {
                BranchBase.$$$reportNull$$$0(8);
            }
            int hash = statements.length;
            for (PsiStatement statement : statements) {
                hash = hash * 31 + BranchBase.hashElement((PsiElement)statement, 2);
            }
            return hash;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "labels";
                    break;
                }
                case 1: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statements";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commentTexts";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$BranchBase";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$BranchBase";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFinder";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFinder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createFinder";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "hashElement";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "hashReference";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "hashStatements";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class BranchFixContext {
        private Branch myBranchToDelete;
        private Branch myBranchToMergeWith;
        private List<PsiElement> myBranchPrefixToMove;
        private PsiSwitchLabelStatement myLabelToMergeWith;
        private Set<String> myCommentsToMergeWith;
        private PsiElement myNextFromLabelToMergeWith;

        BranchFixContext() {
        }

        private boolean prepare(PsiElement startElement, Predicate<? super Branch> shouldMergeWith) {
            PsiSwitchBlock switchBlock = (PsiSwitchBlock)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiSwitchBlock.class);
            if (switchBlock == null) {
                return false;
            }
            List<Branch> candidateBranches = null;
            for (List<Branch> branches : DuplicateBranchesInSwitchInspection.collectProbablySimilarBranches(switchBlock)) {
                this.myBranchToDelete = (Branch)ContainerUtil.find(branches, branch -> branch.myStatements[0] == startElement);
                if (this.myBranchToDelete == null) continue;
                candidateBranches = branches;
                break;
            }
            if (this.myBranchToDelete == null || candidateBranches == null) {
                return false;
            }
            for (Branch branch2 : candidateBranches) {
                if (!shouldMergeWith.test(branch2) || !DuplicateBranchesInSwitchInspection.areDuplicates(this.myBranchToDelete, branch2)) continue;
                this.myBranchToMergeWith = branch2;
                break;
            }
            if (this.myBranchToMergeWith == null) {
                return false;
            }
            this.myBranchPrefixToMove = this.myBranchToDelete.getBranchPrefix();
            if (this.myBranchPrefixToMove.isEmpty()) {
                return false;
            }
            this.myLabelToMergeWith = (PsiSwitchLabelStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)this.myBranchToMergeWith.myStatements[0], PsiSwitchLabelStatement.class);
            if (this.myLabelToMergeWith == null) {
                return false;
            }
            this.myNextFromLabelToMergeWith = PsiTreeUtil.skipWhitespacesForward((PsiElement)this.myLabelToMergeWith);
            this.myCommentsToMergeWith = ContainerUtil.set((Object[])this.myBranchToMergeWith.myCommentTexts);
            return true;
        }

        void moveBranchLabel() {
            PsiElement prevElement;
            PsiElement firstElementToMove = this.myBranchPrefixToMove.get(0);
            PsiElement lastElementToMove = this.myBranchPrefixToMove.get(this.myBranchPrefixToMove.size() - 1);
            PsiSwitchLabelStatement moveTarget = this.myLabelToMergeWith;
            if (this.myLabelToMergeWith.isDefaultCase() && (prevElement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)this.myLabelToMergeWith)) != null) {
                moveTarget = prevElement;
            }
            moveTarget.getParent().addRangeAfter(firstElementToMove, lastElementToMove, (PsiElement)moveTarget);
            firstElementToMove.getParent().deleteChildRange(firstElementToMove, lastElementToMove);
        }

        void deleteStatements() {
            PsiStatement[] statementsToDelete;
            CommentTracker tracker = new CommentTracker();
            for (PsiStatement statement : statementsToDelete = this.myBranchToDelete.getStatementsToDelete()) {
                PsiTreeUtil.processElements((PsiElement)statement, child -> {
                    if (DuplicateBranchesInSwitchInspection.isRedundantComment(this.myCommentsToMergeWith, child)) {
                        tracker.markUnchanged(child);
                    }
                    return true;
                });
            }
            for (int i = 0; i < statementsToDelete.length - 1; ++i) {
                tracker.delete((PsiElement)statementsToDelete[i]);
            }
            tracker.deleteAndRestoreComments((PsiElement)statementsToDelete[statementsToDelete.length - 1]);
        }

        void deleteRedundantComments() {
            ArrayList redundantComments = new ArrayList();
            for (PsiElement element = this.myLabelToMergeWith.getNextSibling(); element != null && element != this.myNextFromLabelToMergeWith; element = element.getNextSibling()) {
                PsiTreeUtil.processElements((PsiElement)element, child -> {
                    if (DuplicateBranchesInSwitchInspection.isRedundantComment(this.myCommentsToMergeWith, child)) {
                        redundantComments.add(child);
                    }
                    return true;
                });
            }
            redundantComments.forEach(PsiElement::delete);
        }

        void deleteBranchLabel() {
            ArrayList<PsiElement> toDelete = new ArrayList<PsiElement>();
            CommentTracker tracker = new CommentTracker();
            for (PsiElement element : this.myBranchPrefixToMove) {
                if (element instanceof PsiWhiteSpace) continue;
                toDelete.add(element);
                PsiTreeUtil.processElements((PsiElement)element, child -> {
                    if (DuplicateBranchesInSwitchInspection.isRedundantComment(this.myCommentsToMergeWith, child)) {
                        tracker.markUnchanged(child);
                    }
                    return true;
                });
            }
            int size = toDelete.size();
            if (size != 0) {
                for (int i = 0; i < size - 1; ++i) {
                    tracker.delete((PsiElement)toDelete.get(i));
                }
                tracker.deleteAndRestoreComments((PsiElement)toDelete.get(size - 1));
            }
        }
    }

    private static class DeleteRedundantBranchFix
    implements LocalQuickFix {
        private DeleteRedundantBranchFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.duplicate.branches.in.switch.delete.fix.name", (Object[])new Object[0]);
            if (string == null) {
                DeleteRedundantBranchFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.duplicate.branches.in.switch.delete.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                DeleteRedundantBranchFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            BranchFixContext context;
            if (project == null) {
                DeleteRedundantBranchFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                DeleteRedundantBranchFix.$$$reportNull$$$0(3);
            }
            if ((context = new BranchFixContext()).prepare(descriptor.getStartElement(), BranchBase::isDefault)) {
                context.deleteBranchLabel();
                context.deleteStatements();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$DeleteRedundantBranchFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$DeleteRedundantBranchFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MergeWithDefaultBranchFix
    implements LocalQuickFix {
        private MergeWithDefaultBranchFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.duplicate.branches.in.switch.merge.with.default.fix.name", (Object[])new Object[0]);
            if (string == null) {
                MergeWithDefaultBranchFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            BranchFixContext context;
            if (project == null) {
                MergeWithDefaultBranchFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MergeWithDefaultBranchFix.$$$reportNull$$$0(2);
            }
            if ((context = new BranchFixContext()).prepare(descriptor.getStartElement(), BranchBase::isDefault)) {
                context.moveBranchLabel();
                context.deleteRedundantComments();
                context.deleteStatements();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$MergeWithDefaultBranchFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$MergeWithDefaultBranchFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MergeBranchesFix
    implements LocalQuickFix {
        @NotNull
        private final String mySwitchLabelText;

        MergeBranchesFix(@NotNull String switchLabelText) {
            if (switchLabelText == null) {
                MergeBranchesFix.$$$reportNull$$$0(0);
            }
            this.mySwitchLabelText = switchLabelText;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.duplicate.branches.in.switch.merge.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MergeBranchesFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.duplicate.branches.in.switch.merge.fix.name", (Object[])new Object[]{this.mySwitchLabelText});
            if (string == null) {
                MergeBranchesFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            BranchFixContext context;
            if (project == null) {
                MergeBranchesFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                MergeBranchesFix.$$$reportNull$$$0(4);
            }
            if ((context = new BranchFixContext()).prepare(descriptor.getStartElement(), branch -> this.mySwitchLabelText.equals(branch.getSwitchLabelText()))) {
                context.moveBranchLabel();
                context.deleteRedundantComments();
                context.deleteStatements();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switchLabelText";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$MergeBranchesFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$MergeBranchesFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DuplicateBranchesVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        DuplicateBranchesVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitSwitchStatement(PsiSwitchStatement switchStatement) {
            super.visitSwitchStatement(switchStatement);
            this.visitSwitchBlock((PsiSwitchBlock)switchStatement);
        }

        public void visitSwitchExpression(PsiSwitchExpression switchExpression) {
            super.visitSwitchExpression(switchExpression);
            this.visitSwitchBlock((PsiSwitchBlock)switchExpression);
        }

        private void visitSwitchBlock(PsiSwitchBlock switchBlock) {
            if (SwitchUtils.isRuleFormatSwitch(switchBlock)) {
                this.visitEnhancedSwitch(switchBlock);
                return;
            }
            for (List<Branch> branches : DuplicateBranchesInSwitchInspection.collectProbablySimilarBranches(switchBlock)) {
                this.registerProblems(branches);
            }
        }

        private void visitEnhancedSwitch(@NotNull PsiSwitchBlock switchBlock) {
            if (switchBlock == null) {
                DuplicateBranchesVisitor.$$$reportNull$$$0(0);
            }
            Collection probablySimilarRules = DuplicateBranchesInSwitchInspection.collectProbablySimilarRules(switchBlock);
            for (List rules : probablySimilarRules) {
                this.registerProblems(rules);
            }
        }

        void registerProblems(List<? extends BranchBase> branches) {
            int size = branches.size();
            if (size > 1) {
                BranchBase branch;
                int index;
                boolean[] isDuplicate = new boolean[size];
                int defaultIndex = ContainerUtil.indexOf(branches, BranchBase::isDefault);
                if (defaultIndex >= 0) {
                    BranchBase defaultBranch = branches.get(defaultIndex);
                    for (index = 0; index < size; ++index) {
                        if (index == defaultIndex || !DuplicateBranchesInSwitchInspection.areDuplicates(defaultBranch, branch = branches.get(index))) continue;
                        isDuplicate[defaultIndex] = true;
                        isDuplicate[index] = true;
                        this.highlightDefaultDuplicate(branch);
                    }
                }
                int compareCount = 0;
                for (index = 0; index < size - 1; ++index) {
                    if (isDuplicate[index]) continue;
                    branch = branches.get(index);
                    for (int otherIndex = index + 1; otherIndex < size; ++otherIndex) {
                        if (isDuplicate[otherIndex]) continue;
                        if (++compareCount > 200) {
                            return;
                        }
                        BranchBase otherBranch = branches.get(otherIndex);
                        if (!DuplicateBranchesInSwitchInspection.areDuplicates(branch, otherBranch)) continue;
                        isDuplicate[otherIndex] = true;
                        this.highlightDuplicate(otherBranch, branch);
                    }
                }
            }
        }

        private void highlightDuplicate(@NotNull BranchBase duplicate, @NotNull BranchBase original) {
            if (duplicate == null) {
                DuplicateBranchesVisitor.$$$reportNull$$$0(1);
            }
            if (original == null) {
                DuplicateBranchesVisitor.$$$reportNull$$$0(2);
            }
            this.registerProblem(duplicate, duplicate.getCaseBranchMessage(), original.newMergeCasesFix());
        }

        private void highlightDefaultDuplicate(@NotNull BranchBase branch) {
            if (branch == null) {
                DuplicateBranchesVisitor.$$$reportNull$$$0(3);
            }
            this.registerProblem(branch, branch.getDefaultBranchMessage(), branch.newDeleteCaseFix(), branch.newMergeWithDefaultFix());
        }

        private void registerProblem(@NotNull BranchBase duplicate, @NotNull String message2, LocalQuickFix ... fixes) {
            if (duplicate == null) {
                DuplicateBranchesVisitor.$$$reportNull$$$0(4);
            }
            if (message2 == null) {
                DuplicateBranchesVisitor.$$$reportNull$$$0(5);
            }
            ProblemDescriptor descriptor = InspectionManager.getInstance((Project)this.myHolder.getProject()).createProblemDescriptor((PsiElement)duplicate.myStatements[0], (PsiElement)duplicate.myStatements[duplicate.myStatements.length - 1], message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myHolder.isOnTheFly(), fixes);
            this.myHolder.registerProblem(descriptor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switchBlock";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "duplicate";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branch";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$DuplicateBranchesVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitEnhancedSwitch";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "highlightDuplicate";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "highlightDefaultDuplicate";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerProblem";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

