/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DefaultAnnotationParamInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DefaultAnnotationParamInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitNameValuePair(PsiNameValuePair pair2) {
                PsiAnnotationMemberValue value2 = pair2.getValue();
                PsiReference reference = pair2.getReference();
                if (reference == null) {
                    return;
                }
                PsiElement element = reference.resolve();
                if (!(element instanceof PsiAnnotationMethod)) {
                    return;
                }
                PsiAnnotationMemberValue defaultValue = ((PsiAnnotationMethod)element).getDefaultValue();
                if (defaultValue == null) {
                    return;
                }
                if (AnnotationUtil.equal((PsiAnnotationMemberValue)value2, (PsiAnnotationMemberValue)defaultValue)) {
                    holder.registerProblem((PsiElement)value2, "Redundant default parameter value assignment", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{DefaultAnnotationParamInspection.createRemoveParameterFix()});
                }
            }
        };
        if (javaElementVisitor == null) {
            DefaultAnnotationParamInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    @NotNull
    private static LocalQuickFix createRemoveParameterFix() {
        LocalQuickFix localQuickFix = new LocalQuickFix(){

            @Nls
            @NotNull
            public String getFamilyName() {
                if ("Remove redundant parameter" == null) {
                    2.$$$reportNull$$$0(0);
                }
                return "Remove redundant parameter";
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    2.$$$reportNull$$$0(2);
                }
                PsiElement parent = descriptor.getPsiElement().getParent();
                parent.delete();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/DefaultAnnotationParamInspection$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/DefaultAnnotationParamInspection$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (localQuickFix == null) {
            DefaultAnnotationParamInspection.$$$reportNull$$$0(2);
        }
        return localQuickFix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/DefaultAnnotationParamInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/DefaultAnnotationParamInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoveParameterFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

