/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.codeInspection.util.OptionalRefactoringUtil;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionalCanBeOptionalInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            ConditionalCanBeOptionalInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                ConditionalCanBeOptionalInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitConditionalExpression(PsiConditionalExpression ternary) {
                boolean mayChangeSemantics;
                List<PsiReferenceExpression> references;
                TernaryNullCheck ternaryNullCheck = TernaryNullCheck.from(ternary);
                if (ternaryNullCheck == null) {
                    return;
                }
                PsiVariable variable = ternaryNullCheck.myVariable;
                PsiExpression nullBranch = ternaryNullCheck.myNullBranch;
                PsiExpression notNullBranch = ternaryNullCheck.myNotNullBranch;
                if (!ExpressionUtils.isSafelyRecomputableExpression(nullBranch)) {
                    if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)nullBranch, variable::equals)) {
                        return;
                    }
                }
                if ((references = VariableAccessUtils.getVariableReferences(variable, (PsiElement)notNullBranch)).isEmpty() || variable instanceof PsiField && references.stream().noneMatch(ExpressionUtil::isEffectivelyUnqualified)) {
                    return;
                }
                if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)notNullBranch, variable::equals)) {
                    return;
                }
                if (!this.areTypesCompatible(nullBranch, notNullBranch)) {
                    return;
                }
                boolean bl = mayChangeSemantics = !ExpressionUtils.isNullLiteral(nullBranch) && NullabilityUtil.getExpressionNullability(notNullBranch, true) != Nullability.NOT_NULL;
                if (!isOnTheFly && mayChangeSemantics) {
                    return;
                }
                holder.registerProblem((PsiElement)ternary.getCondition(), "Can be replaced with Optional.ofNullable()", mayChangeSemantics ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceConditionWithOptionalFix(mayChangeSemantics)});
            }

            private boolean areTypesCompatible(PsiExpression nullBranch, PsiExpression notNullBranch) {
                PsiType notNullType = ((PsiExpression)notNullBranch.copy()).getType();
                PsiType nullType = ((PsiExpression)nullBranch.copy()).getType();
                if (nullType == null || notNullType == null) {
                    return false;
                }
                if (nullType.isAssignableFrom(notNullType)) {
                    return true;
                }
                if (nullType.equals(PsiType.NULL)) {
                    return true;
                }
                return OptionalUtil.isOptionalEmptyCall(nullBranch) && TypeUtils.isOptional(notNullType);
            }
        };
        if (javaElementVisitor == null) {
            ConditionalCanBeOptionalInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ConditionalCanBeOptionalInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ConditionalCanBeOptionalInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TernaryNullCheck {
        final PsiVariable myVariable;
        final PsiExpression myNullBranch;
        final PsiExpression myNotNullBranch;

        private TernaryNullCheck(PsiVariable variable, PsiExpression nullBranch, PsiExpression notNullBranch) {
            this.myVariable = variable;
            this.myNullBranch = nullBranch;
            this.myNotNullBranch = notNullBranch;
        }

        @Contract(value="null -> null")
        @Nullable
        public static TernaryNullCheck from(@Nullable PsiConditionalExpression ternary) {
            PsiExpression notNullBranch;
            if (ternary == null) {
                return null;
            }
            PsiExpression condition2 = ternary.getCondition();
            boolean isNull = true;
            PsiReferenceExpression ref = ExpressionUtils.getReferenceExpressionFromNullComparison(condition2, true);
            if (ref == null) {
                isNull = false;
                ref = ExpressionUtils.getReferenceExpressionFromNullComparison(condition2, false);
            }
            if (ref == null) {
                return null;
            }
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)ref.resolve(), PsiVariable.class);
            if (variable == null || variable instanceof PsiField && !ExpressionUtil.isEffectivelyUnqualified(ref)) {
                return null;
            }
            PsiExpression nullBranch = isNull ? ternary.getThenExpression() : ternary.getElseExpression();
            PsiExpression psiExpression = notNullBranch = isNull ? ternary.getElseExpression() : ternary.getThenExpression();
            if (nullBranch == null || notNullBranch == null) {
                return null;
            }
            return new TernaryNullCheck(variable, nullBranch, notNullBranch);
        }
    }

    private static class ReplaceConditionWithOptionalFix
    implements LocalQuickFix {
        private final boolean myChangesSemantics;

        ReplaceConditionWithOptionalFix(boolean changesSemantics) {
            this.myChangesSemantics = changesSemantics;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName() + (this.myChangesSemantics ? " (may change semantics)" : "");
            if (string == null) {
                ReplaceConditionWithOptionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace with Optional.ofNullable() chain" == null) {
                ReplaceConditionWithOptionalFix.$$$reportNull$$$0(1);
            }
            return "Replace with Optional.ofNullable() chain";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiConditionalExpression ternary;
            TernaryNullCheck ternaryNullCheck;
            if (project == null) {
                ReplaceConditionWithOptionalFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                ReplaceConditionWithOptionalFix.$$$reportNull$$$0(3);
            }
            if ((ternaryNullCheck = TernaryNullCheck.from(ternary = (PsiConditionalExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)descriptor.getStartElement(), (Class[])new Class[]{PsiConditionalExpression.class}))) == null) {
                return;
            }
            PsiVariable variable = ternaryNullCheck.myVariable;
            String name2 = variable.getName();
            if (name2 == null) {
                return;
            }
            String inLambdaName = new VariableNameGenerator((PsiElement)ternary, VariableKind.PARAMETER).byName(name2).byType(variable.getType()).generate(true);
            PsiExpression nullBranch = ternaryNullCheck.myNullBranch;
            PsiExpression notNullBranch = ternaryNullCheck.myNotNullBranch;
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            CommentTracker ct = new CommentTracker();
            for (PsiReferenceExpression psiReferenceExpression : VariableAccessUtils.getVariableReferences(variable, (PsiElement)nullBranch)) {
                if (!ExpressionUtil.isEffectivelyUnqualified(psiReferenceExpression)) continue;
                PsiElement result = ct.replace((PsiElement)psiReferenceExpression, "null");
                if (nullBranch != psiReferenceExpression) continue;
                nullBranch = (PsiExpression)result;
            }
            String origExpression = null;
            for (PsiReferenceExpression reference : VariableAccessUtils.getVariableReferences(variable, (PsiElement)notNullBranch)) {
                PsiExpression qualifier = reference.getQualifierExpression();
                if (qualifier != null) {
                    if (!ExpressionUtil.isEffectivelyUnqualified(reference)) continue;
                    if (origExpression == null) {
                        origExpression = ct.text((PsiElement)reference);
                    }
                    ct.delete((PsiElement)qualifier);
                }
                ExpressionUtils.bindReferenceTo(reference, inLambdaName);
            }
            PsiLambdaExpression psiLambdaExpression = (PsiLambdaExpression)factory.createExpressionFromText("(" + variable.getType().getCanonicalText() + " " + inLambdaName + ")->" + ct.text((PsiElement)notNullBranch), (PsiElement)ternary);
            PsiParameter lambdaParameter = psiLambdaExpression.getParameterList().getParameters()[0];
            PsiExpression trueBody = Objects.requireNonNull((PsiExpression)psiLambdaExpression.getBody());
            String ofNullableText = "java.util.Optional.ofNullable(" + (origExpression == null ? name2 : origExpression) + ")";
            String replacement = OptionalRefactoringUtil.generateOptionalUnwrap(ofNullableText, (PsiVariable)lambdaParameter, trueBody, ct.markUnchanged(nullBranch), ternary.getType(), !ExpressionUtils.isSafelyRecomputableExpression(nullBranch));
            PsiElement result = ct.replaceAndRestoreComments((PsiElement)ternary, replacement);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ConditionalCanBeOptionalInspection$ReplaceConditionWithOptionalFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ConditionalCanBeOptionalInspection$ReplaceConditionWithOptionalFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

