/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteCatchFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteMultiCatchFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharsetObjectCanBeUsedInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    private static final CharsetCallMatcher[] MATCHERS = new CharsetCallMatcher[]{new CharsetConstructorMatcher("java.io.InputStreamReader", "java.io.InputStream", ""), new CharsetConstructorMatcher("java.io.OutputStreamWriter", "java.io.OutputStream", ""), new CharsetConstructorMatcher("java.lang.String", "byte[]", "int", "int", ""), new CharsetConstructorMatcher("java.lang.String", "byte[]", ""), new CharsetMethodMatcher("java.lang.String", "getBytes", new String[]{""}), new CharsetConstructorMatcher("java.util.Scanner", "java.io.InputStream", ""), new CharsetConstructorMatcher("java.util.Scanner", "java.io.File", ""), new CharsetConstructorMatcher("java.util.Scanner", "java.nio.file.Path", ""), new CharsetConstructorMatcher("java.util.Scanner", "java.nio.channels.ReadableByteChannel", ""), new CharsetConstructorMatcher("java.io.PrintStream", "java.io.OutputStream", "boolean", ""), new CharsetConstructorMatcher("java.io.PrintStream", "java.lang.String", ""), new CharsetConstructorMatcher("java.io.PrintStream", "java.io.File", ""), new CharsetConstructorMatcher("java.io.PrintWriter", "java.io.OutputStream", "boolean", ""), new CharsetConstructorMatcher("java.io.PrintWriter", "java.lang.String", ""), new CharsetConstructorMatcher("java.io.PrintWriter", "java.io.File", ""), new CharsetMethodMatcher("java.io.ByteArrayOutputStream", "toString", new String[]{""}), new CharsetMethodMatcher("java.net.URLDecoder", "decode", new String[]{"java.lang.String", ""}), new CharsetMethodMatcher("java.net.URLEncoder", "encode", new String[]{"java.lang.String", ""}), new CharsetMethodMatcher("java.nio.channels.Channels", "newReader", new String[]{"java.nio.channels.ReadableByteChannel", ""}), new CharsetMethodMatcher("java.nio.channels.Channels", "newWriter", new String[]{"java.nio.channels.WritableByteChannel", ""}), new CharsetMethodMatcher("java.util.Properties", "storeToXML", new String[]{"java.io.OutputStream", "java.lang.String", ""}), new CharsetMethodMatcher("org.apache.commons.io.IOUtils", "toString", new String[]{"java.io.InputStream", ""}), new CharsetMethodMatcher("org.apache.commons.io.IOUtils", "toString", new String[]{"java.net.URI", ""}), new CharsetMethodMatcher("org.apache.commons.io.IOUtils", "toString", new String[]{"java.net.URL", ""})};
    private static final CallMatcher FOR_NAME_MATCHER = CallMatcher.staticCall("java.nio.charset.Charset", "forName").parameterTypes("java.lang.String");
    private static final Map<String, String> SUPPORTED_CHARSETS = ContainerUtil.immutableMapBuilder().put((Object)"US-ASCII", (Object)"US_ASCII").put((Object)"ASCII", (Object)"US_ASCII").put((Object)"ISO646-US", (Object)"US_ASCII").put((Object)"ISO-8859-1", (Object)"ISO_8859_1").put((Object)"UTF-8", (Object)"UTF_8").put((Object)"UTF8", (Object)"UTF_8").put((Object)"UTF-16BE", (Object)"UTF_16BE").put((Object)"UTF16BE", (Object)"UTF_16BE").put((Object)"UTF-16LE", (Object)"UTF_16LE").put((Object)"UTF16LE", (Object)"UTF_16LE").put((Object)"UTF-16", (Object)"UTF_16").put((Object)"UTF16", (Object)"UTF_16").build();

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CharsetObjectCanBeUsedInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                CharsetObjectCanBeUsedInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitCallExpression(PsiCallExpression call) {
                CharsetMatch match = StreamEx.of((Object[])MATCHERS).map(matcher -> matcher.extractCharsetMatch(call)).nonNull().findFirst().orElse(null);
                if (match == null) {
                    return;
                }
                this.addCharsetReplacement((PsiElement)match.myStringCharset, match.myStringCharset);
            }

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                super.visitMethodCallExpression(call);
                if (!FOR_NAME_MATCHER.matches((PsiExpression)call)) {
                    return;
                }
                PsiExpressionList arguments = call.getArgumentList();
                PsiExpression charset = arguments.getExpressions()[0];
                this.addCharsetReplacement((PsiElement)call, charset);
            }

            private void addCharsetReplacement(@NotNull PsiElement place, @NotNull PsiExpression charset) {
                String charsetString;
                if (place == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (charset == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((charsetString = this.getCharsetString(charset)) == null) {
                    return;
                }
                String constantName = "StandardCharsets." + (String)SUPPORTED_CHARSETS.get(charsetString);
                holder.registerProblem(place, InspectionsBundle.message((String)"inspection.charset.object.can.be.used.message", (Object[])new Object[]{constantName}), new LocalQuickFix[]{new CharsetObjectCanBeUsedFix(constantName)});
            }

            @Nullable
            private String getCharsetString(PsiExpression charsetExpression) {
                String charsetString = (String)ObjectUtils.tryCast((Object)ExpressionUtils.computeConstantExpression(charsetExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)charsetExpression)), String.class);
                if (charsetString == null) {
                    return null;
                }
                charsetString = StringUtil.toUpperCase((String)charsetString);
                if (!SUPPORTED_CHARSETS.containsKey(charsetString)) {
                    return null;
                }
                if (charsetExpression instanceof PsiLiteralExpression) {
                    return charsetString;
                }
                if (charsetExpression instanceof PsiReferenceExpression) {
                    String baseCharset;
                    String name2 = ((PsiReferenceExpression)charsetExpression).getReferenceName();
                    if (name2 == null) {
                        return null;
                    }
                    String baseName = StringUtil.toLowerCase((String)name2.replaceAll("[^A-Z0-9]", ""));
                    if (!baseName.contains(baseCharset = StringUtil.toLowerCase((String)charsetString.replaceAll("[^A-Z0-9]", "")))) {
                        return null;
                    }
                    return charsetString;
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "place";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "charset";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/CharsetObjectCanBeUsedInspection$1";
                objectArray[2] = "addCharsetReplacement";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (javaElementVisitor == null) {
            CharsetObjectCanBeUsedInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/CharsetObjectCanBeUsedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/CharsetObjectCanBeUsedInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class CharsetObjectCanBeUsedFix
    implements LocalQuickFix {
        private final String myConstantName;

        CharsetObjectCanBeUsedFix(String constantName) {
            this.myConstantName = constantName;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.charset.object.can.be.used.fix.name", (Object[])new Object[]{this.myConstantName});
            if (string == null) {
                CharsetObjectCanBeUsedFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.charset.object.can.be.used.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                CharsetObjectCanBeUsedFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiTryStatement tryStatement;
            PsiExpression expression2;
            if (project == null) {
                CharsetObjectCanBeUsedFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                CharsetObjectCanBeUsedFix.$$$reportNull$$$0(3);
            }
            if ((expression2 = (PsiExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiExpression.class)) == null) {
                return;
            }
            PsiElement anchor = FOR_NAME_MATCHER.matches(expression2) ? null : PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiCallExpression.class);
            CommentTracker ct = new CommentTracker();
            String replacement = "java.nio.charset." + this.myConstantName;
            PsiReferenceExpression ref = (PsiReferenceExpression)ct.replaceAndRestoreComments((PsiElement)expression2, replacement);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)ref);
            if (anchor == null) {
                return;
            }
            while ((tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)anchor, PsiTryStatement.class, (boolean)true, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class})) != null) {
                PsiCodeBlock tryBlock = tryStatement.getTryBlock();
                if (PsiTreeUtil.isAncestor((PsiElement)tryBlock, (PsiElement)anchor, (boolean)true)) {
                    for (PsiParameter parameter2 : tryStatement.getCatchBlockParameters()) {
                        List typeElements = PsiUtil.getParameterTypeElements((PsiParameter)parameter2);
                        for (PsiTypeElement element : typeElements) {
                            PsiType type2 = element.getType();
                            if (type2.equalsToText("java.io.UnsupportedEncodingException") || type2.equalsToText("java.io.IOException")) {
                                List unhandledExceptions = ExceptionUtil.collectUnhandledExceptions((PsiElement)tryBlock, (PsiElement)tryBlock);
                                PsiResourceList resourceList = tryStatement.getResourceList();
                                if (resourceList != null) {
                                    Collection<PsiClassType> resourceExceptions = ExceptionUtil.collectUnhandledExceptions((PsiElement)resourceList, (PsiElement)resourceList);
                                    unhandledExceptions = StreamEx.of((Object[])new Collection[]{unhandledExceptions, resourceExceptions}).toFlatList(Function.identity());
                                }
                                if (unhandledExceptions.stream().noneMatch(ue -> ue.isAssignableFrom(type2) || type2.isAssignableFrom((PsiType)ue))) {
                                    if (parameter2.getType() instanceof PsiDisjunctionType) {
                                        DeleteMultiCatchFix.deleteCaughtExceptionType(element);
                                    } else {
                                        DeleteCatchFix.deleteCatch(parameter2);
                                    }
                                }
                                return;
                            }
                            if (!type2.equalsToText("java.lang.Exception") && !type2.equalsToText("java.lang.Throwable")) continue;
                            return;
                        }
                    }
                }
                anchor = tryStatement;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/CharsetObjectCanBeUsedInspection$CharsetObjectCanBeUsedFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/CharsetObjectCanBeUsedInspection$CharsetObjectCanBeUsedFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class CharsetMatch {
        @NotNull
        final PsiExpression myStringCharset;
        @NotNull
        final PsiMethod myStringMethod;
        @NotNull
        final PsiMethod myCharsetMethod;

        CharsetMatch(@NotNull PsiExpression charset, @NotNull PsiMethod stringMethod, @NotNull PsiMethod charsetMethod) {
            if (charset == null) {
                CharsetMatch.$$$reportNull$$$0(0);
            }
            if (stringMethod == null) {
                CharsetMatch.$$$reportNull$$$0(1);
            }
            if (charsetMethod == null) {
                CharsetMatch.$$$reportNull$$$0(2);
            }
            this.myStringCharset = charset;
            this.myStringMethod = stringMethod;
            this.myCharsetMethod = charsetMethod;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "charset";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stringMethod";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "charsetMethod";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/CharsetObjectCanBeUsedInspection$CharsetMatch";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class CharsetMethodMatcher
    extends CharsetCallMatcher {
        @NotNull
        private final String myMethodName;

        CharsetMethodMatcher(@NotNull String className2, @NotNull String methodName, String ... parameters2) {
            if (className2 == null) {
                CharsetMethodMatcher.$$$reportNull$$$0(0);
            }
            if (methodName == null) {
                CharsetMethodMatcher.$$$reportNull$$$0(1);
            }
            if (parameters2 == null) {
                CharsetMethodMatcher.$$$reportNull$$$0(2);
            }
            super(className2, parameters2);
            this.myMethodName = methodName;
        }

        @Override
        CharsetMatch extractCharsetMatch(PsiCallExpression call) {
            if (!(call instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)call;
            if (!this.myMethodName.equals(methodCallExpression.getMethodExpression().getReferenceName())) {
                return null;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            if (argumentList.getExpressionCount() != this.myParameters.length) {
                return null;
            }
            PsiMethod method = call.resolveMethod();
            if (!this.checkMethod(method, "java.lang.String")) {
                return null;
            }
            return this.createMatch(method, argumentList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "className";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "methodName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/CharsetObjectCanBeUsedInspection$CharsetMethodMatcher";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class CharsetConstructorMatcher
    extends CharsetCallMatcher {
        CharsetConstructorMatcher(@NotNull String className2, String ... parameters2) {
            if (className2 == null) {
                CharsetConstructorMatcher.$$$reportNull$$$0(0);
            }
            if (parameters2 == null) {
                CharsetConstructorMatcher.$$$reportNull$$$0(1);
            }
            super(className2, parameters2);
        }

        @Override
        CharsetMatch extractCharsetMatch(PsiCallExpression call) {
            if (!(call instanceof PsiNewExpression)) {
                return null;
            }
            PsiNewExpression newExpression = (PsiNewExpression)call;
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null || argumentList.getExpressionCount() != this.myParameters.length) {
                return null;
            }
            PsiMethod method = call.resolveMethod();
            if (!this.checkMethod(method, "java.lang.String") || !method.isConstructor()) {
                return null;
            }
            return this.createMatch(method, argumentList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "className";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/CharsetObjectCanBeUsedInspection$CharsetConstructorMatcher";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static abstract class CharsetCallMatcher {
        @NotNull
        final String myClassName;
        @NotNull
        final String[] myParameters;
        final int myCharsetParameterIndex;

        CharsetCallMatcher(@NotNull String className2, String ... parameters2) {
            if (className2 == null) {
                CharsetCallMatcher.$$$reportNull$$$0(0);
            }
            if (parameters2 == null) {
                CharsetCallMatcher.$$$reportNull$$$0(1);
            }
            this.myClassName = className2;
            this.myParameters = parameters2;
            int index = -1;
            for (int i = 0; i < parameters2.length; ++i) {
                if (!parameters2[i].isEmpty()) continue;
                if (index == -1) {
                    index = i;
                    continue;
                }
                throw new IllegalArgumentException("Empty parameter type must be specified exactly once");
            }
            if (index == -1) {
                throw new IllegalArgumentException("No empty parameter type is specified");
            }
            this.myCharsetParameterIndex = index;
        }

        @Contract(value="null,_ -> false")
        final boolean checkMethod(PsiMethod method, @NotNull String charsetType) {
            if (charsetType == null) {
                CharsetCallMatcher.$$$reportNull$$$0(2);
            }
            if (method == null) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || !this.myClassName.equals(containingClass.getQualifiedName())) {
                return false;
            }
            PsiParameterList list = method.getParameterList();
            if (list.getParametersCount() != this.myParameters.length) {
                return false;
            }
            PsiParameter[] parameters2 = list.getParameters();
            for (int i = 0; i < this.myParameters.length; ++i) {
                PsiType parameterType = parameters2[i].getType();
                if (parameterType.equalsToText(this.myParameters[i].isEmpty() ? charsetType : this.myParameters[i])) continue;
                return false;
            }
            return true;
        }

        @Nullable
        final CharsetMatch createMatch(PsiMethod method, PsiExpressionList arguments) {
            PsiExpression argument = arguments.getExpressions()[this.myCharsetParameterIndex];
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return null;
            }
            PsiMethod[] candidates = method.isConstructor() ? aClass.getConstructors() : aClass.findMethodsByName(method.getName(), false);
            PsiMethod charsetMethod = Arrays.stream(candidates).filter(psiMethod -> this.checkMethod((PsiMethod)psiMethod, "java.nio.charset.Charset")).findFirst().orElse(null);
            if (charsetMethod == null) {
                return null;
            }
            return new CharsetMatch(argument, method, charsetMethod);
        }

        @Nullable
        abstract CharsetMatch extractCharsetMatch(PsiCallExpression var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "charsetType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/CharsetObjectCanBeUsedInspection$CharsetCallMatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkMethod";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

