/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.AnnotatedApiUsageProcessor;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageProcessor;
import com.intellij.codeInspection.apiUsage.ApiUsageUastVisitor;
import com.intellij.codeInspection.deprecation.DeprecationInspectionBase;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

public abstract class AnnotatedElementInspectionBase
extends LocalInspectionTool {
    public boolean myIgnoreInsideImports = true;

    @NotNull
    protected abstract List<String> getAnnotations();

    @NotNull
    public JPanel createOptionsPanel() {
        SingleCheckboxOptionsPanel singleCheckboxOptionsPanel = new SingleCheckboxOptionsPanel(JvmAnalysisBundle.message("jvm.inspections.unstable.api.usage.ignore.inside.imports", new Object[0]), (InspectionProfileEntry)this, "myIgnoreInsideImports");
        if (singleCheckboxOptionsPanel == null) {
            AnnotatedElementInspectionBase.$$$reportNull$$$0(0);
        }
        return singleCheckboxOptionsPanel;
    }

    @NotNull
    protected abstract AnnotatedApiUsageProcessor buildAnnotatedApiUsageProcessor(@NotNull ProblemsHolder var1);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AnnotatedElementInspectionBase.$$$reportNull$$$0(1);
        }
        if (!this.isApplicable(holder.getFile(), holder.getProject())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                AnnotatedElementInspectionBase.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        AnnotatedApiUsageProcessor annotatedApiProcessor = this.buildAnnotatedApiUsageProcessor(holder);
        AnnotatedApiUsageProcessorBridge processorBridge = new AnnotatedApiUsageProcessorBridge(this.myIgnoreInsideImports, this.getAnnotations(), annotatedApiProcessor);
        PsiElementVisitor psiElementVisitor = ApiUsageUastVisitor.createPsiElementVisitor(processorBridge);
        if (psiElementVisitor == null) {
            AnnotatedElementInspectionBase.$$$reportNull$$$0(3);
        }
        return psiElementVisitor;
    }

    private boolean isApplicable(@Nullable PsiFile file, @Nullable Project project) {
        if (file == null || project == null) {
            return false;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scope = file.getResolveScope();
        for (String annotation : this.getAnnotations()) {
            if (javaPsiFacade.findClass(annotation, scope) == null) continue;
            return true;
        }
        return false;
    }

    protected static String getPresentableText(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            AnnotatedElementInspectionBase.$$$reportNull$$$0(4);
        }
        return DeprecationInspectionBase.getPresentableName(psiElement);
    }

    protected static boolean isLibraryElement(@NotNull PsiElement element) {
        if (element == null) {
            AnnotatedElementInspectionBase.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        VirtualFile containingVirtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        return containingVirtualFile != null && ProjectFileIndex.getInstance((Project)element.getProject()).isInLibraryClasses(containingVirtualFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/AnnotatedElementInspectionBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/AnnotatedElementInspectionBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class AnnotatedApiUsageProcessorBridge
    implements ApiUsageProcessor {
        private final boolean myIgnoreInsideImports;
        private final List<String> myAnnotations;
        private final AnnotatedApiUsageProcessor myAnnotatedApiProcessor;

        private AnnotatedApiUsageProcessorBridge(boolean ignoreInsideImports, @NotNull List<String> annotations2, @NotNull AnnotatedApiUsageProcessor annotatedApiProcessor) {
            if (annotations2 == null) {
                AnnotatedApiUsageProcessorBridge.$$$reportNull$$$0(0);
            }
            if (annotatedApiProcessor == null) {
                AnnotatedApiUsageProcessorBridge.$$$reportNull$$$0(1);
            }
            this.myIgnoreInsideImports = ignoreInsideImports;
            this.myAnnotations = annotations2;
            this.myAnnotatedApiProcessor = annotatedApiProcessor;
        }

        @Override
        public void processImportReference(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target) {
            if (sourceNode == null) {
                AnnotatedApiUsageProcessorBridge.$$$reportNull$$$0(2);
            }
            if (target == null) {
                AnnotatedApiUsageProcessorBridge.$$$reportNull$$$0(3);
            }
            if (!this.myIgnoreInsideImports) {
                this.maybeProcessAnnotatedTarget(sourceNode, target);
            }
        }

        @Override
        public void processReference(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target, @Nullable UExpression qualifier) {
            if (sourceNode == null) {
                AnnotatedApiUsageProcessorBridge.$$$reportNull$$$0(4);
            }
            if (target == null) {
                AnnotatedApiUsageProcessorBridge.$$$reportNull$$$0(5);
            }
            this.maybeProcessAnnotatedTarget(sourceNode, target);
        }

        @Override
        public void processConstructorInvocation(@NotNull UElement sourceNode, @NotNull PsiClass instantiatedClass, @Nullable PsiMethod constructor, @Nullable UClass subclassDeclaration) {
            if (sourceNode == null) {
                AnnotatedApiUsageProcessorBridge.$$$reportNull$$$0(6);
            }
            if (instantiatedClass == null) {
                AnnotatedApiUsageProcessorBridge.$$$reportNull$$$0(7);
            }
            if (constructor != null) {
                this.maybeProcessAnnotatedTarget(sourceNode, (PsiModifierListOwner)constructor);
            }
        }

        private void maybeProcessAnnotatedTarget(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target) {
            List annotations2;
            if (sourceNode == null) {
                AnnotatedApiUsageProcessorBridge.$$$reportNull$$$0(8);
            }
            if (target == null) {
                AnnotatedApiUsageProcessorBridge.$$$reportNull$$$0(9);
            }
            if ((annotations2 = AnnotationUtil.findAllAnnotations((PsiModifierListOwner)target, this.myAnnotations, (boolean)false)).isEmpty()) {
                return;
            }
            this.myAnnotatedApiProcessor.processAnnotatedTarget(sourceNode, target, annotations2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotations";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotatedApiProcessor";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceNode";
                    break;
                }
                case 3: 
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instantiatedClass";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/AnnotatedElementInspectionBase$AnnotatedApiUsageProcessorBridge";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processImportReference";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processReference";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processConstructorInvocation";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "maybeProcessAnnotatedTarget";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

