/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.unwrap.JavaUnwrapper;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JavaTryUnwrapper
extends JavaUnwrapper {
    public JavaTryUnwrapper() {
        super(CodeInsightBundle.message((String)"unwrap.try", (Object[])new Object[0]));
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        if (e == null) {
            JavaTryUnwrapper.$$$reportNull$$$0(0);
        }
        return e instanceof PsiTryStatement;
    }

    protected void doUnwrap(PsiElement element, JavaUnwrapper.Context context) throws IncorrectOperationException {
        PsiTryStatement trySt = (PsiTryStatement)element;
        PsiResourceList resourceList = trySt.getResourceList();
        if (resourceList != null) {
            for (PsiResourceListElement listElement : resourceList) {
                if (!(listElement instanceof PsiResourceVariable)) continue;
                context.extractElement((PsiElement)listElement, (PsiElement)trySt);
                if (!context.isEffective()) continue;
                PsiStatement emptyStatement = JavaPsiFacade.getElementFactory((Project)resourceList.getProject()).createStatementFromText(";", (PsiElement)trySt);
                BlockUtils.addBefore((PsiStatement)trySt, emptyStatement);
            }
        }
        if (RefactoringUtil.isLoopOrIf(trySt.getParent())) {
            trySt = BlockUtils.expandSingleStatementToBlockStatement(trySt);
        }
        context.extractFromCodeBlock(trySt.getTryBlock(), (PsiElement)trySt);
        context.extractFromCodeBlock(trySt.getFinallyBlock(), (PsiElement)trySt);
        context.delete((PsiElement)trySt);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/unwrap/JavaTryUnwrapper", "isApplicableTo"));
    }
}

