/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.MemberLookupHelper;
import com.intellij.codeInsight.completion.StaticallyImportable;
import com.intellij.codeInsight.daemon.impl.JavaColorProvider;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.lookup.DefaultLookupItemRenderer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.codeInsight.lookup.impl.JavaElementLookupRenderer;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.PsiFieldImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableLookupItem
extends LookupItem<PsiVariable>
implements TypedLookupItem,
StaticallyImportable {
    private static final String EQ = " = ";
    @Nullable
    private final MemberLookupHelper myHelper;
    private final Color myColor;
    private final String myTailText;
    private PsiSubstitutor mySubstitutor = PsiSubstitutor.EMPTY;

    public VariableLookupItem(PsiVariable var) {
        super((Object)var, var.getName());
        this.myHelper = null;
        this.myColor = VariableLookupItem.getInitializerColor(var);
        this.myTailText = this.getInitializerText(var);
    }

    public VariableLookupItem(PsiField field, boolean shouldImport) {
        super((Object)field, field.getName());
        this.myHelper = new MemberLookupHelper((PsiMember)field, field.getContainingClass(), shouldImport, false);
        if (!shouldImport) {
            for (String s : JavaCompletionUtil.getAllLookupStrings((PsiMember)field)) {
                this.setLookupString(s);
            }
        }
        this.myColor = VariableLookupItem.getInitializerColor((PsiVariable)field);
        this.myTailText = this.getInitializerText((PsiVariable)field);
    }

    @Nullable
    private String getInitializerText(PsiVariable var) {
        String initText;
        if (this.myColor != null || !var.hasModifierProperty("final") || !var.hasModifierProperty("static")) {
            return null;
        }
        PsiExpression initializer = var instanceof PsiEnumConstant ? ((PsiEnumConstant)var).getArgumentList() : VariableLookupItem.getInitializer(var);
        String string = initText = initializer == null ? null : initializer.getText();
        if (StringUtil.isEmpty((String)initText)) {
            return null;
        }
        String prefix = var instanceof PsiEnumConstant ? "" : EQ;
        String suffix = var instanceof PsiEnumConstant && ((PsiEnumConstant)var).getInitializingClass() != null ? " {...}" : "";
        return StringUtil.trimLog((String)(prefix + initText + suffix), (int)30);
    }

    private static PsiExpression getInitializer(@NotNull PsiVariable var) {
        PsiElement navigationElement;
        if (var == null) {
            VariableLookupItem.$$$reportNull$$$0(0);
        }
        if ((navigationElement = var.getNavigationElement()) instanceof PsiVariable) {
            var = (PsiVariable)navigationElement;
        }
        return var instanceof PsiFieldImpl ? ((PsiFieldImpl)var).getDetachedInitializer() : var.getInitializer();
    }

    @Nullable
    private static Color getInitializerColor(@NotNull PsiVariable var) {
        PsiElement target;
        if (var == null) {
            VariableLookupItem.$$$reportNull$$$0(1);
        }
        if (!JavaColorProvider.isColorType(var.getType())) {
            return null;
        }
        PsiExpression expression2 = VariableLookupItem.getInitializer(var);
        if (expression2 instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)expression2).resolve()) instanceof PsiVariable) {
            return (Color)RecursionManager.doPreventingRecursion((Object)expression2, (boolean)true, () -> VariableLookupItem.getInitializerColor((PsiVariable)target));
        }
        return JavaColorProvider.getJavaColorFromExpression((PsiElement)expression2);
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType = this.getSubstitutor().substitute(((PsiVariable)this.getObject()).getType());
        if (psiType == null) {
            VariableLookupItem.$$$reportNull$$$0(2);
        }
        return psiType;
    }

    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.mySubstitutor;
        if (psiSubstitutor == null) {
            VariableLookupItem.$$$reportNull$$$0(3);
        }
        return psiSubstitutor;
    }

    public VariableLookupItem setSubstitutor(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            VariableLookupItem.$$$reportNull$$$0(4);
        }
        this.mySubstitutor = substitutor;
        return this;
    }

    @Override
    public void setShouldBeImported(boolean shouldImportStatic) {
        assert (this.myHelper != null);
        this.myHelper.setShouldBeImported(shouldImportStatic);
    }

    @Override
    public boolean canBeImported() {
        return this.myHelper != null;
    }

    @Override
    public boolean willBeImported() {
        return this.myHelper != null && this.myHelper.willBeImported();
    }

    public void renderElement(LookupElementPresentation presentation) {
        boolean qualify = this.myHelper != null && !this.myHelper.willBeImported();
        PsiVariable variable = (PsiVariable)this.getObject();
        String name2 = variable.getName();
        if (qualify && variable instanceof PsiField && ((PsiField)variable).getContainingClass() != null) {
            name2 = ((PsiField)variable).getContainingClass().getName() + "." + name2;
        }
        presentation.setItemText(name2);
        presentation.setIcon(DefaultLookupItemRenderer.getRawIcon((LookupElement)this, (boolean)presentation.isReal()));
        presentation.setStrikeout(JavaElementLookupRenderer.isToStrikeout((LookupElement)this));
        if (this.myHelper != null) {
            this.myHelper.renderElement(presentation, qualify, true, this.getSubstitutor());
        }
        if (this.myColor != null) {
            presentation.setTypeText("", (Icon)JBUI.scale((JBUI.JBIcon)new ColorIcon(12, this.myColor)));
        } else {
            presentation.setTypeText(this.getType().getPresentableText());
        }
        if (this.myTailText != null && StringUtil.isEmpty((String)presentation.getTailText())) {
            if (this.myTailText.startsWith(EQ)) {
                presentation.appendTailTextItalic(" (" + this.myTailText + ")", true);
            } else {
                presentation.setTailText(this.myTailText, true);
            }
        }
    }

    public void handleInsert(@NotNull InsertionContext context) {
        char completionChar;
        PsiElement target;
        PsiReferenceExpression ref;
        if (context == null) {
            VariableLookupItem.$$$reportNull$$$0(5);
        }
        PsiVariable variable = (PsiVariable)this.getObject();
        Document document = context.getDocument();
        document.replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)variable.getName());
        context.commitDocument();
        if (variable instanceof PsiField) {
            if (this.willBeImported()) {
                RangeMarker toDelete = JavaCompletionUtil.insertTemporary(context.getTailOffset(), document, " ");
                context.commitDocument();
                PsiReferenceExpression ref2 = (PsiReferenceExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiReferenceExpression.class, (boolean)false);
                if (ref2 != null) {
                    if (ref2.isQualified()) {
                        return;
                    }
                    ref2.bindToElementViaStaticImport(((PsiField)variable).getContainingClass());
                    PostprocessReformattingAspect.getInstance((Project)ref2.getProject()).doPostponedFormatting();
                }
                if (toDelete != null && toDelete.isValid()) {
                    document.deleteString(toDelete.getStartOffset(), toDelete.getEndOffset());
                }
                context.commitDocument();
            } else if (this.shouldQualify((PsiField)variable, context)) {
                VariableLookupItem.qualifyFieldReference(context, (PsiField)variable);
            }
        }
        if ((ref = (PsiReferenceExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)(context.getTailOffset() - 1), PsiReferenceExpression.class, (boolean)false)) != null) {
            JavaCodeStyleManager.getInstance((Project)context.getProject()).shortenClassReferences((PsiElement)ref);
        }
        PsiElement psiElement = target = (ref = (PsiReferenceExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)(context.getTailOffset() - 1), PsiReferenceExpression.class, (boolean)false)) == null ? null : ref.resolve();
        if (target instanceof PsiLocalVariable || target instanceof PsiParameter) {
            VariableLookupItem.makeFinalIfNeeded(context, (PsiVariable)target);
        }
        if ((completionChar = context.getCompletionChar()) == '=') {
            context.setAddCompletionChar(false);
            TailType.EQ.processTail(context.getEditor(), context.getTailOffset());
        } else if (completionChar == ',' && this.getAttribute(LookupItem.TAIL_TYPE_ATTR) != TailType.UNKNOWN) {
            context.setAddCompletionChar(false);
            TailType.COMMA.processTail(context.getEditor(), context.getTailOffset());
            AutoPopupController.getInstance((Project)context.getProject()).autoPopupParameterInfo(context.getEditor(), null);
        } else if (completionChar == ':' && this.getAttribute(LookupItem.TAIL_TYPE_ATTR) != TailType.UNKNOWN && VariableLookupItem.isTernaryCondition(ref)) {
            context.setAddCompletionChar(false);
            TailType.COND_EXPR_COLON.processTail(context.getEditor(), context.getTailOffset());
        } else if (completionChar == '.') {
            AutoPopupController.getInstance((Project)context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
        } else if (completionChar == '!' && PsiType.BOOLEAN.isAssignableFrom(variable.getType())) {
            context.setAddCompletionChar(false);
            if (ref != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishByExclamation");
                document.insertString(ref.getTextRange().getStartOffset(), (CharSequence)"!");
            }
        }
    }

    private static boolean isTernaryCondition(PsiReferenceExpression ref) {
        PsiElement parent = ref == null ? null : ref.getParent();
        return parent instanceof PsiConditionalExpression && ref == ((PsiConditionalExpression)parent).getThenExpression();
    }

    public static void makeFinalIfNeeded(@NotNull InsertionContext context, @NotNull PsiVariable variable) {
        PsiElement place;
        if (context == null) {
            VariableLookupItem.$$$reportNull$$$0(6);
        }
        if (variable == null) {
            VariableLookupItem.$$$reportNull$$$0(7);
        }
        if ((place = context.getFile().findElementAt(context.getTailOffset() - 1)) == null || PsiUtil.isLanguageLevel8OrHigher((PsiElement)place) || JspPsiUtil.isInJspFile((PsiElement)place)) {
            return;
        }
        if (HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, place) != null && !HighlightControlFlowUtil.isReassigned(variable, new HashMap<PsiElement, Collection<ControlFlowUtil.VariableInfo>>())) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)variable, (String)"final", (boolean)true);
        }
    }

    private boolean shouldQualify(PsiField field, InsertionContext context) {
        if (this.myHelper != null && !this.myHelper.willBeImported()) {
            return true;
        }
        PsiReference reference = context.getFile().findReferenceAt(context.getStartOffset());
        if (reference instanceof PsiReferenceExpression && !((PsiReferenceExpression)reference).isQualified()) {
            PsiVariable target = JavaPsiFacade.getInstance((Project)context.getProject()).getResolveHelper().resolveReferencedVariable(field.getName(), (PsiElement)reference);
            return !field.getManager().areElementsEquivalent((PsiElement)target, CompletionUtil.getOriginalOrSelf((PsiElement)field));
        }
        return false;
    }

    private static void qualifyFieldReference(InsertionContext context, PsiField field) {
        context.commitDocument();
        PsiFile file = context.getFile();
        PsiReference reference = file.findReferenceAt(context.getStartOffset());
        if (reference instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)reference).isQualified()) {
            return;
        }
        PsiClass containingClass = field.getContainingClass();
        if (containingClass != null && containingClass.getName() != null) {
            context.getDocument().insertString(context.getStartOffset(), (CharSequence)".");
            JavaCompletionUtil.insertClassReference(containingClass, file, context.getStartOffset());
            PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getDocument());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/VariableLookupItem";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/VariableLookupItem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInitializer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInitializerColor";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSubstitutor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "makeFinalIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

