/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.codeInsight.lookup.DefaultLookupItemRenderer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassConditionKey;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypeLookupItem
extends LookupItem
implements TypedLookupItem {
    private static final InsertHandler<PsiTypeLookupItem> DEFAULT_IMPORT_FIXER = new InsertHandler<PsiTypeLookupItem>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull PsiTypeLookupItem item) {
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            if (item == null) {
                1.$$$reportNull$$$0(1);
            }
            if (item.getObject() instanceof PsiClass) {
                PsiTypeLookupItem.addImportForItem(context, (PsiClass)item.getObject());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/lookup/PsiTypeLookupItem$1";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.lookup.PsiTypeLookupItem");
    public static final ClassConditionKey<PsiTypeLookupItem> CLASS_CONDITION_KEY = ClassConditionKey.create(PsiTypeLookupItem.class);
    private final boolean myDiamond;
    private final int myBracketsCount;
    private boolean myIndicateAnonymous;
    private final InsertHandler<PsiTypeLookupItem> myImportFixer;
    @NotNull
    private final PsiSubstitutor mySubstitutor;
    private boolean myAddArrayInitializer;
    private String myLocationString;
    private final String myForcedPresentableName;

    private PsiTypeLookupItem(Object o, @NotNull @NonNls String lookupString, boolean diamond, int bracketsCount, InsertHandler<PsiTypeLookupItem> fixer, @NotNull PsiSubstitutor substitutor) {
        if (lookupString == null) {
            PsiTypeLookupItem.$$$reportNull$$$0(0);
        }
        if (substitutor == null) {
            PsiTypeLookupItem.$$$reportNull$$$0(1);
        }
        super(o, lookupString);
        this.myLocationString = "";
        this.myDiamond = diamond;
        this.myBracketsCount = bracketsCount;
        this.myImportFixer = fixer;
        this.mySubstitutor = substitutor;
        this.myForcedPresentableName = o instanceof PsiClass && !lookupString.equals(((PsiClass)o).getName()) ? lookupString : null;
    }

    @Override
    @NotNull
    public PsiType getType() {
        Object object = this.getObject();
        PsiType type2 = object instanceof PsiType ? this.getSubstitutor().substitute((PsiType)object) : JavaPsiFacade.getElementFactory((Project)((PsiClass)object).getProject()).createType((PsiClass)object, this.getSubstitutor());
        for (int i = 0; i < this.getBracketsCount(); ++i) {
            type2 = new PsiArrayType(type2);
        }
        PsiType psiType = type2;
        if (psiType == null) {
            PsiTypeLookupItem.$$$reportNull$$$0(2);
        }
        return psiType;
    }

    @Nullable
    public String getForcedPresentableName() {
        return this.myForcedPresentableName;
    }

    public void setIndicateAnonymous(boolean indicateAnonymous) {
        this.myIndicateAnonymous = indicateAnonymous;
    }

    public boolean isIndicateAnonymous() {
        return this.myIndicateAnonymous;
    }

    public boolean equals(Object o) {
        return super.equals(o) && o instanceof PsiTypeLookupItem && this.getBracketsCount() == ((PsiTypeLookupItem)o).getBracketsCount() && this.myAddArrayInitializer == ((PsiTypeLookupItem)o).myAddArrayInitializer;
    }

    public boolean isAddArrayInitializer() {
        return this.myAddArrayInitializer;
    }

    public void setAddArrayInitializer() {
        this.myAddArrayInitializer = true;
    }

    public void handleInsert(@NotNull InsertionContext context) {
        PsiElement position;
        if (context == null) {
            PsiTypeLookupItem.$$$reportNull$$$0(3);
        }
        SmartPsiElementPointer pointer = null;
        if (this.getObject() instanceof PsiElement) {
            PsiElement psiElement = (PsiElement)this.getObject();
            pointer = SmartPointerManager.getInstance((Project)context.getProject()).createSmartPsiElementPointer(psiElement);
        }
        this.myImportFixer.handleInsert(context, (LookupElement)this);
        if (pointer != null) {
            this.setObject(pointer.getElement());
        }
        if ((position = context.getFile().findElementAt(context.getStartOffset())) != null) {
            int genericsStart = context.getTailOffset();
            context.getDocument().insertString(genericsStart, (CharSequence)JavaCompletionUtil.escapeXmlIfNeeded(context, this.calcGenerics(position, context)));
            JavaCompletionUtil.shortenReference(context.getFile(), genericsStart - 1);
        }
        int targetOffset = context.getTailOffset();
        String braces = StringUtil.repeat((String)"[]", (int)this.getBracketsCount());
        Editor editor = context.getEditor();
        if (!braces.isEmpty()) {
            if (this.myAddArrayInitializer) {
                context.getDocument().insertString(targetOffset, (CharSequence)(braces + "{}"));
                targetOffset += braces.length() + 1;
            } else {
                context.getDocument().insertString(targetOffset, (CharSequence)braces);
                ++targetOffset;
                if (context.getCompletionChar() == '[') {
                    context.setAddCompletionChar(false);
                }
            }
            TabOutScopesTracker.getInstance().registerEmptyScope(editor, targetOffset);
        }
        editor.getCaretModel().moveToOffset(targetOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        InsertHandler handler = this.getInsertHandler();
        if (handler != null) {
            handler.handleInsert(context, (LookupElement)this);
        }
    }

    @NotNull
    public String calcGenerics(@NotNull PsiElement context, InsertionContext insertionContext) {
        if (context == null) {
            PsiTypeLookupItem.$$$reportNull$$$0(4);
        }
        if (insertionContext.getCompletionChar() == '<') {
            if ("" == null) {
                PsiTypeLookupItem.$$$reportNull$$$0(5);
            }
            return "";
        }
        assert (context.isValid());
        if (this.myDiamond) {
            if ("<>" == null) {
                PsiTypeLookupItem.$$$reportNull$$$0(6);
            }
            return "<>";
        }
        if (this.getObject() instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)this.getObject();
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getResolveHelper();
            PsiSubstitutor substitutor = this.getSubstitutor();
            StringBuilder builder = new StringBuilder();
            for (PsiTypeParameter parameter2 : psiClass.getTypeParameters()) {
                PsiType substitute = substitutor.substitute(parameter2);
                if (substitute == null || PsiUtil.resolveClassInType((PsiType)substitute) == parameter2 && resolveHelper.resolveReferencedClass(parameter2.getName(), context) != CompletionUtil.getOriginalOrSelf((PsiElement)parameter2)) {
                    if ("" == null) {
                        PsiTypeLookupItem.$$$reportNull$$$0(7);
                    }
                    return "";
                }
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(substitute.getCanonicalText());
            }
            if (builder.length() > 0) {
                String string = "<" + builder + ">";
                if (string == null) {
                    PsiTypeLookupItem.$$$reportNull$$$0(8);
                }
                return string;
            }
        }
        if ("" == null) {
            PsiTypeLookupItem.$$$reportNull$$$0(9);
        }
        return "";
    }

    public int hashCode() {
        int fromSuper = super.hashCode();
        int dim = this.getBracketsCount();
        return fromSuper + dim * 31;
    }

    public int getBracketsCount() {
        return this.myBracketsCount;
    }

    public static PsiTypeLookupItem createLookupItem(@NotNull PsiType type2, @Nullable PsiElement context) {
        if (type2 == null) {
            PsiTypeLookupItem.$$$reportNull$$$0(10);
        }
        boolean diamond = PsiTypeLookupItem.isDiamond(type2);
        return PsiTypeLookupItem.createLookupItem(type2, context, diamond);
    }

    public static PsiTypeLookupItem createLookupItem(@NotNull PsiType type2, @Nullable PsiElement context, boolean isDiamond) {
        if (type2 == null) {
            PsiTypeLookupItem.$$$reportNull$$$0(11);
        }
        return PsiTypeLookupItem.createLookupItem(type2, context, isDiamond, DEFAULT_IMPORT_FIXER);
    }

    public static PsiTypeLookupItem createLookupItem(@NotNull PsiType type2, @Nullable PsiElement context, boolean isDiamond, InsertHandler<PsiTypeLookupItem> importFixer) {
        if (type2 == null) {
            PsiTypeLookupItem.$$$reportNull$$$0(12);
        }
        int dim = 0;
        while (type2 instanceof PsiArrayType) {
            type2 = ((PsiArrayType)type2).getComponentType();
            ++dim;
        }
        return PsiTypeLookupItem.doCreateItem(type2, context, dim, isDiamond, importFixer);
    }

    private static PsiTypeLookupItem doCreateItem(PsiType type2, PsiElement context, int bracketsCount, boolean diamond, InsertHandler<PsiTypeLookupItem> importFixer) {
        String name2;
        PsiClassType.ClassResolveResult classResolveResult;
        PsiClass psiClass;
        if (type2 instanceof PsiClassType && (psiClass = (classResolveResult = ((PsiClassType)type2).resolveGenerics()).getElement()) != null && (name2 = psiClass.getName()) != null) {
            PsiClass resolved = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getResolveHelper().resolveReferencedClass(name2, context);
            String[] allStrings = !psiClass.getManager().areElementsEquivalent((PsiElement)resolved, (PsiElement)psiClass) ? ArrayUtilRt.toStringArray(JavaCompletionUtil.getAllLookupStrings((PsiMember)psiClass)) : new String[]{name2};
            String lookupString = allStrings[allStrings.length - 1];
            PsiTypeLookupItem item = new PsiTypeLookupItem(psiClass, lookupString, diamond, bracketsCount, importFixer, classResolveResult.getSubstitutor());
            item.addLookupStrings(allStrings);
            return item;
        }
        return new PsiTypeLookupItem(type2, type2.getPresentableText(), false, bracketsCount, importFixer, PsiSubstitutor.EMPTY);
    }

    public static boolean isDiamond(PsiType type2) {
        PsiReferenceParameterList parameterList;
        boolean diamond = false;
        if (type2 instanceof PsiClassReferenceType && (parameterList = ((PsiClassReferenceType)type2).getReference().getParameterList()) != null) {
            PsiTypeElement[] typeParameterElements = parameterList.getTypeParameterElements();
            diamond = typeParameterElements.length == 1 && typeParameterElements[0].getType() instanceof PsiDiamondType;
        }
        return diamond;
    }

    @NotNull
    private PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.mySubstitutor;
        if (psiSubstitutor == null) {
            PsiTypeLookupItem.$$$reportNull$$$0(13);
        }
        return psiSubstitutor;
    }

    public void renderElement(LookupElementPresentation presentation) {
        Object object = this.getObject();
        if (object instanceof PsiClass) {
            JavaPsiClassReferenceElement.renderClassItem(presentation, (LookupElement)this, (PsiClass)object, this.myDiamond, this.myLocationString, this.mySubstitutor);
        } else {
            assert (object instanceof PsiType);
            if (!(object instanceof PsiPrimitiveType)) {
                presentation.setIcon(DefaultLookupItemRenderer.getRawIcon((LookupElement)this, (boolean)presentation.isReal()));
            }
            presentation.setItemText(((PsiType)object).getCanonicalText());
            presentation.setItemTextBold(object instanceof PsiPrimitiveType);
            if (this.isAddArrayInitializer()) {
                presentation.setTailText("{...}");
            }
        }
        if (this.myBracketsCount > 0) {
            ArrayList tail = new ArrayList(presentation.getTailFragments());
            presentation.clearTail();
            presentation.appendTailText(StringUtil.repeat((String)"[]", (int)this.myBracketsCount), false);
            for (LookupElementPresentation.TextFragment fragment : tail) {
                presentation.appendTailText(fragment.text, fragment.isGrayed());
            }
        }
    }

    public PsiTypeLookupItem setShowPackage() {
        Object object = this.getObject();
        if (object instanceof PsiClass) {
            this.myLocationString = " (" + PsiFormatUtil.getPackageDisplayName((PsiClass)((PsiClass)object)) + ")";
        }
        return this;
    }

    public static void addImportForItem(InsertionContext context, PsiClass aClass) {
        int tail;
        int startOffset;
        if (aClass.getQualifiedName() == null) {
            return;
        }
        PsiFile file = context.getFile();
        int newTail = JavaCompletionUtil.insertClassReference(aClass, file, startOffset = context.getStartOffset(), tail = context.getTailOffset());
        if (newTail > context.getDocument().getTextLength() || newTail < 0) {
            LOG.error("Invalid offset after insertion\noffset=" + newTail + "\nstart=" + startOffset + "\ntail=" + tail + "\nfile.length=" + file.getTextLength() + "\ndocument=" + context.getDocument() + "\n" + new Throwable(), new Attachment[]{AttachmentFactory.createAttachment((Document)context.getDocument())});
            return;
        }
        context.setTailOffset(newTail);
        JavaCompletionUtil.shortenReference(file, context.getStartOffset());
        PostprocessReformattingAspect.getInstance((Project)context.getProject()).doPostponedFormatting();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/PsiTypeLookupItem";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/PsiTypeLookupItem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calcGenerics";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcGenerics";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createLookupItem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

