/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.singlereturn;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.singlereturn.ExitContext;
import com.intellij.codeInsight.intention.impl.singlereturn.FinishMarker;
import com.intellij.codeInsight.intention.impl.singlereturn.ReturnReplacementContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToSingleReturnAction
extends PsiElementBaseIntentionAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiCodeBlock block;
        if (project == null) {
            ConvertToSingleReturnAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            ConvertToSingleReturnAction.$$$reportNull$$$0(1);
        }
        if ((block = ConvertToSingleReturnAction.findBlock(element)) == null) {
            return;
        }
        ThrowableComputable bodyGenerator = () -> ConvertToSingleReturnAction.generateBody(project, block, ProgressManager.getInstance().getProgressIndicator());
        PsiCodeBlock replacement = (PsiCodeBlock)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (PsiCodeBlock)ReadAction.compute((ThrowableComputable)bodyGenerator), StringUtil.toTitleCase((String)this.getFamilyName()), true, project);
        if (replacement != null) {
            Runnable action = () -> CodeStyleManager.getInstance((Project)project).reformat(block.replace((PsiElement)replacement));
            WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getFamilyName(), null, (Runnable)action, (PsiFile[])new PsiFile[]{element.getContainingFile()});
        }
    }

    @Nullable
    private static PsiCodeBlock generateBody(@NotNull Project project, PsiCodeBlock block, ProgressIndicator indicator) {
        if (project == null) {
            ConvertToSingleReturnAction.$$$reportNull$$$0(2);
        }
        indicator.setIndeterminate(false);
        PsiType returnType = PsiTypesUtil.getMethodReturnType((PsiElement)block);
        if (returnType == null) {
            return null;
        }
        List<PsiReturnStatement> returns = Arrays.asList(PsiUtil.findReturnStatements((PsiCodeBlock)block));
        indicator.checkCanceled();
        indicator.setFraction(0.1);
        FinishMarker marker = FinishMarker.defineFinishMarker(block, returnType, returns);
        indicator.checkCanceled();
        indicator.setFraction(0.2);
        PsiCodeBlock copy = (PsiCodeBlock)block.copy();
        indicator.checkCanceled();
        indicator.setFraction(0.3);
        PsiLocalVariable variable = ConvertToSingleReturnAction.convertReturns(project, copy, returnType, marker, returns.size(), indicator);
        if (variable != null) {
            PsiJavaToken end = Objects.requireNonNull(copy.getRBrace());
            copy.addBefore((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createStatementFromText("return " + variable.getName() + ";", (PsiElement)copy), (PsiElement)end);
        }
        return copy;
    }

    public static PsiLocalVariable convertReturns(@NotNull Project project, PsiCodeBlock block, PsiType returnType, FinishMarker marker, int count, ProgressIndicator indicator) {
        if (project == null) {
            ConvertToSingleReturnAction.$$$reportNull$$$0(3);
        }
        ExitContext exitContext = new ExitContext(block, returnType, marker);
        int i = 0;
        while (true) {
            indicator.checkCanceled();
            indicator.setFraction(0.3 + 0.6 * (double)i++ / (double)count);
            ProgressManager.checkCanceled();
            PsiReturnStatement returnStatement = ConvertToSingleReturnAction.getNonTerminalReturn(block);
            if (returnStatement == null) break;
            ReturnReplacementContext.replaceSingleReturn(project, block, exitContext, returnStatement);
        }
        indicator.setFraction(0.9);
        PsiLocalVariable resultVariable = exitContext.declareVariables();
        indicator.setFraction(0.92);
        return resultVariable;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiCodeBlock block;
        if (project == null) {
            ConvertToSingleReturnAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            ConvertToSingleReturnAction.$$$reportNull$$$0(5);
        }
        if ((block = ConvertToSingleReturnAction.findBlock(element)) == null) {
            return false;
        }
        PsiType returnType = PsiTypesUtil.getMethodReturnType((PsiElement)block);
        return returnType != null && ConvertToSingleReturnAction.getNonTerminalReturn(block) != null;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            ConvertToSingleReturnAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    private static PsiCodeBlock findBlock(PsiElement element) {
        PsiParameterListOwner owner2 = (PsiParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameterListOwner.class, (boolean)false, (Class[])new Class[]{PsiCodeBlock.class});
        if (owner2 == null) {
            return null;
        }
        return (PsiCodeBlock)ObjectUtils.tryCast((Object)owner2.getBody(), PsiCodeBlock.class);
    }

    private static PsiReturnStatement getNonTerminalReturn(@NotNull PsiCodeBlock block) {
        PsiStatement lastStatement;
        if (block == null) {
            ConvertToSingleReturnAction.$$$reportNull$$$0(7);
        }
        if ((lastStatement = (PsiStatement)ArrayUtil.getLastElement((Object[])block.getStatements())) == null) {
            return null;
        }
        class Visitor
        extends JavaRecursiveElementWalkingVisitor {
            private PsiReturnStatement myReturnStatement;
            final /* synthetic */ PsiStatement val$lastStatement;

            Visitor(PsiStatement psiStatement) {
                this.val$lastStatement = psiStatement;
            }

            public void visitReturnStatement(PsiReturnStatement statement) {
                super.visitReturnStatement(statement);
                if (this.val$lastStatement != statement) {
                    this.myReturnStatement = statement;
                    this.stopWalking();
                }
            }

            public void visitExpression(PsiExpression expression2) {
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
            }

            public void visitClass(PsiClass aClass) {
            }
        }
        Visitor visitor = new Visitor(lastStatement);
        block.accept((PsiElementVisitor)visitor);
        return visitor.myReturnStatement;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.convert.to.single.return.name", (Object[])new Object[0]);
        if (string == null) {
            ConvertToSingleReturnAction.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/singlereturn/ConvertToSingleReturnAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/singlereturn/ConvertToSingleReturnAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generateBody";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertReturns";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNonTerminalReturn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

