/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapWithUnmodifiableAction
extends BaseIntentionAction {
    private static final String JAVA_UTIL_SORTED_SET = "java.util.SortedSet";
    private static final String JAVA_UTIL_SORTED_MAP = "java.util.SortedMap";

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiClass expectedClass;
        PsiClass psiClass;
        if (project == null) {
            WrapWithUnmodifiableAction.$$$reportNull$$$0(0);
        }
        if (editor == null || file == null || !WrapWithUnmodifiableAction.canModify((PsiElement)file)) {
            return;
        }
        PsiExpression expression2 = WrapWithUnmodifiableAction.getParentExpression(editor, file);
        if (expression2 != null && (psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType())) != null && (expectedClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)WrapWithUnmodifiableAction.getExpectedType(expression2))) != null) {
            GlobalSearchScope scope = psiClass.getResolveScope();
            if (WrapWithUnmodifiableAction.isInheritorChain(psiClass, "java.util.List", expectedClass, scope, project)) {
                WrapWithUnmodifiableAction.wrapWith(expression2, "unmodifiableList");
            } else if (WrapWithUnmodifiableAction.isInheritorChain(psiClass, JAVA_UTIL_SORTED_SET, expectedClass, scope, project)) {
                WrapWithUnmodifiableAction.wrapWith(expression2, "unmodifiableSortedSet");
            } else if (WrapWithUnmodifiableAction.isInheritorChain(psiClass, "java.util.Set", expectedClass, scope, project)) {
                WrapWithUnmodifiableAction.wrapWith(expression2, "unmodifiableSet");
            } else if (WrapWithUnmodifiableAction.isInheritorChain(psiClass, JAVA_UTIL_SORTED_MAP, expectedClass, scope, project)) {
                WrapWithUnmodifiableAction.wrapWith(expression2, "unmodifiableSortedMap");
            } else if (WrapWithUnmodifiableAction.isInheritorChain(psiClass, "java.util.Map", expectedClass, scope, project)) {
                WrapWithUnmodifiableAction.wrapWith(expression2, "unmodifiableMap");
            }
        }
    }

    @Nullable
    private static PsiExpression getParentExpression(@NotNull Editor editor, @NotNull PsiFile file) {
        PsiMethodCallExpression methodCall;
        PsiElement element;
        PsiExpression expression2;
        if (editor == null) {
            WrapWithUnmodifiableAction.$$$reportNull$$$0(1);
        }
        if (file == null) {
            WrapWithUnmodifiableAction.$$$reportNull$$$0(2);
        }
        if ((expression2 = (PsiExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)(element = file.findElementAt(editor.getCaretModel().getOffset())), (Class[])new Class[]{PsiExpression.class})) == null) {
            element = file.findElementAt(editor.getCaretModel().getOffset() - 1);
            expression2 = (PsiExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiExpression.class});
        }
        if (expression2 != null && (methodCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expression2.getParent(), PsiMethodCallExpression.class)) != null && methodCall.getMethodExpression() == expression2) {
            return methodCall;
        }
        return expression2;
    }

    private static void wrapWith(PsiExpression expression2, String methodName) {
        CommentTracker tracker = new CommentTracker();
        String text2 = "java.util.Collections." + methodName + '(' + tracker.text((PsiElement)expression2) + ')';
        PsiElement result = tracker.replaceAndRestoreComments((PsiElement)expression2, text2);
        JavaCodeStyleManager.getInstance((Project)result.getProject()).shortenClassReferences(result);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            WrapWithUnmodifiableAction.$$$reportNull$$$0(3);
        }
        if (editor == null || file == null || !WrapWithUnmodifiableAction.canModify((PsiElement)file)) {
            return false;
        }
        PsiExpression expression2 = WrapWithUnmodifiableAction.getParentExpression(editor, file);
        if (expression2 != null) {
            PsiClass expectedClass;
            if (PsiUtil.isOnAssignmentLeftHand((PsiExpression)expression2) || WrapWithUnmodifiableAction.isUnmodifiable(expression2)) {
                return false;
            }
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
            if (psiClass != null && (expectedClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)WrapWithUnmodifiableAction.getExpectedType(expression2))) != null) {
                GlobalSearchScope scope = psiClass.getResolveScope();
                if (WrapWithUnmodifiableAction.isInheritorChain(psiClass, "java.util.List", expectedClass, scope, project)) {
                    this.setText(CodeInsightBundle.message((String)"intention.wrap.with.unmodifiable.list", (Object[])new Object[0]));
                    return true;
                }
                if (WrapWithUnmodifiableAction.isInheritorChain(psiClass, "java.util.Set", expectedClass, scope, project) || WrapWithUnmodifiableAction.isInheritorChain(psiClass, JAVA_UTIL_SORTED_SET, expectedClass, scope, project)) {
                    this.setText(CodeInsightBundle.message((String)"intention.wrap.with.unmodifiable.set", (Object[])new Object[0]));
                    return true;
                }
                if (WrapWithUnmodifiableAction.isInheritorChain(psiClass, "java.util.Map", expectedClass, scope, project) || WrapWithUnmodifiableAction.isInheritorChain(psiClass, JAVA_UTIL_SORTED_MAP, expectedClass, scope, project)) {
                    this.setText(CodeInsightBundle.message((String)"intention.wrap.with.unmodifiable.map", (Object[])new Object[0]));
                    return true;
                }
            }
        }
        return false;
    }

    private static PsiType getExpectedType(@NotNull PsiExpression expression2) {
        PsiType expectedType;
        if (expression2 == null) {
            WrapWithUnmodifiableAction.$$$reportNull$$$0(4);
        }
        if ((expectedType = PsiTypesUtil.getExpectedTypeByParent((PsiElement)expression2)) != null) {
            return expectedType;
        }
        return ExpectedTypeUtils.findExpectedType(expression2, false);
    }

    private static boolean isInheritorChain(PsiClass psiClass, String collectionClassName, PsiClass expectedClass, GlobalSearchScope scope, Project project) {
        PsiClass collectionClass = JavaPsiFacade.getInstance((Project)project).findClass(collectionClassName, scope);
        return InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)collectionClass, (boolean)true) && InheritanceUtil.isInheritorOrSelf((PsiClass)collectionClass, (PsiClass)expectedClass, (boolean)true);
    }

    private static boolean isUnmodifiable(@NotNull PsiExpression expression2) {
        Mutability fact;
        if (expression2 == null) {
            WrapWithUnmodifiableAction.$$$reportNull$$$0(5);
        }
        if ((fact = CommonDataflow.getExpressionFact(expression2, DfaFactType.MUTABILITY)) != null && fact.isUnmodifiable()) {
            return true;
        }
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expression2, PsiMethodCallExpression.class);
        if (WrapWithUnmodifiableAction.isUnmodifiableCall(methodCall)) {
            return true;
        }
        PsiExpressionList expressionList = (PsiExpressionList)ObjectUtils.tryCast((Object)ExpressionUtils.getPassThroughParent(expression2), PsiExpressionList.class);
        return expressionList != null && expressionList.getExpressionCount() == 1 && WrapWithUnmodifiableAction.isUnmodifiableCall(methodCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expressionList.getParent(), PsiMethodCallExpression.class));
    }

    private static boolean isUnmodifiableCall(@Nullable PsiMethodCallExpression methodCall) {
        PsiClass psiClass;
        PsiMethod method;
        String name2;
        return methodCall != null && (name2 = methodCall.getMethodExpression().getReferenceName()) != null && name2.startsWith("unmodifiable") && (method = methodCall.resolveMethod()) != null && method.hasModifierProperty("static") && (psiClass = method.getContainingClass()) != null && "java.util.Collections".equals(psiClass.getQualifiedName());
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.wrap.with.unmodifiable", (Object[])new Object[0]);
        if (string == null) {
            WrapWithUnmodifiableAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/WrapWithUnmodifiableAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/WrapWithUnmodifiableAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getParentExpression";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUnmodifiable";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

