/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollapseAnnotationsFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private CollapseAnnotationsFix(PsiAnnotation annotation) {
        super((PsiElement)annotation);
    }

    @NotNull
    public String getText() {
        if ("Collapse repeating annotations" == null) {
            CollapseAnnotationsFix.$$$reportNull$$$0(0);
        }
        return "Collapse repeating annotations";
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            CollapseAnnotationsFix.$$$reportNull$$$0(1);
        }
        if (file == null) {
            CollapseAnnotationsFix.$$$reportNull$$$0(2);
        }
        if (startElement == null) {
            CollapseAnnotationsFix.$$$reportNull$$$0(3);
        }
        if (endElement == null) {
            CollapseAnnotationsFix.$$$reportNull$$$0(4);
        }
        if (!(startElement instanceof PsiAnnotation)) {
            return;
        }
        PsiAnnotation annotation = (PsiAnnotation)startElement;
        PsiNameValuePair attribute = (PsiNameValuePair)ArrayUtil.getFirstElement((Object[])annotation.getParameterList().getAttributes());
        if (attribute == null) {
            return;
        }
        PsiAnnotationMemberValue origValue = attribute.getValue();
        if (origValue == null) {
            return;
        }
        List<PsiAnnotation> annotations2 = CollapseAnnotationsFix.findCollapsibleAnnotations(annotation, attribute);
        ArrayList<PsiAnnotationMemberValue> values = new ArrayList<PsiAnnotationMemberValue>();
        CommentTracker ct = new CommentTracker();
        for (PsiAnnotation anno : annotations2) {
            PsiAnnotationMemberValue value2 = anno.getParameterList().getAttributes()[0].getValue();
            if (value2 instanceof PsiArrayInitializerMemberValue) {
                PsiAnnotationMemberValue[] initializers;
                for (PsiAnnotationMemberValue initializer : initializers = ((PsiArrayInitializerMemberValue)value2).getInitializers()) {
                    values.add(ct.markUnchanged(initializer));
                }
            } else if (value2 != null) {
                values.add(ct.markUnchanged(value2));
            }
            if (anno == annotation) continue;
            ct.delete((PsiElement)anno);
        }
        String newValue = StreamEx.of(values).map(PsiElement::getText).joining((CharSequence)", ", (CharSequence)"{", (CharSequence)"}");
        PsiAnnotation dummy = JavaPsiFacade.getElementFactory((Project)project).createAnnotationFromText("@x(" + newValue + ")", (PsiElement)origValue);
        ct.replaceAndRestoreComments((PsiElement)origValue, (PsiElement)Objects.requireNonNull(dummy.getParameterList().getAttributes()[0].getValue()));
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            CollapseAnnotationsFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static List<PsiAnnotation> findCollapsibleAnnotations(PsiAnnotation annotation, PsiNameValuePair attribute) {
        PsiAnnotationOwner owner2 = annotation.getOwner();
        String name2 = annotation.getQualifiedName();
        if (owner2 == null || name2 == null) {
            return Collections.emptyList();
        }
        ArrayList<PsiAnnotation> annotations2 = new ArrayList<PsiAnnotation>();
        for (PsiAnnotation other : owner2.getAnnotations()) {
            PsiNameValuePair otherAttribute;
            PsiNameValuePair[] otherAttributes;
            if (!name2.equals(other.getQualifiedName()) || (otherAttributes = other.getParameterList().getAttributes()).length != 1 || !(otherAttribute = otherAttributes[0]).getAttributeName().equals(attribute.getAttributeName())) continue;
            annotations2.add(other);
        }
        return annotations2;
    }

    @Nullable
    public static CollapseAnnotationsFix from(PsiAnnotation annotation) {
        PsiAnnotationOwner owner2 = annotation.getOwner();
        String name2 = annotation.getQualifiedName();
        PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        if (owner2 == null || name2 == null || attributes.length != 1) {
            return null;
        }
        PsiNameValuePair attribute = attributes[0];
        if (attribute.getValue() == null) {
            return null;
        }
        PsiMethod annoMethod = CollapseAnnotationsFix.findAttributeMethod(attribute);
        if (annoMethod == null || !(annoMethod.getReturnType() instanceof PsiArrayType)) {
            return null;
        }
        List<PsiAnnotation> annotations2 = CollapseAnnotationsFix.findCollapsibleAnnotations(annotation, attribute);
        if (annotations2.size() < 2) {
            return null;
        }
        return new CollapseAnnotationsFix(annotation);
    }

    @Nullable
    private static PsiMethod findAttributeMethod(PsiNameValuePair attribute) {
        PsiReference ref = attribute.getReference();
        if (ref == null) {
            return null;
        }
        PsiElement target = ref.resolve();
        if (PsiUtil.isAnnotationMethod((PsiElement)target)) {
            return (PsiAnnotationMethod)target;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/CollapseAnnotationsFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/CollapseAnnotationsFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

