/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.JavaPsiConstructorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseMoveInitializerToMethodAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiCompiledElement) {
            return false;
        }
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class, (boolean)false, (Class[])new Class[]{PsiMember.class, PsiCodeBlock.class, PsiDocComment.class});
        if (field == null || this.hasUnsuitableModifiers(field)) {
            return false;
        }
        if (field.getLanguage() != JavaLanguage.INSTANCE) {
            return false;
        }
        PsiExpression initializer = field.getInitializer();
        if (initializer == null || initializer.getNextSibling() instanceof PsiErrorElement) {
            return false;
        }
        PsiClass psiClass = field.getContainingClass();
        return psiClass != null && !psiClass.isInterface() && !(psiClass instanceof PsiAnonymousClass) && !(psiClass instanceof PsiSyntheticClass);
    }

    private boolean hasUnsuitableModifiers(@NotNull PsiField field) {
        if (field == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(2);
        }
        for (String modifier : this.getUnsuitableModifiers()) {
            if (!field.hasModifierProperty(modifier)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected abstract Collection<String> getUnsuitableModifiers();

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(4);
        }
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        assert (field != null);
        PsiClass aClass = field.getContainingClass();
        if (aClass == null) {
            return;
        }
        Collection<PsiMethod> methodsToAddInitialization = this.getOrCreateMethods(project, editor, element.getContainingFile(), aClass);
        if (methodsToAddInitialization.isEmpty()) {
            return;
        }
        List<PsiExpressionStatement> assignments = BaseMoveInitializerToMethodAction.addFieldAssignments(field, methodsToAddInitialization);
        PsiExpression initializer = field.getInitializer();
        if (initializer != null) {
            initializer.delete();
        }
        if (!assignments.isEmpty()) {
            BaseMoveInitializerToMethodAction.highlightRExpression((PsiAssignmentExpression)assignments.get(0).getExpression(), project, editor);
        }
    }

    private static void highlightRExpression(@NotNull PsiAssignmentExpression assignment, @NotNull Project project, Editor editor) {
        if (assignment == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(5);
        }
        if (project == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(6);
        }
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        PsiExpression expression2 = assignment.getRExpression();
        HighlightManager.getInstance((Project)project).addOccurrenceHighlights(editor, new PsiElement[]{expression2}, attributes, false, null);
    }

    @NotNull
    private static List<PsiExpressionStatement> addFieldAssignments(@NotNull PsiField field, @NotNull Collection<? extends PsiMethod> methods) {
        if (field == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(7);
        }
        if (methods == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(8);
        }
        ArrayList<PsiExpressionStatement> assignments = new ArrayList<PsiExpressionStatement>();
        for (PsiMethod psiMethod : methods) {
            assignments.add(BaseMoveInitializerToMethodAction.addAssignment(BaseMoveInitializerToMethodAction.getOrCreateMethodBody(psiMethod), field));
        }
        ArrayList<PsiExpressionStatement> arrayList = assignments;
        if (arrayList == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    private static PsiCodeBlock getOrCreateMethodBody(@NotNull PsiMethod method) {
        PsiCodeBlock codeBlock;
        if (method == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(10);
        }
        if ((codeBlock = method.getBody()) == null) {
            CreateFromUsageUtils.setupMethodBody(method);
            codeBlock = method.getBody();
        }
        PsiCodeBlock psiCodeBlock = codeBlock;
        if (psiCodeBlock == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(11);
        }
        return psiCodeBlock;
    }

    @NotNull
    protected abstract Collection<PsiMethod> getOrCreateMethods(@NotNull Project var1, @NotNull Editor var2, PsiFile var3, @NotNull PsiClass var4);

    @NotNull
    private static PsiExpressionStatement addAssignment(@NotNull PsiCodeBlock codeBlock, @NotNull PsiField field) throws IncorrectOperationException {
        if (codeBlock == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(12);
        }
        if (field == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(13);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)codeBlock.getProject());
        PsiExpressionStatement statement = (PsiExpressionStatement)factory.createStatementFromText(field.getName() + " = y;", (PsiElement)codeBlock);
        PsiExpression initializer = field.getInitializer();
        initializer = RefactoringUtil.convertInitializerToNormalExpression(initializer, field.getType());
        PsiAssignmentExpression expression2 = (PsiAssignmentExpression)statement.getExpression();
        Objects.requireNonNull(expression2.getRExpression()).replace((PsiElement)Objects.requireNonNull(initializer));
        PsiElement newStatement = codeBlock.addBefore((PsiElement)statement, BaseMoveInitializerToMethodAction.findFirstFieldUsage(codeBlock.getStatements(), field));
        BaseMoveInitializerToMethodAction.replaceWithQualifiedReferences(newStatement, newStatement, factory);
        PsiExpressionStatement psiExpressionStatement = (PsiExpressionStatement)newStatement;
        if (psiExpressionStatement == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(14);
        }
        return psiExpressionStatement;
    }

    @Nullable
    private static PsiElement findFirstFieldUsage(@NotNull PsiStatement[] statements, @NotNull PsiField field) {
        if (statements == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(15);
        }
        if (field == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(16);
        }
        for (PsiStatement blockStatement : statements) {
            if (BaseMoveInitializerToMethodAction.isSuperOrThisMethodCall(blockStatement) || !BaseMoveInitializerToMethodAction.containsReference((PsiElement)blockStatement, field)) continue;
            return blockStatement;
        }
        return null;
    }

    private static boolean isSuperOrThisMethodCall(@NotNull PsiStatement statement) {
        if (statement == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(17);
        }
        if (statement instanceof PsiExpressionStatement) {
            PsiExpression expression2 = ((PsiExpressionStatement)statement).getExpression();
            return JavaPsiConstructorUtil.isConstructorCall((PsiElement)expression2);
        }
        return false;
    }

    private static boolean containsReference(@NotNull PsiElement element, final @NotNull PsiField field) {
        if (element == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(18);
        }
        if (field == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(19);
        }
        final Ref result = new Ref((Object)Boolean.FALSE);
        element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                if (expression2.resolve() == field) {
                    result.set((Object)Boolean.TRUE);
                }
                super.visitReferenceExpression(expression2);
            }
        });
        return (Boolean)result.get();
    }

    private static void replaceWithQualifiedReferences(@NotNull PsiElement expression2, @NotNull PsiElement root, @NotNull PsiElementFactory factory) throws IncorrectOperationException {
        PsiReference reference;
        if (expression2 == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(20);
        }
        if (root == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(21);
        }
        if (factory == null) {
            BaseMoveInitializerToMethodAction.$$$reportNull$$$0(22);
        }
        if ((reference = expression2.getReference()) == null) {
            for (PsiElement child : expression2.getChildren()) {
                BaseMoveInitializerToMethodAction.replaceWithQualifiedReferences(child, root, factory);
            }
            return;
        }
        PsiElement resolved = reference.resolve();
        if (resolved instanceof PsiVariable && !(resolved instanceof PsiField) && !PsiTreeUtil.isAncestor((PsiElement)root, (PsiElement)resolved, (boolean)false)) {
            PsiVariable variable = (PsiVariable)resolved;
            PsiExpression qualifiedExpr = factory.createExpressionFromText("this." + variable.getName(), expression2);
            expression2.replace((PsiElement)qualifiedExpr);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 7: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlock";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addFieldAssignments";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateMethodBody";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "addAssignment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasUnsuitableModifiers";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "highlightRExpression";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addFieldAssignments";
                break;
            }
            case 9: 
            case 11: 
            case 14: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateMethodBody";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addAssignment";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findFirstFieldUsage";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSuperOrThisMethodCall";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "containsReference";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithQualifiedReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

