/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.SequencePresentation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u001e\u0010\u0015\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0018\u0010\u001d\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u000e\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/codeInsight/hints/JavaTypeHintsPresentationFactory;", "", "myFactory", "Lcom/intellij/codeInsight/hints/presentation/PresentationFactory;", "myFoldingLevel", "", "(Lcom/intellij/codeInsight/hints/presentation/PresentationFactory;I)V", "classHint", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "aClass", "Lcom/intellij/psi/PsiClass;", "level", "classTypeHint", "classType", "Lcom/intellij/psi/PsiClassType;", "getName", "element", "Lcom/intellij/psi/PsiNamedElement;", "hint", "type", "Lcom/intellij/psi/PsiType;", "join", "presentations", "", "text", "", "joinWithDot", "first", "second", "parametersHint", "typeHint", "wildcardHint", "wildcardType", "Lcom/intellij/psi/PsiWildcardType;", "Companion", "intellij.java.impl"})
public final class JavaTypeHintsPresentationFactory {
    private final PresentationFactory myFactory;
    private final int myFoldingLevel;
    private static final String ANONYMOUS_MARK = "anonymous";
    private static final String PLACEHOLDER_MARK = "...";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final InlayPresentation typeHint(@NotNull PsiType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        return this.myFactory.roundWithBackground(this.hint(type2, 0));
    }

    /*
     * WARNING - void declaration
     */
    private final InlayPresentation hint(PsiType type2, int level) {
        InlayPresentation inlayPresentation;
        PsiType psiType = type2;
        if (psiType instanceof PsiArrayType) {
            InlayPresentation[] inlayPresentationArray = new InlayPresentation[2];
            PsiType psiType2 = ((PsiArrayType)type2).getComponentType();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiType2, (String)"type.componentType");
            inlayPresentationArray[0] = this.hint(psiType2, level);
            inlayPresentationArray[1] = this.myFactory.smallText("[]");
            inlayPresentation = this.myFactory.seq(inlayPresentationArray);
        } else if (psiType instanceof PsiClassType) {
            inlayPresentation = this.classTypeHint((PsiClassType)type2, level);
        } else if (psiType instanceof PsiCapturedWildcardType) {
            InlayPresentation[] inlayPresentationArray = new InlayPresentation[2];
            inlayPresentationArray[0] = this.myFactory.smallText("capture of ");
            PsiWildcardType psiWildcardType = ((PsiCapturedWildcardType)type2).getWildcard();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiWildcardType, (String)"type.wildcard");
            inlayPresentationArray[1] = this.hint((PsiType)psiWildcardType, level);
            inlayPresentation = this.myFactory.seq(inlayPresentationArray);
        } else if (psiType instanceof PsiWildcardType) {
            inlayPresentation = this.wildcardHint((PsiWildcardType)type2, level);
        } else if (psiType instanceof PsiEllipsisType) {
            InlayPresentation[] inlayPresentationArray = new InlayPresentation[2];
            PsiType psiType3 = ((PsiEllipsisType)type2).getComponentType();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiType3, (String)"type.componentType");
            inlayPresentationArray[0] = this.hint(psiType3, level);
            inlayPresentationArray[1] = this.myFactory.smallText(PLACEHOLDER_MARK);
            inlayPresentation = this.myFactory.seq(inlayPresentationArray);
        } else if (psiType instanceof PsiDisjunctionType) {
            Collection<InlayPresentation> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list = ((PsiDisjunctionType)type2).getDisjunctions();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"type.disjunctions");
            Iterable iterable = list;
            JavaTypeHintsPresentationFactory javaTypeHintsPresentationFactory = this;
            boolean $i$f$map = false;
            void var6_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PsiType psiType4 = (PsiType)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void v8 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"it");
                InlayPresentation inlayPresentation2 = this.hint((PsiType)v8, level);
                collection.add(inlayPresentation2);
            }
            collection = (List)destination$iv$iv;
            inlayPresentation = javaTypeHintsPresentationFactory.join((Iterable<? extends InlayPresentation>)collection, " | ");
        } else if (psiType instanceof PsiIntersectionType) {
            Collection<InlayPresentation> collection;
            PsiType[] psiTypeArray = ((PsiIntersectionType)type2).getConjuncts();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeArray, (String)"type.conjuncts");
            PsiType[] $this$map$iv = psiTypeArray;
            JavaTypeHintsPresentationFactory javaTypeHintsPresentationFactory = this;
            boolean $i$f$map = false;
            PsiType[] $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            PsiType[] psiTypeArray2 = $this$mapTo$iv$iv;
            int n = psiTypeArray2.length;
            for (int i = 0; i < n; ++i) {
                void it;
                PsiType item$iv$iv;
                PsiType psiType5 = item$iv$iv = psiTypeArray2[i];
                collection = destination$iv$iv;
                boolean bl = false;
                void v10 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"it");
                InlayPresentation inlayPresentation3 = this.hint((PsiType)v10, level);
                collection.add(inlayPresentation3);
            }
            collection = (List)destination$iv$iv;
            inlayPresentation = javaTypeHintsPresentationFactory.join((Iterable<? extends InlayPresentation>)collection, " & ");
        } else {
            String string = type2.getPresentableText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type.presentableText");
            inlayPresentation = this.myFactory.smallText(string);
        }
        return inlayPresentation;
    }

    private final InlayPresentation classTypeHint(PsiClassType classType, int level) {
        PsiClass qualifier;
        InlayPresentation qualifierPresentation;
        PsiClass aClass = classType.resolve();
        InlayPresentation inlayPresentation = qualifierPresentation = aClass == null ? null : ((qualifier = aClass.getContainingClass()) == null ? null : this.classHint(qualifier, level));
        String string = classType.getClassName();
        if (string == null) {
            string = ANONYMOUS_MARK;
        }
        InlayPresentation className2 = this.myFactory.psiSingleReference(this.myFactory.smallText(string), (Function0)new Function0<PsiClass>(classType){
            final /* synthetic */ PsiClassType $classType;

            @Nullable
            public final PsiClass invoke() {
                return this.$classType.resolve();
            }
            {
                this.$classType = psiClassType;
                super(0);
            }
        });
        if (classType.getParameterCount() == 0) {
            if (qualifierPresentation == null) {
                return className2;
            }
            return this.joinWithDot(qualifierPresentation, className2);
        }
        List presentations = CollectionsKt.mutableListOf((Object[])new InlayPresentation[]{this.joinWithDot(qualifierPresentation, className2)});
        InlayPresentation collapsible2 = this.myFactory.collapsible(this.myFactory.smallText("<"), this.myFactory.smallText(PLACEHOLDER_MARK), (Function0)new Function0<InlayPresentation>(this, classType, level){
            final /* synthetic */ JavaTypeHintsPresentationFactory this$0;
            final /* synthetic */ PsiClassType $classType;
            final /* synthetic */ int $level;

            @NotNull
            public final InlayPresentation invoke() {
                return JavaTypeHintsPresentationFactory.access$parametersHint(this.this$0, this.$classType, this.$level);
            }
            {
                this.this$0 = javaTypeHintsPresentationFactory;
                this.$classType = psiClassType;
                this.$level = n;
                super(0);
            }
        }, this.myFactory.smallText(">"), level > this.myFoldingLevel);
        presentations.add(collapsible2);
        return (InlayPresentation)new SequencePresentation(presentations);
    }

    /*
     * WARNING - void declaration
     */
    private final InlayPresentation parametersHint(PsiClassType classType, int level) {
        Collection<InlayPresentation> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        PsiType[] psiTypeArray = classType.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeArray, (String)"classType.parameters");
        PsiType[] psiTypeArray2 = psiTypeArray;
        JavaTypeHintsPresentationFactory javaTypeHintsPresentationFactory = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var8_9 = $this$mapTo$iv$iv;
        int n = ((void)var8_9).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_13 = item$iv$iv = var8_9[i];
            collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            InlayPresentation inlayPresentation = this.hint((PsiType)v1, level + 1);
            collection.add(inlayPresentation);
        }
        collection = (List)destination$iv$iv;
        return javaTypeHintsPresentationFactory.join((Iterable<? extends InlayPresentation>)collection, ", ");
    }

    private final InlayPresentation classHint(PsiClass aClass, int level) {
        if (aClass.getName() == null) {
            return null;
        }
        PsiClass containingClass = aClass.getContainingClass();
        InlayPresentation containingClassPresentation = containingClass != null ? this.classHint(containingClass, level) : null;
        InlayPresentation className2 = this.myFactory.psiSingleReference(this.getName((PsiNamedElement)aClass), (Function0)new Function0<PsiClass>(aClass){
            final /* synthetic */ PsiClass $aClass;

            @NotNull
            public final PsiClass invoke() {
                return this.$aClass;
            }
            {
                this.$aClass = psiClass;
                super(0);
            }
        });
        if (!aClass.hasTypeParameters()) {
            return containingClassPresentation != null ? this.myFactory.seq(new InlayPresentation[]{containingClassPresentation, this.myFactory.smallText("."), className2}) : className2;
        }
        List presentations = CollectionsKt.mutableListOf((Object[])new InlayPresentation[]{this.joinWithDot(containingClassPresentation, className2)});
        PresentationFactory presentationFactory = this.myFactory;
        List list = presentations;
        boolean bl = false;
        boolean bl2 = false;
        PresentationFactory $this$with = presentationFactory;
        boolean bl3 = false;
        InlayPresentation inlayPresentation = $this$with.collapsible($this$with.smallText("<"), $this$with.smallText(PLACEHOLDER_MARK), (Function0)new Function0<InlayPresentation>(this, aClass){
            final /* synthetic */ JavaTypeHintsPresentationFactory this$0;
            final /* synthetic */ PsiClass $aClass$inlined;
            {
                this.this$0 = javaTypeHintsPresentationFactory;
                this.$aClass$inlined = psiClass;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final InlayPresentation invoke() {
                Collection<InlayPresentation> collection;
                void $this$mapTo$iv$iv;
                PsiTypeParameter[] psiTypeParameterArray = this.$aClass$inlined.getTypeParameters();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeParameterArray, (String)"aClass.typeParameters");
                PsiTypeParameter[] $this$map$iv = psiTypeParameterArray;
                JavaTypeHintsPresentationFactory javaTypeHintsPresentationFactory = this.this$0;
                boolean $i$f$map = false;
                PsiTypeParameter[] psiTypeParameterArray2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                boolean $i$f$mapTo = false;
                void var7_7 = $this$mapTo$iv$iv;
                int n = ((void)var7_7).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var11_11 = item$iv$iv = var7_7[i];
                    collection = destination$iv$iv;
                    boolean bl = false;
                    PresentationFactory presentationFactory = JavaTypeHintsPresentationFactory.access$getMyFactory$p(this.this$0);
                    void v2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                    InlayPresentation inlayPresentation = presentationFactory.psiSingleReference(JavaTypeHintsPresentationFactory.access$getName(this.this$0, (PsiNamedElement)v2), (Function0)new Function0<PsiTypeParameter>((PsiTypeParameter)it){
                        final /* synthetic */ PsiTypeParameter $it;
                        {
                            this.$it = psiTypeParameter;
                            super(0);
                        }

                        public final PsiTypeParameter invoke() {
                            return this.$it;
                        }
                    });
                    collection.add(inlayPresentation);
                }
                collection = (List)destination$iv$iv;
                return JavaTypeHintsPresentationFactory.access$join(javaTypeHintsPresentationFactory, collection, ", ");
            }
        }, $this$with.smallText(">"), false);
        list.add(inlayPresentation);
        return (InlayPresentation)new SequencePresentation(presentations);
    }

    /*
     * WARNING - void declaration
     */
    private final InlayPresentation wildcardHint(PsiWildcardType wildcardType, int level) {
        void type2;
        Pair pair2;
        if (wildcardType.isExtends()) {
            pair2 = TuplesKt.to((Object)"extends", (Object)wildcardType.getExtendsBound());
        } else if (wildcardType.isSuper()) {
            pair2 = TuplesKt.to((Object)"super", (Object)wildcardType.getSuperBound());
        } else {
            return this.myFactory.smallText("?");
        }
        Pair pair3 = pair2;
        String string = (String)pair3.component1();
        PsiType bound = (PsiType)pair3.component2();
        InlayPresentation[] inlayPresentationArray = new InlayPresentation[2];
        inlayPresentationArray[0] = this.myFactory.smallText("? " + (String)type2 + ' ');
        PsiType psiType = bound;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"bound");
        inlayPresentationArray[1] = this.hint(psiType, level);
        return this.myFactory.seq(inlayPresentationArray);
    }

    private final InlayPresentation joinWithDot(InlayPresentation first, InlayPresentation second) {
        if (first == null) {
            return second;
        }
        return this.myFactory.seq(new InlayPresentation[]{first, this.myFactory.smallText("."), second});
    }

    private final InlayPresentation getName(PsiNamedElement element) {
        String string = element.getName();
        if (string == null) {
            string = ANONYMOUS_MARK;
        }
        return this.myFactory.smallText(string);
    }

    private final InlayPresentation join(Iterable<? extends InlayPresentation> presentations, String text2) {
        boolean bl = false;
        List seq = new ArrayList();
        boolean first = true;
        for (InlayPresentation inlayPresentation : presentations) {
            if (!first) {
                seq.add(this.myFactory.smallText(text2));
            }
            seq.add(inlayPresentation);
            first = false;
        }
        return (InlayPresentation)new SequencePresentation(seq);
    }

    public JavaTypeHintsPresentationFactory(@NotNull PresentationFactory myFactory, int myFoldingLevel) {
        Intrinsics.checkParameterIsNotNull((Object)myFactory, (String)"myFactory");
        this.myFactory = myFactory;
        this.myFoldingLevel = myFoldingLevel;
    }

    public static final /* synthetic */ InlayPresentation access$parametersHint(JavaTypeHintsPresentationFactory $this, PsiClassType classType, int level) {
        return $this.parametersHint(classType, level);
    }

    public static final /* synthetic */ InlayPresentation access$join(JavaTypeHintsPresentationFactory $this, Iterable presentations, String text2) {
        return $this.join(presentations, text2);
    }

    public static final /* synthetic */ PresentationFactory access$getMyFactory$p(JavaTypeHintsPresentationFactory $this) {
        return $this.myFactory;
    }

    public static final /* synthetic */ InlayPresentation access$getName(JavaTypeHintsPresentationFactory $this, PsiNamedElement element) {
        return $this.getName(element);
    }

    @JvmStatic
    @NotNull
    public static final InlayPresentation presentation(@NotNull PsiType type2, @NotNull PresentationFactory factory) {
        return Companion.presentation(type2, factory);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/codeInsight/hints/JavaTypeHintsPresentationFactory$Companion;", "", "()V", "ANONYMOUS_MARK", "", "PLACEHOLDER_MARK", "presentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "type", "Lcom/intellij/psi/PsiType;", "factory", "Lcom/intellij/codeInsight/hints/presentation/PresentationFactory;", "intellij.java.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final InlayPresentation presentation(@NotNull PsiType type2, @NotNull PresentationFactory factory) {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
            InlayPresentation base = new JavaTypeHintsPresentationFactory(factory, 3).typeHint(type2);
            return factory.roundWithBackground(base);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

