/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.ui;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.ide.wizard.Step;
import com.intellij.ide.wizard.StepAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.ui.AbstractMemberSelectionPanel;
import com.intellij.util.containers.HashMap;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public abstract class AbstractGenerateEqualsWizard<C extends PsiElement, M extends PsiElement, I extends MemberInfoBase<M>>
extends AbstractWizard<Step> {
    protected final C myClass;
    protected final AbstractMemberSelectionPanel<M, I> myEqualsPanel;
    protected final AbstractMemberSelectionPanel<M, I> myHashCodePanel;
    protected final AbstractMemberSelectionPanel<M, I> myNonNullPanel;
    protected final Map<M, I> myFieldsToHashCode;
    protected final Map<M, I> myFieldsToNonNull;
    private int myNonNullStepCode;
    private int myEqualsStepCode;
    private int myHashCodeStepCode;
    protected final List<I> myClassFields;
    protected final Builder<C, M, I> myBuilder;

    protected int getHashCodeStepCode() {
        return this.myHashCodeStepCode;
    }

    protected int getEqualsStepCode() {
        return this.myEqualsStepCode;
    }

    protected int getNonNullStepCode() {
        return this.myNonNullStepCode;
    }

    public AbstractGenerateEqualsWizard(Project project, Builder<C, M, I> builder) {
        super(CodeInsightBundle.message((String)"generate.equals.hashcode.wizard.title", (Object[])new Object[0]), project);
        this.myBuilder = builder;
        this.myClass = builder.getPsiClass();
        this.myClassFields = builder.getClassFields();
        this.myFieldsToHashCode = builder.getFieldsToHashCode();
        this.myFieldsToNonNull = builder.getFieldsToNonNull();
        this.myEqualsPanel = builder.getEqualsPanel();
        this.myHashCodePanel = builder.getHashCodePanel();
        this.myNonNullPanel = builder.getNonNullPanel();
        this.addTableListeners();
        this.addSteps();
        this.init();
        this.updateButtons();
    }

    protected void addSteps() {
        this.myEqualsStepCode = this.addStepForPanel(this.myEqualsPanel);
        this.myHashCodeStepCode = this.addStepForPanel(this.myHashCodePanel);
        this.myNonNullStepCode = this.addStepForPanel(this.myNonNullPanel);
    }

    protected int addStepForPanel(AbstractMemberSelectionPanel<M, I> panel) {
        if (panel != null) {
            this.addStep((Step)new MyStep(panel));
            return this.getStepCount() - 1;
        }
        return -1;
    }

    protected void addTableListeners() {
        MyTableModelListener listener = new MyTableModelListener();
        if (this.myEqualsPanel != null) {
            this.myEqualsPanel.getTable().getModel().addTableModelListener(listener);
        }
        if (this.myHashCodePanel != null) {
            this.myHashCodePanel.getTable().getModel().addTableModelListener(listener);
        }
    }

    protected void doNextAction() {
        if (this.getCurrentStep() == this.getEqualsStepCode() && this.myEqualsPanel != null) {
            this.equalsFieldsSelected();
        } else if (this.getCurrentStep() == this.getHashCodeStepCode() && this.myHashCodePanel != null) {
            Collection selectedMemberInfos = this.myEqualsPanel != null ? this.myEqualsPanel.getTable().getSelectedMemberInfos() : this.myHashCodePanel.getTable().getSelectedMemberInfos();
            this.updateNonNullMemberInfos(selectedMemberInfos);
        }
        super.doNextAction();
        this.updateButtons();
    }

    protected String getHelpID() {
        return "editing.altInsert.equals";
    }

    private void equalsFieldsSelected() {
        Collection selectedMemberInfos = this.myEqualsPanel.getTable().getSelectedMemberInfos();
        this.updateHashCodeMemberInfos(selectedMemberInfos);
        this.updateNonNullMemberInfos(selectedMemberInfos);
    }

    protected void doOKAction() {
        if (this.myEqualsPanel != null) {
            this.equalsFieldsSelected();
        }
        super.doOKAction();
    }

    protected void updateHashCodeMemberInfos(Collection<I> equalsMemberInfos) {
        this.myBuilder.updateHashCodeMemberInfos(equalsMemberInfos);
    }

    protected void updateNonNullMemberInfos(Collection<I> equalsMemberInfos) {
        this.myBuilder.updateNonNullMemberInfos(equalsMemberInfos);
    }

    protected boolean canGoNext() {
        if (this.getCurrentStep() == this.myEqualsStepCode) {
            for (MemberInfoBase classField : this.myClassFields) {
                if (!classField.isChecked()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public JComponent getPreferredFocusedComponent() {
        Component stepComponent = this.getCurrentStepComponent();
        if (stepComponent instanceof AbstractMemberSelectionPanel) {
            return ((AbstractMemberSelectionPanel)stepComponent).getTable();
        }
        return null;
    }

    private static class MyStep
    extends StepAdapter {
        final AbstractMemberSelectionPanel myPanel;

        MyStep(AbstractMemberSelectionPanel panel) {
            this.myPanel = panel;
        }

        public Icon getIcon() {
            return null;
        }

        public JComponent getComponent() {
            return this.myPanel;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myPanel.getTable();
        }
    }

    private class MyTableModelListener
    implements TableModelListener {
        private MyTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent modelEvent) {
            AbstractGenerateEqualsWizard.this.updateButtons();
        }
    }

    public static abstract class Builder<C extends PsiElement, M extends PsiElement, I extends MemberInfoBase<M>> {
        protected abstract C getPsiClass();

        protected abstract List<I> getClassFields();

        protected abstract HashMap<M, I> getFieldsToHashCode();

        protected abstract HashMap<M, I> getFieldsToNonNull();

        protected abstract AbstractMemberSelectionPanel<M, I> getEqualsPanel();

        protected abstract AbstractMemberSelectionPanel<M, I> getHashCodePanel();

        protected abstract AbstractMemberSelectionPanel<M, I> getNonNullPanel();

        protected abstract void updateHashCodeMemberInfos(Collection<? extends I> var1);

        protected abstract void updateNonNullMemberInfos(Collection<? extends I> var1);
    }
}

