/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.MethodImplementor;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.ImplementMethodsHandler;
import com.intellij.codeInsight.generation.JavaOverrideImplementMemberChooser;
import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.codeInsight.generation.OverrideImplementsAnnotationsHandler;
import com.intellij.codeInsight.generation.OverrideMethodsHandler;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.JavaTemplateUtil;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverrideImplementUtil
extends OverrideImplementExploreUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.OverrideImplementUtil");
    public static final String IMPLEMENT_COMMAND_MARKER = "implement";

    private OverrideImplementUtil() {
    }

    @NotNull
    protected static List<MethodImplementor> getImplementors() {
        List list = MethodImplementor.EXTENSION_POINT_NAME.getExtensionList();
        if (list == null) {
            OverrideImplementUtil.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public static List<PsiMethod> overrideOrImplementMethod(@NotNull PsiClass aClass, @NotNull PsiMethod method, boolean toCopyJavaDoc) throws IncorrectOperationException {
        PsiClass containingClass;
        if (aClass == null) {
            OverrideImplementUtil.$$$reportNull$$$0(1);
        }
        if (method == null) {
            OverrideImplementUtil.$$$reportNull$$$0(2);
        }
        LOG.assertTrue((containingClass = method.getContainingClass()) != null);
        PsiSubstitutor substitutor = aClass.isInheritor(containingClass, true) ? TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY) : PsiSubstitutor.EMPTY;
        List<PsiMethod> list = OverrideImplementUtil.overrideOrImplementMethod(aClass, method, substitutor, toCopyJavaDoc, JavaCodeStyleSettings.getInstance((PsiFile)aClass.getContainingFile()).INSERT_OVERRIDE_ANNOTATION);
        if (list == null) {
            OverrideImplementUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    public static boolean isInsertOverride(@NotNull PsiMethod superMethod, @NotNull PsiClass targetClass) {
        if (superMethod == null) {
            OverrideImplementUtil.$$$reportNull$$$0(4);
        }
        if (targetClass == null) {
            OverrideImplementUtil.$$$reportNull$$$0(5);
        }
        if (!JavaCodeStyleSettings.getInstance((PsiFile)targetClass.getContainingFile()).INSERT_OVERRIDE_ANNOTATION) {
            return false;
        }
        return OverrideImplementUtil.canInsertOverride(superMethod, targetClass);
    }

    public static boolean canInsertOverride(@NotNull PsiMethod superMethod, @NotNull PsiClass targetClass) {
        if (superMethod == null) {
            OverrideImplementUtil.$$$reportNull$$$0(6);
        }
        if (targetClass == null) {
            OverrideImplementUtil.$$$reportNull$$$0(7);
        }
        if (superMethod.isConstructor() || superMethod.hasModifierProperty("static")) {
            return false;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)targetClass)) {
            return false;
        }
        if (PsiUtil.isLanguageLevel6OrHigher((PsiElement)targetClass)) {
            return true;
        }
        PsiClass superClass = superMethod.getContainingClass();
        return superClass != null && !superClass.isInterface();
    }

    @NotNull
    public static List<PsiMethod> overrideOrImplementMethod(@NotNull PsiClass aClass, @NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, boolean toCopyJavaDoc, boolean insertOverrideIfPossible) throws IncorrectOperationException {
        if (aClass == null) {
            OverrideImplementUtil.$$$reportNull$$$0(8);
        }
        if (method == null) {
            OverrideImplementUtil.$$$reportNull$$$0(9);
        }
        if (substitutor == null) {
            OverrideImplementUtil.$$$reportNull$$$0(10);
        }
        if (!method.isValid() || !substitutor.isValid()) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                OverrideImplementUtil.$$$reportNull$$$0(11);
            }
            return list;
        }
        ArrayList<PsiMethod> results = new ArrayList<PsiMethod>();
        for (MethodImplementor implementor : OverrideImplementUtil.getImplementors()) {
            PsiMethod[] prototypes;
            for (PsiMethod prototype : prototypes = implementor.createImplementationPrototypes(aClass, method)) {
                implementor.createDecorator(aClass, method, toCopyJavaDoc, insertOverrideIfPossible).consume((Object)prototype);
                results.add(prototype);
            }
        }
        if (results.isEmpty()) {
            PsiAnnotationMemberValue defaultValue;
            PsiMethod method1 = GenerateMembersUtil.substituteGenericMethod(method, substitutor, (PsiElement)aClass);
            PsiElement copyClass = OverrideImplementUtil.copyClass(aClass);
            PsiMethod result = (PsiMethod)copyClass.add((PsiElement)method1);
            if (PsiUtil.isAnnotationMethod((PsiElement)result) && (defaultValue = ((PsiAnnotationMethod)result).getDefaultValue()) != null) {
                PsiAnnotationMemberValue defaultKeyword;
                for (defaultKeyword = defaultValue; !(defaultKeyword instanceof PsiKeyword) && defaultKeyword != null; defaultKeyword = defaultKeyword.getPrevSibling()) {
                }
                if (defaultKeyword == null) {
                    defaultKeyword = defaultValue;
                }
                defaultValue.getParent().deleteChildRange((PsiElement)defaultKeyword, (PsiElement)defaultValue);
            }
            Consumer<PsiMethod> decorator = OverrideImplementUtil.createDefaultDecorator(aClass, method, toCopyJavaDoc, insertOverrideIfPossible);
            decorator.consume((Object)result);
            results.add(result);
        }
        results.removeIf(m -> aClass.findMethodBySignature(m, false) != null);
        ArrayList<PsiMethod> arrayList = results;
        if (arrayList == null) {
            OverrideImplementUtil.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    private static PsiElement copyClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            OverrideImplementUtil.$$$reportNull$$$0(13);
        }
        Object marker = new Object();
        PsiTreeUtil.mark((PsiElement)aClass, (Object)marker);
        PsiElement copy = aClass.getContainingFile().copy();
        PsiElement copyClass = PsiTreeUtil.releaseMark((PsiElement)copy, (Object)marker);
        LOG.assertTrue(copyClass != null);
        PsiElement psiElement = copyClass;
        if (psiElement == null) {
            OverrideImplementUtil.$$$reportNull$$$0(14);
        }
        return psiElement;
    }

    @NotNull
    public static Consumer<PsiMethod> createDefaultDecorator(@NotNull PsiClass aClass, @NotNull PsiMethod method, boolean toCopyJavaDoc, boolean insertOverrideIfPossible) {
        if (aClass == null) {
            OverrideImplementUtil.$$$reportNull$$$0(15);
        }
        if (method == null) {
            OverrideImplementUtil.$$$reportNull$$$0(16);
        }
        Consumer consumer = result -> OverrideImplementUtil.decorateMethod(aClass, method, toCopyJavaDoc, insertOverrideIfPossible, result);
        if (consumer == null) {
            OverrideImplementUtil.$$$reportNull$$$0(17);
        }
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static PsiMethod decorateMethod(@NotNull PsiClass aClass, @NotNull PsiMethod method, boolean toCopyJavaDoc, boolean insertOverrideIfPossible, @NotNull PsiMethod result) {
        PsiClass containingClass;
        PsiTypeParameterList list;
        if (aClass == null) {
            OverrideImplementUtil.$$$reportNull$$$0(18);
        }
        if (method == null) {
            OverrideImplementUtil.$$$reportNull$$$0(19);
        }
        if (result == null) {
            OverrideImplementUtil.$$$reportNull$$$0(20);
        }
        PsiUtil.setModifierProperty((PsiModifierListOwner)result, (String)"abstract", (aClass.isInterface() && method.hasModifierProperty("abstract") ? 1 : 0) != 0);
        PsiUtil.setModifierProperty((PsiModifierListOwner)result, (String)"native", (boolean)false);
        if (!toCopyJavaDoc) {
            OverrideImplementUtil.deleteDocComment(result);
        }
        if ((list = result.getTypeParameterList()) != null && (containingClass = method.getContainingClass()) != null) {
            for (PsiClassType classType : aClass.getSuperTypes()) {
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)PsiUtil.resolveClassInType((PsiType)classType), (PsiClass)containingClass, (boolean)true) || !classType.isRaw()) continue;
                list.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createTypeParameterList());
                break;
            }
        }
        OverrideImplementUtil.annotateOnOverrideImplement(result, aClass, method, insertOverrideIfPossible);
        if (JavaCodeStyleSettings.getInstance((PsiFile)aClass.getContainingFile()).REPEAT_SYNCHRONIZED && method.hasModifierProperty("synchronized")) {
            result.getModifierList().setModifierProperty("synchronized", true);
        }
        PsiCodeBlock body2 = JavaPsiFacade.getElementFactory((Project)method.getProject()).createCodeBlockFromText("{}", null);
        PsiCodeBlock oldBody = result.getBody();
        if (oldBody != null) {
            oldBody.replace((PsiElement)body2);
        } else {
            result.add((PsiElement)body2);
        }
        OverrideImplementUtil.setupMethodBody(result, method, aClass);
        Project project = method.getProject();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        CommonCodeStyleSettings javaSettings = CodeStyle.getLanguageSettings((PsiFile)aClass.getContainingFile(), (Language)JavaLanguage.INSTANCE);
        boolean keepBreaks = javaSettings.KEEP_LINE_BREAKS;
        javaSettings.KEEP_LINE_BREAKS = false;
        try {
            result = (PsiMethod)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)result);
            result = (PsiMethod)codeStyleManager.reformat((PsiElement)result);
        }
        finally {
            javaSettings.KEEP_LINE_BREAKS = keepBreaks;
        }
        PsiMethod psiMethod = result;
        if (psiMethod == null) {
            OverrideImplementUtil.$$$reportNull$$$0(21);
        }
        return psiMethod;
    }

    public static void deleteDocComment(@NotNull PsiMethod result) {
        PsiDocComment comment;
        if (result == null) {
            OverrideImplementUtil.$$$reportNull$$$0(22);
        }
        if ((comment = result.getDocComment()) != null) {
            comment.delete();
        }
    }

    public static void annotateOnOverrideImplement(@NotNull PsiMethod method, @NotNull PsiClass targetClass, @NotNull PsiMethod overridden) {
        if (method == null) {
            OverrideImplementUtil.$$$reportNull$$$0(23);
        }
        if (targetClass == null) {
            OverrideImplementUtil.$$$reportNull$$$0(24);
        }
        if (overridden == null) {
            OverrideImplementUtil.$$$reportNull$$$0(25);
        }
        OverrideImplementUtil.annotateOnOverrideImplement(method, targetClass, overridden, JavaCodeStyleSettings.getInstance((PsiFile)targetClass.getContainingFile()).INSERT_OVERRIDE_ANNOTATION);
    }

    static void annotateOnOverrideImplement(@NotNull PsiMethod method, @NotNull PsiClass targetClass, @NotNull PsiMethod overridden, boolean insertOverride) {
        String overrideAnnotationName;
        if (method == null) {
            OverrideImplementUtil.$$$reportNull$$$0(26);
        }
        if (targetClass == null) {
            OverrideImplementUtil.$$$reportNull$$$0(27);
        }
        if (overridden == null) {
            OverrideImplementUtil.$$$reportNull$$$0(28);
        }
        if (insertOverride && OverrideImplementUtil.canInsertOverride(overridden, targetClass) && !AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)(overrideAnnotationName = Override.class.getName()), (int)0)) {
            AddAnnotationPsiFix.addPhysicalAnnotation(overrideAnnotationName, PsiNameValuePair.EMPTY_ARRAY, method.getModifierList());
        }
        OverrideImplementsAnnotationsHandler.repeatAnnotationsFromSource((PsiModifierListOwner)overridden, (PsiElement)targetClass, (PsiModifierListOwner)method);
    }

    public static void annotate(@NotNull PsiMethod result, @NotNull String fqn, String ... annosToRemove) throws IncorrectOperationException {
        Project project;
        AddAnnotationFix fix2;
        if (result == null) {
            OverrideImplementUtil.$$$reportNull$$$0(29);
        }
        if (fqn == null) {
            OverrideImplementUtil.$$$reportNull$$$0(30);
        }
        if (annosToRemove == null) {
            OverrideImplementUtil.$$$reportNull$$$0(31);
        }
        if ((fix2 = new AddAnnotationFix(fqn, (PsiModifierListOwner)result, annosToRemove)).isAvailable(project = result.getProject(), null, result.getContainingFile())) {
            fix2.invoke(project, null, result.getContainingFile());
        }
    }

    @NotNull
    public static List<PsiGenerationInfo<PsiMethod>> overrideOrImplementMethods(@NotNull PsiClass aClass, @NotNull Collection<? extends PsiMethodMember> candidates, boolean toCopyJavaDoc, boolean toInsertAtOverride) throws IncorrectOperationException {
        if (aClass == null) {
            OverrideImplementUtil.$$$reportNull$$$0(32);
        }
        if (candidates == null) {
            OverrideImplementUtil.$$$reportNull$$$0(33);
        }
        List candidateInfos = ContainerUtil.map2List(candidates, s -> new CandidateInfo(s.getElement(), s.getSubstitutor()));
        List<PsiMethod> methods = OverrideImplementUtil.overrideOrImplementMethodCandidates(aClass, candidateInfos, toCopyJavaDoc, toInsertAtOverride);
        List<PsiGenerationInfo<PsiMethod>> list = OverrideImplementUtil.convert2GenerationInfos(methods);
        if (list == null) {
            OverrideImplementUtil.$$$reportNull$$$0(34);
        }
        return list;
    }

    @NotNull
    public static List<PsiMethod> overrideOrImplementMethodCandidates(@NotNull PsiClass aClass, @NotNull Collection<? extends CandidateInfo> candidates, boolean toCopyJavaDoc, boolean insertOverrideWherePossible) throws IncorrectOperationException {
        if (aClass == null) {
            OverrideImplementUtil.$$$reportNull$$$0(35);
        }
        if (candidates == null) {
            OverrideImplementUtil.$$$reportNull$$$0(36);
        }
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        for (CandidateInfo candidateInfo : candidates) {
            result.addAll(OverrideImplementUtil.overrideOrImplementMethod(aClass, (PsiMethod)candidateInfo.getElement(), candidateInfo.getSubstitutor(), toCopyJavaDoc, insertOverrideWherePossible));
        }
        ArrayList<PsiMethod> arrayList = result;
        if (arrayList == null) {
            OverrideImplementUtil.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiGenerationInfo<PsiMethod>> convert2GenerationInfos(@NotNull Collection<? extends PsiMethod> methods) {
        if (methods == null) {
            OverrideImplementUtil.$$$reportNull$$$0(38);
        }
        List list = ContainerUtil.map2List(methods, s -> OverrideImplementUtil.createGenerationInfo(s));
        if (list == null) {
            OverrideImplementUtil.$$$reportNull$$$0(39);
        }
        return list;
    }

    @NotNull
    public static PsiGenerationInfo<PsiMethod> createGenerationInfo(@NotNull PsiMethod s) {
        if (s == null) {
            OverrideImplementUtil.$$$reportNull$$$0(40);
        }
        PsiGenerationInfo<PsiMethod> psiGenerationInfo = OverrideImplementUtil.createGenerationInfo(s, true);
        if (psiGenerationInfo == null) {
            OverrideImplementUtil.$$$reportNull$$$0(41);
        }
        return psiGenerationInfo;
    }

    @NotNull
    private static PsiGenerationInfo<PsiMethod> createGenerationInfo(@NotNull PsiMethod s, boolean mergeIfExists) {
        if (s == null) {
            OverrideImplementUtil.$$$reportNull$$$0(42);
        }
        for (MethodImplementor implementor : OverrideImplementUtil.getImplementors()) {
            PsiGenerationInfo psiGenerationInfo;
            GenerationInfo info = implementor.createGenerationInfo(s, mergeIfExists);
            if (!(info instanceof PsiGenerationInfo)) continue;
            PsiGenerationInfo psiGenerationInfo2 = psiGenerationInfo = (PsiGenerationInfo)info;
            if (psiGenerationInfo2 == null) {
                OverrideImplementUtil.$$$reportNull$$$0(43);
            }
            return psiGenerationInfo2;
        }
        PsiGenerationInfo<PsiMethod> psiGenerationInfo = new PsiGenerationInfo<PsiMethod>(s);
        if (psiGenerationInfo == null) {
            OverrideImplementUtil.$$$reportNull$$$0(44);
        }
        return psiGenerationInfo;
    }

    @NotNull
    private static String callSuper(@NotNull PsiMethod superMethod, @NotNull PsiMethod overriding) {
        if (superMethod == null) {
            OverrideImplementUtil.$$$reportNull$$$0(45);
        }
        if (overriding == null) {
            OverrideImplementUtil.$$$reportNull$$$0(46);
        }
        String string = OverrideImplementUtil.callSuper(superMethod, overriding, true);
        if (string == null) {
            OverrideImplementUtil.$$$reportNull$$$0(47);
        }
        return string;
    }

    @NotNull
    private static String callSuper(@NotNull PsiMethod superMethod, @NotNull PsiMethod overriding, boolean prependReturn) {
        if (superMethod == null) {
            OverrideImplementUtil.$$$reportNull$$$0(48);
        }
        if (overriding == null) {
            OverrideImplementUtil.$$$reportNull$$$0(49);
        }
        StringBuilder buffer = new StringBuilder();
        if (prependReturn && !superMethod.isConstructor() && !PsiType.VOID.equals((Object)superMethod.getReturnType())) {
            buffer.append("return ");
        }
        buffer.append("super");
        PsiParameter[] parameters2 = overriding.getParameterList().getParameters();
        if (!superMethod.isConstructor()) {
            buffer.append(".");
            buffer.append(superMethod.getName());
        }
        buffer.append("(");
        for (int i = 0; i < parameters2.length; ++i) {
            String name2 = parameters2[i].getName();
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(name2);
        }
        buffer.append(")");
        String string = buffer.toString();
        if (string == null) {
            OverrideImplementUtil.$$$reportNull$$$0(50);
        }
        return string;
    }

    public static void setupMethodBody(@NotNull PsiMethod result, @NotNull PsiMethod originalMethod, @NotNull PsiClass targetClass) throws IncorrectOperationException {
        if (result == null) {
            OverrideImplementUtil.$$$reportNull$$$0(51);
        }
        if (originalMethod == null) {
            OverrideImplementUtil.$$$reportNull$$$0(52);
        }
        if (targetClass == null) {
            OverrideImplementUtil.$$$reportNull$$$0(53);
        }
        boolean isAbstract = originalMethod.hasModifierProperty("abstract") || originalMethod.hasModifierProperty("default");
        String templateName = isAbstract ? "Implemented Method Body.java" : "Overridden Method Body.java";
        FileTemplate template = FileTemplateManager.getInstance((Project)originalMethod.getProject()).getCodeTemplate(templateName);
        OverrideImplementUtil.setupMethodBody(result, originalMethod, targetClass, template);
    }

    public static void setupMethodBody(@NotNull PsiMethod result, @NotNull PsiMethod originalMethod, @NotNull PsiClass targetClass, @NotNull FileTemplate template) throws IncorrectOperationException {
        PsiMethod m;
        String methodText;
        if (result == null) {
            OverrideImplementUtil.$$$reportNull$$$0(54);
        }
        if (originalMethod == null) {
            OverrideImplementUtil.$$$reportNull$$$0(55);
        }
        if (targetClass == null) {
            OverrideImplementUtil.$$$reportNull$$$0(56);
        }
        if (template == null) {
            OverrideImplementUtil.$$$reportNull$$$0(57);
        }
        if (targetClass.isInterface()) {
            if (OverrideImplementUtil.isImplementInterfaceInJava8Interface(targetClass) || originalMethod.hasModifierProperty("default")) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)result, (String)"default", (boolean)true);
            } else {
                PsiCodeBlock body2 = result.getBody();
                if (body2 != null) {
                    body2.delete();
                }
            }
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(template.getExtension());
        PsiType returnType = result.getReturnType();
        if (returnType == null) {
            returnType = PsiType.VOID;
        }
        Properties properties = FileTemplateManager.getInstance((Project)targetClass.getProject()).getDefaultProperties();
        properties.setProperty("RETURN_TYPE", returnType.getPresentableText());
        properties.setProperty("DEFAULT_RETURN_VALUE", PsiTypesUtil.getDefaultValueOfType((PsiType)returnType, (boolean)true));
        properties.setProperty("CALL_SUPER", OverrideImplementUtil.callSuper(originalMethod, result));
        properties.setProperty("PLAIN_CALL_SUPER", OverrideImplementUtil.callSuper(originalMethod, result, false));
        JavaTemplateUtil.setClassAndMethodNameProperties(properties, targetClass, result);
        JVMElementFactory factory = JVMElementFactories.getFactory((Language)targetClass.getLanguage(), (Project)originalMethod.getProject());
        if (factory == null) {
            factory = JavaPsiFacade.getElementFactory((Project)originalMethod.getProject());
        }
        try {
            methodText = "void foo () {\n" + template.getText(properties) + "\n}";
            methodText = FileTemplateUtil.indent((String)methodText, (Project)result.getProject(), (FileType)fileType);
        }
        catch (Exception e) {
            throw new IncorrectOperationException("Failed to parse file template", (Throwable)e);
        }
        try {
            m = factory.createMethodFromText(methodText, (PsiElement)originalMethod);
        }
        catch (IncorrectOperationException e) {
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)CodeInsightBundle.message((String)"override.implement.broken.file.template.message", (Object[])new Object[0]), (String)CodeInsightBundle.message((String)"override.implement.broken.file.template.title", (Object[])new Object[0])));
            return;
        }
        PsiCodeBlock oldBody = result.getBody();
        if (oldBody != null) {
            oldBody.replace((PsiElement)m.getBody());
        }
    }

    private static boolean isImplementInterfaceInJava8Interface(@NotNull PsiClass targetClass) {
        if (targetClass == null) {
            OverrideImplementUtil.$$$reportNull$$$0(58);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)targetClass)) {
            return false;
        }
        String commandName = CommandProcessor.getInstance().getCurrentCommandName();
        return commandName != null && StringUtil.containsIgnoreCase((String)commandName, (String)IMPLEMENT_COMMAND_MARKER);
    }

    public static void chooseAndOverrideMethods(Project project, Editor editor, PsiClass aClass) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        OverrideImplementUtil.chooseAndOverrideOrImplementMethods(project, editor, aClass, false);
    }

    public static void chooseAndImplementMethods(Project project, Editor editor, PsiClass aClass) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        OverrideImplementUtil.chooseAndOverrideOrImplementMethods(project, editor, aClass, true);
    }

    public static void chooseAndOverrideOrImplementMethods(Project project, Editor editor, @NotNull PsiClass aClass, boolean toImplement) {
        if (aClass == null) {
            OverrideImplementUtil.$$$reportNull$$$0(59);
        }
        LOG.assertTrue(aClass.isValid());
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<CandidateInfo> candidates = OverrideImplementUtil.getMethodsToOverrideImplement(aClass, toImplement);
        ArrayList<CandidateInfo> secondary = toImplement || aClass.isInterface() ? new ArrayList<CandidateInfo>() : OverrideImplementUtil.getMethodsToOverrideImplement(aClass, true);
        MemberChooser<PsiMethodMember> chooser = OverrideImplementUtil.showOverrideImplementChooser(editor, (PsiElement)aClass, toImplement, candidates, secondary);
        if (chooser == null) {
            return;
        }
        List selectedElements = chooser.getSelectedElements();
        if (selectedElements == null || selectedElements.isEmpty()) {
            return;
        }
        LOG.assertTrue(aClass.isValid());
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{aClass.getContainingFile()}).run(() -> OverrideImplementUtil.overrideOrImplementMethodsInRightPlace(editor, aClass, selectedElements, chooser.isCopyJavadoc(), chooser.isInsertOverrideAnnotation()));
    }

    @Nullable
    public static MemberChooser<PsiMethodMember> showOverrideImplementChooser(@NotNull Editor editor, @NotNull PsiElement aClass, boolean toImplement, @NotNull Collection<CandidateInfo> candidates, @NotNull Collection<CandidateInfo> secondary) {
        JavaOverrideImplementMemberChooser chooser;
        if (editor == null) {
            OverrideImplementUtil.$$$reportNull$$$0(60);
        }
        if (aClass == null) {
            OverrideImplementUtil.$$$reportNull$$$0(61);
        }
        if (candidates == null) {
            OverrideImplementUtil.$$$reportNull$$$0(62);
        }
        if (secondary == null) {
            OverrideImplementUtil.$$$reportNull$$$0(63);
        }
        if (toImplement) {
            Iterator<CandidateInfo> iterator = candidates.iterator();
            while (iterator.hasNext()) {
                CandidateInfo candidate = iterator.next();
                PsiElement element = candidate.getElement();
                if (!(element instanceof PsiMethod) || !((PsiMethod)element).hasModifierProperty("default")) continue;
                iterator.remove();
                secondary.add(candidate);
            }
        }
        if ((chooser = JavaOverrideImplementMemberChooser.create(aClass, toImplement, candidates, secondary)) == null) {
            return null;
        }
        Project project = aClass.getProject();
        OverrideImplementUtil.registerHandlerForComplementaryAction(project, editor, aClass, toImplement, chooser);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return chooser;
        }
        chooser.show();
        if (chooser.getExitCode() != 0) {
            return null;
        }
        return chooser;
    }

    private static void registerHandlerForComplementaryAction(final @NotNull Project project, final @NotNull Editor editor, final @NotNull PsiElement aClass, final boolean toImplement, final @NotNull MemberChooser<PsiMethodMember> chooser) {
        String s;
        if (project == null) {
            OverrideImplementUtil.$$$reportNull$$$0(64);
        }
        if (editor == null) {
            OverrideImplementUtil.$$$reportNull$$$0(65);
        }
        if (aClass == null) {
            OverrideImplementUtil.$$$reportNull$$$0(66);
        }
        if (chooser == null) {
            OverrideImplementUtil.$$$reportNull$$$0(67);
        }
        JComponent preferredFocusedComponent = chooser.getPreferredFocusedComponent();
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcuts = keymap.getShortcuts(s = toImplement ? "OverrideMethods" : "ImplementMethods");
        if (shortcuts.length > 0 && shortcuts[0] instanceof KeyboardShortcut) {
            preferredFocusedComponent.getInputMap().put(((KeyboardShortcut)shortcuts[0]).getFirstKeyStroke(), s);
            preferredFocusedComponent.getActionMap().put(s, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    chooser.close(1);
                    TransactionGuard.getInstance().submitTransactionLater((Disposable)project, () -> {
                        OverrideMethodsHandler handler = toImplement ? new OverrideMethodsHandler() : new ImplementMethodsHandler();
                        handler.invoke(project, editor, aClass.getContainingFile());
                    });
                }
            });
        }
    }

    public static void overrideOrImplementMethodsInRightPlace(@NotNull Editor editor, @NotNull PsiClass aClass, @NotNull Collection<? extends PsiMethodMember> candidates, boolean copyJavadoc, boolean insertOverrideWherePossible) {
        if (editor == null) {
            OverrideImplementUtil.$$$reportNull$$$0(68);
        }
        if (aClass == null) {
            OverrideImplementUtil.$$$reportNull$$$0(69);
        }
        if (candidates == null) {
            OverrideImplementUtil.$$$reportNull$$$0(70);
        }
        try {
            List<Object> resultMembers;
            int lbraceOffset;
            int offset = editor.getCaretModel().getOffset();
            PsiElement brace = aClass.getLBrace();
            if (brace == null) {
                PsiClass psiClass = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createClass("X");
                brace = aClass.addRangeAfter(psiClass.getLBrace(), psiClass.getRBrace(), aClass.getLastChild());
                LOG.assertTrue(brace != null, (Object)aClass.getLastChild());
            }
            if (offset <= (lbraceOffset = brace.getTextOffset()) || aClass.isEnum()) {
                resultMembers = new ArrayList();
                for (PsiMethodMember psiMethodMember : candidates) {
                    List<PsiMethod> prototypes = OverrideImplementUtil.overrideOrImplementMethod(aClass, (PsiMethod)psiMethodMember.getElement(), psiMethodMember.getSubstitutor(), copyJavadoc, insertOverrideWherePossible);
                    List<PsiGenerationInfo<PsiMethod>> infos = OverrideImplementUtil.convert2GenerationInfos(prototypes);
                    for (PsiGenerationInfo<PsiMethod> info : infos) {
                        PsiElement anchor = OverrideImplementUtil.getDefaultAnchorToOverrideOrImplement(aClass, (PsiMethod)psiMethodMember.getElement(), psiMethodMember.getSubstitutor());
                        info.insert(aClass, anchor, true);
                        resultMembers.add(info);
                    }
                }
            } else {
                List<PsiGenerationInfo<PsiMethod>> prototypes = OverrideImplementUtil.overrideOrImplementMethods(aClass, candidates, copyJavadoc, insertOverrideWherePossible);
                resultMembers = GenerateMembersUtil.insertMembersAtOffset(aClass, offset, prototypes);
            }
            if (!resultMembers.isEmpty()) {
                ((PsiGenerationInfo)resultMembers.get(0)).positionCaret(editor, true);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    public static PsiElement getDefaultAnchorToOverrideOrImplement(@NotNull PsiClass aClass, @NotNull PsiMethod baseMethod, @NotNull PsiSubstitutor substitutor) {
        if (aClass == null) {
            OverrideImplementUtil.$$$reportNull$$$0(71);
        }
        if (baseMethod == null) {
            OverrideImplementUtil.$$$reportNull$$$0(72);
        }
        if (substitutor == null) {
            OverrideImplementUtil.$$$reportNull$$$0(73);
        }
        PsiMethod prevBaseMethod = (PsiMethod)PsiTreeUtil.getPrevSiblingOfType((PsiElement)baseMethod, PsiMethod.class);
        while (prevBaseMethod != null) {
            MethodSignature signature;
            PsiMethod prevMethod;
            String name2;
            String string = name2 = prevBaseMethod.isConstructor() ? aClass.getName() : prevBaseMethod.getName();
            if (name2 != null && (prevMethod = MethodSignatureUtil.findMethodBySignature((PsiClass)aClass, (MethodSignature)(signature = MethodSignatureUtil.createMethodSignature((String)name2, (PsiParameterList)prevBaseMethod.getParameterList(), (PsiTypeParameterList)prevBaseMethod.getTypeParameterList(), (PsiSubstitutor)substitutor, (boolean)prevBaseMethod.isConstructor())), (boolean)false)) != null && prevMethod.isPhysical()) {
                return prevMethod.getNextSibling();
            }
            prevBaseMethod = (PsiMethod)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prevBaseMethod, PsiMethod.class);
        }
        PsiMethod nextBaseMethod = (PsiMethod)PsiTreeUtil.getNextSiblingOfType((PsiElement)baseMethod, PsiMethod.class);
        while (nextBaseMethod != null) {
            MethodSignature signature;
            PsiMethod nextMethod;
            String name3;
            String string = name3 = nextBaseMethod.isConstructor() ? aClass.getName() : nextBaseMethod.getName();
            if (name3 != null && (nextMethod = MethodSignatureUtil.findMethodBySignature((PsiClass)aClass, (MethodSignature)(signature = MethodSignatureUtil.createMethodSignature((String)name3, (PsiParameterList)nextBaseMethod.getParameterList(), (PsiTypeParameterList)nextBaseMethod.getTypeParameterList(), (PsiSubstitutor)substitutor, (boolean)nextBaseMethod.isConstructor())), (boolean)false)) != null && nextMethod.isPhysical()) {
                return nextMethod;
            }
            nextBaseMethod = (PsiMethod)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextBaseMethod, PsiMethod.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<PsiGenerationInfo<PsiMethod>> overrideOrImplement(@NotNull PsiClass psiClass, @NotNull PsiMethod baseMethod) throws IncorrectOperationException {
        if (psiClass == null) {
            OverrideImplementUtil.$$$reportNull$$$0(74);
        }
        if (baseMethod == null) {
            OverrideImplementUtil.$$$reportNull$$$0(75);
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)baseMethod.getProject());
        List<Object> results = new ArrayList();
        List<PsiGenerationInfo<PsiMethod>> prototypes = OverrideImplementUtil.convert2GenerationInfos(OverrideImplementUtil.overrideOrImplementMethod(psiClass, baseMethod, false));
        if (prototypes.isEmpty()) {
            List<PsiGenerationInfo<PsiMethod>> list = Collections.emptyList();
            List<PsiGenerationInfo<PsiMethod>> list2 = list;
            if (list2 == null) {
                OverrideImplementUtil.$$$reportNull$$$0(76);
            }
            return list2;
        }
        PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseMethod.getContainingClass(), (PsiClass)psiClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        PsiElement anchor = OverrideImplementUtil.getDefaultAnchorToOverrideOrImplement(psiClass, baseMethod, substitutor);
        List<Object> list = results = GenerateMembersUtil.insertMembersBeforeAnchor(psiClass, anchor, prototypes);
        List<Object> list3 = list;
        if (list3 == null) {
            OverrideImplementUtil.$$$reportNull$$$0(77);
        }
        return list3;
        finally {
            PsiFile psiFile = psiClass.getContainingFile();
            Editor editor = fileEditorManager.openTextEditor(new OpenFileDescriptor(psiFile.getProject(), psiFile.getVirtualFile()), true);
            if (editor != null && !results.isEmpty()) {
                ((PsiGenerationInfo)results.get(0)).positionCaret(editor, true);
                editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
            }
        }
    }

    @Nullable
    public static PsiClass getContextClass(Project project, @NotNull Editor editor, @NotNull PsiFile file, boolean allowInterface) {
        if (editor == null) {
            OverrideImplementUtil.$$$reportNull$$$0(78);
        }
        if (file == null) {
            OverrideImplementUtil.$$$reportNull$$$0(79);
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        while ((element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) instanceof PsiTypeParameter) {
        }
        PsiClass aClass = (PsiClass)element;
        if (aClass instanceof PsiSyntheticClass) {
            return null;
        }
        return aClass == null || !allowInterface && aClass.isInterface() ? null : aClass;
    }

    public static void overrideOrImplementMethodsInRightPlace(@NotNull Editor editor, @NotNull PsiClass aClass, @NotNull Collection<? extends PsiMethodMember> members, boolean copyJavadoc) {
        if (editor == null) {
            OverrideImplementUtil.$$$reportNull$$$0(80);
        }
        if (aClass == null) {
            OverrideImplementUtil.$$$reportNull$$$0(81);
        }
        if (members == null) {
            OverrideImplementUtil.$$$reportNull$$$0(82);
        }
        boolean insert = JavaCodeStyleSettings.getInstance((PsiFile)aClass.getContainingFile()).INSERT_OVERRIDE_ANNOTATION;
        OverrideImplementUtil.overrideOrImplementMethodsInRightPlace(editor, aClass, members, copyJavadoc, insert);
    }

    @NotNull
    public static List<PsiMethod> overrideOrImplementMethodCandidates(@NotNull PsiClass aClass, @NotNull Collection<? extends CandidateInfo> candidatesToImplement, boolean copyJavadoc) throws IncorrectOperationException {
        if (aClass == null) {
            OverrideImplementUtil.$$$reportNull$$$0(83);
        }
        if (candidatesToImplement == null) {
            OverrideImplementUtil.$$$reportNull$$$0(84);
        }
        boolean insert = JavaCodeStyleSettings.getInstance((PsiFile)aClass.getContainingFile()).INSERT_OVERRIDE_ANNOTATION;
        List<PsiMethod> list = OverrideImplementUtil.overrideOrImplementMethodCandidates(aClass, candidatesToImplement, copyJavadoc, insert);
        if (list == null) {
            OverrideImplementUtil.$$$reportNull$$$0(85);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/generation/OverrideImplementUtil";
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 15: 
            case 18: 
            case 32: 
            case 35: 
            case 59: 
            case 61: 
            case 66: 
            case 69: 
            case 71: 
            case 81: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 9: 
            case 16: 
            case 19: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: 
            case 6: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
            case 5: 
            case 7: 
            case 24: 
            case 27: 
            case 53: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 10: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 20: 
            case 22: 
            case 29: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overridden";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annosToRemove";
                break;
            }
            case 33: 
            case 36: 
            case 62: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overriding";
                break;
            }
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalMethod";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 60: 
            case 65: 
            case 68: 
            case 78: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondary";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooser";
                break;
            }
            case 72: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseMethod";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidatesToImplement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementors";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/generation/OverrideImplementUtil";
                break;
            }
            case 3: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "overrideOrImplementMethod";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "copyClass";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultDecorator";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "decorateMethod";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "overrideOrImplementMethods";
                break;
            }
            case 37: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "overrideOrImplementMethodCandidates";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "convert2GenerationInfos";
                break;
            }
            case 41: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createGenerationInfo";
                break;
            }
            case 47: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "callSuper";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "overrideOrImplement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "overrideOrImplementMethod";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInsertOverride";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canInsertOverride";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copyClass";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultDecorator";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "decorateMethod";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "deleteDocComment";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "annotateOnOverrideImplement";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "overrideOrImplementMethods";
                break;
            }
            case 35: 
            case 36: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "overrideOrImplementMethodCandidates";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "convert2GenerationInfos";
                break;
            }
            case 40: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createGenerationInfo";
                break;
            }
            case 45: 
            case 46: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "callSuper";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "setupMethodBody";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isImplementInterfaceInJava8Interface";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndOverrideOrImplementMethods";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "showOverrideImplementChooser";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "registerHandlerForComplementaryAction";
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "overrideOrImplementMethodsInRightPlace";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultAnchorToOverrideOrImplement";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "overrideOrImplement";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getContextClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

