/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.codeInsight.generation.TemplateGenerationInfo;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.generate.exception.GenerateCodeException;

public abstract class GenerateMembersHandlerBase
implements CodeInsightActionHandler,
ContextAwareActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateMembersHandlerBase");
    private final String myChooserTitle;
    protected boolean myToCopyJavaDoc;

    public GenerateMembersHandlerBase(String chooserTitle) {
        this.myChooserTitle = chooserTitle;
    }

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        PsiClass aClass;
        if (editor == null) {
            GenerateMembersHandlerBase.$$$reportNull$$$0(0);
        }
        if (file == null) {
            GenerateMembersHandlerBase.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            GenerateMembersHandlerBase.$$$reportNull$$$0(2);
        }
        return (aClass = OverrideImplementUtil.getContextClass(file.getProject(), editor, file, false)) != null && this.hasMembers(aClass);
    }

    protected boolean hasMembers(@NotNull PsiClass aClass) {
        if (aClass == null) {
            GenerateMembersHandlerBase.$$$reportNull$$$0(3);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            GenerateMembersHandlerBase.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            GenerateMembersHandlerBase.$$$reportNull$$$0(5);
        }
        if (file == null) {
            GenerateMembersHandlerBase.$$$reportNull$$$0(6);
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor)) {
            return;
        }
        if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project)) {
            return;
        }
        PsiClass aClass = OverrideImplementUtil.getContextClass(project, editor, file, false);
        if (aClass == null || aClass.isInterface()) {
            return;
        }
        LOG.assertTrue(aClass.isValid());
        LOG.assertTrue(aClass.getContainingFile() != null);
        try {
            ClassMember[] members = this.chooseOriginalMembers(aClass, project, editor);
            if (members == null) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(project, () -> {
                int offset = editor.getCaretModel().getOffset();
                try {
                    this.doGenerate(project, editor, aClass, members);
                }
                catch (GenerateCodeException e) {
                    String message2 = e.getMessage();
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (!editor.isDisposed()) {
                            editor.getCaretModel().moveToOffset(offset);
                            HintManager.getInstance().showErrorHint(editor, message2);
                        }
                    }, project.getDisposed());
                }
            }, null, null);
        }
        finally {
            this.cleanup();
        }
    }

    protected void cleanup() {
    }

    private void doGenerate(Project project, Editor editor, PsiClass aClass, ClassMember[] members) {
        int offset = editor.getCaretModel().getOffset();
        int col = editor.getCaretModel().getLogicalPosition().column;
        int line = editor.getCaretModel().getLogicalPosition().line;
        Document document = editor.getDocument();
        int lineStartOffset = document.getLineStartOffset(line);
        CharSequence docText = document.getCharsSequence();
        String textBeforeCaret = docText.subSequence(lineStartOffset, offset).toString();
        String afterCaret = docText.subSequence(offset, document.getLineEndOffset(line)).toString();
        PsiElement lBrace = aClass.getLBrace();
        if (textBeforeCaret.trim().length() > 0 && StringUtil.isEmptyOrSpaces((String)afterCaret) && (lBrace == null || lBrace.getTextOffset() < offset) && !editor.getSelectionModel().hasSelection()) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            offset = editor.getCaretModel().getOffset();
            col = editor.getCaretModel().getLogicalPosition().column;
            line = editor.getCaretModel().getLogicalPosition().line;
        }
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(0, 0));
        int finalOffset = offset;
        List newMembers = (List)WriteAction.compute(() -> GenerateMembersUtil.insertMembersAtOffset(aClass, finalOffset, this.generateMemberPrototypes(aClass, members)));
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, col));
        if (newMembers.isEmpty()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                HintManager.getInstance().showErrorHint(editor, this.getNothingFoundMessage());
            }
            return;
        }
        ArrayList elements = new ArrayList();
        for (GenerationInfo member : newMembers) {
            if (member instanceof TemplateGenerationInfo) continue;
            ContainerUtil.addIfNotNull(elements, (Object)member.getPsiMember());
        }
        GlobalInspectionContextBase.cleanupElements((Project)project, null, (PsiElement[])elements.toArray(PsiElement.EMPTY_ARRAY));
        ArrayList<TemplateGenerationInfo> templates = new ArrayList<TemplateGenerationInfo>();
        for (GenerationInfo member : newMembers) {
            if (!(member instanceof TemplateGenerationInfo)) continue;
            templates.add((TemplateGenerationInfo)member);
        }
        if (!templates.isEmpty()) {
            GenerateMembersHandlerBase.runTemplates(project, editor, templates, 0);
        } else if (!newMembers.isEmpty()) {
            this.notifyOnSuccess(editor, members, newMembers);
        }
    }

    protected void notifyOnSuccess(Editor editor, ClassMember[] members, List<? extends GenerationInfo> generatedMembers) {
        generatedMembers.get(0).positionCaret(editor, false);
    }

    protected String getNothingFoundMessage() {
        return "Nothing found to insert";
    }

    private static void runTemplates(final Project myProject, final Editor editor, final List<? extends TemplateGenerationInfo> templates, final int index) {
        TemplateGenerationInfo info = templates.get(index);
        Template template = info.getTemplate();
        PsiElement element = (PsiElement)Objects.requireNonNull(info.getPsiMember());
        TextRange range = element.getTextRange();
        WriteAction.run(() -> editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset()));
        int offset = range.getStartOffset();
        editor.getCaretModel().moveToOffset(offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        TemplateManager.getInstance((Project)myProject).startTemplate(editor, template, (TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                if (template == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (index + 1 < templates.size()) {
                    ApplicationManager.getApplication().invokeLater(() -> WriteCommandAction.runWriteCommandAction((Project)myProject, () -> GenerateMembersHandlerBase.runTemplates(myProject, editor, templates, index + 1)));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/generation/GenerateMembersHandlerBase$1", "templateFinished"));
            }
        });
    }

    @Nullable
    protected ClassMember[] chooseOriginalMembers(PsiClass aClass, Project project) {
        ClassMember[] allMembers = this.getAllOriginalMembers(aClass);
        return this.chooseMembers(allMembers, false, false, project, null);
    }

    @Nullable
    protected ClassMember[] chooseOriginalMembers(PsiClass aClass, Project project, Editor editor) {
        return this.chooseOriginalMembers(aClass, project);
    }

    @Nullable
    protected ClassMember[] chooseMembers(ClassMember[] members, boolean allowEmptySelection, boolean copyJavadocCheckbox, Project project, @Nullable Editor editor) {
        MemberChooser<ClassMember> chooser = this.createMembersChooser(members, allowEmptySelection, copyJavadocCheckbox, project);
        if (editor != null) {
            int offset = editor.getCaretModel().getOffset();
            ClassMember preselection = null;
            for (ClassMember member : members) {
                TextRange textRange;
                Object owner2;
                if (!(member instanceof PsiElementClassMember) || (owner2 = ((PsiElementClassMember)member).getElement()) == null || (textRange = owner2.getTextRange()) == null || !textRange.contains(offset)) continue;
                preselection = member;
                break;
            }
            if (preselection != null) {
                chooser.selectElements(new ClassMember[]{preselection});
            }
        }
        chooser.show();
        this.myToCopyJavaDoc = chooser.isCopyJavadoc();
        List list = chooser.getSelectedElements();
        return list == null ? null : list.toArray(ClassMember.EMPTY_ARRAY);
    }

    protected MemberChooser<ClassMember> createMembersChooser(ClassMember[] members, boolean allowEmptySelection, boolean copyJavadocCheckbox, Project project) {
        MemberChooser<ClassMember> chooser = new MemberChooser<ClassMember>(members, allowEmptySelection, true, project, this.getHeaderPanel(project), this.getOptionControls()){

            @Nullable
            protected String getHelpId() {
                return GenerateMembersHandlerBase.this.getHelpId();
            }
        };
        chooser.setTitle(this.myChooserTitle);
        chooser.setCopyJavadocVisible(copyJavadocCheckbox);
        return chooser;
    }

    @Nullable
    protected JComponent getHeaderPanel(Project project) {
        return null;
    }

    @Nullable
    protected JComponent[] getOptionControls() {
        return null;
    }

    protected String getHelpId() {
        return null;
    }

    @NotNull
    protected List<? extends GenerationInfo> generateMemberPrototypes(PsiClass aClass, ClassMember[] members) throws IncorrectOperationException {
        ArrayList array = new ArrayList();
        for (ClassMember member : members) {
            Object[] prototypes = this.generateMemberPrototypes(aClass, member);
            if (prototypes == null) continue;
            ContainerUtil.addAll(array, (Object[])prototypes);
        }
        ArrayList arrayList = array;
        if (arrayList == null) {
            GenerateMembersHandlerBase.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    protected abstract ClassMember[] getAllOriginalMembers(PsiClass var1);

    protected abstract GenerationInfo[] generateMemberPrototypes(PsiClass var1, ClassMember var2) throws IncorrectOperationException;

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/generation/GenerateMembersHandlerBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/generation/GenerateMembersHandlerBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generateMemberPrototypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForQuickList";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasMembers";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

