/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.processor.VariablesProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateDelegateHandler
implements LanguageCodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateDelegateHandler");
    private boolean myToCopyJavaDoc;

    public boolean isValidFor(Editor editor, PsiFile file) {
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        return OverrideImplementUtil.getContextClass(editor.getProject(), editor, file, false) != null && GenerateDelegateHandler.isApplicable(file, editor);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            GenerateDelegateHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GenerateDelegateHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            GenerateDelegateHandler.$$$reportNull$$$0(2);
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor)) {
            return;
        }
        if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project)) {
            return;
        }
        PsiElementClassMember target = GenerateDelegateHandler.chooseTarget(file, editor, project);
        if (target == null) {
            return;
        }
        PsiMethodMember[] candidates = this.chooseMethods(target, file, editor, project);
        if (candidates == null || candidates.length == 0) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                int offset = editor.getCaretModel().getOffset();
                ArrayList<PsiGenerationInfo<PsiMethod>> prototypes = new ArrayList<PsiGenerationInfo<PsiMethod>>(candidates.length);
                for (PsiMethodMember candidate : candidates) {
                    prototypes.add(this.generateDelegatePrototype(candidate, (PsiElement)target.getElement()));
                }
                List results = GenerateMembersUtil.insertMembersAtOffset(file, offset, prototypes);
                if (!results.isEmpty()) {
                    PsiMethod firstMethod = (PsiMethod)((PsiGenerationInfo)results.get(0)).getPsiMember();
                    PsiCodeBlock block = firstMethod.getBody();
                    assert (block != null);
                    PsiElement first = block.getFirstBodyElement();
                    assert (first != null);
                    editor.getCaretModel().moveToOffset(first.getTextRange().getStartOffset());
                    editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                    editor.getSelectionModel().removeSelection();
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    private PsiGenerationInfo<PsiMethod> generateDelegatePrototype(PsiMethodMember methodCandidate, PsiElement target) throws IncorrectOperationException {
        PsiMethod method = GenerateMembersUtil.substituteGenericMethod((PsiMethod)methodCandidate.getElement(), methodCandidate.getSubstitutor(), target);
        this.clearMethod(method);
        GenerateDelegateHandler.clearModifiers(method);
        StringBuilder call = new StringBuilder();
        PsiModifierList modifierList = null;
        if (!PsiType.VOID.equals((Object)method.getReturnType())) {
            call.append("return ");
        }
        boolean isMethodStatic = ((PsiMethod)methodCandidate.getElement()).hasModifierProperty("static");
        if (target instanceof PsiField) {
            PsiField field = (PsiField)target;
            modifierList = field.getModifierList();
            if (isMethodStatic) {
                call.append(methodCandidate.getContainingClass().getQualifiedName());
            } else {
                PsiParameter[] parameters2;
                String name2 = field.getName();
                for (PsiParameter parameter2 : parameters2 = method.getParameterList().getParameters()) {
                    if (!name2.equals(parameter2.getName())) continue;
                    call.append("this.");
                    break;
                }
                call.append(name2);
            }
            call.append(".");
        } else if (target instanceof PsiMethod) {
            PsiMethod m = (PsiMethod)target;
            modifierList = m.getModifierList();
            if (isMethodStatic) {
                call.append(methodCandidate.getContainingClass().getQualifiedName()).append(".");
            } else {
                call.append(m.getName());
                call.append("().");
            }
        }
        call.append(method.getName());
        call.append("(");
        PsiParameter[] parameters3 = method.getParameterList().getParameters();
        for (int j = 0; j < parameters3.length; ++j) {
            PsiParameter parameter3 = parameters3[j];
            if (j > 0) {
                call.append(",");
            }
            call.append(parameter3.getName());
        }
        call.append(");");
        PsiManager psiManager = method.getManager();
        PsiStatement stmt = JavaPsiFacade.getElementFactory((Project)psiManager.getProject()).createStatementFromText(call.toString(), (PsiElement)method);
        stmt = (PsiStatement)CodeStyleManager.getInstance((Project)psiManager.getProject()).reformat((PsiElement)stmt);
        method.getBody().add((PsiElement)stmt);
        GenerateMembersUtil.copyAnnotations(((PsiMethod)methodCandidate.getElement()).getModifierList(), method.getModifierList(), SuppressWarnings.class.getName(), Override.class.getName());
        if (isMethodStatic || modifierList != null && modifierList.hasModifierProperty("static")) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"static", (boolean)true);
        }
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"public", (boolean)true);
        PsiClass targetClass = ((PsiMember)target).getContainingClass();
        LOG.assertTrue(targetClass != null);
        PsiMethod overridden = targetClass.findMethodBySignature(method, true);
        if (overridden != null && overridden.getContainingClass() != targetClass) {
            OverrideImplementUtil.annotateOnOverrideImplement(method, targetClass, overridden);
        }
        return new PsiGenerationInfo<PsiMethod>(method);
    }

    private void clearMethod(PsiMethod method) throws IncorrectOperationException {
        PsiDocComment docComment;
        LOG.assertTrue(!method.isPhysical());
        PsiCodeBlock codeBlock = JavaPsiFacade.getElementFactory((Project)method.getProject()).createCodeBlock();
        if (method.getBody() != null) {
            method.getBody().replace((PsiElement)codeBlock);
        } else {
            method.add((PsiElement)codeBlock);
        }
        if (!this.myToCopyJavaDoc && (docComment = method.getDocComment()) != null) {
            docComment.delete();
        }
    }

    private static void clearModifiers(PsiMethod method) throws IncorrectOperationException {
        PsiElement[] children;
        for (PsiElement child : children = method.getModifierList().getChildren()) {
            if (!(child instanceof PsiKeyword)) continue;
            child.delete();
        }
    }

    @Nullable
    private PsiMethodMember[] chooseMethods(PsiElementClassMember targetMember, PsiFile file, Editor editor, Project project) {
        PsiMethodMember[] result;
        PsiMethod[] allMethods;
        PsiClassType.ClassResolveResult resolveResult = null;
        Object target = targetMember.getElement();
        if (target instanceof PsiField) {
            resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)targetMember.getSubstitutor().substitute(((PsiField)target).getType()));
        } else if (target instanceof PsiMethod) {
            resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)targetMember.getSubstitutor().substitute(((PsiMethod)target).getReturnType()));
        }
        if (resolveResult == null || resolveResult.getElement() == null) {
            return null;
        }
        PsiClass targetClass = resolveResult.getElement();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (aClass == null) {
            return null;
        }
        ArrayList<PsiMethodMember> methodInstances = new ArrayList<PsiMethodMember>();
        if (targetClass instanceof PsiTypeParameter) {
            LinkedHashSet meths = new LinkedHashSet();
            for (PsiClass superClass : targetClass.getSupers()) {
                ContainerUtil.addAll(meths, (Object[])superClass.getAllMethods());
            }
            allMethods = meths.toArray(PsiMethod.EMPTY_ARRAY);
        } else {
            allMethods = targetClass.getAllMethods();
        }
        HashSet<MethodSignature> signatures = new HashSet<MethodSignature>();
        HashSet existingSignatures = new HashSet(aClass.getVisibleSignatures());
        HashSet<PsiMethodMember> selection = new HashSet<PsiMethodMember>();
        HashMap<PsiClass, PsiSubstitutor> superSubstitutors = new HashMap<PsiClass, PsiSubstitutor>();
        PsiClass containingClass = targetMember.getContainingClass();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)target.getProject());
        for (PsiMethod method : allMethods) {
            PsiSubstitutor methodSubstitutor;
            MethodSignature signature;
            PsiMethod overridden;
            PsiClass superClass = method.getContainingClass();
            if ("java.lang.Object".equals(superClass.getQualifiedName()) || method.isConstructor() || method.hasModifierProperty("final") && (overridden = containingClass.findMethodBySignature(method, true)) != null && overridden.getContainingClass() != containingClass || MethodSignatureUtil.findMethodBySuperMethod((PsiClass)containingClass, (PsiMethod)method, (boolean)false) != null) continue;
            PsiSubstitutor superSubstitutor = (PsiSubstitutor)superSubstitutors.get(superClass);
            if (superSubstitutor == null) {
                superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)targetClass, (PsiSubstitutor)substitutor);
                superSubstitutors.put(superClass, superSubstitutor);
            }
            if (signatures.contains(signature = method.getSignature(methodSubstitutor = OverrideImplementExploreUtil.correctSubstitutor(method, superSubstitutor)))) continue;
            signatures.add(signature);
            if (!facade.getResolveHelper().isAccessible((PsiMember)method, target, aClass)) continue;
            PsiMethodMember methodMember = new PsiMethodMember(method, methodSubstitutor);
            methodInstances.add(methodMember);
            if (existingSignatures.contains(signature)) continue;
            selection.add(methodMember);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            MemberChooser chooser = new MemberChooser((ClassMember[])methodInstances.toArray(new PsiMethodMember[0]), false, true, project);
            chooser.setTitle(CodeInsightBundle.message((String)"generate.delegate.method.chooser.title", (Object[])new Object[0]));
            chooser.setCopyJavadocVisible(true);
            if (!selection.isEmpty()) {
                chooser.selectElements(selection.toArray(ClassMember.EMPTY_ARRAY));
            }
            chooser.show();
            if (chooser.getExitCode() != 0) {
                return null;
            }
            this.myToCopyJavaDoc = chooser.isCopyJavadoc();
            List list = chooser.getSelectedElements();
            result = list.toArray(new PsiMethodMember[0]);
        } else {
            PsiMethodMember[] psiMethodMemberArray;
            if (methodInstances.isEmpty()) {
                psiMethodMemberArray = new PsiMethodMember[]{};
            } else {
                PsiMethodMember[] psiMethodMemberArray2 = new PsiMethodMember[1];
                psiMethodMemberArray = psiMethodMemberArray2;
                psiMethodMemberArray2[0] = (PsiMethodMember)((Object)methodInstances.get(0));
            }
            result = psiMethodMemberArray;
        }
        return result;
    }

    public void setToCopyJavaDoc(boolean toCopyJavaDoc) {
        this.myToCopyJavaDoc = toCopyJavaDoc;
    }

    public static boolean isApplicable(PsiFile file, Editor editor) {
        PsiElementClassMember[] targetElements = GenerateDelegateHandler.getTargetElements(file, editor);
        return targetElements != null && targetElements.length > 0;
    }

    @Nullable
    private static PsiElementClassMember chooseTarget(PsiFile file, Editor editor, Project project) {
        PsiElementClassMember[] targetElements = GenerateDelegateHandler.getTargetElements(file, editor);
        if (targetElements == null || targetElements.length == 0) {
            return null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            MemberChooser chooser = new MemberChooser((ClassMember[])targetElements, false, false, project);
            chooser.setTitle(CodeInsightBundle.message((String)"generate.delegate.target.chooser.title", (Object[])new Object[0]));
            chooser.setCopyJavadocVisible(false);
            chooser.show();
            if (chooser.getExitCode() != 0) {
                return null;
            }
            List selectedElements = chooser.getSelectedElements();
            if (selectedElements != null && selectedElements.size() > 0) {
                return (PsiElementClassMember)((Object)selectedElements.get(0));
            }
        } else {
            return targetElements[0];
        }
        return null;
    }

    @Nullable
    private static PsiElementClassMember[] getTargetElements(PsiFile file, Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiClass targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        PsiClass aClass = targetClass;
        if (aClass == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        while (aClass != null) {
            GenerateDelegateHandler.collectTargetsInClass(element, targetClass, aClass, result);
            if (aClass.hasModifierProperty("static")) break;
            aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
        }
        return result.toArray(new PsiElementClassMember[0]);
    }

    private static void collectTargetsInClass(PsiElement element, PsiClass targetClass, final PsiClass aClass, List<? super PsiElementClassMember> result) {
        PsiMethod[] methods;
        PsiClass containingClass;
        PsiField[] fields = aClass.getAllFields();
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)aClass.getProject()).getResolveHelper();
        for (PsiField field : fields) {
            PsiType type2 = field.getType();
            if (!helper.isAccessible((PsiMember)field, (PsiElement)aClass, aClass) || !(type2 instanceof PsiClassType) || PsiTreeUtil.isAncestor((PsiElement)field, (PsiElement)element, (boolean)false) && targetClass != aClass || (containingClass = field.getContainingClass()) == null) continue;
            result.add(new PsiFieldMember(field, TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY)));
        }
        for (PsiMethod method : methods = aClass.getAllMethods()) {
            containingClass = method.getContainingClass();
            if (containingClass == null || "java.lang.Object".equals(containingClass.getQualifiedName())) continue;
            PsiType returnType = method.getReturnType();
            if (!PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method) || !helper.isAccessible((PsiMember)method, (PsiElement)aClass, aClass) || !(returnType instanceof PsiClassType) || PsiTreeUtil.isAncestor((PsiElement)method, (PsiElement)element, (boolean)false) && targetClass != aClass) continue;
            result.add(new PsiMethodMember(method, TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY)));
        }
        if (aClass instanceof PsiAnonymousClass) {
            PsiClass scope;
            VariablesProcessor proc = new VariablesProcessor(false){

                @Override
                protected boolean check(PsiVariable var, ResolveState state) {
                    return var.hasModifierProperty("final") && var instanceof PsiLocalVariable || var instanceof PsiParameter;
                }
            };
            for (scope = aClass; !(scope == null || scope instanceof PsiFile || scope instanceof PsiMethod || scope instanceof PsiClassInitializer); scope = scope.getParent()) {
            }
            if (scope != null) {
                PsiScopesUtil.treeWalkUp(proc, (PsiElement)aClass, (PsiElement)scope);
                for (int i = 0; i < proc.size(); ++i) {
                    PsiVariable psiVariable = proc.getResult(i);
                    PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)aClass.getProject());
                    PsiType type3 = psiVariable.getType();
                    if (LambdaUtil.notInferredType((PsiType)type3)) continue;
                    result.add(new PsiFieldMember(elementFactory.createField(psiVariable.getName(), type3 instanceof PsiEllipsisType ? ((PsiEllipsisType)type3).toArrayType() : type3)){

                        @Override
                        protected PsiClass getContainingClass() {
                            return aClass;
                        }
                    });
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/generation/GenerateDelegateHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

