/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.ConstructorBodyGenerator;
import com.intellij.codeInsight.generation.GenerateMembersHandlerBase;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateConstructorHandler
extends GenerateMembersHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateConstructorHandler");
    private boolean myCopyJavadoc;

    public GenerateConstructorHandler() {
        super(CodeInsightBundle.message((String)"generate.constructor.fields.chooser.title", (Object[])new Object[0]));
    }

    @Override
    protected ClassMember[] getAllOriginalMembers(PsiClass aClass) {
        PsiField[] fields = aClass.getFields();
        ArrayList<PsiFieldMember> array = new ArrayList<PsiFieldMember>();
        List implicitUsageProviders = ImplicitUsageProvider.EP_NAME.getExtensionList();
        block0: for (PsiField field : fields) {
            if (field.hasModifierProperty("static") || field.hasModifierProperty("final") && field.getInitializer() != null) continue;
            for (ImplicitUsageProvider provider : implicitUsageProviders) {
                if (!provider.isImplicitWrite((PsiElement)field)) continue;
                continue block0;
            }
            array.add(new PsiFieldMember(field));
        }
        return array.toArray(ClassMember.EMPTY_ARRAY);
    }

    @Override
    @Nullable
    protected ClassMember[] chooseOriginalMembers(PsiClass aClass, Project project) {
        Object[] members;
        ClassMember[] allMembers;
        if (aClass instanceof PsiAnonymousClass) {
            Messages.showMessageDialog((Project)project, (String)CodeInsightBundle.message((String)"error.attempt.to.generate.constructor.for.anonymous.class", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return null;
        }
        this.myCopyJavadoc = false;
        PsiMethod[] baseConstructors = null;
        PsiClass baseClass = aClass.getSuperClass();
        if (baseClass != null) {
            ArrayList<PsiMethod> array = new ArrayList<PsiMethod>();
            for (PsiMethod method : baseClass.getConstructors()) {
                if (!JavaPsiFacade.getInstance((Project)method.getProject()).getResolveHelper().isAccessible((PsiMember)method, (PsiElement)aClass, null)) continue;
                array.add(method);
            }
            if (!array.isEmpty()) {
                if (array.size() == 1) {
                    baseConstructors = new PsiMethod[]{(PsiMethod)array.get(0)};
                } else {
                    PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                    PsiMethodMember[] constructors = (PsiMethodMember[])ContainerUtil.map2Array(array, PsiMethodMember.class, s -> new PsiMethodMember((PsiMethod)s, substitutor));
                    MemberChooser chooser = new MemberChooser((ClassMember[])constructors, false, true, project);
                    chooser.setTitle(CodeInsightBundle.message((String)"generate.constructor.super.constructor.chooser.title", (Object[])new Object[0]));
                    chooser.show();
                    List elements = chooser.getSelectedElements();
                    if (elements == null || elements.isEmpty()) {
                        return null;
                    }
                    baseConstructors = new PsiMethod[elements.size()];
                    for (int i = 0; i < elements.size(); ++i) {
                        PsiMethodMember psiMethodMember = (PsiMethodMember)((Object)elements.get(i));
                        baseConstructors[i] = (PsiMethod)psiMethodMember.getElement();
                    }
                    this.myCopyJavadoc = chooser.isCopyJavadoc();
                }
            }
        }
        if ((allMembers = this.getAllOriginalMembers(aClass)).length == 0) {
            members = ClassMember.EMPTY_ARRAY;
        } else {
            members = this.chooseMembers(allMembers, true, false, project, null);
            if (members == null) {
                return null;
            }
        }
        if (baseConstructors != null) {
            ArrayList<PsiMethodMember> array = new ArrayList<PsiMethodMember>();
            for (void var11_18 : baseConstructors) {
                array.add(new PsiMethodMember((PsiMethod)var11_18));
            }
            ContainerUtil.addAll(array, (Object[])members);
            members = array.toArray(ClassMember.EMPTY_ARRAY);
        }
        return members;
    }

    @Override
    protected MemberChooser<ClassMember> createMembersChooser(ClassMember[] members, boolean allowEmptySelection, boolean copyJavadocCheckbox, Project project) {
        MemberChooser<ClassMember> chooser = super.createMembersChooser(members, allowEmptySelection, copyJavadocCheckbox, project);
        List<ClassMember> preselection = GenerateConstructorHandler.preselect(members);
        if (!preselection.isEmpty()) {
            chooser.selectElements(preselection.toArray(ClassMember.EMPTY_ARRAY));
        }
        return chooser;
    }

    protected static List<ClassMember> preselect(ClassMember[] members) {
        ArrayList<ClassMember> preselection = new ArrayList<ClassMember>();
        for (ClassMember member : members) {
            PsiField psiField;
            if (!(member instanceof PsiFieldMember) || !(psiField = (PsiField)((PsiFieldMember)member).getElement()).hasModifierProperty("final")) continue;
            preselection.add(member);
        }
        return preselection;
    }

    @Override
    @NotNull
    protected List<? extends GenerationInfo> generateMemberPrototypes(PsiClass aClass, ClassMember[] members) throws IncorrectOperationException {
        ArrayList<PsiMethod> baseConstructors = new ArrayList<PsiMethod>();
        ArrayList<PsiField> fieldsVector = new ArrayList<PsiField>();
        for (ClassMember member1 : members) {
            Object member = ((PsiElementClassMember)member1).getElement();
            if (member instanceof PsiMethod) {
                baseConstructors.add((PsiMethod)member);
                continue;
            }
            fieldsVector.add((PsiField)member);
        }
        PsiField[] fields = fieldsVector.toArray(PsiField.EMPTY_ARRAY);
        if (!baseConstructors.isEmpty()) {
            ArrayList<PsiGenerationInfo<PsiMethod>> constructors = new ArrayList<PsiGenerationInfo<PsiMethod>>(baseConstructors.size());
            PsiClass superClass = aClass.getSuperClass();
            assert (superClass != null);
            PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            for (PsiMethod baseConstructor : baseConstructors) {
                baseConstructor = GenerateMembersUtil.substituteGenericMethod(baseConstructor, substitutor, (PsiElement)aClass);
                constructors.add(new PsiGenerationInfo<PsiMethod>(GenerateConstructorHandler.generateConstructorPrototype(aClass, baseConstructor, this.myCopyJavadoc, fields)));
            }
            List<? extends GenerationInfo> constructorsToCreate = GenerateConstructorHandler.filterOutAlreadyInsertedConstructors(aClass, constructors);
            if (!constructorsToCreate.isEmpty()) {
                List<? extends GenerationInfo> list = constructorsToCreate;
                if (list == null) {
                    GenerateConstructorHandler.$$$reportNull$$$0(0);
                }
                return list;
            }
        }
        List<PsiGenerationInfo<PsiMethod>> constructors = Collections.singletonList(new PsiGenerationInfo<PsiMethod>(GenerateConstructorHandler.generateConstructorPrototype(aClass, null, false, fields)));
        List<? extends GenerationInfo> list = GenerateConstructorHandler.filterOutAlreadyInsertedConstructors(aClass, constructors);
        if (list == null) {
            GenerateConstructorHandler.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static List<? extends GenerationInfo> filterOutAlreadyInsertedConstructors(PsiClass aClass, List<? extends GenerationInfo> constructors) {
        boolean alreadyExist = true;
        for (GenerationInfo generationInfo : constructors) {
            PsiMethod existingMethod = aClass.findMethodBySignature((PsiMethod)generationInfo.getPsiMember(), false);
            alreadyExist &= existingMethod != null && existingMethod.isPhysical();
        }
        if (alreadyExist) {
            return Collections.emptyList();
        }
        return constructors;
    }

    @Override
    protected String getNothingFoundMessage() {
        return "Constructor already exists";
    }

    public static PsiMethod generateConstructorPrototype(PsiClass aClass, PsiMethod baseConstructor, boolean copyJavaDoc, PsiField[] fields) throws IncorrectOperationException {
        PsiManager manager = aClass.getManager();
        Project project = aClass.getProject();
        JVMElementFactory factory = JVMElementFactories.requireFactory((Language)aClass.getLanguage(), (Project)project);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
        String className2 = aClass.getName();
        assert (className2 != null) : aClass;
        PsiMethod constructor = factory.createConstructor(className2, (PsiElement)aClass);
        GenerateMembersUtil.setVisibility((PsiMember)aClass, constructor);
        if (baseConstructor != null) {
            PsiDocComment docComment;
            PsiJavaCodeReferenceElement[] throwRefs;
            for (PsiJavaCodeReferenceElement ref : throwRefs = baseConstructor.getThrowsList().getReferenceElements()) {
                constructor.getThrowsList().add((PsiElement)ref);
            }
            if (copyJavaDoc && (docComment = ((PsiMethod)baseConstructor.getNavigationElement()).getDocComment()) != null) {
                constructor.addAfter((PsiElement)docComment, null);
            }
        }
        boolean isNotEnum = false;
        if (baseConstructor != null) {
            PsiClass superClass = aClass.getSuperClass();
            LOG.assertTrue(superClass != null);
            if (!"java.lang.Enum".equals(superClass.getQualifiedName())) {
                PsiParameter[] params;
                isNotEnum = true;
                if (baseConstructor instanceof PsiCompiledElement) {
                    PsiClass dummyClass = JVMElementFactories.requireFactory((Language)baseConstructor.getLanguage(), (Project)project).createClass("Dummy");
                    baseConstructor = (PsiMethod)dummyClass.add((PsiElement)baseConstructor);
                }
                for (PsiParameter param : params = baseConstructor.getParameterList().getParameters()) {
                    String name2 = param.getName();
                    assert (name2 != null) : param;
                    PsiParameter newParam = factory.createParameter(name2, param.getType(), (PsiElement)aClass);
                    GenerateMembersUtil.copyOrReplaceModifierList((PsiModifierListOwner)param, (PsiElement)aClass, (PsiModifierListOwner)newParam);
                    constructor.getParameterList().add((PsiElement)newParam);
                }
            }
        }
        JavaCodeStyleManager javaStyle = JavaCodeStyleManager.getInstance((Project)project);
        PsiMethod dummyConstructor = factory.createConstructor(className2);
        dummyConstructor.getParameterList().replace(constructor.getParameterList().copy());
        ArrayList<PsiParameter> fieldParams = new ArrayList<PsiParameter>();
        for (PsiField field : fields) {
            String fieldName = field.getName();
            assert (fieldName != null) : field;
            String name3 = javaStyle.variableNameToPropertyName(fieldName, VariableKind.FIELD);
            String parmName = javaStyle.propertyNameToVariableName(name3, VariableKind.PARAMETER);
            parmName = javaStyle.suggestUniqueVariableName(parmName, (PsiElement)dummyConstructor, true);
            PsiParameter parm = factory.createParameter(parmName, field.getType(), (PsiElement)aClass);
            NullableNotNullManager.getInstance((Project)project).copyNullableOrNotNullAnnotation((PsiModifierListOwner)field, (PsiModifierListOwner)parm);
            if (constructor.isVarArgs()) {
                PsiParameterList parameterList = constructor.getParameterList();
                parameterList.addBefore((PsiElement)parm, (PsiElement)parameterList.getParameters()[parameterList.getParametersCount() - 1]);
                PsiParameterList dummyParameterList = dummyConstructor.getParameterList();
                dummyParameterList.addBefore(parm.copy(), (PsiElement)dummyParameterList.getParameters()[dummyParameterList.getParametersCount() - 1]);
            } else {
                constructor.getParameterList().add((PsiElement)parm);
                dummyConstructor.getParameterList().add(parm.copy());
            }
            fieldParams.add(parm);
        }
        ConstructorBodyGenerator generator = (ConstructorBodyGenerator)ConstructorBodyGenerator.INSTANCE.forLanguage(aClass.getLanguage());
        if (generator != null) {
            StringBuilder buffer = new StringBuilder();
            generator.start(buffer, constructor.getName(), PsiParameter.EMPTY_ARRAY);
            if (isNotEnum) {
                generator.generateSuperCallIfNeeded(buffer, baseConstructor.getParameterList().getParameters());
            }
            PsiParameter[] parameters2 = fieldParams.toArray(PsiParameter.EMPTY_ARRAY);
            List existingNames = ContainerUtil.map((Object[])dummyConstructor.getParameterList().getParameters(), parameter2 -> parameter2.getName());
            generator.generateFieldInitialization(buffer, fields, parameters2, existingNames);
            generator.finish(buffer);
            PsiMethod stub = factory.createMethodFromText(buffer.toString(), (PsiElement)aClass);
            PsiCodeBlock original = constructor.getBody();
            PsiCodeBlock replacement = stub.getBody();
            assert (original != null) : constructor;
            assert (replacement != null) : stub;
            original.replace((PsiElement)replacement);
        }
        constructor = (PsiMethod)codeStyleManager.reformat((PsiElement)constructor);
        return constructor;
    }

    @Override
    protected GenerationInfo[] generateMemberPrototypes(PsiClass aClass, ClassMember originalMember) {
        LOG.assertTrue(false);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateConstructorHandler", "generateMemberPrototypes"));
    }
}

