/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CodeBlockOrInitializerSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            CodeBlockOrInitializerSelectioner.$$$reportNull$$$0(0);
        }
        return e instanceof PsiCodeBlock || e instanceof PsiArrayInitializerExpression || e instanceof PsiClass && !(e instanceof PsiTypeParameter);
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        int start;
        if (e == null) {
            CodeBlockOrInitializerSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            CodeBlockOrInitializerSelectioner.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            CodeBlockOrInitializerSelectioner.$$$reportNull$$$0(3);
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        result.add(this.getElementRange(e));
        PsiElement[] children = e.getChildren();
        if (children.length > 0 && (start = CodeBlockOrInitializerSelectioner.findOpeningBrace(children)) != 0) {
            int end = CodeBlockOrInitializerSelectioner.findClosingBrace(children, start);
            result.addAll(CodeBlockOrInitializerSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)new TextRange(start, end)));
        }
        return result;
    }

    public TextRange getElementRange(@NotNull PsiElement e) {
        if (e == null) {
            CodeBlockOrInitializerSelectioner.$$$reportNull$$$0(4);
        }
        if (e instanceof PsiClass) {
            PsiElement lBrace = ((PsiClass)e).getLBrace();
            PsiElement rBrace = ((PsiClass)e).getRBrace();
            if (lBrace != null && rBrace != null) {
                return new TextRange(lBrace.getTextOffset(), rBrace.getTextRange().getEndOffset());
            }
        }
        return e.getTextRange();
    }

    public static int findOpeningBrace(PsiElement[] children) {
        int start = 0;
        for (int i = 0; i < children.length; ++i) {
            PsiJavaToken token;
            PsiElement child = children[i];
            if (!(child instanceof PsiJavaToken) || (token = (PsiJavaToken)child).getTokenType() != JavaTokenType.LBRACE) continue;
            int j = i + 1;
            while (children[j] instanceof PsiWhiteSpace) {
                ++j;
            }
            start = children[j].getTextRange().getStartOffset();
        }
        return start;
    }

    public static int findClosingBrace(PsiElement[] children, int startOffset) {
        int end = children[children.length - 1].getTextRange().getEndOffset();
        for (int i = 0; i < children.length; ++i) {
            PsiJavaToken token;
            PsiElement child = children[i];
            if (!(child instanceof PsiJavaToken) || (token = (PsiJavaToken)child).getTokenType() != JavaTokenType.RBRACE) continue;
            int j = i - 1;
            while (children[j] instanceof PsiWhiteSpace && children[j].getTextRange().getStartOffset() > startOffset) {
                --j;
            }
            end = children[j].getTextRange().getEndOffset();
        }
        return end;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/wordSelection/CodeBlockOrInitializerSelectioner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

