/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiRawStringLiteralUtil;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaQuoteHandler
extends SimpleTokenSetQuoteHandler
implements JavaLikeQuoteHandler,
MultiCharQuoteHandler {
    private final TokenSet myConcatenableStrings = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.STRING_LITERAL});
    private final TokenSet myAppropriateElementTypeForLiteral = TokenSet.orSet((TokenSet[])new TokenSet[]{ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET, ElementType.TEXT_LITERALS, TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.SEMICOLON, JavaTokenType.COMMA, JavaTokenType.RPARENTH, JavaTokenType.RBRACKET, JavaTokenType.RBRACE})});

    public JavaQuoteHandler() {
        super(ElementType.TEXT_LITERALS);
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        boolean openingQuote = super.isOpeningQuote(iterator, offset);
        if (openingQuote && !iterator.atEnd()) {
            iterator.retreat();
            if (!iterator.atEnd() && StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(iterator.getTokenType())) {
                openingQuote = false;
            }
            iterator.advance();
        }
        return openingQuote;
    }

    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        if (iterator.getTokenType() == JavaTokenType.TEXT_BLOCK_LITERAL) {
            int start = iterator.getStart();
            int end = iterator.getEnd();
            return end - start >= 5 && offset >= end - 3;
        }
        boolean closingQuote = super.isClosingQuote(iterator, offset);
        if (closingQuote && !iterator.atEnd()) {
            iterator.advance();
            if (!iterator.atEnd() && StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(iterator.getTokenType())) {
                closingQuote = false;
            }
            iterator.retreat();
        }
        return closingQuote;
    }

    public TokenSet getConcatenatableStringTokenTypes() {
        return this.myConcatenableStrings;
    }

    public String getStringConcatenationOperatorRepresentation() {
        return "+";
    }

    public TokenSet getStringTokenTypes() {
        return this.myLiteralTokenSet;
    }

    public boolean isAppropriateElementTypeForLiteral(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            JavaQuoteHandler.$$$reportNull$$$0(0);
        }
        return this.myAppropriateElementTypeForLiteral.contains(tokenType);
    }

    public boolean needParenthesesAroundConcatenation(PsiElement element) {
        return element.getParent() instanceof PsiLiteralExpression && element.getParent().getParent() instanceof PsiReferenceExpression;
    }

    @Nullable
    public CharSequence getClosingQuote(@NotNull HighlighterIterator iterator, int offset) {
        int closingSequence;
        CharSequence text2;
        int leadingTicsSequence;
        IElementType tokenType;
        if (iterator == null) {
            JavaQuoteHandler.$$$reportNull$$$0(1);
        }
        if ((tokenType = iterator.getTokenType()) == JavaTokenType.TEXT_BLOCK_LITERAL && offset == iterator.getStart() + 3) {
            return "\"\"\"";
        }
        if (tokenType == JavaTokenType.RAW_STRING_LITERAL && this.isOpeningQuote(iterator, offset - (leadingTicsSequence = PsiRawStringLiteralUtil.getLeadingTicksSequence((CharSequence)(text2 = iterator.getDocument().getImmutableCharSequence()).subSequence(iterator.getStart(), offset)))) && (closingSequence = PsiRawStringLiteralUtil.getLeadingTicksSequence((CharSequence)text2.subSequence(offset, iterator.getEnd()))) + 1 == leadingTicsSequence) {
            return "`";
        }
        return null;
    }

    public boolean hasNonClosedLiteral(Editor editor, HighlighterIterator iterator, int offset) {
        Document document;
        if (iterator.getTokenType() == JavaTokenType.TEXT_BLOCK_LITERAL && (document = iterator.getDocument()) != null && StringUtil.equals((CharSequence)document.getCharsSequence().subSequence(iterator.getStart(), offset + 1), (CharSequence)"\"\"\"")) {
            return true;
        }
        return super.hasNonClosedLiteral(editor, iterator, offset);
    }

    public void insertClosingQuote(@NotNull Editor editor, int offset, @NotNull CharSequence closingQuote) {
        if (editor == null) {
            JavaQuoteHandler.$$$reportNull$$$0(2);
        }
        if (closingQuote == null) {
            JavaQuoteHandler.$$$reportNull$$$0(3);
        }
        if (closingQuote.charAt(0) == '`') {
            editor.getDocument().insertString(offset, (CharSequence)(" " + closingQuote));
            editor.getSelectionModel().setSelection(offset, offset + 1);
        } else {
            editor.getDocument().insertString(offset, (CharSequence)("\n" + closingQuote));
            editor.getCaretModel().moveToOffset(offset + 1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closingQuote";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/JavaQuoteHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAppropriateElementTypeForLiteral";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getClosingQuote";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "insertClosingQuote";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

