/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VariableAccessFromInnerClassFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.VariableAccessFromInnerClassFix");
    private final PsiVariable myVariable;
    private final PsiElement myContext;
    private final int myFixType;
    private static final int MAKE_FINAL = 0;
    private static final int MAKE_ARRAY = 1;
    private static final int COPY_TO_FINAL = 2;
    private static final Key<Map<PsiVariable, Boolean>>[] VARS = new Key[]{Key.create((String)"VARS_TO_MAKE_FINAL"), Key.create((String)"VARS_TO_TRANSFORM"), Key.create((String)"???")};

    public VariableAccessFromInnerClassFix(@NotNull PsiVariable variable, @NotNull PsiElement element) {
        if (variable == null) {
            VariableAccessFromInnerClassFix.$$$reportNull$$$0(0);
        }
        if (element == null) {
            VariableAccessFromInnerClassFix.$$$reportNull$$$0(1);
        }
        this.myVariable = variable;
        this.myContext = element;
        this.myFixType = VariableAccessFromInnerClassFix.getQuickFixType(variable);
        if (this.myFixType == -1) {
            return;
        }
        this.getVariablesToFix().add(variable);
    }

    @NotNull
    public String getText() {
        String message2;
        switch (this.myFixType) {
            case 0: {
                message2 = "make.final.text";
                break;
            }
            case 1: {
                message2 = "make.final.transform.to.one.element.array";
                break;
            }
            case 2: {
                String string = QuickFixBundle.message("make.final.copy.to.temp", this.myVariable.getName(), (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)this.myContext) ? "" : "effectively ") + "final");
                if (string == null) {
                    VariableAccessFromInnerClassFix.$$$reportNull$$$0(2);
                }
                return string;
            }
            default: {
                if ("" == null) {
                    VariableAccessFromInnerClassFix.$$$reportNull$$$0(3);
                }
                return "";
            }
        }
        Collection<PsiVariable> vars = this.getVariablesToFix();
        String varNames = vars.size() == 1 ? "'" + this.myVariable.getName() + "'" : "variables";
        String string = QuickFixBundle.message(message2, varNames);
        if (string == null) {
            VariableAccessFromInnerClassFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("make.final.family", new Object[0]);
        if (string == null) {
            VariableAccessFromInnerClassFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            VariableAccessFromInnerClassFix.$$$reportNull$$$0(6);
        }
        return this.myContext.isValid() && BaseIntentionAction.canModify((PsiElement)this.myContext) && this.myVariable.isValid() && this.myFixType != -1 && !this.getVariablesToFix().isEmpty() && !VariableAccessFromInnerClassFix.inOwnInitializer(this.myVariable, this.myContext);
    }

    private static boolean inOwnInitializer(PsiVariable variable, PsiElement context) {
        return PsiTreeUtil.isAncestor((PsiElement)variable, (PsiElement)context, (boolean)false);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            VariableAccessFromInnerClassFix.$$$reportNull$$$0(7);
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{this.myContext, this.myVariable})) {
            return;
        }
        WriteAction.run(() -> {
            try {
                switch (this.myFixType) {
                    case 0: {
                        this.makeFinal();
                        return;
                    }
                    case 1: {
                        this.makeArray();
                        return;
                    }
                    case 2: {
                        VariableAccessFromInnerClassFix.copyToFinal(this.myVariable, this.myContext);
                        return;
                    }
                }
                return;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return;
            }
            finally {
                this.getVariablesToFix().clear();
            }
        });
    }

    private void makeArray() {
        for (PsiVariable var : this.getVariablesToFix()) {
            VariableAccessFromInnerClassFix.makeArray(var, this.myContext);
        }
    }

    @NotNull
    private Collection<PsiVariable> getVariablesToFix() {
        Map vars = (Map)this.myContext.getUserData(VARS[this.myFixType]);
        if (vars == null) {
            vars = ContainerUtil.createConcurrentWeakMap();
            this.myContext.putUserData(VARS[this.myFixType], (Object)vars);
        }
        final Map finalVars = vars;
        AbstractCollection<PsiVariable> abstractCollection = new AbstractCollection<PsiVariable>(){

            @Override
            public boolean add(PsiVariable psiVariable) {
                return finalVars.put(psiVariable, Boolean.TRUE) == null;
            }

            @Override
            @NotNull
            public Iterator<PsiVariable> iterator() {
                Iterator<PsiVariable> iterator = finalVars.keySet().iterator();
                if (iterator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            @Override
            public int size() {
                return finalVars.size();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix$1", "iterator"));
            }
        };
        if (abstractCollection == null) {
            VariableAccessFromInnerClassFix.$$$reportNull$$$0(8);
        }
        return abstractCollection;
    }

    private void makeFinal() {
        for (PsiVariable var : this.getVariablesToFix()) {
            if (!var.isValid()) continue;
            PsiUtil.setModifierProperty((PsiModifierListOwner)var, (String)"final", (boolean)true);
        }
    }

    private static void makeArray(PsiVariable variable, PsiElement context) throws IncorrectOperationException {
        PsiDeclarationStatement variableDeclarationStatement;
        PsiExpression init;
        variable.normalizeDeclaration();
        PsiType type2 = variable.getType();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        PsiArrayType newType = type2.createArrayType();
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            String expression2 = "[1]";
            while (type2 instanceof PsiArrayType) {
                expression2 = expression2 + "[1]";
                type2 = ((PsiArrayType)type2).getComponentType();
            }
            init = factory.createExpressionFromText("new " + type2.getCanonicalText() + expression2, (PsiElement)variable);
            variableDeclarationStatement = factory.createVariableDeclarationStatement(variable.getName(), (PsiType)newType, init);
        } else {
            String explicitArrayDeclaration = JavaGenericsUtil.isReifiableType((PsiType)type2) ? "" : "new " + TypeConversionUtil.erasure((PsiType)type2).getCanonicalText() + "[]";
            init = factory.createExpressionFromText(explicitArrayDeclaration + "{ " + initializer.getText() + " }", (PsiElement)variable);
            variableDeclarationStatement = factory.createVariableDeclarationStatement(variable.getName(), (PsiType)newType, init);
        }
        PsiVariable newVariable = (PsiVariable)variableDeclarationStatement.getDeclaredElements()[0];
        PsiUtil.setModifierProperty((PsiModifierListOwner)newVariable, (String)"final", (boolean)true);
        PsiExpression newExpression = factory.createExpressionFromText(variable.getName() + "[0]", (PsiElement)variable);
        PsiElement outerCodeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
        if (outerCodeBlock == null) {
            return;
        }
        ArrayList outerReferences = new ArrayList();
        VariableAccessFromInnerClassFix.collectReferences(outerCodeBlock, variable, outerReferences);
        VariableAccessFromInnerClassFix.replaceReferences(outerReferences, (PsiElement)newExpression);
        variable.replace((PsiElement)newVariable);
    }

    private static void copyToFinal(PsiVariable variable, PsiElement context) throws IncorrectOperationException {
        PsiManager psiManager = context.getManager();
        Project project = psiManager.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiExpression initializer = factory.createExpressionFromText(variable.getName(), context);
        String newName = VariableAccessFromInnerClassFix.suggestNewName(project, variable);
        PsiType type2 = variable.getType();
        PsiDeclarationStatement copyDecl = factory.createVariableDeclarationStatement(newName, type2, initializer);
        PsiVariable newVariable = (PsiVariable)copyDecl.getDeclaredElements()[0];
        boolean mustBeFinal = !PsiUtil.isLanguageLevel8OrHigher((PsiElement)context) || JavaCodeStyleSettings.getInstance((PsiFile)context.getContainingFile()).GENERATE_FINAL_LOCALS;
        PsiUtil.setModifierProperty((PsiModifierListOwner)newVariable, (String)"final", (boolean)mustBeFinal);
        PsiElement statement = VariableAccessFromInnerClassFix.getStatementToInsertBefore(variable, context);
        if (statement == null) {
            return;
        }
        PsiExpression newExpression = factory.createExpressionFromText(newName, (PsiElement)variable);
        VariableAccessFromInnerClassFix.replaceReferences(context, variable, (PsiElement)newExpression);
        if (RefactoringUtil.isLoopOrIf(statement.getParent())) {
            RefactoringUtil.putStatementInLoopBody((PsiStatement)copyDecl, statement.getParent(), statement);
        } else {
            statement.getParent().addBefore((PsiElement)copyDecl, statement);
        }
    }

    private static PsiElement getStatementToInsertBefore(PsiVariable variable, PsiElement context) {
        PsiElement declarationScope;
        PsiElement psiElement = declarationScope = variable instanceof PsiParameter ? ((PsiParameter)variable).getDeclarationScope() : PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
        if (declarationScope == null) {
            return null;
        }
        PsiElement statement = context;
        block0: while (true) {
            if ((statement = RefactoringUtil.getParentStatement(statement, false)) == null || statement.getParent() == null) {
                return null;
            }
            for (PsiElement element = statement; element != declarationScope && !(element instanceof PsiFile); element = element.getParent()) {
                if (!(element instanceof PsiClass) && !(element instanceof PsiLambdaExpression)) continue;
                statement = statement.getParent();
                continue block0;
            }
            break;
        }
        return statement;
    }

    private static String suggestNewName(Project project, PsiVariable variable) {
        String name2 = variable.getName();
        if (name2.length() > 1 && Character.isDigit(name2.charAt(name2.length() - 1))) {
            name2 = name2.substring(0, name2.length() - 1);
        }
        name2 = "final" + StringUtil.capitalize((String)StringUtil.trimStart((String)name2, (String)"final"));
        return JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName(name2, (PsiElement)variable, true);
    }

    private static void replaceReferences(PsiElement context, final PsiVariable variable, final PsiElement newExpression) {
        context.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                if (expression2.resolve() == variable) {
                    try {
                        expression2.replace(newExpression);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
                super.visitReferenceExpression(expression2);
            }
        });
    }

    private static void replaceReferences(List<? extends PsiReferenceExpression> references, PsiElement newExpression) throws IncorrectOperationException {
        for (PsiReferenceExpression psiReferenceExpression : references) {
            psiReferenceExpression.replace(newExpression);
        }
    }

    private static void collectReferences(PsiElement context, final PsiVariable variable, final List<? super PsiReferenceExpression> references) {
        context.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                if (expression2.resolve() == variable) {
                    references.add(expression2);
                }
                super.visitReferenceExpression(expression2);
            }
        });
    }

    private static int getQuickFixType(@NotNull PsiVariable variable) {
        PsiElement outerCodeBlock;
        if (variable == null) {
            VariableAccessFromInnerClassFix.$$$reportNull$$$0(9);
        }
        if ((outerCodeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null)) == null) {
            return -1;
        }
        ArrayList outerReferences = new ArrayList();
        VariableAccessFromInnerClassFix.collectReferences(outerCodeBlock, variable, outerReferences);
        int type2 = 0;
        for (PsiReferenceExpression expression2 : outerReferences) {
            PsiElement innerScope = HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, (PsiElement)expression2);
            if (innerScope == null) continue;
            int thisType = 0;
            if (VariableAccessFromInnerClassFix.writtenInside(variable, innerScope)) {
                if (variable instanceof PsiParameter) {
                    return -1;
                }
                thisType = 1;
            }
            if (thisType == 0 && !VariableAccessFromInnerClassFix.canBeFinal(variable, outerReferences)) {
                thisType = 2;
            }
            type2 = Math.max(type2, thisType);
        }
        return type2;
    }

    private static boolean canBeFinal(@NotNull PsiVariable variable, @NotNull List<? extends PsiReferenceExpression> references) {
        if (variable == null) {
            VariableAccessFromInnerClassFix.$$$reportNull$$$0(10);
        }
        if (references == null) {
            VariableAccessFromInnerClassFix.$$$reportNull$$$0(11);
        }
        THashMap uninitializedVarProblems = new THashMap();
        THashMap finalVarProblems = new THashMap();
        for (PsiReferenceExpression psiReferenceExpression : references) {
            if (ControlFlowUtil.isVariableAssignedInLoop(psiReferenceExpression, (PsiElement)variable)) {
                return false;
            }
            HighlightInfo highlightInfo = HighlightControlFlowUtil.checkVariableInitializedBeforeUsage(psiReferenceExpression, variable, (Map<PsiElement, Collection<PsiReferenceExpression>>)uninitializedVarProblems, variable.getContainingFile());
            if (highlightInfo != null) {
                return false;
            }
            highlightInfo = HighlightControlFlowUtil.checkFinalVariableMightAlreadyHaveBeenAssignedTo(variable, psiReferenceExpression, (Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>>)finalVarProblems);
            if (highlightInfo != null) {
                return false;
            }
            if (!(variable instanceof PsiParameter) || !PsiUtil.isAccessedForWriting((PsiExpression)psiReferenceExpression)) continue;
            return false;
        }
        return true;
    }

    private static boolean writtenInside(PsiVariable variable, PsiElement element) {
        PsiElement[] children;
        PsiExpression operand2;
        PsiAssignmentExpression assignmentExpression;
        PsiExpression lExpression;
        if (element instanceof PsiAssignmentExpression ? (lExpression = (assignmentExpression = (PsiAssignmentExpression)element).getLExpression()) instanceof PsiReferenceExpression && ((PsiReferenceExpression)lExpression).resolve() == variable : PsiUtil.isIncrementDecrementOperation((PsiElement)element) && (operand2 = ((PsiUnaryExpression)element).getOperand()) instanceof PsiReferenceExpression && ((PsiReferenceExpression)operand2).resolve() == variable) {
            return true;
        }
        for (PsiElement child : children = element.getChildren()) {
            if (!VariableAccessFromInnerClassFix.writtenInside(variable, child)) continue;
            return true;
        }
        return false;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void fixAccess(@NotNull PsiVariable variable, @NotNull PsiElement context) {
        int type2;
        if (variable == null) {
            VariableAccessFromInnerClassFix.$$$reportNull$$$0(12);
        }
        if (context == null) {
            VariableAccessFromInnerClassFix.$$$reportNull$$$0(13);
        }
        if ((type2 = VariableAccessFromInnerClassFix.getQuickFixType(variable)) == -1) {
            return;
        }
        switch (type2) {
            case 0: {
                PsiUtil.setModifierProperty((PsiModifierListOwner)variable, (String)"final", (boolean)true);
                break;
            }
            case 1: {
                VariableAccessFromInnerClassFix.makeArray(variable, context);
                break;
            }
            case 2: {
                VariableAccessFromInnerClassFix.copyToFinal(variable, context);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariablesToFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canBeFinal";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fixAccess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

