/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.JavaProjectCodeInsightSettings;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFixBase;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticMembersProcessor;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StaticImportMemberFix<T extends PsiMember, R extends PsiElement>
implements IntentionAction,
HintAction {
    private final List<T> candidates;
    protected final SmartPsiElementPointer<R> myRef;

    StaticImportMemberFix(@NotNull PsiFile file, @NotNull R reference) {
        if (file == null) {
            StaticImportMemberFix.$$$reportNull$$$0(0);
        }
        if (reference == null) {
            StaticImportMemberFix.$$$reportNull$$$0(1);
        }
        this.myRef = SmartPointerManager.getInstance((Project)file.getProject()).createSmartPsiElementPointer(reference);
        this.candidates = this.getMembersToImport(false, StaticMembersProcessor.SearchMode.MAX_2_MEMBERS);
    }

    @NotNull
    protected abstract String getBaseText();

    @NotNull
    protected abstract String getMemberPresentableText(@NotNull T var1);

    @NotNull
    public String getText() {
        String string = this.getBaseText() + (this.candidates == null || this.candidates.size() != 1 ? "..." : " '" + this.getMemberPresentableText((PsiMember)this.candidates.get(0)) + "'");
        if (string == null) {
            StaticImportMemberFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            StaticImportMemberFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            StaticImportMemberFix.$$$reportNull$$$0(4);
        }
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file) && file instanceof PsiJavaFile && this.getElement() != null && this.getElement().isValid() && this.getQualifierExpression() == null && this.resolveRef() == null && BaseIntentionAction.canModify((PsiElement)file) && !this.candidates.isEmpty() && ContainerUtil.all(this.candidates, PsiElement::isValid);
    }

    @NotNull
    protected abstract List<T> getMembersToImport(boolean var1, @NotNull StaticMembersProcessor.SearchMode var2);

    protected abstract boolean toAddStaticImports();

    public static boolean isExcluded(@NotNull PsiMember method) {
        String name2;
        if (method == null) {
            StaticImportMemberFix.$$$reportNull$$$0(5);
        }
        return (name2 = PsiUtil.getMemberQualifiedName((PsiMember)method)) != null && JavaProjectCodeInsightSettings.getSettings(method.getProject()).isExcluded(name2);
    }

    @NotNull
    protected abstract QuestionAction createQuestionAction(@NotNull List<? extends T> var1, @NotNull Project var2, Editor var3);

    @Nullable
    protected abstract PsiElement getElement();

    @Nullable
    protected abstract PsiElement getQualifierExpression();

    @Nullable
    protected abstract PsiElement resolveRef();

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            StaticImportMemberFix.$$$reportNull$$$0(6);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            List<T> methodsToImport = this.getMembersToImport(false, StaticMembersProcessor.SearchMode.MAX_100_MEMBERS);
            if (methodsToImport.isEmpty()) {
                return;
            }
            this.createQuestionAction(methodsToImport, project, editor).execute();
        });
    }

    @NotNull
    private ImportClassFixBase.Result doFix(@NotNull Editor editor) {
        if (editor == null) {
            StaticImportMemberFix.$$$reportNull$$$0(7);
        }
        if (!CodeInsightSettings.getInstance().ADD_MEMBER_IMPORTS_ON_THE_FLY) {
            ImportClassFixBase.Result result = ImportClassFixBase.Result.POPUP_NOT_SHOWN;
            if (result == null) {
                StaticImportMemberFix.$$$reportNull$$$0(8);
            }
            return result;
        }
        List<T> candidates = this.getMembersToImport(true, StaticMembersProcessor.SearchMode.MAX_100_MEMBERS);
        if (candidates.isEmpty()) {
            ImportClassFixBase.Result result = ImportClassFixBase.Result.POPUP_NOT_SHOWN;
            if (result == null) {
                StaticImportMemberFix.$$$reportNull$$$0(9);
            }
            return result;
        }
        PsiElement element = this.getElement();
        if (element == null) {
            ImportClassFixBase.Result result = ImportClassFixBase.Result.POPUP_NOT_SHOWN;
            if (result == null) {
                StaticImportMemberFix.$$$reportNull$$$0(10);
            }
            return result;
        }
        if (this.toAddStaticImports() && candidates.size() == 1 && PsiTreeUtil.isAncestor((PsiElement)element.getContainingFile(), (PsiElement)((PsiElement)candidates.get(0)), (boolean)true)) {
            ImportClassFixBase.Result result = ImportClassFixBase.Result.POPUP_NOT_SHOWN;
            if (result == null) {
                StaticImportMemberFix.$$$reportNull$$$0(11);
            }
            return result;
        }
        QuestionAction action = this.createQuestionAction(candidates, element.getProject(), editor);
        String hintText = ShowAutoImportPass.getMessage((candidates.size() > 1 ? 1 : 0) != 0, (String)this.getMemberPresentableText((PsiMember)candidates.get(0)));
        if (!ApplicationManager.getApplication().isUnitTestMode() && !HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(true)) {
            TextRange textRange = element.getTextRange();
            HintManager.getInstance().showQuestionHint(editor, hintText, textRange.getStartOffset(), textRange.getEndOffset(), action);
        }
        ImportClassFixBase.Result result = ImportClassFixBase.Result.POPUP_SHOWN;
        if (result == null) {
            StaticImportMemberFix.$$$reportNull$$$0(12);
        }
        return result;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean showHint(@NotNull Editor editor) {
        PsiElement callExpression;
        if (editor == null) {
            StaticImportMemberFix.$$$reportNull$$$0(13);
        }
        if ((callExpression = this.getElement()) == null || this.getQualifierExpression() != null) {
            return false;
        }
        ImportClassFixBase.Result result = this.doFix(editor);
        return result == ImportClassFixBase.Result.POPUP_SHOWN || result == ImportClassFixBase.Result.CLASS_AUTO_IMPORTED;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMemberFix";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMemberFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

