/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateServiceClassFixBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.impl.scopes.ModulesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.PanelGridBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UI;
import java.util.Collections;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateServiceImplementationClassFix
extends CreateServiceClassFixBase {
    private String mySuperClassName;
    private String myImplementationClassName;
    private String myModuleName;

    public CreateServiceImplementationClassFix(PsiJavaCodeReferenceElement referenceElement) {
        this.init(referenceElement);
    }

    private void init(@NotNull PsiJavaCodeReferenceElement referenceElement) {
        PsiProvidesStatement providesStatement;
        PsiElement parent;
        if (referenceElement == null) {
            CreateServiceImplementationClassFix.$$$reportNull$$$0(0);
        }
        if ((parent = (referenceElement = CreateServiceImplementationClassFix.findTopmostReference(referenceElement)).getParent()) != null && referenceElement.isQualified() && (providesStatement = (PsiProvidesStatement)ObjectUtils.tryCast((Object)parent.getParent(), PsiProvidesStatement.class)) != null && providesStatement.getImplementationList() == parent) {
            PsiClass superClass;
            PsiJavaCodeReferenceElement interfaceReference;
            this.myImplementationClassName = referenceElement.getQualifiedName();
            if (this.myImplementationClassName != null && (interfaceReference = providesStatement.getInterfaceReference()) != null && (superClass = (PsiClass)ObjectUtils.tryCast((Object)interfaceReference.resolve(), PsiClass.class)) != null) {
                this.mySuperClassName = superClass.getQualifiedName();
                if (this.mySuperClassName != null) {
                    this.myModuleName = Optional.of(referenceElement).map(PsiElement::getContainingFile).map(ModuleUtilCore::findModuleForFile).map(Module::getName).orElse(null);
                }
            }
        }
    }

    @Nls
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("create.service.implementation.fix.name", this.myImplementationClassName);
        if (string == null) {
            CreateServiceImplementationClassFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.service.implementation.fix.family.name", new Object[0]);
        if (string == null) {
            CreateServiceImplementationClassFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            CreateServiceImplementationClassFix.$$$reportNull$$$0(3);
        }
        if (this.mySuperClassName != null && this.myImplementationClassName != null && this.myModuleName != null) {
            GlobalSearchScope projectScope;
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            return psiFacade.findClass(this.myImplementationClassName, projectScope = GlobalSearchScope.projectScope((Project)project)) == null && psiFacade.findClass(this.mySuperClassName, projectScope) != null && CreateServiceImplementationClassFix.isQualifierInProject(this.myImplementationClassName, project);
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        Module module;
        if (project == null) {
            CreateServiceImplementationClassFix.$$$reportNull$$$0(4);
        }
        if ((module = ModuleManager.getInstance((Project)project).findModuleByName(this.myModuleName)) != null) {
            PsiDirectory psiRootDir;
            PsiClass outerClass;
            String qualifierText = StringUtil.getPackageName((String)this.myImplementationClassName);
            if (!StringUtil.isEmpty((String)qualifierText) && (outerClass = CreateServiceImplementationClassFix.findClassInModule(qualifierText, module)) != null) {
                this.createClassInOuter(qualifierText, outerClass);
                return;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                PsiDirectory rootDir = (PsiDirectory)file.getUserData(SERVICE_ROOT_DIR);
                Boolean isSubclass = (Boolean)file.getUserData(SERVICE_IS_SUBCLASS);
                if (rootDir != null && isSubclass != null) {
                    WriteAction.run(() -> this.createClassInRoot(rootDir, isSubclass, (PsiElement)file));
                }
                return;
            }
            PsiDirectory[] psiRootDirs = CreateServiceImplementationClassFix.getModuleRootDirs(module);
            CreateServiceImplementationDialog dialog = new CreateServiceImplementationDialog(project, psiRootDirs, this.mySuperClassName);
            if (dialog.showAndGet() && (psiRootDir = dialog.getRootDir()) != null) {
                boolean isSubclass = dialog.isSubclass();
                PsiClass psiClass = (PsiClass)WriteAction.compute(() -> this.createClassInRoot(psiRootDir, isSubclass, (PsiElement)file));
                CreateServiceImplementationClassFix.positionCursor(psiClass);
            }
        }
    }

    private PsiClass createClassInRoot(@NotNull PsiDirectory psiRootDir, boolean isSubclass, @NotNull PsiElement contextElement) {
        if (psiRootDir == null) {
            CreateServiceImplementationClassFix.$$$reportNull$$$0(5);
        }
        if (contextElement == null) {
            CreateServiceImplementationClassFix.$$$reportNull$$$0(6);
        }
        Project project = psiRootDir.getProject();
        PsiClass psiImplClass = CreateServiceImplementationClassFix.createClassInRoot(this.myImplementationClassName, CreateClassKind.CLASS, psiRootDir, contextElement, isSubclass ? this.mySuperClassName : null);
        if (psiImplClass != null && !isSubclass) {
            String text2 = "public static " + this.mySuperClassName + " provider() { return null;}";
            PsiMethod method = JavaPsiFacade.getElementFactory((Project)project).createMethodFromText(text2, psiImplClass.getLBrace());
            method = (PsiMethod)psiImplClass.addAfter((PsiElement)method, psiImplClass.getLBrace());
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)method);
        }
        return psiImplClass;
    }

    @Nullable
    private static PsiClass findClassInModule(@NotNull String className2, @NotNull Module module) {
        if (className2 == null) {
            CreateServiceImplementationClassFix.$$$reportNull$$$0(7);
        }
        if (module == null) {
            CreateServiceImplementationClassFix.$$$reportNull$$$0(8);
        }
        Project project = module.getProject();
        ModulesScope scope = new ModulesScope(Collections.singleton(module), project);
        return JavaPsiFacade.getInstance((Project)project).findClass(className2, (GlobalSearchScope)scope);
    }

    private void createClassInOuter(String qualifierText, PsiClass outerClass) {
        String name2 = this.myImplementationClassName.substring(qualifierText.length() + 1);
        PsiClass psiClass = (PsiClass)WriteAction.compute(() -> CreateServiceImplementationClassFix.createClassInOuterImpl(name2, outerClass, this.mySuperClassName));
        CreateServiceImplementationClassFix.positionCursor(psiClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateServiceImplementationClassFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiRootDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateServiceImplementationClassFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createClassInRoot";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findClassInModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CreateServiceImplementationDialog
    extends DialogWrapper {
        private final ComboBoxWithWidePopup<PsiDirectory> myRootDirCombo;
        private final JRadioButton mySubclassButton;
        private final JRadioButton myProviderButton;

        protected CreateServiceImplementationDialog(@Nullable Project project, @NotNull PsiDirectory[] psiRootDirs, @NotNull String superClassName) {
            if (psiRootDirs == null) {
                CreateServiceImplementationDialog.$$$reportNull$$$0(0);
            }
            if (superClassName == null) {
                CreateServiceImplementationDialog.$$$reportNull$$$0(1);
            }
            super(project);
            this.myRootDirCombo = new ComboBoxWithWidePopup();
            this.mySubclassButton = new JBRadioButton();
            this.myProviderButton = new JBRadioButton();
            this.setTitle("Create Service Implementation");
            this.mySubclassButton.setText("Subclass of '" + superClassName + "'");
            this.mySubclassButton.setSelected(true);
            this.myProviderButton.setText("With 'provider()' method");
            ButtonGroup group = new ButtonGroup();
            group.add(this.mySubclassButton);
            group.add(this.myProviderButton);
            this.myRootDirCombo.setRenderer((ListCellRenderer)((Object)new CreateServiceClassFixBase.PsiDirectoryListCellRenderer()));
            this.myRootDirCombo.setModel(new DefaultComboBoxModel<PsiDirectory>(psiRootDirs));
            this.init();
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
            if (actionArray == null) {
                CreateServiceImplementationDialog.$$$reportNull$$$0(2);
            }
            return actionArray;
        }

        protected JComponent createCenterPanel() {
            return null;
        }

        @Nullable
        protected JComponent createNorthPanel() {
            PanelGridBuilder builder = UI.PanelFactory.grid();
            builder.add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.mySubclassButton).withLabel("Implementation:")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.myProviderButton));
            if (this.myRootDirCombo.getModel().getSize() > 1) {
                builder.add((PanelBuilder)UI.PanelFactory.panel(this.myRootDirCombo).withLabel("Source root:"));
            }
            return builder.createPanel();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.mySubclassButton;
        }

        @Nullable
        public PsiDirectory getRootDir() {
            return (PsiDirectory)this.myRootDirCombo.getSelectedItem();
        }

        public boolean isSubclass() {
            return this.mySubclassButton.isSelected();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiRootDirs";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "superClassName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateServiceImplementationClassFix$CreateServiceImplementationDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateServiceImplementationClassFix$CreateServiceImplementationDialog";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

