/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateClassFromUsageBaseFix
extends BaseIntentionAction {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromUsageBaseFix");
    protected CreateClassKind myKind;
    private final SmartPsiElementPointer<PsiJavaCodeReferenceElement> myRefElement;

    public CreateClassFromUsageBaseFix(CreateClassKind kind2, PsiJavaCodeReferenceElement refElement) {
        this.myKind = kind2;
        this.myRefElement = SmartPointerManager.getInstance((Project)refElement.getProject()).createSmartPsiElementPointer((PsiElement)refElement);
    }

    protected abstract String getText(String var1);

    private boolean isAvailableInContext(@NotNull PsiJavaCodeReferenceElement element) {
        if (element == null) {
            CreateClassFromUsageBaseFix.$$$reportNull$$$0(0);
        }
        PsiElement parent = element.getParent();
        if (this.myKind == CreateClassKind.ANNOTATION) {
            return parent instanceof PsiAnnotation;
        }
        if (parent instanceof PsiJavaCodeReferenceCodeFragment) {
            return true;
        }
        if (parent instanceof PsiTypeElement) {
            if (parent.getParent() instanceof PsiReferenceParameterList) {
                return true;
            }
            while (parent.getParent() instanceof PsiTypeElement) {
                if (!((parent = parent.getParent()).getParent() instanceof PsiReferenceParameterList)) continue;
                return true;
            }
            if (parent.getParent() instanceof PsiCodeFragment || parent.getParent() instanceof PsiVariable || parent.getParent() instanceof PsiMethod || parent.getParent() instanceof PsiClassObjectAccessExpression || parent.getParent() instanceof PsiTypeCastExpression || parent.getParent() instanceof PsiInstanceOfExpression && ((PsiInstanceOfExpression)parent.getParent()).getCheckType() == parent) {
                return true;
            }
        } else if (parent instanceof PsiReferenceList) {
            PsiMethod method;
            if (this.myKind == CreateClassKind.ENUM) {
                return false;
            }
            if (parent.getParent() instanceof PsiClass) {
                PsiClass psiClass = (PsiClass)parent.getParent();
                if (psiClass.getExtendsList() == parent) {
                    if (this.myKind == CreateClassKind.CLASS && !psiClass.isInterface()) {
                        return true;
                    }
                    if (this.myKind == CreateClassKind.INTERFACE && psiClass.isInterface()) {
                        return true;
                    }
                }
                if (psiClass.getImplementsList() == parent && this.myKind == CreateClassKind.INTERFACE) {
                    return true;
                }
            } else if (parent.getParent() instanceof PsiMethod && (method = (PsiMethod)parent.getParent()).getThrowsList() == parent && this.myKind == CreateClassKind.CLASS) {
                return true;
            }
        } else if (parent instanceof PsiAnonymousClass && ((PsiAnonymousClass)parent).getBaseClassReference() == element) {
            return true;
        }
        if (element instanceof PsiReferenceExpression) {
            if (parent instanceof PsiMethodCallExpression) {
                return false;
            }
            return !(parent.getParent() instanceof PsiMethodCallExpression) || this.myKind == CreateClassKind.CLASS;
        }
        return false;
    }

    private static boolean checkClassName(String name2) {
        return Character.isUpperCase(name2.charAt(0));
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        int offset;
        PsiJavaCodeReferenceElement element;
        if (project == null) {
            CreateClassFromUsageBaseFix.$$$reportNull$$$0(1);
        }
        if ((element = this.getRefElement()) == null || !element.getManager().isInProject((PsiElement)element)) {
            return false;
        }
        JavaResolveResult[] results = element.multiResolve(true);
        if (results.length > 0 && results[0].getElement() instanceof PsiClass) {
            return false;
        }
        String refName = element.getReferenceName();
        if (refName == null || PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiTypeElement.class, PsiReferenceList.class}) == null && !CreateClassFromUsageBaseFix.checkClassName(refName)) {
            return false;
        }
        PsiElement nameElement = element.getReferenceNameElement();
        if (nameElement == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiExpression && !(parent instanceof PsiReferenceExpression)) {
            return false;
        }
        if (!this.isAvailableInContext(element)) {
            return false;
        }
        String superClassName = this.getSuperClassName(element);
        if (superClassName != null) {
            if (superClassName.equals("java.lang.Enum") && this.myKind != CreateClassKind.ENUM) {
                return false;
            }
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(superClassName, GlobalSearchScope.allScope((Project)project));
            if (psiClass != null && psiClass.hasModifierProperty("final")) {
                return false;
            }
        }
        if (CreateFromUsageUtils.shouldShowTag(offset = editor.getCaretModel().getOffset(), nameElement, (PsiElement)element)) {
            this.setText(this.getText(nameElement.getText()));
            return true;
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.class.from.usage.family", new Object[0]);
        if (string == null) {
            CreateClassFromUsageBaseFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    protected PsiJavaCodeReferenceElement getRefElement() {
        return (PsiJavaCodeReferenceElement)this.myRefElement.getElement();
    }

    @Nullable
    protected String getSuperClassName(PsiJavaCodeReferenceElement element) {
        String superClassName = null;
        PsiElement parent = element.getParent();
        PsiElement ggParent = parent.getParent();
        if (ggParent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)ggParent;
            if (method.getThrowsList() == parent) {
                superClassName = "java.lang.Exception";
            }
        } else if (ggParent instanceof PsiClassObjectAccessExpression) {
            PsiClassType.ClassResolveResult classResolveResult;
            PsiClass psiClass;
            ExpectedTypeInfo[] expectedTypes = ExpectedTypesProvider.getExpectedTypes((PsiExpression)ggParent, false);
            if (expectedTypes.length == 1 && (psiClass = (classResolveResult = PsiUtil.resolveGenericsClassInType((PsiType)expectedTypes[0].getType())).getElement()) != null && "java.lang.Class".equals(psiClass.getQualifiedName())) {
                PsiClass aClass;
                PsiType psiType;
                PsiTypeParameter[] typeParameters = psiClass.getTypeParameters();
                PsiType psiType2 = psiType = typeParameters.length == 1 ? classResolveResult.getSubstitutor().substitute(typeParameters[0]) : null;
                if (psiType instanceof PsiWildcardType && ((PsiWildcardType)psiType).isExtends()) {
                    psiType = ((PsiWildcardType)psiType).getExtendsBound();
                }
                if ((aClass = PsiUtil.resolveClassInType((PsiType)psiType)) != null) {
                    return aClass.getQualifiedName();
                }
            }
        } else if (ggParent instanceof PsiExpressionList && parent instanceof PsiExpression && this.myKind == CreateClassKind.ENUM) {
            PsiClassType.ClassResolveResult classResolveResult;
            PsiClass psiClass;
            ExpectedTypeInfo[] expectedTypes = ExpectedTypesProvider.getExpectedTypes((PsiExpression)parent, false);
            if (expectedTypes.length == 1 && (psiClass = (classResolveResult = PsiUtil.resolveGenericsClassInType((PsiType)expectedTypes[0].getType())).getElement()) != null && psiClass.isInterface()) {
                return psiClass.getQualifiedName();
            }
            return null;
        }
        return superClassName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateClassFromUsageBaseFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateClassFromUsageBaseFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableInContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

