/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.editorActions.StringLiteralCopyPasteProcessor;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class ConvertRawToStringLiteralAction
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("convert.to.string.text", new Object[0]);
        if (string == null) {
            ConvertRawToStringLiteralAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Convert raw to String literal" == null) {
            ConvertRawToStringLiteralAction.$$$reportNull$$$0(1);
        }
        return "Convert raw to String literal";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ConvertRawToStringLiteralAction.$$$reportNull$$$0(2);
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        return PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.RAW_STRING_LITERAL);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement parent;
        PsiElement element;
        if (project == null) {
            ConvertRawToStringLiteralAction.$$$reportNull$$$0(3);
        }
        if ((element = file.findElementAt(editor.getCaretModel().getOffset())) != null && PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.RAW_STRING_LITERAL) && (parent = element.getParent()) instanceof PsiLiteralExpressionImpl) {
            String text2 = ((PsiLiteralExpressionImpl)parent).getRawString();
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
            PsiElement literalToken = elementFactory.createExpressionFromText("\"\"", (PsiElement)file).getFirstChild();
            String preprocessedValue = new StringLiteralCopyPasteProcessor().escapeAndSplit(text2, literalToken);
            PsiExpression replacement = elementFactory.createExpressionFromText('\"' + preprocessedValue + '\"', null);
            PsiExpression replacedExpression = ExpressionUtils.replacePolyadicWithParent((PsiExpression)parent, replacement);
            if (replacedExpression == null) {
                replacedExpression = parent.replace((PsiElement)replacement);
            }
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)replacedExpression);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ConvertRawToStringLiteralAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ConvertRawToStringLiteralAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

