/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.refactoring.changeClassSignature.ChangeClassSignatureDialog;
import com.intellij.refactoring.changeClassSignature.TypeParameterInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ChangeClassSignatureFromUsageFix
extends BaseIntentionAction {
    private final PsiClass myClass;
    private final PsiReferenceParameterList myParameterList;

    public ChangeClassSignatureFromUsageFix(@NotNull PsiClass aClass, @NotNull PsiReferenceParameterList parameterList) {
        if (aClass == null) {
            ChangeClassSignatureFromUsageFix.$$$reportNull$$$0(0);
        }
        if (parameterList == null) {
            ChangeClassSignatureFromUsageFix.$$$reportNull$$$0(1);
        }
        this.myClass = aClass;
        this.myParameterList = parameterList;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("change.class.signature.family", new Object[0]);
        if (string == null) {
            ChangeClassSignatureFromUsageFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ChangeClassSignatureFromUsageFix.$$$reportNull$$$0(3);
        }
        if (!this.myClass.isValid() || !this.myParameterList.isValid() || this.myClass instanceof PsiCompiledElement) {
            return false;
        }
        if (this.myClass.getTypeParameters().length >= this.myParameterList.getTypeArguments().length) {
            return false;
        }
        PsiTypeParameterList classTypeParameterList = this.myClass.getTypeParameterList();
        if (classTypeParameterList == null) {
            return false;
        }
        this.setText(QuickFixBundle.message("change.class.signature.text", this.myClass.getName(), this.myParameterList.getText()));
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiTypeParameterList classTypeParameterList;
        if (project == null) {
            ChangeClassSignatureFromUsageFix.$$$reportNull$$$0(4);
        }
        if ((classTypeParameterList = this.myClass.getTypeParameterList()) == null) {
            return;
        }
        ChangeClassSignatureDialog dialog = new ChangeClassSignatureDialog(this.myClass, ChangeClassSignatureFromUsageFix.createTypeParameters(JavaCodeFragmentFactory.getInstance((Project)project), Arrays.asList(classTypeParameterList.getTypeParameters()), Arrays.asList(this.myParameterList.getTypeParameterElements())), false);
        dialog.show();
    }

    @NotNull
    private static List<TypeParameterInfoView> createTypeParameters(@NotNull JavaCodeFragmentFactory factory, @NotNull List<? extends PsiTypeParameter> classTypeParameters, @NotNull List<? extends PsiTypeElement> typeElements) {
        if (factory == null) {
            ChangeClassSignatureFromUsageFix.$$$reportNull$$$0(5);
        }
        if (classTypeParameters == null) {
            ChangeClassSignatureFromUsageFix.$$$reportNull$$$0(6);
        }
        if (typeElements == null) {
            ChangeClassSignatureFromUsageFix.$$$reportNull$$$0(7);
        }
        TypeParameterNameSuggester suggester = new TypeParameterNameSuggester(classTypeParameters);
        ArrayList<TypeParameterInfoView> result = new ArrayList<TypeParameterInfoView>();
        int listIndex = 0;
        for (PsiTypeElement psiTypeElement : typeElements) {
            String suggestedName;
            PsiTypeParameter typeParameter;
            if (listIndex < classTypeParameters.size() && ChangeClassSignatureFromUsageFix.isAssignable(typeParameter = classTypeParameters.get(listIndex), psiTypeElement.getType())) {
                result.add(new TypeParameterInfoView(new TypeParameterInfo.Existing(listIndex++), null, null));
                continue;
            }
            PsiType defaultType = psiTypeElement.getType();
            PsiClassType boundType = null;
            if (defaultType instanceof PsiClassType) {
                PsiClassType[] types;
                PsiReferenceList extendsList;
                suggestedName = suggester.suggest((PsiClassType)defaultType);
                PsiClass resolved = ((PsiClassType)defaultType).resolve();
                if (resolved != null && (extendsList = resolved.getExtendsList()) != null && (types = extendsList.getReferencedTypes()).length == 1) {
                    boundType = types[0];
                }
            } else {
                suggestedName = suggester.suggestUnusedName("T");
            }
            PsiTypeCodeFragment boundFragment = ChangeClassSignatureDialog.createTableCodeFragment(boundType, (PsiElement)psiTypeElement, factory, true);
            result.add(new TypeParameterInfoView(new TypeParameterInfo.New(suggestedName, defaultType, null), boundFragment, boundType == null ? factory.createTypeCodeFragment(suggestedName, (PsiElement)psiTypeElement, true) : ChangeClassSignatureDialog.createTableCodeFragment(boundType, (PsiElement)psiTypeElement, factory, false)));
        }
        ArrayList<TypeParameterInfoView> arrayList = result;
        if (arrayList == null) {
            ChangeClassSignatureFromUsageFix.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static boolean isAssignable(@NotNull PsiTypeParameter typeParameter, @NotNull PsiType type2) {
        if (typeParameter == null) {
            ChangeClassSignatureFromUsageFix.$$$reportNull$$$0(9);
        }
        if (type2 == null) {
            ChangeClassSignatureFromUsageFix.$$$reportNull$$$0(10);
        }
        for (PsiClassType t : typeParameter.getExtendsListTypes()) {
            if (t.isAssignableFrom(type2)) continue;
            return false;
        }
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeClassSignatureFromUsageFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classTypeParameters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElements";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeClassSignatureFromUsageFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTypeParameters";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAssignable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TypeParameterInfoView {
        private final TypeParameterInfo myInfo;
        private final PsiTypeCodeFragment myBoundValueFragment;
        private final PsiTypeCodeFragment myDefaultValueFragment;

        public TypeParameterInfoView(TypeParameterInfo info, PsiTypeCodeFragment boundValueFragment, PsiTypeCodeFragment defaultValueFragment) {
            this.myInfo = info;
            this.myBoundValueFragment = boundValueFragment;
            this.myDefaultValueFragment = defaultValueFragment;
        }

        public TypeParameterInfo getInfo() {
            return this.myInfo;
        }

        public PsiTypeCodeFragment getBoundValueFragment() {
            return this.myBoundValueFragment;
        }

        public PsiTypeCodeFragment getDefaultValueFragment() {
            return this.myDefaultValueFragment;
        }
    }

    private static class TypeParameterNameSuggester {
        private final Set<String> usedNames;

        TypeParameterNameSuggester(PsiTypeParameter ... typeParameters) {
            if (typeParameters == null) {
                TypeParameterNameSuggester.$$$reportNull$$$0(0);
            }
            this(Arrays.asList(typeParameters));
        }

        TypeParameterNameSuggester(@NotNull Collection<? extends PsiTypeParameter> typeParameters) {
            if (typeParameters == null) {
                TypeParameterNameSuggester.$$$reportNull$$$0(1);
            }
            this.usedNames = new HashSet<String>();
            for (PsiTypeParameter psiTypeParameter : typeParameters) {
                this.usedNames.add(psiTypeParameter.getName());
            }
        }

        @NotNull
        private String suggestUnusedName(@NotNull String name2) {
            if (name2 == null) {
                TypeParameterNameSuggester.$$$reportNull$$$0(2);
            }
            String unusedName = name2;
            int i = 0;
            while (true) {
                if (this.usedNames.add(unusedName)) {
                    String string = unusedName;
                    if (string == null) {
                        TypeParameterNameSuggester.$$$reportNull$$$0(3);
                    }
                    return string;
                }
                unusedName = name2 + ++i;
            }
        }

        @NotNull
        public String suggest(@NotNull PsiClassType type2) {
            if (type2 == null) {
                TypeParameterNameSuggester.$$$reportNull$$$0(4);
            }
            String string = this.suggestUnusedName(StringUtil.toUpperCase((String)type2.getClassName().substring(0, 1)));
            if (string == null) {
                TypeParameterNameSuggester.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeParameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeClassSignatureFromUsageFix$TypeParameterNameSuggester";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeClassSignatureFromUsageFix$TypeParameterNameSuggester";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "suggestUnusedName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "suggest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "suggestUnusedName";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "suggest";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

