/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddMethodFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final SmartPsiElementPointer<PsiMethod> myMethodPrototype;
    private final List<String> myExceptions;
    private String myText;

    public AddMethodFix(@NotNull PsiMethod methodPrototype, @NotNull PsiClass implClass) {
        if (methodPrototype == null) {
            AddMethodFix.$$$reportNull$$$0(0);
        }
        if (implClass == null) {
            AddMethodFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)implClass);
        this.myExceptions = new ArrayList<String>();
        this.myMethodPrototype = SmartPointerManager.createPointer((PsiElement)methodPrototype);
        this.setText(QuickFixBundle.message("add.method.text", methodPrototype.getName(), implClass.getName()));
    }

    public AddMethodFix(@NonNls @NotNull String methodText, @NotNull PsiClass implClass, String ... exceptions) {
        if (methodText == null) {
            AddMethodFix.$$$reportNull$$$0(2);
        }
        if (implClass == null) {
            AddMethodFix.$$$reportNull$$$0(3);
        }
        if (exceptions == null) {
            AddMethodFix.$$$reportNull$$$0(4);
        }
        this(AddMethodFix.createMethod(methodText, implClass), implClass);
        ContainerUtil.addAll(this.myExceptions, (Object[])exceptions);
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            AddMethodFix.$$$reportNull$$$0(5);
        }
        return this.myStartElement.getContainingFile();
    }

    @NotNull
    private static PsiMethod createMethod(String methodText, PsiClass implClass) {
        PsiMethod psiMethod = JavaPsiFacade.getElementFactory((Project)implClass.getProject()).createMethodFromText(methodText, (PsiElement)implClass);
        if (psiMethod == null) {
            AddMethodFix.$$$reportNull$$$0(6);
        }
        return psiMethod;
    }

    private static PsiMethod reformat(Project project, PsiMethod result) throws IncorrectOperationException {
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        result = (PsiMethod)codeStyleManager.reformat((PsiElement)result);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        result = (PsiMethod)javaCodeStyleManager.shortenClassReferences((PsiElement)result);
        return result;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            AddMethodFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    protected void setText(@NotNull String text2) {
        if (text2 == null) {
            AddMethodFix.$$$reportNull$$$0(8);
        }
        this.myText = text2;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.method.family", new Object[0]);
        if (string == null) {
            AddMethodFix.$$$reportNull$$$0(9);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            AddMethodFix.$$$reportNull$$$0(10);
        }
        if (file == null) {
            AddMethodFix.$$$reportNull$$$0(11);
        }
        if (startElement == null) {
            AddMethodFix.$$$reportNull$$$0(12);
        }
        if (endElement == null) {
            AddMethodFix.$$$reportNull$$$0(13);
        }
        PsiClass myClass = (PsiClass)startElement;
        PsiMethod methodPrototype = (PsiMethod)this.myMethodPrototype.getElement();
        return methodPrototype != null && methodPrototype.isValid() && BaseIntentionAction.canModify((PsiElement)myClass) && this.myText != null && MethodSignatureUtil.findMethodBySignature((PsiClass)myClass, (PsiMethod)methodPrototype, (boolean)false) == null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiCodeBlock body2;
        PsiMethod methodPrototype;
        if (project == null) {
            AddMethodFix.$$$reportNull$$$0(14);
        }
        if (file == null) {
            AddMethodFix.$$$reportNull$$$0(15);
        }
        if (startElement == null) {
            AddMethodFix.$$$reportNull$$$0(16);
        }
        if (endElement == null) {
            AddMethodFix.$$$reportNull$$$0(17);
        }
        if ((methodPrototype = (PsiMethod)this.myMethodPrototype.getElement()) == null) {
            return;
        }
        PsiClass myClass = (PsiClass)startElement;
        if (myClass.isInterface() && (body2 = methodPrototype.getBody()) != null) {
            body2.delete();
        }
        for (String exception : this.myExceptions) {
            PsiUtil.addException((PsiMethod)methodPrototype, (String)exception);
        }
        PsiMethod method = (PsiMethod)myClass.add((PsiElement)methodPrototype);
        method = (PsiMethod)method.replace((PsiElement)AddMethodFix.reformat(project, method));
        this.postAddAction(file, editor, method);
    }

    protected void postAddAction(@NotNull PsiFile file, @Nullable Editor editor, PsiMethod newMethod) {
        if (file == null) {
            AddMethodFix.$$$reportNull$$$0(18);
        }
        if (editor != null && newMethod.getContainingFile() == file) {
            GenerateMembersUtil.positionCaret(editor, (PsiElement)newMethod, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodPrototype";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethod";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "postAddAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

