/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaHighlightUtil {
    public static boolean isSerializable(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaHighlightUtil.$$$reportNull$$$0(0);
        }
        return JavaHighlightUtil.isSerializable(aClass, "java.io.Serializable");
    }

    public static boolean isSerializable(@NotNull PsiClass aClass, @NotNull String serializableClassName) {
        Project project;
        PsiClass serializableClass;
        if (aClass == null) {
            JavaHighlightUtil.$$$reportNull$$$0(1);
        }
        if (serializableClassName == null) {
            JavaHighlightUtil.$$$reportNull$$$0(2);
        }
        return (serializableClass = JavaPsiFacade.getInstance((Project)(project = aClass.getManager().getProject())).findClass(serializableClassName, aClass.getResolveScope())) != null && aClass.isInheritor(serializableClass, true);
    }

    public static boolean isSerializationRelatedMethod(@NotNull PsiMethod method, @Nullable PsiClass containingClass) {
        if (method == null) {
            JavaHighlightUtil.$$$reportNull$$$0(3);
        }
        if (containingClass == null) {
            return false;
        }
        if (method.isConstructor()) {
            return JavaHighlightUtil.isSerializable(containingClass, "java.io.Externalizable") && method.getParameterList().isEmpty() && method.hasModifierProperty("public");
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        String name2 = method.getName();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        PsiType returnType = method.getReturnType();
        if ("readObjectNoData".equals(name2)) {
            return parameters2.length == 0 && TypeConversionUtil.isVoidType((PsiType)returnType) && JavaHighlightUtil.isSerializable(containingClass);
        }
        if ("readObject".equals(name2)) {
            return parameters2.length == 1 && parameters2[0].getType().equalsToText("java.io.ObjectInputStream") && TypeConversionUtil.isVoidType((PsiType)returnType) && method.hasModifierProperty("private") && JavaHighlightUtil.isSerializable(containingClass);
        }
        if ("readResolve".equals(name2)) {
            return parameters2.length == 0 && returnType != null && returnType.equalsToText("java.lang.Object") && (containingClass.hasModifierProperty("abstract") || JavaHighlightUtil.isSerializable(containingClass));
        }
        if ("writeReplace".equals(name2)) {
            return parameters2.length == 0 && returnType != null && returnType.equalsToText("java.lang.Object") && (containingClass.hasModifierProperty("abstract") || JavaHighlightUtil.isSerializable(containingClass));
        }
        if ("writeObject".equals(name2)) {
            return parameters2.length == 1 && TypeConversionUtil.isVoidType((PsiType)returnType) && parameters2[0].getType().equalsToText("java.io.ObjectOutputStream") && method.hasModifierProperty("private") && JavaHighlightUtil.isSerializable(containingClass);
        }
        return false;
    }

    @NotNull
    public static String formatType(@Nullable PsiType type2) {
        String string = type2 == null ? "null" : type2.getInternalCanonicalText();
        if (string == null) {
            JavaHighlightUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private static PsiType getArrayInitializerType(@NotNull PsiArrayInitializerExpression element) {
        PsiType typeCheckResult;
        if (element == null) {
            JavaHighlightUtil.$$$reportNull$$$0(5);
        }
        return (typeCheckResult = JavaHighlightUtil.sameType(element.getInitializers())) != null ? typeCheckResult.createArrayType() : null;
    }

    @Nullable
    public static PsiType sameType(@NotNull PsiExpression[] expressions2) {
        if (expressions2 == null) {
            JavaHighlightUtil.$$$reportNull$$$0(6);
        }
        PsiType type2 = null;
        for (PsiExpression expression2 : expressions2) {
            PsiType currentType = expression2 instanceof PsiArrayInitializerExpression ? JavaHighlightUtil.getArrayInitializerType((PsiArrayInitializerExpression)expression2) : expression2.getType();
            if (type2 == null) {
                type2 = currentType;
                continue;
            }
            if (type2.equals(currentType)) continue;
            return null;
        }
        return type2;
    }

    @NotNull
    public static String formatMethod(@NotNull PsiMethod method) {
        if (method == null) {
            JavaHighlightUtil.$$$reportNull$$$0(7);
        }
        String string = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
        if (string == null) {
            JavaHighlightUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    public static boolean isSuperOrThisCall(@NotNull PsiStatement statement, boolean testForSuper, boolean testForThis) {
        if (statement == null) {
            JavaHighlightUtil.$$$reportNull$$$0(9);
        }
        if (!(statement instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression expression2 = ((PsiExpressionStatement)statement).getExpression();
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)expression2).getMethodExpression();
        if (testForSuper && "super".equals(methodExpression.getText())) {
            return true;
        }
        return testForThis && "this".equals(methodExpression.getText());
    }

    @NotNull
    public static List<PsiMethod> getChainedConstructors(@NotNull PsiMethod constructor) {
        if (constructor == null) {
            JavaHighlightUtil.$$$reportNull$$$0(10);
        }
        ConstructorVisitorInfo info = new ConstructorVisitorInfo();
        JavaHighlightUtil.visitConstructorChain(constructor, info);
        if (info.visitedConstructors != null) {
            info.visitedConstructors.remove(constructor);
        }
        List list = (List)ObjectUtils.notNull(info.visitedConstructors, Collections.emptyList());
        if (list == null) {
            JavaHighlightUtil.$$$reportNull$$$0(11);
        }
        return list;
    }

    static void visitConstructorChain(@NotNull PsiMethod entry, @NotNull ConstructorVisitorInfo info) {
        if (entry == null) {
            JavaHighlightUtil.$$$reportNull$$$0(12);
        }
        if (info == null) {
            JavaHighlightUtil.$$$reportNull$$$0(13);
        }
        PsiMethod constructor = entry;
        PsiMethodCallExpression methodCall;
        while (JavaPsiConstructorUtil.isChainedConstructorCall((PsiElement)(methodCall = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)constructor)))) {
            PsiMethod method = methodCall.resolveMethod();
            if (method == null) {
                return;
            }
            if (info.visitedConstructors != null && info.visitedConstructors.contains(method)) {
                info.recursivelyCalledConstructor = method;
                return;
            }
            if (info.visitedConstructors == null) {
                info.visitedConstructors = new ArrayList<PsiMethod>(5);
            }
            info.visitedConstructors.add(method);
            constructor = method;
        }
        return;
    }

    @Nullable
    public static String checkPsiTypeUseInContext(@NotNull PsiType type2, @NotNull PsiElement context) {
        if (type2 == null) {
            JavaHighlightUtil.$$$reportNull$$$0(14);
        }
        if (context == null) {
            JavaHighlightUtil.$$$reportNull$$$0(15);
        }
        if (type2 instanceof PsiPrimitiveType) {
            return null;
        }
        if (type2 instanceof PsiArrayType) {
            return JavaHighlightUtil.checkPsiTypeUseInContext(((PsiArrayType)type2).getComponentType(), context);
        }
        if (PsiUtil.resolveClassInType((PsiType)type2) != null) {
            return null;
        }
        if (type2 instanceof PsiClassType) {
            return JavaHighlightUtil.checkClassType((PsiClassType)type2, context);
        }
        return "Invalid Java type";
    }

    @NotNull
    private static String checkClassType(@NotNull PsiClassType type2, @NotNull PsiElement context) {
        String className2;
        if (type2 == null) {
            JavaHighlightUtil.$$$reportNull$$$0(16);
        }
        if (context == null) {
            JavaHighlightUtil.$$$reportNull$$$0(17);
        }
        if (JavaHighlightUtil.classExists(context, className2 = PsiNameHelper.getQualifiedClassName((String)type2.getCanonicalText(false), (boolean)true))) {
            String string = JavaHighlightUtil.getClassInaccessibleMessage(context, className2);
            if (string == null) {
                JavaHighlightUtil.$$$reportNull$$$0(18);
            }
            return string;
        }
        if ("Invalid Java type" == null) {
            JavaHighlightUtil.$$$reportNull$$$0(19);
        }
        return "Invalid Java type";
    }

    private static boolean classExists(@NotNull PsiElement context, @NotNull String className2) {
        if (context == null) {
            JavaHighlightUtil.$$$reportNull$$$0(20);
        }
        if (className2 == null) {
            JavaHighlightUtil.$$$reportNull$$$0(21);
        }
        return JavaPsiFacade.getInstance((Project)context.getProject()).findClass(className2, GlobalSearchScope.allScope((Project)context.getProject())) != null;
    }

    @NotNull
    private static String getClassInaccessibleMessage(@NotNull PsiElement context, @NotNull String className2) {
        if (context == null) {
            JavaHighlightUtil.$$$reportNull$$$0(22);
        }
        if (className2 == null) {
            JavaHighlightUtil.$$$reportNull$$$0(23);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        String string = "Class '" + className2 + "' is not accessible " + (module == null ? "here" : "from module '" + module.getName() + "'");
        if (string == null) {
            JavaHighlightUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 18: 
            case 19: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 18: 
            case 19: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializableClassName";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 18: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/JavaHighlightUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: 
            case 17: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/JavaHighlightUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "formatType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "formatMethod";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChainedConstructors";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "checkClassType";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassInaccessibleMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSerializable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSerializationRelatedMethod";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 18: 
            case 19: 
            case 24: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getArrayInitializerType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sameType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "formatMethod";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSuperOrThisCall";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getChainedConstructors";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitConstructorChain";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkPsiTypeUseInContext";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkClassType";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "classExists";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getClassInaccessibleMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 18: 
            case 19: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ConstructorVisitorInfo {
        List<PsiMethod> visitedConstructors;
        PsiMethod recursivelyCalledConstructor;

        ConstructorVisitorInfo() {
        }
    }
}

