/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.ErrorFixExtensionPoint;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightFixUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.ChangeModifierRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MemberRequestsKt;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AllVariablesControlFlowPolicy;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightControlFlowUtil {
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();

    private HighlightControlFlowUtil() {
    }

    @Nullable
    static HighlightInfo checkMissingReturnStatement(@Nullable PsiCodeBlock body2, @Nullable PsiType returnType) {
        if (body2 == null || returnType == null || PsiType.VOID.equals((Object)returnType.getDeepComponentType())) {
            return null;
        }
        try {
            ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate((PsiElement)body2);
            if (!ControlFlowUtil.returnPresent(controlFlow)) {
                PsiJavaToken rBrace = body2.getRBrace();
                PsiJavaToken context = rBrace == null ? body2.getLastChild() : rBrace;
                String message2 = JavaErrorMessages.message("missing.return.statement", new Object[0]);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)context).descriptionAndTooltip(message2).create();
                PsiElement parent = body2.getParent();
                if (parent instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)parent;
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createAddReturnFix((PsiParameterListOwner)method));
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(method, (PsiType)PsiType.VOID, true));
                }
                if (parent instanceof PsiLambdaExpression) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createAddReturnFix((PsiParameterListOwner)((PsiLambdaExpression)parent)));
                }
                return info;
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public static ControlFlow getControlFlowNoConstantEvaluate(@NotNull PsiElement body2) throws AnalysisCanceledException {
        if (body2 == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(0);
        }
        LocalsOrMyInstanceFieldsControlFlowPolicy policy = LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance();
        ControlFlow controlFlow = ControlFlowFactory.getInstance(body2.getProject()).getControlFlow(body2, policy, false, false);
        if (controlFlow == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(1);
        }
        return controlFlow;
    }

    @NotNull
    private static ControlFlow getControlFlow(@NotNull PsiElement context) throws AnalysisCanceledException {
        if (context == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(2);
        }
        LocalsOrMyInstanceFieldsControlFlowPolicy policy = LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance();
        ControlFlow controlFlow = ControlFlowFactory.getInstance(context.getProject()).getControlFlow(context, policy);
        if (controlFlow == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(3);
        }
        return controlFlow;
    }

    static HighlightInfo checkUnreachableStatement(@Nullable PsiCodeBlock codeBlock) {
        if (codeBlock == null) {
            return null;
        }
        try {
            AllVariablesControlFlowPolicy policy = AllVariablesControlFlowPolicy.getInstance();
            ControlFlow controlFlow = ControlFlowFactory.getInstance(codeBlock.getProject()).getControlFlow((PsiElement)codeBlock, policy, false, false);
            PsiElement unreachableStatement = ControlFlowUtil.getUnreachableStatement(controlFlow);
            if (unreachableStatement != null) {
                String description = JavaErrorMessages.message("unreachable.statement", new Object[0]);
                PsiElement keyword = null;
                if (unreachableStatement instanceof PsiIfStatement || unreachableStatement instanceof PsiSwitchBlock || unreachableStatement instanceof PsiLoopStatement) {
                    keyword = unreachableStatement.getFirstChild();
                }
                PsiElement element = keyword != null ? keyword : unreachableStatement;
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createDeleteFix(unreachableStatement, QuickFixBundle.message("delete.unreachable.statement.fix.text", new Object[0])));
                return info;
            }
        }
        catch (IndexNotReadyException | AnalysisCanceledException throwable) {
            // empty catch block
        }
        return null;
    }

    public static boolean isFieldInitializedAfterObjectConstruction(@NotNull PsiField field) {
        if (field == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(4);
        }
        if (field.hasInitializer()) {
            return true;
        }
        boolean isFieldStatic = field.hasModifierProperty("static");
        PsiClass aClass = field.getContainingClass();
        if (aClass != null && HighlightControlFlowUtil.isFieldInitializedInOtherFieldInitializer(aClass, field, isFieldStatic, (Condition<? super PsiField>)Condition.TRUE)) {
            return true;
        }
        if (aClass == null) {
            return false;
        }
        PsiClassInitializer[] initializers = aClass.getInitializers();
        if (HighlightControlFlowUtil.isFieldInitializedInClassInitializer(field, isFieldStatic, initializers)) {
            return true;
        }
        if (isFieldStatic) {
            return false;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        block0: for (PsiMethod constructor : constructors) {
            PsiCodeBlock ctrBody = constructor.getBody();
            if (ctrBody == null) {
                return false;
            }
            List<PsiMethod> redirectedConstructors = JavaHighlightUtil.getChainedConstructors(constructor);
            for (PsiMethod redirectedConstructor : redirectedConstructors) {
                PsiCodeBlock body2 = redirectedConstructor.getBody();
                if (body2 == null || !HighlightControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)body2)) continue;
                continue block0;
            }
            if (!ctrBody.isValid() || HighlightControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)ctrBody)) continue;
            return false;
        }
        return true;
    }

    private static boolean isFieldInitializedInClassInitializer(@NotNull PsiField field, boolean isFieldStatic, @NotNull PsiClassInitializer[] initializers) {
        if (field == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(5);
        }
        if (initializers == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(6);
        }
        return ContainerUtil.find((Object[])initializers, initializer -> initializer.hasModifierProperty("static") == isFieldStatic && HighlightControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)initializer.getBody())) != null;
    }

    private static boolean isFieldInitializedInOtherFieldInitializer(@NotNull PsiClass aClass, @NotNull PsiField field, boolean fieldStatic, @NotNull Condition<? super PsiField> condition2) {
        PsiField[] fields;
        if (aClass == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(7);
        }
        if (field == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(8);
        }
        if (condition2 == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(9);
        }
        for (PsiField psiField : fields = aClass.getFields()) {
            if (psiField == field || psiField.hasModifierProperty("static") != fieldStatic || !HighlightControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)psiField) || !condition2.value((Object)psiField)) continue;
            return true;
        }
        return false;
    }

    static boolean isRecursivelyCalledConstructor(@NotNull PsiMethod constructor) {
        if (constructor == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(10);
        }
        JavaHighlightUtil.ConstructorVisitorInfo info = new JavaHighlightUtil.ConstructorVisitorInfo();
        JavaHighlightUtil.visitConstructorChain(constructor, info);
        if (info.recursivelyCalledConstructor == null) {
            return false;
        }
        return info.visitedConstructors.indexOf(info.recursivelyCalledConstructor) <= info.visitedConstructors.indexOf(constructor);
    }

    public static boolean isAssigned(@NotNull PsiParameter parameter2) {
        if (parameter2 == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(11);
        }
        ParamWriteProcessor processor = new ParamWriteProcessor();
        ReferencesSearch.search((PsiElement)parameter2, (SearchScope)new LocalSearchScope(parameter2.getDeclarationScope()), (boolean)true).forEach((Processor)processor);
        return processor.isWriteRefFound();
    }

    public static boolean variableDefinitelyAssignedIn(@NotNull PsiVariable variable, @NotNull PsiElement context) {
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(12);
        }
        if (context == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(13);
        }
        try {
            ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlow(context);
            return ControlFlowUtil.isVariableDefinitelyAssigned(variable, controlFlow);
        }
        catch (AnalysisCanceledException e) {
            return false;
        }
    }

    private static boolean variableDefinitelyNotAssignedIn(@NotNull PsiVariable variable, @NotNull PsiElement context) {
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(14);
        }
        if (context == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(15);
        }
        try {
            ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlow(context);
            return ControlFlowUtil.isVariableDefinitelyNotAssigned(variable, controlFlow);
        }
        catch (AnalysisCanceledException e) {
            return false;
        }
    }

    @Nullable
    static HighlightInfo checkFinalFieldInitialized(@NotNull PsiField field) {
        if (field == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(16);
        }
        if (!field.hasModifierProperty("final")) {
            return null;
        }
        if (HighlightControlFlowUtil.isFieldInitializedAfterObjectConstruction(field)) {
            return null;
        }
        String description = JavaErrorMessages.message("variable.not.initialized", field.getName());
        TextRange range = HighlightNamesUtil.getFieldDeclarationTextRange(field);
        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)HighlightMethodUtil.getFixRange((PsiElement)field), (IntentionAction)QUICK_FIX_FACTORY.createCreateConstructorParameterFromFieldFix(field));
        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)HighlightMethodUtil.getFixRange((PsiElement)field), (IntentionAction)QUICK_FIX_FACTORY.createInitializeFinalFieldInConstructorFix(field));
        PsiClass containingClass = field.getContainingClass();
        if (containingClass != null && !containingClass.isInterface()) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)field, "final", false, false));
        }
        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createAddVariableInitializerFix((PsiVariable)field));
        return highlightInfo;
    }

    @Nullable
    public static HighlightInfo checkVariableInitializedBeforeUsage(@NotNull PsiReferenceExpression expression2, @NotNull PsiVariable variable, @NotNull Map<PsiElement, Collection<PsiReferenceExpression>> uninitializedVarProblems, @NotNull PsiFile containingFile) {
        if (expression2 == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(17);
        }
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(18);
        }
        if (uninitializedVarProblems == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(19);
        }
        if (containingFile == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(20);
        }
        return HighlightControlFlowUtil.checkVariableInitializedBeforeUsage(expression2, variable, uninitializedVarProblems, containingFile, false);
    }

    @Nullable
    public static HighlightInfo checkVariableInitializedBeforeUsage(@NotNull PsiReferenceExpression expression2, @NotNull PsiVariable variable, @NotNull Map<PsiElement, Collection<PsiReferenceExpression>> uninitializedVarProblems, @NotNull PsiFile containingFile, boolean ignoreFinality) {
        PsiElement topBlock;
        if (expression2 == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(21);
        }
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(22);
        }
        if (uninitializedVarProblems == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(23);
        }
        if (containingFile == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(24);
        }
        if (variable instanceof ImplicitVariable) {
            return null;
        }
        if (!PsiUtil.isAccessedForReading((PsiExpression)expression2)) {
            return null;
        }
        int startOffset = expression2.getTextRange().getStartOffset();
        if (variable.hasInitializer()) {
            topBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, (PsiElement)variable);
            if (topBlock == null) {
                return null;
            }
        } else {
            PsiClass scope;
            Object object = variable instanceof PsiField ? ((PsiField)variable).getContainingClass() : (scope = variable.getParent() != null ? variable.getParent().getParent() : null);
            if (scope instanceof PsiCodeBlock && scope.getParent() instanceof PsiSwitchStatement) {
                scope = PsiTreeUtil.getParentOfType((PsiElement)scope, PsiCodeBlock.class);
            }
            Object object2 = topBlock = FileTypeUtils.isInServerPageFile((PsiElement)scope) && scope instanceof PsiFile ? scope : PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)expression2, (PsiElement)scope);
            if (variable instanceof PsiField) {
                PsiClass aClass;
                PsiCodeBlock block;
                if (!ignoreFinality && !variable.hasModifierProperty("final")) {
                    return null;
                }
                if (PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)expression2) == null && HighlightUtil.findEnclosingFieldInitializer((PsiElement)expression2) == null) {
                    return null;
                }
                if (topBlock == null) {
                    return null;
                }
                PsiElement parent = topBlock.getParent();
                if (HighlightControlFlowUtil.inInnerClass((PsiElement)expression2, ((PsiField)variable).getContainingClass())) {
                    return null;
                }
                if (parent instanceof PsiMethod) {
                    PsiMethod constructor = (PsiMethod)parent;
                    if (!containingFile.getManager().areElementsEquivalent((PsiElement)constructor.getContainingClass(), (PsiElement)((PsiField)variable).getContainingClass())) {
                        return null;
                    }
                    if (variable.hasModifierProperty("static")) {
                        return null;
                    }
                    List<PsiMethod> redirectedConstructors = JavaHighlightUtil.getChainedConstructors(constructor);
                    for (PsiMethod redirectedConstructor : redirectedConstructors) {
                        PsiMethod[] body2 = redirectedConstructor.getBody();
                        if (body2 == null || !HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, (PsiElement)body2)) continue;
                        return null;
                    }
                    block = constructor.getBody();
                    aClass = constructor.getContainingClass();
                } else if (parent instanceof PsiClassInitializer) {
                    PsiClassInitializer classInitializer = (PsiClassInitializer)parent;
                    if (!containingFile.getManager().areElementsEquivalent((PsiElement)classInitializer.getContainingClass(), (PsiElement)((PsiField)variable).getContainingClass())) {
                        return null;
                    }
                    block = classInitializer.getBody();
                    aClass = classInitializer.getContainingClass();
                    if (aClass == null || HighlightControlFlowUtil.isFieldInitializedInOtherFieldInitializer(aClass, (PsiField)variable, variable.hasModifierProperty("static"), (Condition<? super PsiField>)((Condition)field -> startOffset > field.getTextOffset()))) {
                        return null;
                    }
                } else {
                    PsiMethod[] constructors;
                    PsiField field2 = (PsiField)variable;
                    aClass = field2.getContainingClass();
                    PsiField anotherField = (PsiField)PsiTreeUtil.getTopmostParentOfType((PsiElement)expression2, PsiField.class);
                    if (aClass == null || HighlightControlFlowUtil.isFieldInitializedInOtherFieldInitializer(aClass, field2, field2.hasModifierProperty("static"), (Condition<? super PsiField>)((Condition)psiField -> startOffset > psiField.getTextOffset()))) {
                        return null;
                    }
                    if (anotherField != null && !anotherField.hasModifierProperty("static") && field2.hasModifierProperty("static") && HighlightControlFlowUtil.isFieldInitializedInClassInitializer(field2, true, aClass.getInitializers())) {
                        return null;
                    }
                    int offset = startOffset;
                    if (anotherField != null && anotherField.getContainingClass() == aClass && !field2.hasModifierProperty("static")) {
                        offset = 0;
                    }
                    block = null;
                    for (PsiMethod constructor : constructors = aClass.getConstructors()) {
                        if (offset < constructor.getTextRange().getStartOffset()) continue;
                        PsiCodeBlock body3 = constructor.getBody();
                        if (body3 != null && HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, (PsiElement)body3)) {
                            return null;
                        }
                        List<PsiMethod> redirectedConstructors = JavaHighlightUtil.getChainedConstructors(constructor);
                        for (PsiMethod redirectedConstructor : redirectedConstructors) {
                            PsiCodeBlock redirectedBody;
                            if (offset < redirectedConstructor.getTextRange().getStartOffset() || (redirectedBody = redirectedConstructor.getBody()) == null || !HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, (PsiElement)redirectedBody)) continue;
                            return null;
                        }
                    }
                }
                if (aClass != null) {
                    PsiClassInitializer initializer;
                    PsiCodeBlock body4;
                    PsiClassInitializer[] initializers;
                    PsiClassInitializer[] psiClassInitializerArray = initializers = aClass.getInitializers();
                    int n = psiClassInitializerArray.length;
                    for (int i = 0; i < n && (body4 = (initializer = psiClassInitializerArray[i]).getBody()) != block; ++i) {
                        boolean shouldCheckInitializerOrder;
                        boolean bl = shouldCheckInitializerOrder = block == null || block.getParent() instanceof PsiClassInitializer;
                        if (shouldCheckInitializerOrder && startOffset < initializer.getTextRange().getStartOffset() || initializer.hasModifierProperty("static") != variable.hasModifierProperty("static") || !HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, (PsiElement)body4)) continue;
                        return null;
                    }
                }
            }
        }
        if (topBlock == null) {
            return null;
        }
        Collection<PsiReferenceExpression> codeBlockProblems = uninitializedVarProblems.get(topBlock);
        if (codeBlockProblems == null) {
            try {
                ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlow(topBlock);
                codeBlockProblems = ControlFlowUtil.getReadBeforeWriteLocals(controlFlow);
            }
            catch (IndexNotReadyException | AnalysisCanceledException e) {
                codeBlockProblems = Collections.emptyList();
            }
            uninitializedVarProblems.put(topBlock, codeBlockProblems);
        }
        if (codeBlockProblems.contains(expression2)) {
            String name2 = expression2.getElement().getText();
            String description = JavaErrorMessages.message("variable.not.initialized", name2);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createAddVariableInitializerFix(variable));
            if (variable instanceof PsiLocalVariable) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)HighlightFixUtil.createInsertSwitchDefaultFix(variable, topBlock, (PsiElement)expression2));
            }
            if (variable instanceof PsiField) {
                ChangeModifierRequest request = MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.FINAL, (boolean)false);
                QuickFixAction.registerQuickFixActions((HighlightInfo)highlightInfo, null, (Iterable)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)((PsiField)variable), (ChangeModifierRequest)request));
            }
            return highlightInfo;
        }
        return null;
    }

    private static boolean inInnerClass(@NotNull PsiElement psiElement, @Nullable PsiClass containingClass) {
        if (psiElement == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(25);
        }
        for (PsiElement element = psiElement; element != null; element = element.getParent()) {
            boolean innerClass;
            if (!(element instanceof PsiClass)) continue;
            boolean bl = innerClass = !psiElement.getManager().areElementsEquivalent(element, (PsiElement)containingClass);
            if (innerClass) {
                if (element instanceof PsiAnonymousClass) {
                    if (PsiTreeUtil.isAncestor((PsiElement)((PsiAnonymousClass)element).getArgumentList(), (PsiElement)psiElement, (boolean)false)) continue;
                    return !HighlightControlFlowUtil.insideClassInitialization(containingClass, (PsiClass)element);
                }
                PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiLambdaExpression.class);
                return lambdaExpression == null || !HighlightControlFlowUtil.insideClassInitialization(containingClass, (PsiClass)element);
            }
            return false;
        }
        return false;
    }

    private static boolean insideClassInitialization(@Nullable PsiClass containingClass, PsiClass aClass) {
        PsiClass member = aClass;
        while (member != null) {
            if (member.getContainingClass() == containingClass) {
                return member instanceof PsiField || member instanceof PsiMethod && ((PsiMethod)member).isConstructor() || member instanceof PsiClassInitializer;
            }
            member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)member, PsiMember.class, (boolean)true);
        }
        return false;
    }

    public static boolean isReassigned(@NotNull PsiVariable variable, @NotNull Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> finalVarProblems) {
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(26);
        }
        if (finalVarProblems == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(27);
        }
        if (variable instanceof PsiLocalVariable) {
            PsiElement parent = variable.getParent();
            if (parent == null) {
                return false;
            }
            PsiElement declarationScope = parent.getParent();
            if (declarationScope == null) {
                return false;
            }
            Collection<ControlFlowUtil.VariableInfo> codeBlockProblems = HighlightControlFlowUtil.getFinalVariableProblemsInBlock(finalVarProblems, declarationScope);
            return codeBlockProblems.contains(new ControlFlowUtil.VariableInfo(variable, null));
        }
        if (variable instanceof PsiParameter) {
            PsiParameter parameter2 = (PsiParameter)variable;
            return HighlightControlFlowUtil.isAssigned(parameter2);
        }
        return false;
    }

    @Nullable
    public static HighlightInfo checkFinalVariableMightAlreadyHaveBeenAssignedTo(@NotNull PsiVariable variable, @NotNull PsiReferenceExpression expression2, @NotNull Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> finalVarProblems) {
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(28);
        }
        if (expression2 == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(29);
        }
        if (finalVarProblems == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(30);
        }
        if (!PsiUtil.isAccessedForWriting((PsiExpression)expression2)) {
            return null;
        }
        Object scope = variable instanceof PsiField ? variable.getParent() : (variable.getParent() == null ? null : variable.getParent().getParent());
        PsiElement codeBlock = PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)expression2, (PsiElement)scope);
        if (codeBlock == null) {
            return null;
        }
        Collection<ControlFlowUtil.VariableInfo> codeBlockProblems = HighlightControlFlowUtil.getFinalVariableProblemsInBlock(finalVarProblems, codeBlock);
        boolean alreadyAssigned = false;
        for (ControlFlowUtil.VariableInfo variableInfo : codeBlockProblems) {
            if (variableInfo.expression != expression2) continue;
            alreadyAssigned = true;
            break;
        }
        if (!alreadyAssigned) {
            if (!(variable instanceof PsiField)) {
                return null;
            }
            PsiField field = (PsiField)variable;
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return null;
            }
            ArrayList<PsiField> members = new ArrayList<PsiField>(Arrays.asList(aClass.getFields()));
            boolean isFieldStatic = field.hasModifierProperty("static");
            PsiMember enclosingConstructorOrInitializer = PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)expression2);
            if (enclosingConstructorOrInitializer != null && aClass.getManager().areElementsEquivalent((PsiElement)enclosingConstructorOrInitializer.getContainingClass(), (PsiElement)aClass)) {
                members.addAll(Arrays.asList(aClass.getInitializers()));
                Collections.sort(members, PsiUtil.BY_POSITION);
            }
            for (PsiMember psiMember : members) {
                PsiExpression context;
                if (psiMember == field || (context = psiMember instanceof PsiField ? ((PsiField)psiMember).getInitializer() : ((PsiClassInitializer)psiMember).getBody()) == null || psiMember.hasModifierProperty("static") != isFieldStatic || HighlightControlFlowUtil.variableDefinitelyNotAssignedIn((PsiVariable)field, (PsiElement)context)) continue;
                if (context == codeBlock) {
                    return null;
                }
                alreadyAssigned = true;
                break;
            }
            if (!alreadyAssigned && !isFieldStatic) {
                PsiMethod ctr = codeBlock.getParent() instanceof PsiMethod ? (PsiMethod)codeBlock.getParent() : null;
                List<PsiMethod> list = ctr != null && ctr.isConstructor() ? JavaHighlightUtil.getChainedConstructors(ctr) : Collections.emptyList();
                for (PsiMethod redirectedConstructor : list) {
                    PsiCodeBlock body2 = redirectedConstructor.getBody();
                    if (body2 == null || !HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, (PsiElement)body2)) continue;
                    alreadyAssigned = true;
                    break;
                }
            }
        }
        if (alreadyAssigned) {
            String description = JavaErrorMessages.message("variable.already.assigned", variable.getName());
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
            if (variable instanceof PsiField) {
                QuickFixAction.registerQuickFixActions((HighlightInfo)highlightInfo, null, (Iterable)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)((PsiField)variable), (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.FINAL, (boolean)false)));
            } else {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)variable, "final", false, false));
            }
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createDeferFinalAssignmentFix(variable, expression2));
            return highlightInfo;
        }
        return null;
    }

    @NotNull
    private static Collection<ControlFlowUtil.VariableInfo> getFinalVariableProblemsInBlock(@NotNull Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> finalVarProblems, @NotNull PsiElement codeBlock) {
        Collection<ControlFlowUtil.VariableInfo> codeBlockProblems;
        if (finalVarProblems == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(31);
        }
        if (codeBlock == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(32);
        }
        if ((codeBlockProblems = finalVarProblems.get(codeBlock)) == null) {
            try {
                ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlow(codeBlock);
                codeBlockProblems = ControlFlowUtil.getInitializedTwice(controlFlow);
            }
            catch (AnalysisCanceledException e) {
                codeBlockProblems = Collections.emptyList();
            }
            finalVarProblems.put(codeBlock, codeBlockProblems);
        }
        Collection<ControlFlowUtil.VariableInfo> collection = codeBlockProblems;
        if (collection == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(33);
        }
        return collection;
    }

    @Nullable
    static HighlightInfo checkFinalVariableInitializedInLoop(@NotNull PsiReferenceExpression expression2, @NotNull PsiElement resolved) {
        if (expression2 == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(34);
        }
        if (resolved == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(35);
        }
        if (ControlFlowUtil.isVariableAssignedInLoop(expression2, resolved)) {
            String description = JavaErrorMessages.message("variable.assigned.in.loop", ((PsiVariable)resolved).getName());
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
            if (resolved instanceof PsiField) {
                QuickFixAction.registerQuickFixActions((HighlightInfo)highlightInfo, null, (Iterable)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)((PsiField)resolved), (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.FINAL, (boolean)false)));
            } else {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)((PsiVariable)resolved), "final", false, false));
            }
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkCannotWriteToFinal(@NotNull PsiExpression expression2, @NotNull PsiFile containingFile) {
        boolean canWrite;
        PsiVariable variable;
        if (expression2 == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(36);
        }
        if (containingFile == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(37);
        }
        PsiExpression operand2 = null;
        if (expression2 instanceof PsiAssignmentExpression) {
            operand2 = ((PsiAssignmentExpression)expression2).getLExpression();
        } else if (PsiUtil.isIncrementDecrementOperation((PsiElement)expression2)) {
            operand2 = ((PsiUnaryExpression)expression2).getOperand();
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)operand2), PsiReferenceExpression.class);
        PsiVariable psiVariable = variable = reference == null ? null : (PsiVariable)ObjectUtils.tryCast((Object)reference.resolve(), PsiVariable.class);
        if (variable == null || !variable.hasModifierProperty("final")) {
            return null;
        }
        boolean bl = canWrite = HighlightControlFlowUtil.canWriteToFinal(variable, expression2, reference, containingFile) && HighlightControlFlowUtil.checkWriteToFinalInsideLambda(variable, (PsiJavaCodeReferenceElement)reference) == null;
        if (canWrite) {
            return null;
        }
        String name2 = variable.getName();
        String description = JavaErrorMessages.message("assignment.to.final.variable", name2);
        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(reference.getTextRange()).descriptionAndTooltip(description).create();
        PsiElement innerClass = HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, (PsiElement)expression2);
        if (innerClass == null || variable instanceof PsiField) {
            if (variable instanceof PsiField) {
                QuickFixAction.registerQuickFixActions((HighlightInfo)highlightInfo, null, (Iterable)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)((PsiField)variable), (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.FINAL, (boolean)false)));
            } else {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)variable, "final", false, false));
            }
        } else {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createVariableAccessFromInnerClassFix(variable, innerClass));
        }
        return highlightInfo;
    }

    private static boolean canWriteToFinal(@NotNull PsiVariable variable, @NotNull PsiExpression expression2, @NotNull PsiReferenceExpression reference, @NotNull PsiFile containingFile) {
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(38);
        }
        if (expression2 == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(39);
        }
        if (reference == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(40);
        }
        if (containingFile == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(41);
        }
        if (variable.hasInitializer()) {
            return false;
        }
        if (variable instanceof PsiParameter) {
            return false;
        }
        PsiElement innerClass = HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, (PsiElement)expression2);
        if (variable instanceof PsiField) {
            if (HighlightUtil.findEnclosingFieldInitializer((PsiElement)expression2) != null) {
                return true;
            }
            PsiField field = (PsiField)variable;
            if (innerClass != null && !containingFile.getManager().areElementsEquivalent(innerClass, (PsiElement)field.getContainingClass())) {
                return false;
            }
            PsiMember enclosingCtrOrInitializer = PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)expression2);
            return enclosingCtrOrInitializer != null && HighlightControlFlowUtil.isSameField(enclosingCtrOrInitializer, field, reference, containingFile);
        }
        if (variable instanceof PsiLocalVariable) {
            boolean isAccessedFromOtherClass;
            boolean bl = isAccessedFromOtherClass = innerClass != null;
            if (isAccessedFromOtherClass) {
                return false;
            }
        }
        return true;
    }

    private static boolean isSameField(@NotNull PsiMember enclosingCtrOrInitializer, @NotNull PsiField field, @NotNull PsiReferenceExpression reference, @NotNull PsiFile containingFile) {
        if (enclosingCtrOrInitializer == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(42);
        }
        if (field == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(43);
        }
        if (reference == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(44);
        }
        if (containingFile == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(45);
        }
        if (!containingFile.getManager().areElementsEquivalent((PsiElement)enclosingCtrOrInitializer.getContainingClass(), (PsiElement)field.getContainingClass())) {
            return false;
        }
        return LocalsOrMyInstanceFieldsControlFlowPolicy.isLocalOrMyInstanceReference(reference);
    }

    @Nullable
    static HighlightInfo checkVariableMustBeFinal(@NotNull PsiVariable variable, @NotNull PsiJavaCodeReferenceElement context, @NotNull LanguageLevel languageLevel) {
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(46);
        }
        if (context == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(47);
        }
        if (languageLevel == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(48);
        }
        if (variable.hasModifierProperty("final")) {
            return null;
        }
        PsiElement innerClass = HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, (PsiElement)context);
        if (innerClass instanceof PsiClass) {
            PsiElement parent;
            if (variable instanceof PsiParameter && (parent = variable.getParent()) instanceof PsiParameterList && parent.getParent() instanceof PsiLambdaExpression && HighlightControlFlowUtil.notAccessedForWriting(variable, new LocalSearchScope(((PsiParameter)variable).getDeclarationScope()))) {
                return null;
            }
            boolean isToBeEffectivelyFinal = languageLevel.isAtLeast(LanguageLevel.JDK_1_8);
            if (isToBeEffectivelyFinal && HighlightControlFlowUtil.isEffectivelyFinal(variable, innerClass, context)) {
                return null;
            }
            String description = JavaErrorMessages.message(isToBeEffectivelyFinal ? "variable.must.be.final.or.effectively.final" : "variable.must.be.final", context.getText());
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)context).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createVariableAccessFromInnerClassFix(variable, innerClass));
            return highlightInfo;
        }
        return HighlightControlFlowUtil.checkWriteToFinalInsideLambda(variable, context);
    }

    private static HighlightInfo checkWriteToFinalInsideLambda(@NotNull PsiVariable variable, @NotNull PsiJavaCodeReferenceElement context) {
        PsiLambdaExpression lambdaExpression;
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(49);
        }
        if (context == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(50);
        }
        if ((lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)context, PsiLambdaExpression.class)) != null && !PsiTreeUtil.isAncestor((PsiElement)lambdaExpression, (PsiElement)variable, (boolean)true)) {
            PsiElement parent = variable.getParent();
            if (parent instanceof PsiParameterList && parent.getParent() == lambdaExpression) {
                return null;
            }
            if (!HighlightControlFlowUtil.isEffectivelyFinal(variable, (PsiElement)lambdaExpression, context)) {
                String text2 = JavaErrorMessages.message("lambda.variable.must.be.final", new Object[0]);
                HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)context).descriptionAndTooltip(text2).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createVariableAccessFromInnerClassFix(variable, (PsiElement)lambdaExpression));
                return ErrorFixExtensionPoint.registerFixes(highlightInfo, (PsiElement)context, "lambda.variable.must.be.final");
            }
        }
        return null;
    }

    public static boolean isEffectivelyFinal(@NotNull PsiVariable variable, @NotNull PsiElement scope, @Nullable PsiJavaCodeReferenceElement context) {
        boolean effectivelyFinal;
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(51);
        }
        if (scope == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(52);
        }
        if (variable instanceof PsiParameter) {
            effectivelyFinal = HighlightControlFlowUtil.notAccessedForWriting(variable, new LocalSearchScope(((PsiParameter)variable).getDeclarationScope()));
        } else {
            ControlFlow controlFlow;
            try {
                PsiElement codeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, (PsiElement)context);
                if (codeBlock == null) {
                    return true;
                }
                controlFlow = HighlightControlFlowUtil.getControlFlow(codeBlock);
            }
            catch (AnalysisCanceledException e) {
                return true;
            }
            Collection<ControlFlowUtil.VariableInfo> initializedTwice = ControlFlowUtil.getInitializedTwice(controlFlow);
            boolean bl = effectivelyFinal = !initializedTwice.contains(new ControlFlowUtil.VariableInfo(variable, null));
            if (effectivelyFinal) {
                List<PsiReferenceExpression> readBeforeWriteLocals = ControlFlowUtil.getReadBeforeWriteLocals(controlFlow);
                for (PsiReferenceExpression expression2 : readBeforeWriteLocals) {
                    if (expression2.resolve() != variable) continue;
                    return PsiUtil.isAccessedForReading((PsiExpression)expression2);
                }
                effectivelyFinal = HighlightControlFlowUtil.notAccessedForWriting(variable, new LocalSearchScope(scope));
                if (effectivelyFinal) {
                    return ReferencesSearch.search((PsiElement)variable).allMatch(ref -> {
                        PsiElement element = ref.getElement();
                        if (element instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element))) {
                            return !ControlFlowUtil.isVariableAssignedInLoop((PsiReferenceExpression)element, (PsiElement)variable);
                        }
                        return true;
                    });
                }
            }
        }
        return effectivelyFinal;
    }

    private static boolean notAccessedForWriting(@NotNull PsiVariable variable, @NotNull LocalSearchScope searchScope) {
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(53);
        }
        if (searchScope == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(54);
        }
        for (PsiReference reference : ReferencesSearch.search((PsiElement)variable, (SearchScope)searchScope)) {
            PsiElement element = reference.getElement();
            if (!(element instanceof PsiExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PsiElement getInnerClassVariableReferencedFrom(@NotNull PsiVariable variable, @NotNull PsiElement context) {
        PsiElement parent;
        PsiElement[] scope;
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(55);
        }
        if (context == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(56);
        }
        if (variable instanceof PsiResourceVariable) {
            scope = ((PsiResourceVariable)variable).getDeclarationScope();
        } else if (variable instanceof PsiLocalVariable) {
            parent = variable.getParent();
            scope = new PsiElement[]{parent != null ? parent.getParent() : null};
        } else {
            scope = variable instanceof PsiParameter ? new PsiElement[]{((PsiParameter)variable).getDeclarationScope()} : new PsiElement[]{variable.getParent()};
        }
        if (scope.length < 1 || scope[0] == null || scope[0].getContainingFile() != context.getContainingFile()) {
            return null;
        }
        PsiElement prevParent = context;
        block0: for (parent = context.getParent(); parent != null; parent = parent.getParent()) {
            for (PsiElement scopeElement : scope) {
                if (parent.equals(scopeElement)) break block0;
            }
            if (!(!(parent instanceof PsiClass) || prevParent instanceof PsiExpressionList && parent instanceof PsiAnonymousClass)) {
                return parent;
            }
            if (parent instanceof PsiLambdaExpression) {
                return parent;
            }
            prevParent = parent;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkInitializerCompleteNormally(@NotNull PsiClassInitializer initializer) {
        if (initializer == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(57);
        }
        PsiCodeBlock body2 = initializer.getBody();
        try {
            ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate((PsiElement)body2);
            int completionReasons = ControlFlowUtil.getCompletionReasons(controlFlow, 0, controlFlow.getSize());
            if (!BitUtil.isSet((int)completionReasons, (int)1)) {
                String description = JavaErrorMessages.message("initializer.must.be.able.to.complete.normally", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)body2).descriptionAndTooltip(description).create();
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 1: 
            case 3: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil";
                break;
            }
            case 2: 
            case 13: 
            case 15: 
            case 47: 
            case 50: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 16: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializers";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 12: 
            case 14: 
            case 18: 
            case 22: 
            case 26: 
            case 28: 
            case 38: 
            case 46: 
            case 49: 
            case 51: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 17: 
            case 21: 
            case 29: 
            case 34: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uninitializedVarProblems";
                break;
            }
            case 20: 
            case 24: 
            case 37: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 27: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finalVarProblems";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlock";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enclosingCtrOrInitializer";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlowNoConstantEvaluate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlow";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getFinalVariableProblemsInBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlowNoConstantEvaluate";
                break;
            }
            case 1: 
            case 3: 
            case 33: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlow";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFieldInitializedAfterObjectConstruction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFieldInitializedInClassInitializer";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isFieldInitializedInOtherFieldInitializer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isRecursivelyCalledConstructor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAssigned";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "variableDefinitelyAssignedIn";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "variableDefinitelyNotAssignedIn";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkFinalFieldInitialized";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkVariableInitializedBeforeUsage";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "inInnerClass";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isReassigned";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "checkFinalVariableMightAlreadyHaveBeenAssignedTo";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getFinalVariableProblemsInBlock";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "checkFinalVariableInitializedInLoop";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "checkCannotWriteToFinal";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "canWriteToFinal";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isSameField";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "checkVariableMustBeFinal";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "checkWriteToFinalInsideLambda";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isEffectivelyFinal";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "notAccessedForWriting";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getInnerClassVariableReferencedFrom";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "checkInitializerCompleteNormally";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ParamWriteProcessor
    implements Processor<PsiReference> {
        private volatile boolean myIsWriteRefFound;

        private ParamWriteProcessor() {
        }

        public boolean process(PsiReference reference) {
            PsiElement element = reference.getElement();
            if (element instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element))) {
                this.myIsWriteRefFound = true;
                return false;
            }
            return true;
        }

        private boolean isWriteRefFound() {
            return this.myIsWriteRefFound;
        }
    }
}

