/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.impl.GutterTooltipHelper;
import com.intellij.codeInsight.daemon.impl.LineMarkerNavigator;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.ide.util.MethodOrFunctionalExpressionCellRenderer;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.ide.util.PsiClassOrFunctionalExpressionListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkerType {
    private final GutterIconNavigationHandler<PsiElement> handler;
    private final Function<PsiElement, String> myTooltip;
    @NotNull
    private final String myDebugName;
    public static final MarkerType OVERRIDING_METHOD = new MarkerType("OVERRIDING_METHOD", (Function<PsiElement, String>)((NullableFunction)element -> {
        PsiMethod method;
        PsiElement parent = MarkerType.getParentMethod(element);
        if (!(parent instanceof PsiMethod)) {
            return null;
        }
        return MarkerType.calculateOverridingMethodTooltip(method, (method = (PsiMethod)parent) != element.getParent());
    }), new LineMarkerNavigator(){

        @Override
        public void browse(MouseEvent e, PsiElement element) {
            PsiMethod method;
            PsiElement parent = MarkerType.getParentMethod(element);
            if (!(parent instanceof PsiMethod)) {
                return;
            }
            MarkerType.navigateToOverridingMethod(e, method, (method = (PsiMethod)parent) != element.getParent());
        }
    });
    public static final MarkerType SIBLING_OVERRIDING_METHOD = new MarkerType("SIBLING_OVERRIDING_METHOD", (Function<PsiElement, String>)((NullableFunction)element -> {
        PsiElement parent = MarkerType.getParentMethod(element);
        if (!(parent instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)parent;
        return MarkerType.calculateOverridingSiblingMethodTooltip(method);
    }), new LineMarkerNavigator(){

        @Override
        public void browse(MouseEvent e, PsiElement element) {
            PsiElement parent = MarkerType.getParentMethod(element);
            if (!(parent instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)parent;
            MarkerType.navigateToSiblingOverridingMethod(e, method);
        }
    });
    public static final String SEARCHING_FOR_OVERRIDING_METHODS = "Searching for Overriding Methods";
    public static final MarkerType OVERRIDDEN_METHOD = new MarkerType("OVERRIDDEN_METHOD", (Function<PsiElement, String>)((NullableFunction)element -> {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)parent;
        return MarkerType.getOverriddenMethodTooltip(method);
    }), new LineMarkerNavigator(){

        @Override
        public void browse(MouseEvent e, PsiElement element) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiMethod)) {
                return;
            }
            MarkerType.navigateToOverriddenMethod(e, (PsiMethod)parent);
        }
    });
    private static final String SEARCHING_FOR_OVERRIDDEN_METHODS = "Searching for Overridden Methods";
    public static final MarkerType SUBCLASSED_CLASS = new MarkerType("SUBCLASSED_CLASS", (Function<PsiElement, String>)((NullableFunction)element -> {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiClass)) {
            return null;
        }
        PsiClass aClass = (PsiClass)parent;
        return MarkerType.getSubclassedClassTooltip(aClass);
    }), new LineMarkerNavigator(){

        @Override
        public void browse(MouseEvent e, PsiElement element) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)parent;
            MarkerType.navigateToSubclassedClass(e, aClass);
        }
    });

    @Deprecated
    public MarkerType(@NotNull Function<PsiElement, String> tooltip, @NotNull LineMarkerNavigator navigator) {
        if (tooltip == null) {
            MarkerType.$$$reportNull$$$0(0);
        }
        if (navigator == null) {
            MarkerType.$$$reportNull$$$0(1);
        }
        this("Unknown", tooltip, navigator);
    }

    public MarkerType(@NotNull String debugName, @NotNull Function<PsiElement, String> tooltip, @NotNull LineMarkerNavigator navigator) {
        if (debugName == null) {
            MarkerType.$$$reportNull$$$0(2);
        }
        if (tooltip == null) {
            MarkerType.$$$reportNull$$$0(3);
        }
        if (navigator == null) {
            MarkerType.$$$reportNull$$$0(4);
        }
        this.myTooltip = tooltip;
        this.myDebugName = debugName;
        this.handler = (e, elt) -> DumbService.getInstance((Project)elt.getProject()).withAlternativeResolveEnabled(() -> navigator.browse(e, elt));
    }

    public String toString() {
        return this.myDebugName;
    }

    @NotNull
    public GutterIconNavigationHandler<PsiElement> getNavigationHandler() {
        GutterIconNavigationHandler<PsiElement> gutterIconNavigationHandler = this.handler;
        if (gutterIconNavigationHandler == null) {
            MarkerType.$$$reportNull$$$0(5);
        }
        return gutterIconNavigationHandler;
    }

    @NotNull
    public Function<PsiElement, String> getTooltip() {
        Function<PsiElement, String> function = this.myTooltip;
        if (function == null) {
            MarkerType.$$$reportNull$$$0(6);
        }
        return function;
    }

    @Nullable
    private static String calculateOverridingMethodTooltip(@NotNull PsiMethod method, boolean acceptSelf) {
        PsiMethod[] superMethods;
        if (method == null) {
            MarkerType.$$$reportNull$$$0(7);
        }
        if ((superMethods = MarkerType.composeSuperMethods(method, acceptSelf)).length == 0) {
            return null;
        }
        String divider = GutterTooltipHelper.getElementDivider(false, false, superMethods.length);
        AtomicReference<String> reference = new AtomicReference<String>("");
        return GutterTooltipHelper.getTooltipText(Arrays.asList(superMethods), superMethod -> MarkerType.getTooltipPrefix(method, superMethod, reference.getAndSet(divider)), superMethod -> MarkerType.isSameSignature(method, superMethod), "GotoSuperMethod");
    }

    @Nullable
    private static String calculateOverridingSiblingMethodTooltip(@NotNull PsiMethod method) {
        FindSuperElementsHelper.SiblingInfo pair2;
        if (method == null) {
            MarkerType.$$$reportNull$$$0(8);
        }
        if ((pair2 = FindSuperElementsHelper.getSiblingInfoInheritedViaSubClass(method)) == null) {
            return null;
        }
        return GutterTooltipHelper.getTooltipText(Arrays.asList(pair2.superMethod, pair2.subClass), element -> element instanceof PsiMethod ? MarkerType.getTooltipPrefix(method, (PsiMethod)element, "") : " via subclass ", element -> element instanceof PsiMethod && MarkerType.isSameSignature(method, (PsiMethod)element), "GotoSuperMethod");
    }

    @NotNull
    private static String getTooltipPrefix(@NotNull PsiMethod method, @NotNull PsiMethod superMethod, @NotNull String prefix) {
        if (method == null) {
            MarkerType.$$$reportNull$$$0(9);
        }
        if (superMethod == null) {
            MarkerType.$$$reportNull$$$0(10);
        }
        if (prefix == null) {
            MarkerType.$$$reportNull$$$0(11);
        }
        StringBuilder sb = new StringBuilder(prefix);
        boolean isAbstract = method.hasModifierProperty("abstract");
        boolean isSuperAbstract = superMethod.hasModifierProperty("abstract");
        sb.append(isSuperAbstract && !isAbstract ? "Implements method " : "Overrides method ");
        if (MarkerType.isSameSignature(method, superMethod)) {
            sb.append("in ");
        }
        String string = sb.toString();
        if (string == null) {
            MarkerType.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static boolean isSameSignature(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        if (method == null) {
            MarkerType.$$$reportNull$$$0(13);
        }
        if (superMethod == null) {
            MarkerType.$$$reportNull$$$0(14);
        }
        return method.getSignature(PsiSubstitutor.EMPTY).equals(superMethod.getSignature(PsiSubstitutor.EMPTY));
    }

    @NotNull
    private static <E extends PsiElement> PsiElementProcessor.CollectElementsWithLimit<E> getProcessor(int limit, boolean set) {
        PsiElementProcessor.CollectElementsWithLimit collectElementsWithLimit = set ? new PsiElementProcessor.CollectElementsWithLimit(limit, (Collection)new THashSet()) : new PsiElementProcessor.CollectElementsWithLimit(limit);
        if (collectElementsWithLimit == null) {
            MarkerType.$$$reportNull$$$0(15);
        }
        return collectElementsWithLimit;
    }

    private static String getFunctionalImplementationTooltip(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            MarkerType.$$$reportNull$$$0(16);
        }
        PsiElementProcessor.CollectElementsWithLimit processor = MarkerType.getProcessor(5, true);
        FunctionalExpressionSearch.search((PsiClass)psiClass).forEach((Processor)new PsiElementProcessorAdapter(processor));
        if (processor.isOverflow()) {
            return MarkerType.getImplementationTooltip("Has several functional implementations", new PsiElement[0]);
        }
        if (processor.getCollection().isEmpty()) {
            return null;
        }
        return MarkerType.getImplementationTooltip(processor.getCollection(), "Is functionally implemented in");
    }

    @NotNull
    private static String getImplementationTooltip(@NotNull String prefix, PsiElement ... elements) {
        if (prefix == null) {
            MarkerType.$$$reportNull$$$0(17);
        }
        if (elements == null) {
            MarkerType.$$$reportNull$$$0(18);
        }
        String string = MarkerType.getImplementationTooltip(Arrays.asList(elements), prefix);
        if (string == null) {
            MarkerType.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private static String getImplementationTooltip(@NotNull Collection<? extends PsiElement> elements, @NotNull String prefix) {
        if (elements == null) {
            MarkerType.$$$reportNull$$$0(20);
        }
        if (prefix == null) {
            MarkerType.$$$reportNull$$$0(21);
        }
        String string = GutterTooltipHelper.getTooltipText(elements, prefix, true, "GotoImplementation");
        if (string == null) {
            MarkerType.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static void navigateToOverridingMethod(MouseEvent e, @NotNull PsiMethod method, boolean acceptSelf) {
        PsiMethod[] superMethods;
        if (method == null) {
            MarkerType.$$$reportNull$$$0(23);
        }
        if ((superMethods = MarkerType.composeSuperMethods(method, acceptSelf)).length == 0) {
            return;
        }
        boolean showMethodNames = !PsiUtil.allMethodsHaveSameSignature((PsiMethod[])superMethods);
        PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])superMethods, (String)DaemonBundle.message((String)"navigation.title.super.method", (Object[])new Object[]{method.getName()}), (String)DaemonBundle.message((String)"navigation.findUsages.title.super.method", (Object[])new Object[]{method.getName()}), (ListCellRenderer)((Object)new MethodCellRenderer(showMethodNames)));
    }

    private static void navigateToSiblingOverridingMethod(MouseEvent e, @NotNull PsiMethod method) {
        PsiMethod superMethod;
        if (method == null) {
            MarkerType.$$$reportNull$$$0(24);
        }
        if ((superMethod = FindSuperElementsHelper.getSiblingInheritedViaSubClass(method)) == null) {
            return;
        }
        PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])new NavigatablePsiElement[]{superMethod}, (String)DaemonBundle.message((String)"navigation.title.super.method", (Object[])new Object[]{method.getName()}), (String)DaemonBundle.message((String)"navigation.findUsages.title.super.method", (Object[])new Object[]{method.getName()}), (ListCellRenderer)((Object)new MethodCellRenderer(false)));
    }

    @NotNull
    private static PsiMethod[] composeSuperMethods(@NotNull PsiMethod method, boolean acceptSelf) {
        if (method == null) {
            MarkerType.$$$reportNull$$$0(25);
        }
        Object[] superElements = FindSuperElementsHelper.findSuperElements((PsiElement)method);
        Object[] superMethods = (PsiMethod[])ContainerUtil.map((Object[])superElements, element -> (PsiMethod)element, (Object[])PsiMethod.EMPTY_ARRAY);
        if (acceptSelf) {
            superMethods = (PsiMethod[])ArrayUtil.prepend((Object)method, (Object[])superMethods);
        }
        if (superMethods == null) {
            MarkerType.$$$reportNull$$$0(26);
        }
        return superMethods;
    }

    private static PsiElement getParentMethod(@NotNull PsiElement element) {
        PsiElement parent;
        PsiMethod interfaceMethod;
        if (element == null) {
            MarkerType.$$$reportNull$$$0(27);
        }
        return (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)(parent = element.getParent()))) != null ? interfaceMethod : parent;
    }

    private static String getOverriddenMethodTooltip(@NotNull PsiMethod method) {
        PsiClass aClass;
        if (method == null) {
            MarkerType.$$$reportNull$$$0(28);
        }
        if ((aClass = method.getContainingClass()) != null && "java.lang.Object".equals(aClass.getQualifiedName())) {
            return MarkerType.getImplementationTooltip("Is implemented in several subclasses", new PsiElement[0]);
        }
        PsiElementProcessor.CollectElementsWithLimit processor = MarkerType.getProcessor(5, false);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)PsiUtilCore.getProjectInReadAction((PsiElement)method));
        OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)scope, (boolean)true).forEach((Processor)new PsiElementProcessorAdapter(processor));
        boolean isAbstract = method.hasModifierProperty("abstract");
        if (processor.isOverflow()) {
            return MarkerType.getImplementationTooltip(isAbstract ? "Is implemented in several subclasses" : "Is overridden in several subclasses", new PsiElement[0]);
        }
        PsiMethod[] overridings = (PsiMethod[])processor.toArray((PsiElement[])PsiMethod.EMPTY_ARRAY);
        if (overridings.length == 0) {
            return !isAbstract || aClass == null ? null : MarkerType.getFunctionalImplementationTooltip(aClass);
        }
        Comparator comparator = new MethodCellRenderer(false).getComparator();
        Arrays.sort(overridings, comparator);
        return MarkerType.getImplementationTooltip(isAbstract ? "Is implemented in" : "Is overridden in", (PsiElement[])overridings);
    }

    private static void navigateToOverriddenMethod(MouseEvent e, @NotNull PsiMethod method) {
        if (method == null) {
            MarkerType.$$$reportNull$$$0(29);
        }
        if (DumbService.isDumb((Project)method.getProject())) {
            DumbService.getInstance((Project)method.getProject()).showDumbModeNotification("Navigation to overriding classes is not possible during index update");
            return;
        }
        PsiElementProcessor.CollectElementsWithLimit collectProcessor = MarkerType.getProcessor(2, true);
        PsiElementProcessor.CollectElementsWithLimit collectExprProcessor = MarkerType.getProcessor(2, true);
        boolean isAbstract = method.hasModifierProperty("abstract");
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)PsiUtilCore.getProjectInReadAction((PsiElement)method));
            OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)scope, (boolean)true).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)collectProcessor));
            if (isAbstract && collectProcessor.getCollection().size() < 2) {
                PsiClass aClass = (PsiClass)ReadAction.compute(() -> ((PsiMethod)method).getContainingClass());
                if (aClass != null) {
                    FunctionalExpressionSearch.search((PsiClass)aClass).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)collectExprProcessor));
                }
            }
        }, SEARCHING_FOR_OVERRIDING_METHODS, true, method.getProject(), (JComponent)e.getComponent())) {
            return;
        }
        PsiMethod[] methodOverriders = (PsiMethod[])collectProcessor.toArray((PsiElement[])PsiMethod.EMPTY_ARRAY);
        ArrayList overridings = new ArrayList();
        overridings.addAll(collectProcessor.getCollection());
        overridings.addAll(collectExprProcessor.getCollection());
        if (overridings.isEmpty()) {
            return;
        }
        boolean showMethodNames = !PsiUtil.allMethodsHaveSameSignature((PsiMethod[])methodOverriders);
        MethodOrFunctionalExpressionCellRenderer renderer = new MethodOrFunctionalExpressionCellRenderer(showMethodNames);
        Collections.sort(overridings, renderer.getComparator());
        OverridingMethodsUpdater methodsUpdater = new OverridingMethodsUpdater(method, renderer);
        PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])overridings.toArray(NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY), (String)methodsUpdater.getCaption(overridings.size()), (String)("Overriding methods of " + method.getName()), (ListCellRenderer)((Object)renderer), (BackgroundUpdaterTask)methodsUpdater);
    }

    public static String getSubclassedClassTooltip(@NotNull PsiClass aClass) {
        if (aClass == null) {
            MarkerType.$$$reportNull$$$0(30);
        }
        PsiElementProcessor.CollectElementsWithLimit processor = MarkerType.getProcessor(5, true);
        ClassInheritorsSearch.search((PsiClass)aClass).forEach((Processor)new PsiElementProcessorAdapter(processor));
        if (processor.isOverflow()) {
            return MarkerType.getImplementationTooltip(aClass.isInterface() ? "Is implemented by several subclasses" : "Is overridden by several subclasses", new PsiElement[0]);
        }
        PsiClass[] subclasses = (PsiClass[])processor.toArray((PsiElement[])PsiClass.EMPTY_ARRAY);
        if (subclasses.length == 0) {
            return MarkerType.getFunctionalImplementationTooltip(aClass);
        }
        Comparator comparator = new PsiClassListCellRenderer().getComparator();
        Arrays.sort(subclasses, comparator);
        return MarkerType.getImplementationTooltip(aClass.isInterface() ? "Is implemented by" : "Is subclassed by", (PsiElement[])subclasses);
    }

    public static void navigateToSubclassedClass(MouseEvent e, @NotNull PsiClass aClass) {
        if (aClass == null) {
            MarkerType.$$$reportNull$$$0(31);
        }
        MarkerType.navigateToSubclassedClass(e, aClass, new PsiClassOrFunctionalExpressionListCellRenderer());
    }

    public static void navigateToSubclassedClass(MouseEvent e, @NotNull PsiClass aClass, PsiElementListCellRenderer<NavigatablePsiElement> renderer) {
        if (aClass == null) {
            MarkerType.$$$reportNull$$$0(32);
        }
        if (DumbService.isDumb((Project)aClass.getProject())) {
            DumbService.getInstance((Project)aClass.getProject()).showDumbModeNotification("Navigation to overriding methods is not possible during index update");
            return;
        }
        PsiElementProcessor.FindElement collectProcessor = new PsiElementProcessor.FindElement();
        PsiElementProcessor.FindElement collectExprProcessor = new PsiElementProcessor.FindElement();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ClassInheritorsSearch.search((PsiClass)aClass).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)collectProcessor));
            if (collectProcessor.getFoundElement() == null) {
                FunctionalExpressionSearch.search((PsiClass)aClass).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)collectExprProcessor));
            }
        }, SEARCHING_FOR_OVERRIDDEN_METHODS, true, aClass.getProject(), (JComponent)e.getComponent())) {
            return;
        }
        ArrayList inheritors = new ArrayList();
        ContainerUtil.addIfNotNull(inheritors, (Object)collectProcessor.getFoundElement());
        ContainerUtil.addIfNotNull(inheritors, (Object)collectExprProcessor.getFoundElement());
        if (inheritors.isEmpty()) {
            return;
        }
        SubclassUpdater subclassUpdater = new SubclassUpdater(aClass, renderer);
        Collections.sort(inheritors, renderer.getComparator());
        PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])inheritors.toArray(NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY), (String)subclassUpdater.getCaption(inheritors.size()), (String)CodeInsightBundle.message((String)"goto.implementation.findUsages.title", (Object[])new Object[]{aClass.getName()}), renderer, (BackgroundUpdaterTask)subclassUpdater);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 15: 
            case 19: 
            case 22: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 15: 
            case 19: 
            case 22: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 15: 
            case 19: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/MarkerType";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
            case 11: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/MarkerType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltip";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipPrefix";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessor";
                break;
            }
            case 19: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementationTooltip";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "composeSuperMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 15: 
            case 19: 
            case 22: 
            case 26: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calculateOverridingMethodTooltip";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calculateOverridingSiblingMethodTooltip";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTooltipPrefix";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isSameSignature";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionalImplementationTooltip";
                break;
            }
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getImplementationTooltip";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "navigateToOverridingMethod";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "navigateToSiblingOverridingMethod";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "composeSuperMethods";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getParentMethod";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getOverriddenMethodTooltip";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "navigateToOverriddenMethod";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSubclassedClassTooltip";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "navigateToSubclassedClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 15: 
            case 19: 
            case 22: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OverridingMethodsUpdater
    extends BackgroundUpdaterTask {
        private final PsiMethod myMethod;

        private OverridingMethodsUpdater(@NotNull PsiMethod method, @NotNull PsiElementListCellRenderer renderer) {
            if (method == null) {
                OverridingMethodsUpdater.$$$reportNull$$$0(0);
            }
            if (renderer == null) {
                OverridingMethodsUpdater.$$$reportNull$$$0(1);
            }
            super(method.getProject(), MarkerType.SEARCHING_FOR_OVERRIDING_METHODS, OverridingMethodsUpdater.createComparatorWrapper((Comparator)renderer.getComparator()));
            this.myMethod = method;
        }

        public String getCaption(int size) {
            return DaemonBundle.message((String)(this.myMethod.hasModifierProperty("abstract") ? "navigation.title.implementation.method" : "navigation.title.overrider.method"), (Object[])new Object[]{this.myMethod.getName(), size});
        }

        public void onSuccess() {
            super.onSuccess();
            PsiElement oneElement = this.getTheOnlyOneElement();
            if (oneElement instanceof NavigatablePsiElement) {
                ((NavigatablePsiElement)oneElement).navigate(true);
                this.myPopup.cancel();
            }
        }

        public void run(final @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                OverridingMethodsUpdater.$$$reportNull$$$0(2);
            }
            super.run(indicator);
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)PsiUtilCore.getProjectInReadAction((PsiElement)this.myMethod));
            OverridingMethodsSearch.search((PsiMethod)this.myMethod, (SearchScope)scope, (boolean)true).forEach((Processor)new CommonProcessors.CollectProcessor<PsiMethod>(){

                public boolean process(PsiMethod psiMethod) {
                    if (!this.updateComponent((PsiElement)psiMethod)) {
                        indicator.cancel();
                    }
                    ProgressManager.checkCanceled();
                    return super.process((Object)psiMethod);
                }
            });
            if (((Boolean)ReadAction.compute(() -> this.myMethod.hasModifierProperty("abstract"))).booleanValue()) {
                PsiClass psiClass = (PsiClass)ReadAction.compute(() -> ((PsiMethod)this.myMethod).getContainingClass());
                FunctionalExpressionSearch.search((PsiClass)psiClass).forEach((Processor)new CommonProcessors.CollectProcessor<PsiFunctionalExpression>(){

                    public boolean process(PsiFunctionalExpression expr) {
                        if (!this.updateComponent((PsiElement)expr)) {
                            indicator.cancel();
                        }
                        ProgressManager.checkCanceled();
                        return super.process((Object)expr);
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/MarkerType$OverridingMethodsUpdater";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SubclassUpdater
    extends BackgroundUpdaterTask {
        private final PsiClass myClass;

        private SubclassUpdater(@NotNull PsiClass aClass, @NotNull PsiElementListCellRenderer<NavigatablePsiElement> renderer) {
            if (aClass == null) {
                SubclassUpdater.$$$reportNull$$$0(0);
            }
            if (renderer == null) {
                SubclassUpdater.$$$reportNull$$$0(1);
            }
            super(aClass.getProject(), MarkerType.SEARCHING_FOR_OVERRIDDEN_METHODS, SubclassUpdater.createComparatorWrapper((Comparator)renderer.getComparator()));
            this.myClass = aClass;
        }

        public String getCaption(int size) {
            String suffix = this.isFinished() ? "" : " so far";
            return this.myClass.isInterface() ? CodeInsightBundle.message((String)"goto.implementation.chooserTitle", (Object[])new Object[]{this.myClass.getName(), size, suffix}) : DaemonBundle.message((String)"navigation.title.subclass", (Object[])new Object[]{this.myClass.getName(), size, suffix});
        }

        public void onSuccess() {
            super.onSuccess();
            PsiElement oneElement = this.getTheOnlyOneElement();
            if (oneElement instanceof NavigatablePsiElement) {
                ((NavigatablePsiElement)oneElement).navigate(true);
                this.myPopup.cancel();
            }
        }

        public void run(final @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                SubclassUpdater.$$$reportNull$$$0(2);
            }
            super.run(indicator);
            ClassInheritorsSearch.search((PsiClass)this.myClass, (SearchScope)((SearchScope)ReadAction.compute(() -> ((PsiClass)this.myClass).getUseScope())), (boolean)true).forEach((Processor)new CommonProcessors.CollectProcessor<PsiClass>(){

                public boolean process(PsiClass o) {
                    if (!this.updateComponent((PsiElement)o)) {
                        indicator.cancel();
                    }
                    ProgressManager.checkCanceled();
                    return super.process((Object)o);
                }
            });
            FunctionalExpressionSearch.search((PsiClass)this.myClass).forEach((Processor)new CommonProcessors.CollectProcessor<PsiFunctionalExpression>(){

                public boolean process(PsiFunctionalExpression expr) {
                    if (!this.updateComponent((PsiElement)expr)) {
                        indicator.cancel();
                    }
                    ProgressManager.checkCanceled();
                    return super.process((Object)expr);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/MarkerType$SubclassUpdater";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

